/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class DeletedProjectFilter
extends ViewerFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ILaunchConfigurationType) {
            return true;
        }
        if (!(element instanceof ILaunchConfiguration)) return false;
        try {
            ILaunchConfiguration config = (ILaunchConfiguration)element;
            if (!config.exists()) return false;
            IResource[] resources = config.getMappedResources();
            if (resources == null) {
                return true;
            }
            int i = 0;
            while (true) {
                IProject project;
                if (i >= resources.length) {
                    return false;
                }
                if (resources[i] instanceof IProject && (project = (IProject)resources[i]).exists()) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return false;
    }
}

