/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.viewers.AddRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.ContainerRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.RemoveRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.jface.viewers.TreePath;

public class AsynchronousTreeModel
extends AsynchronousModel {
    public AsynchronousTreeModel(AsynchronousViewer viewer) {
        super(viewer);
    }

    public synchronized void add(TreePath treePath) {
        if (treePath.getSegmentCount() > 1) {
            int i;
            int parentIndex = treePath.getSegmentCount() - 2;
            Object parent = treePath.getSegment(parentIndex);
            ModelNode[] nodes = this.getNodes(parent);
            if (nodes != null) {
                i = 0;
                while (i < nodes.length) {
                    ModelNode node = nodes[i];
                    if (treePath.startsWith(node.getTreePath(), null)) {
                        AddRequestMonitor addRequest = new AddRequestMonitor(node, treePath, this);
                        this.requestScheduled(addRequest);
                        addRequest.done();
                        return;
                    }
                    ++i;
                }
            }
            i = parentIndex - 1;
            while (i >= 0) {
                parent = treePath.getSegment(i);
                nodes = this.getNodes(parent);
                if (nodes != null) {
                    int j = 0;
                    while (j < nodes.length) {
                        final ModelNode node = nodes[j];
                        if (treePath.startsWith(node.getTreePath(), null)) {
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    AsynchronousTreeModel.this.getViewer().nodeChanged(node);
                                }
                            };
                            this.getViewer().getControl().getDisplay().asyncExec(runnable);
                            return;
                        }
                        ++j;
                    }
                }
                --i;
            }
        }
    }

    public synchronized void remove(TreePath treePath) {
        if (treePath.getSegmentCount() > 1) {
            ModelNode node;
            int i;
            Object element = treePath.getLastSegment();
            ModelNode[] nodes = this.getNodes(element);
            if (nodes != null) {
                i = 0;
                while (i < nodes.length) {
                    node = nodes[i];
                    if (node.correspondsTo(treePath)) {
                        RemoveRequestMonitor request = new RemoveRequestMonitor(node, treePath, this);
                        this.requestScheduled(request);
                        request.done();
                        return;
                    }
                    ++i;
                }
            }
            if ((nodes = this.getNodes(element = treePath.getSegment(treePath.getSegmentCount() - 2))) != null) {
                i = 0;
                while (i < nodes.length) {
                    node = nodes[i];
                    if (treePath.startsWith(node.getTreePath(), null)) {
                        Runnable runnable = new Runnable(){

                            public void run() {
                                AsynchronousTreeModel.this.getViewer().nodeChanged(node);
                            }
                        };
                        this.getViewer().getControl().getDisplay().asyncExec(runnable);
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(final ModelNode node) {
        final ModelNode parentNode = node.getParentNode();
        if (parentNode == null) {
            return;
        }
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            parentNode.removeChild(node);
            this.unmapNode(node);
            node.dispose();
        }
        final AsynchronousTreeViewer viewer = this.getTreeViewer();
        this.preservingSelection(new Runnable(){

            public void run() {
                viewer.nodeDisposed(node);
                viewer.nodeChildrenChanged(parentNode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(ModelNode parent, Object element) {
        Object[] children = this.filter(parent.getElement(), new Object[]{element});
        if (children.length == 0) {
            return;
        }
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            ModelNode[] childrenNodes = parent.getChildrenNodes();
            if (childrenNodes != null) {
                int i = 0;
                while (i < childrenNodes.length) {
                    if (element.equals(childrenNodes[i].getElement())) {
                        return;
                    }
                    ++i;
                }
            }
            ModelNode node = new ModelNode(parent, element);
            parent.addChild(node);
            this.mapElement(element, node);
        }
        this.getTreeViewer().nodeChildrenChanged(parent);
    }

    public synchronized TreePath[] getTreePaths(Object element) {
        ModelNode[] nodes = this.getNodes(element);
        if (nodes == null) {
            return null;
        }
        TreePath[] paths = new TreePath[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            ModelNode node = nodes[i];
            ArrayList<Object> path = new ArrayList<Object>();
            path.add(element);
            node = node.getParentNode();
            while (node != null) {
                Object data = node.getElement();
                path.add(0, data);
                node = node.getParentNode();
            }
            paths[i] = new TreePath(path.toArray());
            ++i;
        }
        return paths;
    }

    protected AsynchronousTreeViewer getTreeViewer() {
        return (AsynchronousTreeViewer)this.getViewer();
    }

    protected void updateHasChildren(ModelNode node) {
        Object element = node.getElement();
        IAsynchronousContentAdapter adapter = this.getContentAdapter(element);
        if (adapter != null) {
            ContainerRequestMonitor update = new ContainerRequestMonitor(node, this);
            this.requestScheduled(update);
            adapter.isContainer(element, this.getPresentationContext(), update);
        }
    }

    protected synchronized void unmapNode(ModelNode node) {
        ModelNode[] childrenNodes = node.getChildrenNodes();
        if (childrenNodes != null) {
            int i = 0;
            while (i < childrenNodes.length) {
                this.unmapNode(childrenNodes[i]);
                ++i;
            }
        }
        super.unmapNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsContainer(ModelNode node, boolean containsChildren) {
        ModelNode child;
        int i;
        ModelNode[] prevChildren = null;
        AsynchronousTreeModel asynchronousTreeModel = this;
        synchronized (asynchronousTreeModel) {
            prevChildren = node.getChildrenNodes();
            node.setIsContainer(containsChildren);
            if (!containsChildren && prevChildren != null) {
                i = 0;
                while (i < prevChildren.length) {
                    child = prevChildren[i];
                    this.unmapNode(child);
                    child.dispose();
                    ++i;
                }
                node.setChildren(null);
            }
        }
        AsynchronousTreeViewer viewer = this.getTreeViewer();
        if (containsChildren) {
            if (prevChildren == null) {
                viewer.nodeChildrenChanged(node);
                viewer.nodeContainerChanged(node);
            } else {
                viewer.nodeContainerChanged(node);
            }
        } else if (!containsChildren && prevChildren != null) {
            i = 0;
            while (i < prevChildren.length) {
                child = prevChildren[i];
                viewer.nodeDisposed(child);
                ++i;
            }
            viewer.nodeChildrenChanged(node);
        }
    }
}

