/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.AbstractUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelSelectionPolicyFactoryAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.WorkbenchJob;

public abstract class AsynchronousViewer
extends StructuredViewer
implements Listener {
    private AsynchronousModel fModel;
    private Map fImageCache = new HashMap();
    private Map fFontCache = new HashMap();
    private Map fColorCache = new HashMap();
    private IPresentationContext fContext;
    private ISelection fPendingSelection;
    private ISelection fCurrentSelection;
    private AbstractUpdatePolicy fUpdatePolicy;
    protected static final Rectangle NOT_VISIBLE = new Rectangle(0, 0, 0, 0);
    private Map fParentsPendingChildren = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected AsynchronousViewer() {
        this.setContentProvider((IContentProvider)new NullContentProvider());
        this.setUseHashlookup(true);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        control.addListener(36, (Listener)this);
    }

    public synchronized void dispose() {
        Iterator images = this.fImageCache.values().iterator();
        while (images.hasNext()) {
            Image image = (Image)images.next();
            image.dispose();
        }
        this.fImageCache.clear();
        Iterator fonts = this.fFontCache.values().iterator();
        while (fonts.hasNext()) {
            Font font = (Font)fonts.next();
            font.dispose();
        }
        this.fFontCache.clear();
        Iterator colors = this.fColorCache.values().iterator();
        while (colors.hasNext()) {
            Color color = (Color)colors.next();
            color.dispose();
        }
        this.fColorCache.clear();
        if (this.fModel != null) {
            this.fModel.dispose();
        }
        if (this.fUpdatePolicy != null) {
            this.fUpdatePolicy.dispose();
        }
        if (this.fContext != null) {
            ((PresentationContext)this.fContext).dispose();
        }
    }

    public void update(Object element) {
        if (element == this.getInput()) {
            return;
        }
        ModelNode[] nodes = this.getModel().getNodes(element);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node = nodes[i];
                this.updateLabel(node);
                ++i;
            }
        }
    }

    protected void updateLabel(ModelNode node) {
        if (!node.getElement().equals(this.getInput())) {
            this.getModel().updateLabel(node);
        }
    }

    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    protected IModelProxyFactoryAdapter getModelProxyFactoryAdapter(Object element) {
        IModelProxyFactoryAdapter adapter = null;
        if (element instanceof IModelProxyFactoryAdapter) {
            adapter = (IModelProxyFactoryAdapter)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelProxyFactoryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (IModelProxyFactoryAdapter)adaptable.getAdapter((Class)clazz);
        }
        return adapter;
    }

    protected synchronized void unmapAllElements() {
        super.unmapAllElements();
        AsynchronousModel model = this.getModel();
        if (model != null) {
            model.dispose();
        }
    }

    protected synchronized void inputChanged(Object input, Object oldInput) {
        this.fParentsPendingChildren.clear();
        if (this.fUpdatePolicy == null) {
            this.fUpdatePolicy = this.createUpdatePolicy();
            this.fUpdatePolicy.init(this);
        }
        if (this.fModel != null) {
            this.fModel.dispose();
        }
        this.fModel = this.createModel();
        this.fModel.init(input);
        if (input != null) {
            this.mapElement(this.fModel.getRootNode(), (Widget)this.getControl());
            this.getControl().setData(this.fModel.getRootNode().getElement());
        } else {
            this.unmapAllElements();
        }
        this.refresh();
    }

    protected abstract AsynchronousModel createModel();

    public abstract AbstractUpdatePolicy createUpdatePolicy();

    Image[] getImages(ImageDescriptor[] descriptors) {
        if (descriptors == null || descriptors.length == 0) {
            String[] columns = this.getPresentationContext().getColumns();
            if (columns == null) {
                return new Image[1];
            }
            return new Image[columns.length];
        }
        Image[] images = new Image[descriptors.length];
        int i = 0;
        while (i < images.length) {
            images[i] = this.getImage(descriptors[i]);
            ++i;
        }
        return images;
    }

    protected Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = (Image)this.fImageCache.get(descriptor);
        if (image == null) {
            image = new Image((Device)this.getControl().getDisplay(), descriptor.getImageData());
            this.fImageCache.put(descriptor, image);
        }
        return image;
    }

    protected Font[] getFonts(FontData[] fontDatas) {
        if (fontDatas == null || fontDatas.length == 0) {
            String[] columns = this.getPresentationContext().getColumns();
            if (columns == null) {
                return new Font[1];
            }
            return new Font[columns.length];
        }
        Font[] fonts = new Font[fontDatas.length];
        int i = 0;
        while (i < fonts.length) {
            fonts[i] = this.getFont(fontDatas[i]);
            ++i;
        }
        return fonts;
    }

    protected Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        Font font = (Font)this.fFontCache.get(fontData);
        if (font == null) {
            font = new Font((Device)this.getControl().getDisplay(), fontData);
            this.fFontCache.put(fontData, font);
        }
        return font;
    }

    protected Color[] getColors(RGB[] rgb) {
        if (rgb == null || rgb.length == 0) {
            String[] columns = this.getPresentationContext().getColumns();
            if (columns == null) {
                return new Color[1];
            }
            return new Color[columns.length];
        }
        Color[] colors = new Color[rgb.length];
        int i = 0;
        while (i < colors.length) {
            colors[i] = this.getColor(rgb[i]);
            ++i;
        }
        return colors;
    }

    protected Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = (Color)this.fColorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)this.getControl().getDisplay(), rgb);
            this.fColorCache.put(rgb, color);
        }
        return color;
    }

    public void setContext(IPresentationContext context) {
        this.fContext = context;
    }

    protected Widget doFindItem(Object element) {
        AsynchronousModel model = this.getModel();
        if (model != null) {
            if (element.equals(model.getRootNode())) {
                return this.doFindInputItem(element);
            }
            Widget[] widgets = this.findItems(element);
            if (widgets.length > 0) {
                return widgets[0];
            }
        }
        return null;
    }

    protected Widget doFindInputItem(Object element) {
        ModelNode node;
        if (element instanceof ModelNode && (node = (ModelNode)element).getElement().equals(this.getInput())) {
            return this.getControl();
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected void internalRefresh(Object element) {
        ModelNode[] nodes;
        AsynchronousModel model = this.getModel();
        if (model != null && (nodes = model.getNodes(element)) != null) {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node = nodes[i];
                Widget item = this.findItem(node);
                if (item != null) {
                    this.internalRefresh(node);
                }
                ++i;
            }
        }
    }

    protected void internalRefresh(ModelNode node) {
        this.updateLabel(node);
    }

    public synchronized void setSelection(ISelection selection, boolean reveal) {
        this.setSelection(selection, reveal, false);
    }

    public synchronized void setSelection(ISelection selection, final boolean reveal, boolean force) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (!this.acceptsSelection(selection)) {
            selection = this.getEmptySelection();
        }
        if (!force && !this.overrideSelection(this.fCurrentSelection, selection)) {
            return;
        }
        this.fPendingSelection = selection;
        if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
            this.attemptSelection(reveal);
        } else {
            WorkbenchJob job = new WorkbenchJob("attemptSelection"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    AsynchronousViewer.this.attemptSelection(reveal);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    protected boolean overrideSelection(ISelection current, ISelection candidate) {
        IModelSelectionPolicy selectionPolicy = this.getSelectionPolicy(current);
        if (selectionPolicy == null) {
            return true;
        }
        if (selectionPolicy.contains(candidate, this.getPresentationContext())) {
            return selectionPolicy.overrides(current, candidate, this.getPresentationContext());
        }
        return !selectionPolicy.isSticky(current, this.getPresentationContext());
    }

    public ISelection getSelection() {
        Control control = this.getControl();
        if (control == null || control.isDisposed() || this.fCurrentSelection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fCurrentSelection;
    }

    protected void handleSelect(SelectionEvent event) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            this.updateSelection(this.newSelectionFromWidget());
        }
    }

    protected void handlePostSelect(SelectionEvent e) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.newSelectionFromWidget());
        this.firePostSelectionChanged(event);
    }

    protected abstract ISelection newSelectionFromWidget();

    protected IModelSelectionPolicy getSelectionPolicy(ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IModelSelectionPolicyFactoryAdapter factory;
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.internal.ui.viewers.provisional.IModelSelectionPolicyFactoryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((factory = (IModelSelectionPolicyFactoryAdapter)adaptable.getAdapter((Class)clazz)) != null) {
                return factory.createModelSelectionPolicyAdapter(adaptable, this.getPresentationContext());
            }
        }
        return null;
    }

    protected final void setSelectionToWidget(ISelection selection, boolean reveal) {
        throw new IllegalArgumentException("This method should not be called");
    }

    protected final void setSelectionToWidget(List l, boolean reveal) {
        throw new IllegalArgumentException("This method should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attemptSelection(boolean reveal) {
        ISelection currentSelection = null;
        AsynchronousViewer asynchronousViewer = this;
        synchronized (asynchronousViewer) {
            if (this.fPendingSelection != null) {
                ISelection remaining = this.doAttemptSelectionToWidget(this.fPendingSelection, reveal);
                if (remaining.isEmpty()) {
                    remaining = null;
                }
                if (!this.fPendingSelection.equals(remaining)) {
                    this.fPendingSelection = remaining;
                    currentSelection = this.newSelectionFromWidget();
                    if (this.isSuppressEqualSelections() && currentSelection.equals(this.fCurrentSelection)) {
                        return;
                    }
                }
            }
        }
        if (currentSelection != null) {
            this.updateSelection(currentSelection);
        }
    }

    protected boolean isSuppressEqualSelections() {
        return true;
    }

    protected abstract ISelection doAttemptSelectionToWidget(ISelection var1, boolean var2);

    protected abstract boolean acceptsSelection(ISelection var1);

    protected abstract ISelection getEmptySelection();

    protected void handlePresentationFailure(IAsynchronousRequestMonitor monitor, IStatus status) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void preservingSelection(Runnable updateCode) {
        if (this.fPendingSelection != null && !this.fPendingSelection.isEmpty()) {
            updateCode.run();
            return;
        }
        ISelection oldSelection = null;
        try {
            oldSelection = this.fCurrentSelection;
            updateCode.run();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (oldSelection == null) {
                oldSelection = new StructuredSelection();
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                if (oldSelection.equals(this.newSelectionFromWidget())) throw throwable;
                this.restoreSelection(oldSelection);
                throw throwable;
            }
            ISelection tempSelection = oldSelection;
            WorkbenchJob job = new WorkbenchJob("attemptSelection", tempSelection){
                private final /* synthetic */ ISelection val$tempSelection;
                {
                    this.val$tempSelection = iSelection;
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!AsynchronousViewer.this.getControl().isDisposed() && !this.val$tempSelection.equals(AsynchronousViewer.this.newSelectionFromWidget())) {
                        AsynchronousViewer.this.restoreSelection(this.val$tempSelection);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            throw throwable;
        }
        {
            Object var3_5 = null;
            if (oldSelection == null) {
                oldSelection = new StructuredSelection();
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                if (oldSelection.equals(this.newSelectionFromWidget())) return;
                this.restoreSelection(oldSelection);
                return;
            }
            ISelection tempSelection = oldSelection;
            WorkbenchJob job = new /* invalid duplicate definition of identical inner class */;
            job.setSystem(true);
            job.schedule();
            return;
        }
    }

    protected synchronized void restoreSelection(ISelection oldSelection) {
        this.doAttemptSelectionToWidget(oldSelection, false);
        this.fCurrentSelection = this.newSelectionFromWidget();
        if (!this.fCurrentSelection.equals(oldSelection)) {
            this.handleInvalidSelection(oldSelection, this.fCurrentSelection);
        }
    }

    protected abstract void setColors(Widget var1, RGB[] var2, RGB[] var3);

    protected abstract void setLabels(Widget var1, String[] var2, ImageDescriptor[] var3);

    protected abstract void setFonts(Widget var1, FontData[] var2);

    protected synchronized void updateSelection(ISelection selection) {
        this.fCurrentSelection = selection;
        super.updateSelection(selection);
    }

    protected void modelProxyAdded(IModelProxy proxy) {
        if (this.fUpdatePolicy instanceof IModelChangedListener) {
            proxy.addModelChangedListener((IModelChangedListener)((Object)this.fUpdatePolicy));
        }
    }

    protected void modelProxyRemoved(IModelProxy proxy) {
        if (this.fUpdatePolicy instanceof IModelChangedListener) {
            proxy.removeModelChangedListener((IModelChangedListener)((Object)this.fUpdatePolicy));
        }
    }

    protected AsynchronousModel getModel() {
        return this.fModel;
    }

    protected void nodeDisposed(ModelNode node) {
        Widget widget = this.findItem(node);
        if (widget != null) {
            this.unmapElement(node);
            widget.dispose();
            ModelNode[] childrenNodes = node.getChildrenNodes();
            if (childrenNodes != null) {
                int i = 0;
                while (i < childrenNodes.length) {
                    this.nodeDisposed(childrenNodes[i]);
                    ++i;
                }
            }
        }
    }

    public void nodeChanged(ModelNode node) {
        Widget widget = this.findItem(node);
        if (widget != null) {
            widget.setData(node.getElement());
            this.internalRefresh(node);
        }
    }

    protected synchronized boolean hasPendingUpdates() {
        return this.getModel().hasPendingUpdates();
    }

    protected void updateComplete(IAsynchronousRequestMonitor monitor) {
    }

    protected void nodeChildrenSet(ModelNode parent, ModelNode[] children) {
        int[] indicies = this.removePendingChildren(parent);
        Widget widget = this.findItem(parent);
        if (widget != null && !widget.isDisposed()) {
            if (indicies != null) {
                int i = 0;
                while (i < indicies.length) {
                    int index = indicies[i];
                    Widget item = this.getChildWidget(widget, index);
                    if (item != null && index < children.length) {
                        ModelNode childNode = children[index];
                        this.mapElement(childNode, item);
                        item.setData(childNode.getElement());
                        this.internalRefresh(childNode);
                    }
                    ++i;
                }
                this.setItemCount(widget, children.length);
            } else {
                this.setItemCount(widget, children.length);
            }
        }
        this.attemptPendingUpdates();
    }

    protected abstract Widget getChildWidget(Widget var1, int var2);

    protected abstract void setItemCount(Widget var1, int var2);

    protected void attemptPendingUpdates() {
        this.attemptSelection(false);
    }

    protected void nodeChildrenChanged(ModelNode parentNode) {
        ModelNode[] childrenNodes = parentNode.getChildrenNodes();
        if (childrenNodes != null) {
            this.nodeChildrenSet(parentNode, childrenNodes);
        } else {
            Widget widget = this.findItem(parentNode);
            if (widget != null && !widget.isDisposed()) {
                int childCount = parentNode.getChildCount();
                this.setItemCount(widget, childCount);
                this.attemptPendingUpdates();
            }
        }
    }

    protected ModelNode findNode(Widget widget) {
        ModelNode[] nodes = this.getModel().getNodes(widget.getData());
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node = nodes[i];
                Widget item = this.findItem(node);
                if (widget == item) {
                    return node;
                }
                ++i;
            }
        }
        return null;
    }

    protected Widget findItem(ModelNode node) {
        return this.findItem(node);
    }

    protected synchronized void addPendingChildIndex(ModelNode parent, int index) {
        int[] indicies = (int[])this.fParentsPendingChildren.get(parent);
        if (indicies == null) {
            indicies = new int[]{index};
        } else {
            int[] next = new int[indicies.length + 1];
            System.arraycopy(indicies, 0, next, 0, indicies.length);
            next[indicies.length] = index;
            indicies = next;
        }
        this.fParentsPendingChildren.put(parent, indicies);
    }

    protected int[] removePendingChildren(ModelNode parent) {
        return (int[])this.fParentsPendingChildren.remove(parent);
    }

    public void handleEvent(Event event) {
        Widget parentItem = this.getParentWidget(event.item);
        int index = event.index;
        ModelNode[] nodes = this.getModel().getNodes(parentItem.getData());
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node = nodes[i];
                Widget widget = this.findItem(node);
                if (widget == parentItem) {
                    ModelNode[] childrenNodes = node.getChildrenNodes();
                    if (childrenNodes != null && index < childrenNodes.length) {
                        ModelNode child = childrenNodes[index];
                        this.mapElement(child, event.item);
                        event.item.setData(child.getElement());
                        this.internalRefresh(child);
                    } else {
                        this.addPendingChildIndex(node, index);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    protected abstract Widget getParentWidget(Widget var1);

    protected void updateChildren(ModelNode parent) {
        this.getModel().updateChildren(parent);
    }

    private class NullContentProvider
    implements IStructuredContentProvider {
        private NullContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return null;
        }
    }
}

