/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class MemoryBlockNavigationModel {
    private ArrayList fElements;
    private AsynchronousTreeViewer fViewer = null;
    private Hashtable fLabels;

    public MemoryBlockNavigationModel(AsynchronousTreeViewer viewer) {
        this.init(viewer);
    }

    private void init(AsynchronousTreeViewer viewer) {
        this.fViewer = viewer;
        this.fElements = new ArrayList();
        this.fLabels = new Hashtable();
        TreeItem[] items = viewer.getTree().getItems();
        this.traverse(items);
    }

    private void traverse(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            Object data = item.getData();
            if (data != null) {
                this.fElements.add(data);
                this.fLabels.put(data, item.getText());
                this.traverse(item.getItems());
            }
            ++i;
        }
    }

    public Object[] getElements() {
        return this.fElements.toArray();
    }

    AsynchronousTreeViewer getViewer() {
        return this.fViewer;
    }

    public String getLabel(Object item) {
        return (String)this.fLabels.get(item);
    }
}

