/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractDebugView
extends PageBookView
implements IDebugView,
IDoubleClickListener {
    private Viewer fViewer = null;
    private MessagePage fMessagePage = null;
    private Map fActionMap = new HashMap(5);
    private List fUpdateables = new ArrayList(3);
    private List fContextMenuManagers;
    private IMemento fMemento;
    private boolean fIsVisible = false;
    private DebugViewPartListener fPartListener = null;
    private String fEarlyMessage = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Object getAdapter(Class adapter) {
        IBaseLabelProvider labelProvider;
        StructuredViewer viewer;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.debug.ui.IDebugModelPresentation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2 && (viewer = this.getStructuredViewer()) != null && (labelProvider = viewer.getLabelProvider()) instanceof IDebugModelPresentation) {
            return labelProvider;
        }
        return super.getAdapter(adapter);
    }

    public void createPartControl(Composite parent) {
        String helpId;
        this.registerPartListener();
        super.createPartControl(parent);
        this.createActions();
        this.initializeToolBar();
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            this.createContextMenu(viewer.getControl());
        }
        if ((helpId = this.getHelpContextId()) != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, helpId);
        }
        if (viewer != null) {
            this.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    AbstractDebugView.this.handleKeyPressed(e);
                }
            });
            if (this.getViewer() instanceof StructuredViewer) {
                ((StructuredViewer)this.getViewer()).addDoubleClickListener((IDoubleClickListener)this);
            }
        }
        this.setMessagePage(new MessagePage());
        this.getMessagePage().createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)this.getMessagePage());
        if (this.fEarlyMessage != null) {
            this.showMessage(this.fEarlyMessage);
            this.fEarlyMessage = null;
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        ViewerPage page = new ViewerPage();
        page.createControl((Composite)book);
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    protected abstract Viewer createViewer(Composite var1);

    protected abstract void createActions();

    protected abstract String getHelpContextId();

    public void dispose() {
        this.saveAllCheckedActionStates();
        this.deregisterPartListener();
        if (this.getViewer() instanceof StructuredViewer) {
            ((StructuredViewer)this.getViewer()).removeDoubleClickListener((IDoubleClickListener)this);
        }
        this.setViewer(null);
        this.fActionMap.clear();
        super.dispose();
    }

    protected void saveAllCheckedActionStates() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] items = tbm.getItems();
        int i = 0;
        while (i < items.length) {
            ActionContributionItem item;
            IAction action;
            IContributionItem iContributionItem = items[i];
            if (iContributionItem instanceof ActionContributionItem && (action = (item = (ActionContributionItem)iContributionItem).getAction()).getStyle() == 2 && action.isEnabled()) {
                this.saveCheckedActionState(action);
            }
            ++i;
        }
    }

    protected void saveCheckedActionState(IAction action) {
        String prefKey = this.generatePreferenceKey(action);
        IPreferenceStore prefStore = this.getPreferenceStore();
        prefStore.setValue(prefKey, action.isChecked());
    }

    protected String generatePreferenceKey(IAction action) {
        return String.valueOf(this.getViewSite().getId()) + '+' + action.getId();
    }

    protected IPreferenceStore getPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public Viewer getViewer() {
        return this.fViewer;
    }

    protected StructuredViewer getStructuredViewer() {
        if (this.getViewer() instanceof StructuredViewer) {
            return (StructuredViewer)this.getViewer();
        }
        return null;
    }

    protected TextViewer getTextViewer() {
        if (this.getViewer() instanceof TextViewer) {
            return (TextViewer)this.getViewer();
        }
        return null;
    }

    public IDebugModelPresentation getPresentation(String id) {
        if (this.getViewer() instanceof StructuredViewer) {
            IBaseLabelProvider lp = ((StructuredViewer)this.getViewer()).getLabelProvider();
            if (lp instanceof DelegatingModelPresentation) {
                return ((DelegatingModelPresentation)lp).getPresentation(id);
            }
            if (lp instanceof LazyModelPresentation && ((LazyModelPresentation)lp).getDebugModelIdentifier().equals(id)) {
                return (IDebugModelPresentation)lp;
            }
        }
        return null;
    }

    protected void createContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractDebugView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
        }
        this.addContextMenuManager((IMenuManager)menuMgr);
    }

    public IMenuManager getContextMenuManager() {
        if (this.fContextMenuManagers != null) {
            this.fContextMenuManagers.get(this.fContextMenuManagers.size() - 1);
        }
        return null;
    }

    public List getContextMenuManagers() {
        return this.fContextMenuManagers;
    }

    protected abstract void fillContextMenu(IMenuManager var1);

    protected void initializeToolBar() {
        final IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.configureToolBar(tbm);
        this.getViewSite().getActionBars().updateActionBars();
        Runnable r = new Runnable(){

            public void run() {
                if (!AbstractDebugView.this.isAvailable()) {
                    return;
                }
                IContributionItem[] items = tbm.getItems();
                if (items != null) {
                    int i = 0;
                    while (i < items.length) {
                        IAction action;
                        if (items[i] instanceof ActionContributionItem && (action = ((ActionContributionItem)items[i]).getAction()).getStyle() == 2) {
                            AbstractDebugView.this.initActionState(action);
                            if (action.isChecked()) {
                                action.run();
                            }
                        }
                        ++i;
                    }
                    AbstractDebugView.this.setMemento(null);
                }
                AbstractDebugView.this.updateObjects();
            }
        };
        this.asyncExec(r);
    }

    protected void initActionState(IAction action) {
        String id = action.getId();
        if (id != null && action.isEnabled()) {
            String prefKey = this.generatePreferenceKey(action);
            boolean checked = this.getPreferenceStore().getBoolean(prefKey);
            action.setChecked(checked);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.setMemento(memento);
    }

    protected void setViewer(Viewer viewer) {
        this.fViewer = viewer;
    }

    protected abstract void configureToolBar(IToolBarManager var1);

    public void setAction(String actionID, IAction action) {
        IActionBars actionBars;
        if (action == null) {
            Object removedAction = this.fActionMap.remove(actionID);
            this.fUpdateables.remove(removedAction);
        } else {
            this.fActionMap.put(actionID, action);
            if (action instanceof IUpdate) {
                this.fUpdateables.add(action);
            }
        }
        if (actionID.equals(SELECT_ALL_ACTION)) {
            actionBars = this.getViewSite().getActionBars();
            actionBars.setGlobalActionHandler(actionID, action);
        } else if (actionID.equals(COPY_ACTION)) {
            actionBars = this.getViewSite().getActionBars();
            actionBars.setGlobalActionHandler(actionID, action);
        } else if (actionID.equals(CUT_ACTION)) {
            actionBars = this.getViewSite().getActionBars();
            actionBars.setGlobalActionHandler(actionID, action);
        } else if (actionID.equals(PASTE_ACTION)) {
            actionBars = this.getViewSite().getActionBars();
            actionBars.setGlobalActionHandler(actionID, action);
        } else if (actionID.equals(FIND_ACTION)) {
            actionBars = this.getViewSite().getActionBars();
            actionBars.setGlobalActionHandler(actionID, action);
        }
    }

    public IAction getAction(String actionID) {
        return (IAction)this.fActionMap.get(actionID);
    }

    public void updateObjects() {
        Iterator actions = this.fUpdateables.iterator();
        while (actions.hasNext()) {
            ((IUpdate)actions.next()).update();
        }
    }

    protected void handleKeyPressed(KeyEvent event) {
        IAction action;
        if (event.character == '\u007f' && event.stateMask == 0 && (action = this.getAction("Remove_ActionId")) != null && action.isEnabled()) {
            action.run();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IAction action = this.getAction("Double_Click_ActionId");
        if (action != null && !event.getSelection().isEmpty() && action.isEnabled()) {
            action.run();
        }
    }

    public void asyncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getControl().getDisplay().asyncExec(r);
        }
    }

    protected Control getControl() {
        return this.getViewer().getControl();
    }

    public void syncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getControl().getDisplay().syncExec(r);
        }
    }

    protected IMemento getMemento() {
        return this.fMemento;
    }

    protected void setMemento(IMemento memento) {
        this.fMemento = memento;
    }

    protected IViewPart findView(String id) {
        IWorkbenchPage page = this.getSite().getPage();
        IViewPart view = null;
        if (page != null) {
            view = page.findView(id);
        }
        return view;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return false;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    protected Control getDefaultControl() {
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            return viewer.getControl();
        }
        return null;
    }

    private void setMessagePage(MessagePage page) {
        this.fMessagePage = page;
    }

    protected MessagePage getMessagePage() {
        return this.fMessagePage;
    }

    public void showMessage(String message) {
        if (this.getPageBook().isDisposed()) {
            return;
        }
        if (this.getMessagePage() == null) {
            this.fEarlyMessage = message;
            return;
        }
        this.getMessagePage().setMessage(message);
        this.getPageBook().showPage(this.getMessagePage().getControl());
    }

    public void showViewer() {
        if (this.getPageBook().isDisposed()) {
            return;
        }
        this.getPageBook().showPage(this.getDefaultPage().getControl());
    }

    public boolean isAvailable() {
        return this.getViewer() != null && this.getViewer().getControl() != null && !this.getViewer().getControl().isDisposed();
    }

    public void add(IUpdate updatable) {
        if (!this.fUpdateables.contains(updatable)) {
            this.fUpdateables.add(updatable);
        }
    }

    public void remove(IUpdate updatable) {
        this.fUpdateables.remove(updatable);
    }

    public void addContextMenuManager(IMenuManager contextMenuManager) {
        if (this.fContextMenuManagers == null) {
            this.fContextMenuManagers = new ArrayList();
        }
        this.fContextMenuManagers.add(contextMenuManager);
    }

    protected void becomesVisible() {
    }

    protected void becomesHidden() {
    }

    public boolean isVisible() {
        return this.fIsVisible;
    }

    protected void registerPartListener() {
        if (this.fPartListener == null) {
            this.fPartListener = new DebugViewPartListener();
            this.getSite().getPage().addPartListener((IPartListener2)this.fPartListener);
        }
    }

    protected void deregisterPartListener() {
        if (this.fPartListener != null) {
            this.getSite().getPage().removePartListener((IPartListener2)this.fPartListener);
            this.fPartListener = null;
        }
    }

    public Map getPresentationAttributes(String modelId) {
        IDebugModelPresentation presentation = this.getPresentation(modelId);
        if (presentation instanceof DelegatingModelPresentation) {
            return ((DelegatingModelPresentation)presentation).getAttributeMap();
        }
        if (presentation instanceof LazyModelPresentation) {
            return ((LazyModelPresentation)presentation).getAttributeMap();
        }
        return new HashMap();
    }

    private class DebugViewPartListener
    implements IPartListener2 {
        private DebugViewPartListener() {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == AbstractDebugView.this) {
                AbstractDebugView.this.fIsVisible = true;
                AbstractDebugView.this.becomesVisible();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            IWorkbenchPart part = ref.getPart(false);
            if (part == AbstractDebugView.this) {
                AbstractDebugView.this.fIsVisible = false;
                AbstractDebugView.this.becomesHidden();
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    }

    class ViewerPage
    extends Page {
        ViewerPage() {
        }

        public void createControl(Composite parent) {
            Viewer viewer = AbstractDebugView.this.createViewer(parent);
            AbstractDebugView.this.setViewer(viewer);
        }

        public Control getControl() {
            return AbstractDebugView.this.getDefaultControl();
        }

        public void setFocus() {
            Control c;
            Viewer viewer = AbstractDebugView.this.getViewer();
            if (viewer != null && !(c = viewer.getControl()).isFocusControl()) {
                c.setFocus();
            }
        }
    }
}

