/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;

public class RunToLineHandler
implements IDebugEventSetListener,
IBreakpointManagerListener,
IWorkspaceRunnable {
    private IDebugTarget fTarget;
    private ISuspendResume fResumee;
    private IBreakpoint fBreakpoint;
    private boolean fAutoSkip = false;
    static /* synthetic */ Class class$0;

    public RunToLineHandler(IDebugTarget target, ISuspendResume suspendResume, IBreakpoint breakpoint) {
        this.fResumee = suspendResume;
        this.fTarget = target;
        this.fBreakpoint = breakpoint;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (source instanceof IThread && event.getKind() == 2 && event.getDetail() == 16) {
                IDebugTarget suspendee;
                IThread thread = (IThread)source;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.fTarget.equals(suspendee = (IDebugTarget)thread.getAdapter((Class)clazz))) {
                    this.cancel();
                }
            } else if (source instanceof IDebugTarget && event.getKind() == 8 && source.equals(this.fTarget)) {
                this.cancel();
            }
            ++i;
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        this.fAutoSkip = false;
    }

    private IBreakpointManager getBreakpointManager() {
        return this.getDebugPlugin().getBreakpointManager();
    }

    private DebugPlugin getDebugPlugin() {
        return DebugPlugin.getDefault();
    }

    /*
     * Exception decompiling
     */
    public void cancel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 60->64)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.getDebugPlugin().addDebugEventListener((IDebugEventSetListener)this);
        IBreakpointManager breakpointManager = this.getBreakpointManager();
        boolean bl = this.fAutoSkip = DebugUITools.getPreferenceStore().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE) && breakpointManager.isEnabled();
        if (this.fAutoSkip) {
            this.getBreakpointManager().setEnabled(false);
            breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        }
        Job job = new Job(ActionMessages.RunToLineHandler_0){

            protected IStatus run(IProgressMonitor jobMonitor) {
                if (!jobMonitor.isCanceled()) {
                    RunToLineHandler.this.fTarget.breakpointAdded(RunToLineHandler.this.fBreakpoint);
                    try {
                        RunToLineHandler.this.fResumee.resume();
                    }
                    catch (DebugException e) {
                        this.cancel();
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

