/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.memory;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.AbstractTableRendering;

public abstract class AbstractTextRendering
extends AbstractTableRendering {
    private String fCodePage;

    public AbstractTextRendering(String renderingId) {
        super(renderingId);
    }

    public AbstractTextRendering(String renderingId, String codePage) {
        super(renderingId);
        this.fCodePage = codePage;
    }

    public void setCodePage(String codePage) {
        this.fCodePage = codePage;
    }

    public String getCodePage() {
        return this.fCodePage;
    }

    public String getString(String dataType, BigInteger address, MemoryByte[] data) {
        String paddedStr;
        block8: {
            paddedStr = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_PADDED_STR);
            if (this.fCodePage != null) break block8;
            return "";
        }
        try {
            boolean invalid = false;
            int i = 0;
            while (i < data.length) {
                if (!data[i].isReadable()) {
                    invalid = true;
                    break;
                }
                ++i;
            }
            if (invalid) {
                StringBuffer strBuf = new StringBuffer();
                int i2 = 0;
                while (i2 < data.length) {
                    strBuf.append(paddedStr);
                    ++i2;
                }
                return strBuf.toString();
            }
            byte[] byteArray = new byte[data.length];
            int i3 = 0;
            while (i3 < byteArray.length) {
                byteArray[i3] = data[i3].getValue();
                ++i3;
            }
            return new String(byteArray, this.fCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "-- error --";
        }
    }

    public byte[] getBytes(String dataType, BigInteger address, MemoryByte[] currentValues, String data) {
        try {
            if (this.fCodePage == null) {
                return new byte[0];
            }
            byte[] bytes = data.getBytes(this.fCodePage);
            return bytes;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }
}

