/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;

public class PerformRefactoringHistoryOperation
implements IWorkspaceRunnable {
    private RefactoringStatus fExecutionStatus = new RefactoringStatus();
    private final RefactoringHistory fRefactoringHistory;

    public PerformRefactoringHistoryOperation(RefactoringHistory history) {
        Assert.isNotNull((Object)((Object)history));
        this.fRefactoringHistory = history;
    }

    protected RefactoringStatus aboutToPerformRefactoring(Refactoring refactoring, RefactoringDescriptor descriptor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)((Object)refactoring));
        Assert.isNotNull((Object)descriptor);
        return new RefactoringStatus();
    }

    protected Refactoring createRefactoring(RefactoringDescriptor descriptor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        return descriptor.createRefactoring(status);
    }

    public final RefactoringStatus getExecutionStatus() {
        return this.fExecutionStatus;
    }

    protected void refactoringPerformed(Refactoring refactoring, IProgressMonitor monitor) {
        Assert.isNotNull((Object)((Object)refactoring));
        Assert.isNotNull((Object)monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        this.fExecutionStatus = new RefactoringStatus();
        RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
        monitor.beginTask(RefactoringCoreMessages.PerformRefactoringHistoryOperation_perform_refactorings, 160 * proxies.length);
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.connect();
            int index = 0;
            while (index < proxies.length && !this.fExecutionStatus.hasFatalError()) {
                block11: {
                    Object var9_10;
                    RefactoringDescriptor descriptor = proxies[index].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                    if (descriptor == null) break block11;
                    Refactoring refactoring = null;
                    try {
                        refactoring = this.createRefactoring(descriptor, this.fExecutionStatus);
                    }
                    catch (CoreException exception) {
                        this.fExecutionStatus.merge(RefactoringStatus.create(exception.getStatus()));
                    }
                    if (refactoring == null) break block11;
                    PerformRefactoringOperation operation = new PerformRefactoringOperation(refactoring, 6);
                    try {
                        RefactoringStatus status = this.aboutToPerformRefactoring(refactoring, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 50, 2));
                        if (!status.hasFatalError()) {
                            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, (IProgressMonitor)new SubProgressMonitor(monitor, 90, 2));
                        } else {
                            this.fExecutionStatus.merge(status);
                        }
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        this.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                        throw throwable;
                    }
                    {
                        var9_10 = null;
                        this.refactoringPerformed(refactoring, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2));
                        this.fExecutionStatus.merge(operation.getConditionStatus());
                        if (this.fExecutionStatus.hasFatalError()) break block11;
                        this.fExecutionStatus.merge(operation.getValidationStatus());
                    }
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            service.disconnect();
            monitor.done();
            throw throwable;
        }
        {
            Object var11_14 = null;
            service.disconnect();
        }
        monitor.done();
    }
}

