/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FileSystemSelectionArea;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class ProjectContentsLocationArea {
    private static String BROWSE_LABEL = IDEWorkbenchMessages.ProjectLocationSelectionDialog_browseLabel;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final String FILE_SCHEME = "file";
    private Label locationLabel;
    private Text locationPathField;
    private Button browseButton;
    private IErrorMessageReporter errorReporter;
    private String projectName = "";
    private String userPath = "";
    private Button useDefaultsButton;
    private IProject existingProject;
    private FileSystemSelectionArea fileSystemSelectionArea;

    public ProjectContentsLocationArea(IErrorMessageReporter reporter, Composite composite, IProject startProject) {
        this.errorReporter = reporter;
        this.projectName = startProject.getName();
        this.existingProject = startProject;
        boolean defaultEnabled = true;
        try {
            defaultEnabled = startProject.getDescription().getLocationURI() == null;
        }
        catch (CoreException coreException) {}
        this.createContents(composite, defaultEnabled);
    }

    public ProjectContentsLocationArea(IErrorMessageReporter reporter, Composite composite) {
        this.errorReporter = reporter;
        this.createContents(composite, true);
    }

    private void createContents(Composite composite, boolean defaultEnabled) {
        int columns = 4;
        Composite projectGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_useDefaultLabel);
        this.useDefaultsButton.setSelection(defaultEnabled);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = columns;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserEntryArea(projectGroup, defaultEnabled);
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefaults = ProjectContentsLocationArea.this.useDefaultsButton.getSelection();
                if (useDefaults) {
                    ProjectContentsLocationArea.this.userPath = ProjectContentsLocationArea.this.locationPathField.getText();
                    ProjectContentsLocationArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsLocationArea.this.getDefaultPathDisplayString()));
                } else {
                    ProjectContentsLocationArea.this.locationPathField.setText(TextProcessor.process((String)ProjectContentsLocationArea.this.userPath));
                }
                ProjectContentsLocationArea.this.setUserAreaEnabled(!useDefaults);
            }
        });
        this.setUserAreaEnabled(!defaultEnabled);
    }

    public boolean isDefault() {
        return this.useDefaultsButton.getSelection();
    }

    private void createUserEntryArea(Composite composite, boolean defaultEnabled) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText(IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationLabel);
        this.locationPathField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        data.horizontalSpan = 2;
        this.locationPathField.setLayoutData((Object)data);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectContentsLocationArea.this.handleLocationBrowseButtonPressed();
            }
        });
        this.createFileSystemSelection(composite);
        if (defaultEnabled) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        } else if (this.existingProject == null) {
            this.locationPathField.setText("");
        } else {
            this.locationPathField.setText(TextProcessor.process((String)this.existingProject.getLocation().toString()));
        }
        this.locationPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectContentsLocationArea.this.errorReporter.reportError(ProjectContentsLocationArea.this.checkValidLocation());
            }
        });
    }

    private void createFileSystemSelection(Composite composite) {
        if (FileSystemSupportRegistry.getInstance().hasOneFileSystem()) {
            return;
        }
        new Label(composite, 0);
        this.fileSystemSelectionArea = new FileSystemSelectionArea();
        this.fileSystemSelectionArea.createContents(composite);
    }

    private String getDefaultPathDisplayString() {
        URI defaultURI = null;
        if (this.existingProject != null) {
            defaultURI = this.existingProject.getLocationURI();
        }
        if (defaultURI == null || defaultURI.getScheme().equals(FILE_SCHEME)) {
            return Platform.getLocation().append(this.projectName).toString();
        }
        return defaultURI.toString();
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.locationLabel.setEnabled(enabled);
        this.locationPathField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        if (this.fileSystemSelectionArea != null) {
            this.fileSystemSelectionArea.setEnabled(enabled);
        }
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        IFileInfo info;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(IDEWorkbenchMessages.ProjectLocationSelectionDialog_directoryLabel);
        String dirName = this.getPathFromLocationField();
        if (!dirName.equals("") && (info = IDEResourceInfoUtils.getFileInfo(dirName)) != null && info.exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.updateLocationField(selectedDirectory);
        }
    }

    private void updateLocationField(String selectedPath) {
        this.locationPathField.setText(TextProcessor.process((String)selectedPath));
    }

    private String getPathFromLocationField() {
        URI fieldURI;
        try {
            fieldURI = new URI(this.locationPathField.getText());
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.locationPathField.getText();
        }
        return fieldURI.getPath();
    }

    public String checkValidLocation() {
        if (this.isDefault()) {
            return null;
        }
        String locationFieldContents = this.locationPathField.getText();
        if (locationFieldContents.length() == 0) {
            return IDEWorkbenchMessages.WizardNewProjectCreationPage_projectLocationEmpty;
        }
        URI newPath = this.getProjectLocationURI();
        if (newPath == null) {
            return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
        }
        if (this.existingProject == null) {
            Path projectPath = new Path(locationFieldContents);
            if (Platform.getLocation().isPrefixOf((IPath)projectPath)) {
                return IDEWorkbenchMessages.WizardNewProjectCreationPage_defaultLocationError;
            }
        } else {
            IStatus locationStatus = this.existingProject.getWorkspace().validateProjectLocationURI(this.existingProject, newPath);
            if (!locationStatus.isOK()) {
                return locationStatus.getMessage();
            }
            URI projectPath = this.existingProject.getLocationURI();
            if (projectPath != null && URIUtil.equals((URI)projectPath, (URI)newPath)) {
                return IDEWorkbenchMessages.ProjectLocationSelectionDialog_locationError;
            }
        }
        return null;
    }

    public URI getProjectLocationURI() {
        FileSystemConfiguration configuration = this.getSelectedConfiguration();
        if (configuration == null) {
            return null;
        }
        return configuration.getContributor().getURI(this.locationPathField.getText());
    }

    private FileSystemConfiguration getSelectedConfiguration() {
        if (this.fileSystemSelectionArea == null) {
            return FileSystemSupportRegistry.getInstance().getDefaultConfiguration();
        }
        return this.fileSystemSelectionArea.getSelectedConfiguration();
    }

    public void updateProjectName(String newName) {
        this.projectName = newName;
        if (this.isDefault()) {
            this.locationPathField.setText(TextProcessor.process((String)this.getDefaultPathDisplayString()));
        }
    }

    public String getProjectLocation() {
        if (this.isDefault()) {
            return Platform.getLocation().toString();
        }
        return this.locationPathField.getText();
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1);
    }
}

