/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public abstract class AbstractWorkspaceOperation
extends AbstractOperation
implements IAdvancedUndoableOperation {
    protected IResource[] resources;
    private IResourceChangeListener listener;
    private boolean isValid = true;
    String[] modelProviderIds;
    static /* synthetic */ Class class$0;

    AbstractWorkspaceOperation(String name) {
        super(name);
        this.addContext(PlatformUI.getWorkbench().getOperationSupport().getUndoContext());
    }

    public void setModelProviderIds(String[] ids) {
        this.modelProviderIds = ids;
    }

    protected void setTargetResources(IResource[] resources) {
        this.resources = resources;
        if (this.listener == null && resources != null) {
            this.addWorkspaceListener();
        }
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private void addWorkspaceListener() {
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    event.getDelta().accept(AbstractWorkspaceOperation.this.getDeltaVisitor());
                }
                catch (CoreException coreException) {
                    AbstractWorkspaceOperation.this.markInvalid();
                }
            }
        };
        this.getWorkspace().addResourceChangeListener(this.listener, 1);
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener(this.listener);
        super.dispose();
    }

    protected void markInvalid() {
        this.isValid = false;
    }

    public boolean canUndo() {
        return this.isValid();
    }

    public boolean canRedo() {
        return this.isValid();
    }

    public IStatus execute(IProgressMonitor monitor, final IAdaptable info) {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doExecute(monitor, info);
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(info), (String)UndoMessages.AbstractWorkspaceOperation_ExecuteErrorTitle, null, (IStatus)e.getStatus());
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, final IAdaptable info) {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doExecute(monitor, info);
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(info), (String)UndoMessages.AbstractWorkspaceOperation_RedoErrorTitle, null, (IStatus)e.getStatus());
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, final IAdaptable info) {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doUndo(monitor, info);
                }
            }, null);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(info), (String)UndoMessages.AbstractWorkspaceOperation_UndoErrorTitle, null, (IStatus)e.getStatus());
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    protected abstract void doUndo(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected abstract void doExecute(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected IResourceDeltaVisitor getDeltaVisitor() {
        return new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                if (AbstractWorkspaceOperation.this.resources == null) {
                    return false;
                }
                int i = 0;
                while (i < AbstractWorkspaceOperation.this.resources.length) {
                    if (AbstractWorkspaceOperation.this.isResourceInvalid(AbstractWorkspaceOperation.this.resources[i], delta)) {
                        AbstractWorkspaceOperation.this.markInvalid();
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        };
    }

    protected boolean isResourceInvalid(IResource resource, IResourceDelta delta) {
        return resource.equals((Object)delta.getResource());
    }

    protected Shell getShell(IAdaptable info) {
        if (info != null) {
            Shell shell;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((shell = (Shell)info.getAdapter((Class)clazz)) != null) {
                return shell;
            }
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected boolean isValid() {
        return this.isValid;
    }

    public void aboutToNotify(OperationHistoryEvent event) {
    }

    public Object[] getAffectedObjects() {
        return this.resources;
    }

    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        boolean proceed;
        IStatus status = Status.OK_STATUS;
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(factory, true) && !(proceed = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_UndoSideEffectsWarningMessage, (Object)this.getLabel()), factory.getDelta(), this.modelProviderIds, true))) {
            status = IOperationHistory.OPERATION_INVALID_STATUS;
            this.markInvalid();
        }
        return status;
    }

    public IStatus computeRedoableStatus(IProgressMonitor monitor) {
        boolean proceed;
        IStatus status = Status.OK_STATUS;
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(factory, false) && !(proceed = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_RedoSideEffectsWarningMessage, (Object)this.getLabel()), factory.getDelta(), this.modelProviderIds, true))) {
            status = IOperationHistory.OPERATION_INVALID_STATUS;
            this.markInvalid();
        }
        return status;
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, boolean undo) {
        return false;
    }

    protected IStatus getErrorStatus(String message) {
        String statusMessage = message;
        if (statusMessage == null) {
            statusMessage = NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_ErrorInvalidMessage, (Object)this.getLabel());
        }
        return new Status(4, "org.eclipse.ui.ide", 3, statusMessage, null);
    }

    protected IStatus getWarningStatus(String message, int code) {
        String statusMessage = message;
        if (statusMessage == null) {
            statusMessage = NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_GenericWarningMessage, (Object)this.getLabel());
        }
        return new Status(2, "org.eclipse.ui.ide", code, statusMessage, null);
    }
}

