/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IConfiguredSiteChangedListener;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.IProblemHandler;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.core.ListenersList;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.operations.UpdateUtils;

public class ConfiguredSite
extends ConfiguredSiteModel
implements IConfiguredSite {
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String EXTENSION_SITE_MARKER = ".eclipseextension";
    private ListenersList listeners = new ListenersList();
    private IStatus verifyStatus;
    private transient boolean justCreated = false;

    public ConfiguredSite() {
    }

    public ConfiguredSite(IConfiguredSite configSite) {
        ConfiguredSite cSite = (ConfiguredSite)configSite;
        this.setSiteModel(cSite.getSiteModel());
        this.setConfigurationPolicyModel(new ConfigurationPolicy(cSite.getConfigurationPolicy()));
        this.setUpdatable(cSite.isUpdatable());
        this.setEnabled(cSite.isEnabled());
        this.setPreviousPluginPath(cSite.getPreviousPluginPath());
        this.setPlatformURLString(cSite.getPlatformURLString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfiguredSiteChangedListener(IConfiguredSiteChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfiguredSiteChangedListener(IConfiguredSiteChangedListener listener) {
        ListenersList listenersList = this.listeners;
        synchronized (listenersList) {
            this.listeners.remove(listener);
        }
    }

    public IFeatureReference install(IFeature feature, IVerificationListener verificationListener, IProgressMonitor monitor) throws InstallAbortedException, CoreException {
        return this.install(feature, null, verificationListener, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFeatureReference install(IFeature feature, IFeatureReference[] optionalFeatures, IVerificationListener verificationListener, IProgressMonitor monitor) throws InstallAbortedException, CoreException {
        IFeatureReference installedFeatureRef;
        block15: {
            if (this.justCreated) {
                this.justCreated = false;
            }
            if (!this.isUpdatable()) {
                String errorMessage = NLS.bind((String)Messages.ConfiguredSite_NonInstallableSite, (Object[])new String[]{this.getSite().getURL().toExternalForm()});
                IStatus status = this.verifyUpdatableStatus();
                if (status != null) {
                    errorMessage = String.valueOf(errorMessage) + " " + status.getMessage();
                }
                throw Utilities.newCoreException(errorMessage, null);
            }
            if (feature == null) {
                String errorMessage = Messages.ConfiguredSite_NullFeatureToInstall;
                throw Utilities.newCoreException(errorMessage, null);
            }
            IFeature installedFeature = null;
            ConfigurationActivity activity = new ConfigurationActivity(1);
            activity.setLabel(feature.getVersionedIdentifier().toString());
            activity.setDate(new Date());
            try {
                try {
                    installedFeatureRef = this.getSite().install(feature, optionalFeatures, verificationListener, monitor);
                    if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                        UpdateCore.debug("Sucessfully installed: " + installedFeatureRef.getURL().toExternalForm());
                    }
                    if (installedFeatureRef != null) {
                        try {
                            installedFeature = installedFeatureRef.getFeature(null);
                        }
                        catch (CoreException e) {
                            UpdateCore.warn(null, e);
                        }
                    }
                    activity.setStatus(0);
                    Object[] siteListeners = this.listeners.getListeners();
                    int i = 0;
                    while (i < siteListeners.length) {
                        if (installedFeature != null) {
                            IConfiguredSiteChangedListener listener = (IConfiguredSiteChangedListener)siteListeners[i];
                            listener.featureInstalled(installedFeature);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    activity.setStatus(1);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                IInstallConfiguration current = SiteManager.getLocalSite().getCurrentConfiguration();
                ((InstallConfiguration)current).addActivity(activity);
                throw throwable;
            }
            {
                Object var11_18 = null;
                IInstallConfiguration current = SiteManager.getLocalSite().getCurrentConfiguration();
                ((InstallConfiguration)current).addActivity(activity);
                if (installedFeature == null) break block15;
            }
            this.configure(installedFeature, optionalFeatures, true);
        }
        return installedFeatureRef;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(IFeature feature, IProgressMonitor monitor) throws CoreException {
        if (!this.isUpdatable()) {
            String errorMessage = NLS.bind((String)Messages.ConfiguredSite_NonUninstallableSite, (Object[])new String[]{this.getSite().getURL().toExternalForm()});
            throw Utilities.newCoreException(errorMessage, null);
        }
        ConfigurationActivity activity = new ConfigurationActivity(2);
        activity.setLabel(feature.getVersionedIdentifier().toString());
        activity.setDate(new Date());
        try {
            try {
                IFeatureReference referenceToRemove = null;
                ISiteFeatureReference[] featureRef = this.getSite().getFeatureReferences();
                ISiteFeatureReference ref = this.getSite().getFeatureReference(feature);
                int i = 0;
                while (i < featureRef.length) {
                    if (featureRef[i].equals(ref)) {
                        referenceToRemove = featureRef[i];
                        break;
                    }
                    ++i;
                }
                if (referenceToRemove == null) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.ConfiguredSite_UnableToFindFeature, (Object[])new String[]{feature.getURL().toString()}), null);
                }
                if (this.getConfigurationPolicy().isConfigured(referenceToRemove)) {
                    IFeature featureToRemove = referenceToRemove.getFeature(null);
                    String featureLabel = featureToRemove == null ? null : featureToRemove.getLabel();
                    throw Utilities.newCoreException(NLS.bind((String)Messages.ConfiguredSite_UnableToRemoveConfiguredFeature, (Object[])new String[]{featureLabel}), null);
                }
                this.getSite().remove(feature, monitor);
                this.getConfigurationPolicy().removeFeatureReference(referenceToRemove);
                activity.setStatus(0);
                Object[] siteListeners = this.listeners.getListeners();
                int i2 = 0;
                while (i2 < siteListeners.length) {
                    ((IConfiguredSiteChangedListener)siteListeners[i2]).featureRemoved(feature);
                    ++i2;
                }
            }
            catch (CoreException e) {
                activity.setStatus(1);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            IInstallConfiguration current = SiteManager.getLocalSite().getCurrentConfiguration();
            ((InstallConfiguration)current).addActivity(activity);
            throw throwable;
        }
        {
            Object var9_16 = null;
            IInstallConfiguration current = SiteManager.getLocalSite().getCurrentConfiguration();
            ((InstallConfiguration)current).addActivity(activity);
            return;
        }
    }

    public void configure(IFeature feature) throws CoreException {
        this.configure(feature, null, true);
    }

    private void configure(IFeature feature, IFeatureReference[] optionalFeatures, boolean callInstallHandler) throws CoreException {
        if (feature == null) {
            UpdateCore.warn("Attempting to configure a null feature in site:" + this.getSite().getURL().toExternalForm());
            return;
        }
        ConfigurationPolicy configPolicy = this.getConfigurationPolicy();
        if (configPolicy == null) {
            return;
        }
        IIncludedFeatureReference[] childrenRef = feature.getIncludedFeatureReferences();
        if (optionalFeatures != null) {
            childrenRef = this.childrenToConfigure(childrenRef, optionalFeatures);
        }
        int i = 0;
        while (i < childrenRef.length) {
            block7: {
                try {
                    IFeature child = childrenRef[i].getFeature(null);
                    this.configure(child, optionalFeatures, callInstallHandler);
                }
                catch (CoreException e) {
                    if (childrenRef[i].isOptional()) break block7;
                    UpdateCore.warn("Unable to configure child feature: " + childrenRef[i] + " " + (Object)((Object)e));
                }
            }
            ++i;
        }
        ISiteFeatureReference featureReference = this.getSite().getFeatureReference(feature);
        configPolicy.configure(featureReference, callInstallHandler, true);
        Object[] siteListeners = this.listeners.getListeners();
        int i2 = 0;
        while (i2 < siteListeners.length) {
            ((IConfiguredSiteChangedListener)siteListeners[i2]).featureConfigured(feature);
            ++i2;
        }
    }

    private IIncludedFeatureReference[] childrenToConfigure(IIncludedFeatureReference[] children, IFeatureReference[] optionalfeatures) {
        ArrayList<IIncludedFeatureReference> childrenToInstall = new ArrayList<IIncludedFeatureReference>();
        int i = 0;
        while (i < children.length) {
            IIncludedFeatureReference optionalFeatureToConfigure = children[i];
            if (!optionalFeatureToConfigure.isOptional()) {
                childrenToInstall.add(optionalFeatureToConfigure);
            } else {
                int j = 0;
                while (j < optionalfeatures.length) {
                    try {
                        IFeature installedChildren = optionalfeatures[j].getFeature(null);
                        if (installedChildren.equals(optionalFeatureToConfigure.getFeature(null))) {
                            childrenToInstall.add(optionalFeatureToConfigure);
                            break;
                        }
                    }
                    catch (CoreException e) {
                        UpdateCore.warn("", e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        IIncludedFeatureReference[] result = new IIncludedFeatureReference[childrenToInstall.size()];
        if (childrenToInstall.size() > 0) {
            childrenToInstall.toArray(result);
        }
        return result;
    }

    public boolean unconfigure(IFeature feature) throws CoreException {
        return this.unconfigure(feature, true, false);
    }

    private boolean unconfigure(IFeature feature, boolean includePatches, boolean verifyEnableParent) throws CoreException {
        ISiteFeatureReference featureReference = this.getSite().getFeatureReference(feature);
        if (featureReference == null) {
            UpdateCore.warn("Unable to retrieve Feature Reference for feature" + feature);
            return false;
        }
        ConfigurationPolicy configPolicy = this.getConfigurationPolicy();
        if (configPolicy == null) {
            return false;
        }
        if (verifyEnableParent && !this.validateNoConfiguredParents(feature)) {
            UpdateCore.warn("The feature " + feature.getVersionedIdentifier() + " to disable is needed by another enable feature");
            return false;
        }
        boolean sucessfullyUnconfigured = false;
        try {
            sucessfullyUnconfigured = configPolicy.unconfigure(featureReference, true, true);
        }
        catch (CoreException e) {
            URL url = featureReference.getURL();
            String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
            UpdateCore.warn("Unable to unconfigure" + urlString, e);
            throw e;
        }
        if (sucessfullyUnconfigured) {
            if (includePatches) {
                this.unconfigurePatches(feature);
            }
            IIncludedFeatureReference[] childrenRef = feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < childrenRef.length) {
                try {
                    IFeature child = childrenRef[i].getFeature(null);
                    this.unconfigure(child, includePatches, true);
                }
                catch (CoreException e) {
                    UpdateCore.warn("Unable to unconfigure child feature: " + childrenRef[i] + " " + (Object)((Object)e));
                }
                ++i;
            }
            Object[] siteListeners = this.listeners.getListeners();
            int i2 = 0;
            while (i2 < siteListeners.length) {
                IConfiguredSiteChangedListener listener = (IConfiguredSiteChangedListener)siteListeners[i2];
                listener.featureUnconfigured(feature);
                ++i2;
            }
            return true;
        }
        URL url = featureReference.getURL();
        String urlString = url != null ? url.toExternalForm() : "<no feature reference url>";
        UpdateCore.warn("Unable to unconfigure:" + urlString);
        return false;
    }

    private void unconfigurePatches(IFeature feature) {
        IFeatureReference[] frefs = this.getConfiguredFeatures();
        int i = 0;
        while (i < frefs.length) {
            IFeatureReference fref = frefs[i];
            try {
                IFeature candidate = fref.getFeature(null);
                if (!candidate.equals(feature) && UpdateUtils.isPatch(feature, candidate)) {
                    this.unconfigure(candidate, false, false);
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
            ++i;
        }
    }

    public IFeatureReference[] getConfiguredFeatures() {
        if (this.isEnabled()) {
            return this.getRawConfiguredFeatures();
        }
        return new ISiteFeatureReference[0];
    }

    private IFeatureReference[] getRawConfiguredFeatures() {
        ConfigurationPolicy configPolicy = this.getConfigurationPolicy();
        if (configPolicy == null) {
            return new ISiteFeatureReference[0];
        }
        return configPolicy.getConfiguredFeatures();
    }

    public IFeatureReference[] getFeatureReferences() {
        ConfigurationPolicy configPolicy = this.getConfigurationPolicy();
        if (configPolicy == null) {
            return new ISiteFeatureReference[0];
        }
        IFeatureReference[] configuredFeatures = this.getConfiguredFeatures();
        int confLen = configuredFeatures.length;
        IFeatureReference[] unconfiguredFeatures = configPolicy.getUnconfiguredFeatures();
        int unconfLen = unconfiguredFeatures.length;
        IFeatureReference[] result = new IFeatureReference[confLen + unconfLen];
        if (confLen > 0) {
            System.arraycopy(configuredFeatures, 0, result, 0, confLen);
        }
        if (unconfLen > 0) {
            System.arraycopy(unconfiguredFeatures, 0, result, confLen, unconfLen);
        }
        return result;
    }

    public void revertTo(IConfiguredSite oldConfiguration, IProgressMonitor monitor, IProblemHandler handler) throws CoreException, InterruptedException {
        ConfiguredSite oldConfiguredSite = (ConfiguredSite)oldConfiguration;
        IFeatureReference[] configuredFeatures = oldConfiguredSite.validConfiguredFeatures(handler);
        int i = 0;
        while (i < configuredFeatures.length) {
            this.getConfigurationPolicy().configure(configuredFeatures[i], true, true);
            ++i;
        }
        List featureToUnconfigure = oldConfiguredSite.calculateUnconfiguredFeatures(configuredFeatures);
        Iterator iter = featureToUnconfigure.iterator();
        while (iter.hasNext()) {
            IFeatureReference element = (IFeatureReference)iter.next();
            try {
                this.getConfigurationPolicy().unconfigure(element, true, true);
            }
            catch (CoreException e) {
                String url = element.getURL().toString();
                ISite site = element.getSite();
                String siteString = site != null ? site.getURL().toExternalForm() : Messages.ConfiguredSite_NoSite;
                UpdateCore.warn(NLS.bind((String)Messages.ConfiguredSite_CannotFindFeatureToUnconfigure, (Object[])new String[]{url, siteString}), e);
            }
        }
    }

    private IFeatureReference[] validConfiguredFeatures(IProblemHandler handler) throws InterruptedException {
        IFeatureReference[] configuredFeatures = this.getConfiguredFeatures();
        if (configuredFeatures != null) {
            int i = 0;
            while (i < configuredFeatures.length) {
                IFeature feature;
                block12: {
                    feature = null;
                    try {
                        feature = configuredFeatures[i].getFeature(null);
                    }
                    catch (CoreException e) {
                        UpdateCore.warn(null, e);
                        String featureString = configuredFeatures[i].getURL().toExternalForm();
                        if (handler.reportProblem(NLS.bind((String)Messages.ConfiguredSite_CannotFindFeatureToConfigure, (Object[])new String[]{featureString}))) break block12;
                        throw new InterruptedException();
                    }
                }
                if (feature != null) {
                    ArrayList<VersionedIdentifier> sitePluginIdentifiers = new ArrayList<VersionedIdentifier>();
                    ISite site = feature.getSite();
                    IPluginEntry[] sitePluginEntries = null;
                    if (site != null) {
                        sitePluginEntries = site.getPluginEntries();
                        int index = 0;
                        while (index < sitePluginEntries.length) {
                            IPluginEntry entry = sitePluginEntries[index];
                            sitePluginIdentifiers.add(entry.getVersionedIdentifier());
                            ++index;
                        }
                    }
                    if (sitePluginEntries.length > 0) {
                        IPluginEntry[] featurePluginEntries = feature.getPluginEntries();
                        int index = 0;
                        while (index < featurePluginEntries.length) {
                            IPluginEntry currentFeaturePluginEntry = featurePluginEntries[index];
                            if (!this.contains(currentFeaturePluginEntry.getVersionedIdentifier(), sitePluginIdentifiers)) {
                                String msg = "Error verifying existence of plugin:" + currentFeaturePluginEntry.getVersionedIdentifier().toString();
                                UpdateCore.log(msg, new Exception());
                                String siteString = site != null ? site.getURL().toExternalForm() : Messages.ConfiguredSite_NoSite;
                                String errorLabel = NLS.bind((String)Messages.ConfiguredSite_CannotFindPluginEntry, (Object[])new String[]{currentFeaturePluginEntry.getVersionedIdentifier().toString(), siteString});
                                if (handler == null) {
                                    throw new InterruptedException(errorLabel);
                                }
                                if (!handler.reportProblem(errorLabel)) {
                                    throw new InterruptedException();
                                }
                            }
                            ++index;
                        }
                    }
                }
                ++i;
            }
        }
        return configuredFeatures;
    }

    private List calculateUnconfiguredFeatures(IFeatureReference[] configuredFeatures) throws CoreException {
        HashSet<IFeatureReference> featureToUnconfigureSet = new HashSet<IFeatureReference>();
        IInstallConfiguration[] history = SiteManager.getLocalSite().getConfigurationHistory();
        int i = 0;
        while (i < history.length) {
            IInstallConfiguration element = history[i];
            IConfiguredSite[] configSites = element.getConfiguredSites();
            int j = 0;
            while (j < configSites.length) {
                ConfiguredSite configSite = (ConfiguredSite)configSites[j];
                if (configSite.getSite().equals(this.getSite())) {
                    featureToUnconfigureSet.addAll(Arrays.asList(configSite.getConfigurationPolicy().getUnconfiguredFeatures()));
                    featureToUnconfigureSet.addAll(Arrays.asList(configSite.getConfigurationPolicy().getConfiguredFeatures()));
                }
                ++j;
            }
            ++i;
        }
        List featureToUnconfigureList = this.remove(configuredFeatures, featureToUnconfigureSet);
        return featureToUnconfigureList;
    }

    private List remove(IFeatureReference[] featureRefs, Set set) {
        ArrayList<IFeatureReference> result = new ArrayList<IFeatureReference>();
        if (set == null) {
            return result;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            IFeatureReference element = (IFeatureReference)iter.next();
            boolean found = false;
            int i = 0;
            while (i < featureRefs.length) {
                if (element.equals(featureRefs[i])) {
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            result.add(element);
        }
        return result;
    }

    private boolean contains(VersionedIdentifier id, List list) {
        boolean found = false;
        if (list != null && !list.isEmpty()) {
            Iterator iter = list.iterator();
            while (iter.hasNext() && !found) {
                VersionedIdentifier element = (VersionedIdentifier)iter.next();
                if (!element.equals(id)) continue;
                found = true;
            }
        }
        return found;
    }

    public ConfigurationPolicy getConfigurationPolicy() {
        return (ConfigurationPolicy)this.getConfigurationPolicyModel();
    }

    public ISite getSite() {
        return (ISite)((Object)this.getSiteModel());
    }

    public IInstallConfiguration getInstallConfiguration() {
        return (IInstallConfiguration)((Object)this.getInstallConfigurationModel());
    }

    public IStatus getBrokenStatus(IFeature feature) {
        IStatus featureStatus = this.createStatus(0, 0, "", null);
        IPluginEntry[] siteEntries = this.getSite().getPluginEntries();
        IPluginEntry[] featuresEntries = feature.getPluginEntries();
        IPluginEntry[] result = UpdateManagerUtils.diff(featuresEntries, siteEntries);
        if (result != null && result.length != 0) {
            String msg = Messages.SiteLocal_FeatureUnHappy;
            MultiStatus multi = new MultiStatus(featureStatus.getPlugin(), 2, msg, null);
            int k = 0;
            while (k < result.length) {
                VersionedIdentifier id = result[k].getVersionedIdentifier();
                Object[] values = new String[]{"", ""};
                if (id != null) {
                    values = new Object[]{id.getIdentifier(), id.getVersion()};
                }
                String msg1 = NLS.bind((String)Messages.ConfiguredSite_MissingPluginsBrokenFeature, (Object[])values);
                UpdateCore.warn(msg1);
                IStatus status = this.createStatus(4, 2, msg1, null);
                multi.add(status);
                ++k;
            }
            return multi;
        }
        String msg = Messages.SiteLocal_FeatureHappy;
        return this.createStatus(0, 0, msg, null);
    }

    public boolean isConfigured(IFeature feature) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.getConfigurationPolicy() == null) {
            return false;
        }
        ISiteFeatureReference featureReference = this.getSite().getFeatureReference(feature);
        if (featureReference == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_WARNINGS) {
                UpdateCore.warn("Unable to retrieve featureReference for feature:" + feature);
            }
            return false;
        }
        return this.getConfigurationPolicy().isConfigured(featureReference);
    }

    public String toString() {
        if (this.getSite() == null) {
            return "No Site";
        }
        if (this.getSite().getURL() == null) {
            return "No URL";
        }
        return this.getSite().getURL().toExternalForm();
    }

    public IStatus verifyUpdatableStatus() {
        if (this.verifyStatus != null) {
            return this.verifyStatus;
        }
        URL siteURL = this.getSite().getURL();
        if (siteURL == null) {
            this.verifyStatus = this.createStatus(4, Messages.ConfiguredSite_SiteURLNull, null);
            return this.verifyStatus;
        }
        if (!"file".equalsIgnoreCase(siteURL.getProtocol())) {
            this.verifyStatus = this.createStatus(4, Messages.ConfiguredSite_NonLocalSite, null);
            return this.verifyStatus;
        }
        String siteLocation = siteURL.getFile();
        File file = new File(siteLocation);
        String productName = ConfiguredSite.getProductName(file);
        if (productName != null) {
            if (!productName.equals(ConfiguredSite.getProductIdentifier("id", ConfiguredSite.getProductFile()))) {
                this.verifyStatus = this.createStatus(4, NLS.bind((String)Messages.ConfiguredSite_NotSameProductId, (Object[])new String[]{productName}), null);
                return this.verifyStatus;
            }
        } else {
            File container = ConfiguredSite.getSiteContaining(file);
            if (container != null) {
                this.verifyStatus = this.createStatus(4, NLS.bind((String)Messages.ConfiguredSite_ContainedInAnotherSite, (Object[])new String[]{container.getAbsolutePath()}), null);
                return this.verifyStatus;
            }
        }
        if (!ConfiguredSite.canWrite(file)) {
            this.verifyStatus = this.createStatus(4, Messages.ConfiguredSite_ReadOnlySite, null);
            return this.verifyStatus;
        }
        this.verifyStatus = this.createStatus(0, "", null);
        this.setUpdatable(true);
        return this.verifyStatus;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canWrite(File file) {
        if (!file.isDirectory() && file.getParentFile() != null) {
            file = file.getParentFile();
        }
        File tryFile = null;
        FileOutputStream out = null;
        try {
            try {
                tryFile = new File(file, "toDelete");
                out = new FileOutputStream(tryFile);
                out.write(0);
            }
            catch (IOException iOException) {
                Object var3_3 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException2) {}
                if (tryFile == null) return false;
                tryFile.delete();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {}
            catch (IOException iOException) {}
            if (out != null) {
                out.close();
            }
            if (tryFile == null) throw throwable;
            tryFile.delete();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (out != null) {
            out.close();
        }
        if (tryFile == null) return true;
        tryFile.delete();
        return true;
    }

    private static File getSiteContaining(File file) {
        if (file == null) {
            return null;
        }
        UpdateCore.warn("IsContained: Checking for markers at:" + file);
        if (file.exists() && file.isDirectory()) {
            File productFile = new File(file, PRODUCT_SITE_MARKER);
            File extensionFile = new File(file, EXTENSION_SITE_MARKER);
            if (productFile.exists() || extensionFile.exists()) {
                return file;
            }
        }
        return ConfiguredSite.getSiteContaining(file.getParentFile());
    }

    private static String getProductName(File file) {
        if (file == null) {
            return null;
        }
        File markerFile = new File(file, EXTENSION_SITE_MARKER);
        if (!markerFile.exists()) {
            return null;
        }
        File productFile = ConfiguredSite.getProductFile();
        String productId = null;
        String privateId = null;
        if (productFile != null) {
            productId = ConfiguredSite.getProductIdentifier("id", productFile);
            privateId = ConfiguredSite.getProductIdentifier("id", markerFile);
            if (productId == null) {
                UpdateCore.warn("Product ID is null at:" + productFile);
                return null;
            }
            if (!productId.equalsIgnoreCase(privateId)) {
                String markerID;
                UpdateCore.warn("Product id at" + productFile + " Different than:" + markerFile);
                String name = ConfiguredSite.getProductIdentifier("name", markerFile);
                String version = ConfiguredSite.getProductIdentifier("version", markerFile);
                String string = markerID = name == null ? version : String.valueOf(name) + ":" + version;
                if (markerID == null) {
                    markerID = "";
                }
                return markerID;
            }
            return privateId;
        }
        UpdateCore.warn("Product Marker doesn't exist:" + productFile);
        return null;
    }

    /*
     * Exception decompiling
     */
    private static String getProductIdentifier(String identifier, File propertyFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 145->148)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File getProductFile() {
        String productInstallDirectory = ConfiguratorUtils.getInstallURL().getFile();
        if (productInstallDirectory != null) {
            File productFile = new File(productInstallDirectory, PRODUCT_SITE_MARKER);
            if (productFile.exists()) {
                return productFile;
            }
            UpdateCore.warn("Product marker doesn't exist:" + productFile);
        } else {
            UpdateCore.warn("Cannot retrieve install URL from BootLoader");
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean createPrivateSiteMarker() {
        URL siteURL = this.getSite().getURL();
        if (siteURL == null) {
            UpdateCore.warn("Unable to create marker. The Site url is null.");
            return false;
        }
        if (!"file".equalsIgnoreCase(siteURL.getProtocol())) {
            UpdateCore.warn("Unable to create private marker. The Site is not on the local file system.");
            return false;
        }
        String siteLocation = siteURL.getFile();
        File productFile = ConfiguredSite.getProductFile();
        boolean success = false;
        if (productFile == null) return success;
        String productId = ConfiguredSite.getProductIdentifier("id", productFile);
        String productName = ConfiguredSite.getProductIdentifier("name", productFile);
        String productVer = ConfiguredSite.getProductIdentifier("version", productFile);
        if (productId == null) return success;
        File file = new File(siteLocation, EXTENSION_SITE_MARKER);
        if (file.exists()) return success;
        FileOutputStream out = null;
        OutputStreamWriter outWriter = null;
        try {
            try {
                out = new FileOutputStream(file);
                outWriter = new OutputStreamWriter((OutputStream)out, "UTF8");
                outWriter.write("id=" + productId + "\n");
                if (productName != null) {
                    outWriter.write("name=" + productName + "\n");
                }
                if (productVer != null) {
                    outWriter.write("version=" + productVer + "\n");
                }
                success = true;
                this.justCreated = true;
            }
            catch (Exception e) {
                UpdateCore.warn("Unable to create private Marker at:" + file, e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (outWriter != null) {
                    outWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (outWriter != null) {
            outWriter.close();
        }
        try {}
        catch (IOException iOException) {
            return success;
        }
        if (out == null) return success;
        ((OutputStream)out).close();
        return success;
    }

    public boolean isExtensionSite() {
        return this.containsMarker(EXTENSION_SITE_MARKER);
    }

    public boolean isProductSite() {
        return this.containsMarker(PRODUCT_SITE_MARKER);
    }

    public boolean isPrivateSite() {
        return this.isExtensionSite();
    }

    private boolean containsMarker(String marker) {
        ISite site = this.getSite();
        if (site == null) {
            UpdateCore.warn("Contains Markers:The site is null");
            return false;
        }
        URL url = site.getURL();
        if (url == null) {
            UpdateCore.warn("Contains Markers:Site URL is null");
            return false;
        }
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            UpdateCore.warn("Contains Markers:Non file protocol");
            return false;
        }
        File file = new File(url.getFile());
        if (!file.exists()) {
            UpdateCore.warn("Contains Markers:The site doesn't exist:" + file);
            return false;
        }
        File extension = new File(file, marker);
        if (!extension.exists()) {
            UpdateCore.warn("Contains Markers:The extensionfile does not exist:" + extension);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNativelyLinked() throws CoreException {
        String platformString = this.getPlatformURLString();
        if (platformString == null) {
            UpdateCore.warn("Unable to retrieve platformString");
            return false;
        }
        URL siteURL = null;
        try {
            URL urlToCheck = new URL(platformString);
            IPlatformConfiguration runtimeConfig = ConfiguratorUtils.getCurrentPlatformConfiguration();
            IPlatformConfiguration.ISiteEntry entry = runtimeConfig.findConfiguredSite(urlToCheck);
            if (entry != null) {
                return entry.isNativelyLinked();
            }
            UpdateCore.warn("Unable to retrieve site:" + platformString + " from platform.");
            IPlatformConfiguration.ISiteEntry[] sites = runtimeConfig.getConfiguredSites();
            int i = 0;
            while (true) {
                if (i >= sites.length) {
                    return false;
                }
                siteURL = sites[i].getURL();
                URL resolvedURL = Platform.resolve((URL)siteURL);
                if (UpdateManagerUtils.sameURL(resolvedURL, urlToCheck)) {
                    return true;
                }
                ++i;
            }
        }
        catch (MalformedURLException e) {
            String msg = NLS.bind((String)Messages.ConfiguredSite_UnableResolveURL, (Object[])new String[]{platformString});
            throw Utilities.newCoreException(msg, e);
        }
        catch (IOException e) {
            String msg = NLS.bind((String)Messages.ConfiguredSite_UnableToAccessSite, (Object[])new Object[]{siteURL});
            throw Utilities.newCoreException(msg, e);
        }
    }

    private boolean validateNoConfiguredParents(IFeature feature) throws CoreException {
        if (feature == null) {
            UpdateCore.warn("ConfigurationPolicy: validate Feature is null");
            return true;
        }
        IFeatureReference[] parents = UpdateManagerUtils.getParentFeatures(feature, this.getConfiguredFeatures(), false);
        return parents.length == 0;
    }
}

