/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.text.RuleBasedBreakIterator;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.CompactByteArray;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class RuleBasedBreakIterator_Old
extends RuleBasedBreakIterator {
    protected static final byte IGNORE = -1;
    private static final String IGNORE_VAR = "_ignore_";
    private static final short START_STATE = 1;
    private static final short STOP_STATE = 0;
    private String description;
    private CompactByteArray charCategoryTable = null;
    private short[] stateTable = null;
    private short[] backwardsStateTable = null;
    private boolean[] endStates = null;
    private boolean[] lookaheadStates = null;
    private int numCategories;
    private CharacterIterator text = null;

    public RuleBasedBreakIterator_Old(String description) {
        this.description = description;
        Builder builder = this.makeBuilder();
        builder.buildBreakIterator();
    }

    protected Builder makeBuilder() {
        return new Builder();
    }

    public Object clone() {
        RuleBasedBreakIterator_Old result = (RuleBasedBreakIterator_Old)super.clone();
        if (this.text != null) {
            result.text = (CharacterIterator)this.text.clone();
        }
        return result;
    }

    public boolean equals(Object that) {
        try {
            RuleBasedBreakIterator_Old other = (RuleBasedBreakIterator_Old)that;
            if (!this.description.equals(other.description)) {
                return false;
            }
            return this.getText().equals(other.getText());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public void debugDumpTables() {
        System.out.println("Character Classes:");
        int n = 257;
        int startCurrentRange = 0;
        int initialStringLength = 0;
        StringBuffer[] charClassRanges = new StringBuffer[this.numCategories];
        int i = 0;
        while (i < this.numCategories) {
            charClassRanges[i] = new StringBuffer();
            ++i;
        }
        i = 0;
        while (i < 65535) {
            byte by;
            if (this.charCategoryTable.elementAt((char)i) != by) {
                if (by != 257) {
                    if (i != startCurrentRange + 1) {
                        charClassRanges[by].append("-" + Integer.toHexString(i - 1));
                    }
                    if (charClassRanges[by].length() % 72 < initialStringLength % 72) {
                        charClassRanges[by].append("\n     ");
                    }
                }
                by = this.charCategoryTable.elementAt((char)i);
                startCurrentRange = i;
                initialStringLength = charClassRanges[by].length();
                if (charClassRanges[by].length() > 0) {
                    charClassRanges[by].append(", ");
                }
                charClassRanges[by].append(Integer.toHexString(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.numCategories) {
            System.out.println(String.valueOf(i) + ":     " + charClassRanges[i]);
            ++i;
        }
        System.out.println("\n\nState Table.   *: end state     %: look ahead state");
        System.out.print("C:\t");
        i = 0;
        while (i < this.numCategories) {
            System.out.print(String.valueOf(Integer.toString(i)) + "\t");
            ++i;
        }
        System.out.println();
        System.out.print("=================================================");
        i = 0;
        while (i < this.stateTable.length) {
            if (i % this.numCategories == 0) {
                System.out.println();
                if (this.endStates[i / this.numCategories]) {
                    System.out.print("*");
                } else {
                    System.out.print(" ");
                }
                if (this.lookaheadStates[i / this.numCategories]) {
                    System.out.print("%");
                } else {
                    System.out.print(" ");
                }
                System.out.print(String.valueOf(Integer.toString(i / this.numCategories)) + ":\t");
            }
            if (this.stateTable[i] == 0) {
                System.out.print(".\t");
            } else {
                System.out.print(String.valueOf(Integer.toString(this.stateTable[i])) + "\t");
            }
            ++i;
        }
        System.out.println();
    }

    public void writeTablesToFile(FileOutputStream file, boolean littleEndian) throws IOException {
        short headerSize;
        DataOutputStream out = new DataOutputStream(file);
        byte[] comment = "Copyright (C) 1999, International Business Machines Corp. and others. All Rights Reserved.".getBytes("US-ASCII");
        short realHeaderSize = (short)(headerSize + ((headerSize = (short)(comment.length + 1 + 24)) % 16 == 0 ? 0 : 16 - headerSize % 16));
        this.writeSwappedShort(realHeaderSize, out, littleEndian);
        out.write(218);
        out.write(39);
        this.writeSwappedShort((short)20, out, littleEndian);
        this.writeSwappedShort((short)0, out, littleEndian);
        if (littleEndian) {
            out.write(0);
        } else {
            out.write(1);
        }
        out.write(0);
        out.write(2);
        out.write(0);
        out.writeInt(1112689491);
        out.writeInt(0);
        out.writeInt(0);
        out.write(comment);
        out.write(0);
        while (headerSize < realHeaderSize) {
            out.write(0);
            headerSize = (short)(headerSize + 1);
        }
        this.writeSwappedInt(this.numCategories, out, littleEndian);
        int fileEnd = 36;
        this.writeSwappedInt(fileEnd, out, littleEndian);
        this.writeSwappedInt(fileEnd += (fileEnd += (this.description.length() + 1) * 2) % 4 == 0 ? 0 : 4 - fileEnd % 4, out, littleEndian);
        this.writeSwappedInt(fileEnd += (fileEnd += this.charCategoryTable.getIndexArray().length * 2) % 4 == 0 ? 0 : 4 - fileEnd % 4, out, littleEndian);
        this.writeSwappedInt(fileEnd += (fileEnd += this.charCategoryTable.getValueArray().length) % 4 == 0 ? 0 : 4 - fileEnd % 4, out, littleEndian);
        this.writeSwappedInt(fileEnd += (fileEnd += this.stateTable.length * 2) % 4 == 0 ? 0 : 4 - fileEnd % 4, out, littleEndian);
        this.writeSwappedInt(fileEnd += (fileEnd += this.backwardsStateTable.length * 2) % 4 == 0 ? 0 : 4 - fileEnd % 4, out, littleEndian);
        this.writeSwappedInt(fileEnd += (fileEnd += this.endStates.length) % 4 == 0 ? 0 : 4 - fileEnd % 4, out, littleEndian);
        this.writeSwappedInt(fileEnd += (fileEnd += this.lookaheadStates.length) % 4 == 0 ? 0 : 4 - fileEnd % 4, out, littleEndian);
        int i = 0;
        while (i < this.description.length()) {
            this.writeSwappedShort((short)this.description.charAt(i), out, littleEndian);
            ++i;
        }
        out.writeShort(0);
        if ((this.description.length() + 1) % 2 == 1) {
            out.writeShort(0);
        }
        char[] temp1 = this.charCategoryTable.getIndexArray();
        int i2 = 0;
        while (i2 < temp1.length) {
            this.writeSwappedShort((short)temp1[i2], out, littleEndian);
            ++i2;
        }
        if (temp1.length % 2 == 1) {
            out.writeShort(0);
        }
        byte[] temp2 = this.charCategoryTable.getValueArray();
        out.write(temp2);
        switch (temp2.length % 4) {
            case 1: {
                out.write(0);
            }
            case 2: {
                out.write(0);
            }
            case 3: {
                out.write(0);
            }
        }
        int i3 = 0;
        while (i3 < this.stateTable.length) {
            this.writeSwappedShort(this.stateTable[i3], out, littleEndian);
            ++i3;
        }
        if (this.stateTable.length % 2 == 1) {
            out.writeShort(0);
        }
        i3 = 0;
        while (i3 < this.backwardsStateTable.length) {
            this.writeSwappedShort(this.backwardsStateTable[i3], out, littleEndian);
            ++i3;
        }
        if (this.backwardsStateTable.length % 2 == 1) {
            out.writeShort(0);
        }
        i3 = 0;
        while (i3 < this.endStates.length) {
            out.writeBoolean(this.endStates[i3]);
            ++i3;
        }
        switch (this.endStates.length % 4) {
            case 1: {
                out.write(0);
            }
            case 2: {
                out.write(0);
            }
            case 3: {
                out.write(0);
            }
        }
        i3 = 0;
        while (i3 < this.lookaheadStates.length) {
            out.writeBoolean(this.lookaheadStates[i3]);
            ++i3;
        }
        switch (this.lookaheadStates.length % 4) {
            case 1: {
                out.write(0);
            }
            case 2: {
                out.write(0);
            }
            case 3: {
                out.write(0);
            }
        }
    }

    protected void writeSwappedShort(short x, DataOutputStream out, boolean littleEndian) throws IOException {
        if (littleEndian) {
            out.write((byte)(x & 0xFF));
            out.write((byte)(x >> 8 & 0xFF));
        } else {
            out.write((byte)(x >> 8 & 0xFF));
            out.write((byte)(x & 0xFF));
        }
    }

    protected void writeSwappedInt(int x, DataOutputStream out, boolean littleEndian) throws IOException {
        if (littleEndian) {
            out.write((byte)(x & 0xFF));
            out.write((byte)(x >> 8 & 0xFF));
            out.write((byte)(x >> 16 & 0xFF));
            out.write((byte)(x >> 24 & 0xFF));
        } else {
            out.write((byte)(x >> 24 & 0xFF));
            out.write((byte)(x >> 16 & 0xFF));
            out.write((byte)(x >> 8 & 0xFF));
            out.write((byte)(x & 0xFF));
        }
    }

    public int first() {
        CharacterIterator t = this.getText();
        t.first();
        return t.getIndex();
    }

    public int last() {
        CharacterIterator t = this.getText();
        t.setIndex(t.getEndIndex());
        return t.getIndex();
    }

    public int next(int n) {
        int result = this.current();
        while (n > 0) {
            result = this.handleNext();
            --n;
        }
        while (n < 0) {
            result = this.previous();
            ++n;
        }
        return result;
    }

    public int next() {
        return this.handleNext();
    }

    public int previous() {
        int lastResult;
        CharacterIterator text = this.getText();
        if (this.current() == text.getBeginIndex()) {
            return -1;
        }
        int start = this.current();
        text.previous();
        int result = lastResult = this.handlePrevious();
        while (result != -1 && result < start) {
            lastResult = result;
            result = this.handleNext();
        }
        text.setIndex(lastResult);
        return lastResult;
    }

    protected static final void checkOffset(int offset, CharacterIterator text) {
        if (offset < text.getBeginIndex() || offset > text.getEndIndex()) {
            throw new IllegalArgumentException("offset out of bounds");
        }
    }

    public int following(int offset) {
        CharacterIterator text = this.getText();
        if (offset == text.getEndIndex()) {
            return -1;
        }
        RuleBasedBreakIterator_Old.checkOffset(offset, text);
        text.setIndex(offset);
        if (offset == text.getBeginIndex()) {
            return this.handleNext();
        }
        int result = this.handlePrevious();
        while (result != -1 && result <= offset) {
            result = this.handleNext();
        }
        return result;
    }

    public int preceding(int offset) {
        CharacterIterator text = this.getText();
        RuleBasedBreakIterator_Old.checkOffset(offset, text);
        text.setIndex(offset);
        return this.previous();
    }

    public boolean isBoundary(int offset) {
        CharacterIterator text = this.getText();
        RuleBasedBreakIterator_Old.checkOffset(offset, text);
        if (offset == text.getBeginIndex()) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    public int current() {
        return this.getText().getIndex();
    }

    public int getRuleStatus() {
        return 0;
    }

    public int getRuleStatusVec(int[] fillInArray) {
        if (fillInArray != null && fillInArray.length >= 1) {
            fillInArray[0] = 0;
        }
        return 1;
    }

    public CharacterIterator getText() {
        if (this.text == null) {
            this.text = new StringCharacterIterator("");
        }
        return this.text;
    }

    public void setText(CharacterIterator newText) {
        int end = newText.getEndIndex();
        newText.setIndex(end);
        this.text = newText.getIndex() != end ? new SafeCharIterator(newText) : newText;
        this.text.first();
    }

    /*
     * Unable to fully structure code
     */
    protected int handleNext() {
        text = this.getText();
        if (text.getIndex() == text.getEndIndex()) {
            return -1;
        }
        result = text.getIndex() + 1;
        lookaheadResult = 0;
        state = 1;
        lastC = c = text.current();
        lastCPos = 0;
        if (this.lookupCategory(c) != -1) ** GOTO lbl30
        while (this.lookupCategory(c) == -1) {
            c = text.next();
        }
        if (Character.getType(c) != 6 && Character.getType(c) != 7) ** GOTO lbl30
        return text.getIndex();
lbl-1000:
        // 1 sources

        {
            category = this.lookupCategory(c);
            if (category != -1) {
                state = this.lookupState(state, category);
            }
            if (this.lookaheadStates[state]) {
                if (this.endStates[state]) {
                    result = lookaheadResult > 0 ? lookaheadResult : text.getIndex() + 1;
                } else {
                    lookaheadResult = text.getIndex() + 1;
                }
            } else if (this.endStates[state]) {
                result = text.getIndex() + 1;
            }
            if (category != -1 && state != 0) {
                lastC = c;
                lastCPos = text.getIndex();
            }
            c = text.next();
lbl30:
            // 3 sources

            ** while (c != '\uffff' && state != 0)
        }
lbl31:
        // 1 sources

        if (c == '\uffff' && lookaheadResult == text.getEndIndex()) {
            result = lookaheadResult;
        } else if ("\n\r\f\u2028\u2029".indexOf(lastC) != -1) {
            result = lastCPos + 1;
        }
        text.setIndex(result);
        return result;
    }

    protected int handlePrevious() {
        CharacterIterator text = this.getText();
        int state = 1;
        int category = 0;
        int lastCategory = 0;
        char c = text.current();
        while (c != '\uffff' && state != 0) {
            lastCategory = category;
            category = this.lookupCategory(c);
            if (category != -1) {
                state = this.lookupBackwardState(state, category);
            }
            c = text.previous();
        }
        if (c != '\uffff') {
            if (lastCategory != -1) {
                text.setIndex(text.getIndex() + 2);
            } else {
                text.next();
            }
        }
        return text.getIndex();
    }

    protected int lookupCategory(char c) {
        return this.charCategoryTable.elementAt(c);
    }

    protected int lookupState(int state, int category) {
        return this.stateTable[state * this.numCategories + category];
    }

    protected int lookupBackwardState(int state, int category) {
        return this.backwardsStateTable[state * this.numCategories + category];
    }

    private static UnicodeSet intersection(UnicodeSet a, UnicodeSet b) {
        UnicodeSet result = new UnicodeSet(a);
        result.retainAll(b);
        return result;
    }

    public static void debugPrintln(String s) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                out.append(c);
            } else {
                out.append("\\u");
                String temp = Integer.toHexString(c);
                out.append("0000".substring(0, 4 - temp.length()));
                out.append(temp);
            }
            ++i;
        }
        System.out.println(out);
    }

    protected class Builder {
        protected Vector categories = null;
        protected Hashtable expressions = null;
        protected UnicodeSet ignoreChars = null;
        protected Vector tempStateTable = null;
        protected Vector decisionPointList = null;
        protected Stack decisionPointStack = null;
        protected Vector loopingStates = null;
        protected Vector statesToBackfill = null;
        protected Vector mergeList = null;
        protected boolean clearLoopingStates = false;
        protected static final int END_STATE_FLAG = 32768;
        protected static final int DONT_LOOP_FLAG = 16384;
        protected static final int LOOKAHEAD_STATE_FLAG = 8192;
        protected static final int ALL_FLAGS = 57344;

        public void buildBreakIterator() {
            Vector tempRuleList = this.buildRuleList(RuleBasedBreakIterator_Old.this.description);
            this.buildCharCategories(tempRuleList);
            this.buildStateTable(tempRuleList);
            this.buildBackwardsStateTable(tempRuleList);
        }

        private Vector buildRuleList(String description) {
            Vector<String> tempRuleList = new Vector<String>();
            Stack<Character> parenStack = new Stack<Character>();
            int p = 0;
            int ruleStart = 0;
            char c = '\u0000';
            int lastC = 0;
            int lastOpen = 0;
            boolean haveEquals = false;
            boolean havePipe = false;
            boolean sawVarName = false;
            boolean sawIllegalChar = false;
            int illegalCharPos = 0;
            if (description.length() != 0 && description.charAt(description.length() - 1) != ';') {
                description = String.valueOf(description) + ";";
            }
            while (p < description.length()) {
                c = description.charAt(p);
                switch (c) {
                    case '(': 
                    case '[': 
                    case '{': {
                        if (lastOpen == 123) {
                            this.error("Can't nest brackets inside {}", p, description);
                        }
                        if (lastOpen == 91 && c != '[') {
                            this.error("Can't nest anything in [] but []", p, description);
                        }
                        if (c == '{' && (haveEquals || havePipe)) {
                            this.error("Unknown variable name", p, description);
                        }
                        lastOpen = c;
                        parenStack.push(new Character(c));
                        if (c != '{') break;
                        sawVarName = true;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        char expectedClose = '\u0000';
                        switch (lastOpen) {
                            case 123: {
                                expectedClose = '}';
                                break;
                            }
                            case 91: {
                                expectedClose = ']';
                                break;
                            }
                            case 40: {
                                expectedClose = ')';
                            }
                        }
                        if (c != expectedClose) {
                            this.error("Unbalanced parentheses", p, description);
                        }
                        if (lastC == lastOpen) {
                            this.error("Parens don't contain anything", p, description);
                        }
                        parenStack.pop();
                        if (!parenStack.empty()) {
                            lastOpen = ((Character)parenStack.peek()).charValue();
                            break;
                        }
                        lastOpen = 0;
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        if ("=/<(|>*+?;\u0000".indexOf(lastC) == -1 || c == '?' && lastC == 42) break;
                        this.error("Misplaced *, +, or ?", p, description);
                        break;
                    }
                    case '=': {
                        if (haveEquals || havePipe) {
                            this.error("More than one = or / in rule", p, description);
                        }
                        haveEquals = true;
                        sawIllegalChar = false;
                        break;
                    }
                    case '/': {
                        if (haveEquals || havePipe) {
                            this.error("More than one = or / in rule", p, description);
                        }
                        if (sawVarName) {
                            this.error("Unknown variable name", p, description);
                        }
                        havePipe = true;
                        break;
                    }
                    case '!': {
                        if (lastC == 59 || lastC == 0) break;
                        this.error("! can only occur at the beginning of a rule", p, description);
                        break;
                    }
                    case '\\': {
                        ++p;
                        break;
                    }
                    case '.': {
                        break;
                    }
                    case '&': 
                    case '-': 
                    case ':': 
                    case '^': {
                        if (lastOpen == 91 || lastOpen == 123 || sawIllegalChar) break;
                        sawIllegalChar = true;
                        illegalCharPos = p;
                        break;
                    }
                    case ';': {
                        if (sawIllegalChar) {
                            this.error("Illegal character", illegalCharPos, description);
                        }
                        if (lastC == 59 || lastC == 0) {
                            this.error("Empty rule", p, description);
                        }
                        if (!parenStack.empty()) {
                            this.error("Unbalanced parenheses", p, description);
                        }
                        if (!parenStack.empty()) break;
                        if (haveEquals) {
                            description = this.processSubstitution(description.substring(ruleStart, p), description, p + 1);
                        } else {
                            if (sawVarName) {
                                this.error("Unknown variable name", p, description);
                            }
                            tempRuleList.addElement(description.substring(ruleStart, p));
                        }
                        ruleStart = p + 1;
                        sawIllegalChar = false;
                        sawVarName = false;
                        havePipe = false;
                        haveEquals = false;
                        break;
                    }
                    case '|': {
                        if (lastC == 124) {
                            this.error("Empty alternative", p, description);
                        }
                        if (!parenStack.empty() && lastOpen == 40) break;
                        this.error("Misplaced |", p, description);
                        break;
                    }
                    default: {
                        if (c < ' ' || c >= '\u007f' || Character.isLetter(c) || Character.isDigit(c) || sawIllegalChar) break;
                        sawIllegalChar = true;
                        illegalCharPos = p;
                    }
                }
                lastC = c;
                ++p;
            }
            if (tempRuleList.size() == 0) {
                this.error("No valid rules in description", p, description);
            }
            return tempRuleList;
        }

        protected String processSubstitution(String substitutionRule, String description, int startPos) {
            int equalPos = substitutionRule.indexOf(61);
            if (substitutionRule.charAt(0) != '$') {
                this.error("Missing '$' on left-hand side of =", startPos, description);
            }
            String replace = substitutionRule.substring(1, equalPos);
            String replaceWith = substitutionRule.substring(equalPos + 1);
            this.handleSpecialSubstitution(replace, replaceWith, startPos, description);
            if (replaceWith.length() == 0) {
                this.error("Nothing on right-hand side of =", startPos, description);
            }
            if (replace.length() == 0) {
                this.error("Nothing on left-hand side of =", startPos, description);
            }
            if (!(replaceWith.charAt(0) == '[' && replaceWith.charAt(replaceWith.length() - 1) == ']' || replaceWith.charAt(0) == '(' && replaceWith.charAt(replaceWith.length() - 1) == ')')) {
                this.error("Illegal right-hand side for =", startPos, description);
            }
            replace = "$" + replace;
            StringBuffer result = new StringBuffer();
            result.append(description.substring(0, startPos));
            int lastPos = startPos;
            int pos = description.indexOf(replace, startPos);
            while (pos != -1) {
                if (description.charAt(pos - 1) == ';' && description.charAt(pos + replace.length()) == '=') {
                    this.error("Attempt to redefine " + replace, pos, description);
                }
                result.append(description.substring(lastPos, pos));
                result.append(replaceWith);
                lastPos = pos + replace.length();
                pos = description.indexOf(replace, lastPos);
            }
            result.append(description.substring(lastPos));
            return result.toString();
        }

        protected void handleSpecialSubstitution(String replace, String replaceWith, int startPos, String description) {
            if (replace.equals(RuleBasedBreakIterator_Old.IGNORE_VAR)) {
                if (replaceWith.charAt(0) == '(') {
                    this.error("Ignore group can't be enclosed in (", startPos, description);
                }
                this.ignoreChars = new UnicodeSet(replaceWith, false);
            }
        }

        protected void buildCharCategories(Vector tempRuleList) {
            int j;
            int bracketLevel = 0;
            int p = 0;
            int lineNum = 0;
            this.expressions = new Hashtable();
            while (lineNum < tempRuleList.size()) {
                String line = (String)tempRuleList.elementAt(lineNum);
                p = 0;
                while (p < line.length()) {
                    char c = line.charAt(p);
                    switch (c) {
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '/': 
                        case ';': 
                        case '?': 
                        case '|': {
                            break;
                        }
                        case '[': {
                            int q = p + 1;
                            ++bracketLevel;
                            while (q < line.length() && bracketLevel != 0) {
                                c = line.charAt(q);
                                if (c == '[') {
                                    ++bracketLevel;
                                } else if (c == ']') {
                                    --bracketLevel;
                                }
                                ++q;
                            }
                            if (this.expressions.get(line.substring(p, q)) == null) {
                                this.expressions.put(line.substring(p, q), new UnicodeSet(line.substring(p, q), false));
                            }
                            p = q - 1;
                            break;
                        }
                        case '\\': {
                            c = line.charAt(++p);
                        }
                        default: {
                            UnicodeSet s = new UnicodeSet();
                            s.add(line.charAt(p));
                            this.expressions.put(line.substring(p, p + 1), s);
                        }
                    }
                    ++p;
                }
                ++lineNum;
            }
            this.categories = new Vector();
            if (this.ignoreChars != null) {
                this.categories.addElement(this.ignoreChars);
            } else {
                this.categories.addElement(new UnicodeSet());
            }
            this.ignoreChars = null;
            this.mungeExpressionList(this.expressions);
            Enumeration<Object> iter = this.expressions.elements();
            while (iter.hasMoreElements()) {
                UnicodeSet work = new UnicodeSet((UnicodeSet)iter.nextElement());
                int j2 = this.categories.size() - 1;
                while (!work.isEmpty() && j2 > 0) {
                    UnicodeSet cat = (UnicodeSet)this.categories.elementAt(j2);
                    UnicodeSet overlap = RuleBasedBreakIterator_Old.intersection(work, cat);
                    if (!overlap.isEmpty()) {
                        if (!overlap.equals(cat)) {
                            cat.removeAll(overlap);
                            this.categories.addElement(overlap);
                        }
                        work.removeAll(overlap);
                    }
                    --j2;
                }
                if (work.isEmpty()) continue;
                this.categories.addElement(work);
            }
            UnicodeSet allChars = new UnicodeSet();
            int i = 1;
            while (i < this.categories.size()) {
                allChars.addAll((UnicodeSet)this.categories.elementAt(i));
                ++i;
            }
            UnicodeSet ignoreChars = (UnicodeSet)this.categories.elementAt(0);
            ignoreChars.removeAll(allChars);
            iter = this.expressions.keys();
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                UnicodeSet cs = (UnicodeSet)this.expressions.get(key);
                StringBuffer cats = new StringBuffer();
                j = 1;
                while (j < this.categories.size()) {
                    UnicodeSet cat = new UnicodeSet((UnicodeSet)this.categories.elementAt(j));
                    if (cs.containsAll(cat)) {
                        cats.append((char)(256 + j));
                        if (cs.equals(cat)) break;
                    }
                    ++j;
                }
                this.expressions.put(key, cats.toString());
            }
            RuleBasedBreakIterator_Old.this.charCategoryTable = new CompactByteArray(0);
            int i2 = 0;
            while (i2 < this.categories.size()) {
                UnicodeSet chars = (UnicodeSet)this.categories.elementAt(i2);
                int n = chars.getRangeCount();
                j = 0;
                while (j < n) {
                    int rangeStart = chars.getRangeStart(j);
                    if (rangeStart >= 65536) break;
                    if (i2 != 0) {
                        RuleBasedBreakIterator_Old.this.charCategoryTable.setElementAt((char)rangeStart, (char)chars.getRangeEnd(j), (byte)i2);
                    } else {
                        RuleBasedBreakIterator_Old.this.charCategoryTable.setElementAt((char)rangeStart, (char)chars.getRangeEnd(j), (byte)-1);
                    }
                    ++j;
                }
                ++i2;
            }
            RuleBasedBreakIterator_Old.this.charCategoryTable.compact();
            RuleBasedBreakIterator_Old.this.numCategories = this.categories.size();
        }

        protected void mungeExpressionList(Hashtable expressions) {
        }

        private void buildStateTable(Vector tempRuleList) {
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator_Old.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator_Old.this.numCategories + 1]);
            int i = 0;
            while (i < tempRuleList.size()) {
                String rule = (String)tempRuleList.elementAt(i);
                if (rule.charAt(0) != '!') {
                    this.parseRule(rule, true);
                }
                ++i;
            }
            this.finishBuildingStateTable(true);
        }

        private void parseRule(String rule, boolean forward) {
            short[] state;
            int currentState;
            int p = 0;
            int lastState = currentState = 1;
            String pendingChars = "";
            this.decisionPointStack = new Stack();
            this.decisionPointList = new Vector();
            this.loopingStates = new Vector();
            this.statesToBackfill = new Vector();
            boolean sawEarlyBreak = false;
            if (!forward) {
                this.loopingStates.addElement(new Integer(1));
            }
            this.decisionPointList.addElement(new Integer(currentState));
            currentState = this.tempStateTable.size() - 1;
            while (p < rule.length()) {
                int i;
                char c = rule.charAt(p);
                this.clearLoopingStates = false;
                if (c == '[' || c == '\\' || Character.isLetter(c) || Character.isDigit(c) || c < ' ' || c == '.' || c >= '\u007f') {
                    if (c != '.') {
                        int q = p;
                        if (c == '\\') {
                            q = p + 2;
                            ++p;
                        } else if (c == '[') {
                            int bracketLevel = 1;
                            while (bracketLevel > 0) {
                                if ((c = rule.charAt(++q)) == '[') {
                                    ++bracketLevel;
                                    continue;
                                }
                                if (c == ']') {
                                    --bracketLevel;
                                    continue;
                                }
                                if (c != '\\') continue;
                                ++q;
                            }
                            ++q;
                        } else {
                            q = p + 1;
                        }
                        pendingChars = (String)this.expressions.get(rule.substring(p, q));
                        p = q - 1;
                    } else {
                        int rowNum = (Integer)this.decisionPointList.lastElement();
                        state = (short[])this.tempStateTable.elementAt(rowNum);
                        if (p + 1 < rule.length() && rule.charAt(p + 1) == '*' && state[0] != 0) {
                            this.decisionPointList.addElement(new Integer(state[0]));
                            pendingChars = "";
                            if (++p + 1 < rule.length() && rule.charAt(p + 1) == '?') {
                                this.setLoopingStates(this.decisionPointList, this.decisionPointList);
                                ++p;
                            }
                        } else {
                            StringBuffer temp = new StringBuffer();
                            i = 0;
                            while (i < RuleBasedBreakIterator_Old.this.numCategories) {
                                temp.append((char)(i + 256));
                                ++i;
                            }
                            pendingChars = temp.toString();
                        }
                    }
                    if (pendingChars.length() != 0) {
                        if (p + 1 < rule.length() && (rule.charAt(p + 1) == '*' || rule.charAt(p + 1) == '?')) {
                            this.decisionPointStack.push(this.decisionPointList.clone());
                        }
                        int newState = this.tempStateTable.size();
                        if (this.loopingStates.size() != 0) {
                            this.statesToBackfill.addElement(new Integer(newState));
                        }
                        state = new short[RuleBasedBreakIterator_Old.this.numCategories + 1];
                        if (sawEarlyBreak) {
                            state[((RuleBasedBreakIterator_Old)RuleBasedBreakIterator_Old.this).numCategories] = 16384;
                        }
                        this.tempStateTable.addElement(state);
                        this.updateStateTable(this.decisionPointList, pendingChars, (short)newState);
                        this.decisionPointList.removeAllElements();
                        lastState = currentState;
                        do {
                            this.decisionPointList.addElement(new Integer(++currentState));
                        } while (currentState + 1 < this.tempStateTable.size());
                    }
                }
                if (c == '+' || c == '*' || c == '?') {
                    if (c == '*' || c == '+') {
                        int i2 = lastState + 1;
                        while (i2 < this.tempStateTable.size()) {
                            Vector<Integer> temp = new Vector<Integer>();
                            temp.addElement(new Integer(i2));
                            this.updateStateTable(temp, pendingChars, (short)(lastState + 1));
                            ++i2;
                        }
                        while (currentState + 1 < this.tempStateTable.size()) {
                            this.decisionPointList.addElement(new Integer(++currentState));
                        }
                    }
                    if (c == '*' || c == '?') {
                        Vector temp = (Vector)this.decisionPointStack.pop();
                        int i3 = 0;
                        while (i3 < this.decisionPointList.size()) {
                            temp.addElement(this.decisionPointList.elementAt(i3));
                            ++i3;
                        }
                        this.decisionPointList = temp;
                        if (c == '*' && p + 1 < rule.length() && rule.charAt(p + 1) == '?') {
                            this.setLoopingStates(this.decisionPointList, this.decisionPointList);
                            ++p;
                        }
                    }
                }
                if (c == '(') {
                    this.tempStateTable.addElement(new short[RuleBasedBreakIterator_Old.this.numCategories + 1]);
                    lastState = currentState++;
                    this.decisionPointList.insertElementAt(new Integer(currentState), 0);
                    this.decisionPointStack.push(this.decisionPointList.clone());
                    this.decisionPointStack.push(new Vector());
                }
                if (c == '|') {
                    Vector oneDown = (Vector)this.decisionPointStack.pop();
                    Vector twoDown = (Vector)this.decisionPointStack.peek();
                    this.decisionPointStack.push(oneDown);
                    i = 0;
                    while (i < this.decisionPointList.size()) {
                        oneDown.addElement(this.decisionPointList.elementAt(i));
                        ++i;
                    }
                    this.decisionPointList = (Vector)twoDown.clone();
                }
                if (c == ')') {
                    Vector exitPoints = (Vector)this.decisionPointStack.pop();
                    int i4 = 0;
                    while (i4 < this.decisionPointList.size()) {
                        exitPoints.addElement(this.decisionPointList.elementAt(i4));
                        ++i4;
                    }
                    this.decisionPointList = exitPoints;
                    if (p + 1 >= rule.length() || rule.charAt(p + 1) != '*' && rule.charAt(p + 1) != '+' && rule.charAt(p + 1) != '?') {
                        this.decisionPointStack.pop();
                    } else {
                        int i5;
                        exitPoints = (Vector)this.decisionPointList.clone();
                        Vector temp = (Vector)this.decisionPointStack.pop();
                        int tempStateNum = (Integer)temp.firstElement();
                        short[] tempState = (short[])this.tempStateTable.elementAt(tempStateNum);
                        if (rule.charAt(p + 1) == '?' || rule.charAt(p + 1) == '*') {
                            i5 = 0;
                            while (i5 < this.decisionPointList.size()) {
                                temp.addElement(this.decisionPointList.elementAt(i5));
                                ++i5;
                            }
                            this.decisionPointList = temp;
                        }
                        if (rule.charAt(p + 1) == '+' || rule.charAt(p + 1) == '*') {
                            i5 = 0;
                            while (i5 < tempState.length) {
                                if (tempState[i5] > tempStateNum) {
                                    this.updateStateTable(exitPoints, new Character((char)(i5 + 256)).toString(), tempState[i5]);
                                }
                                ++i5;
                            }
                        }
                        lastState = currentState;
                        currentState = this.tempStateTable.size() - 1;
                        ++p;
                    }
                }
                if (c == '/') {
                    sawEarlyBreak = true;
                    int i6 = 0;
                    while (i6 < this.decisionPointList.size()) {
                        state = (short[])this.tempStateTable.elementAt((Integer)this.decisionPointList.elementAt(i6));
                        int n = RuleBasedBreakIterator_Old.this.numCategories;
                        state[n] = (short)(state[n] | 0x2000);
                        ++i6;
                    }
                }
                if (this.clearLoopingStates) {
                    this.setLoopingStates(null, this.decisionPointList);
                }
                ++p;
            }
            this.setLoopingStates(null, this.decisionPointList);
            int i = 0;
            while (i < this.decisionPointList.size()) {
                int rowNum = (Integer)this.decisionPointList.elementAt(i);
                state = (short[])this.tempStateTable.elementAt(rowNum);
                int n = RuleBasedBreakIterator_Old.this.numCategories;
                state[n] = (short)(state[n] | 0x8000);
                if (sawEarlyBreak) {
                    int n2 = RuleBasedBreakIterator_Old.this.numCategories;
                    state[n2] = (short)(state[n2] | 0x2000);
                }
                ++i;
            }
        }

        private void updateStateTable(Vector rows, String pendingChars, short newValue) {
            short[] newValues = new short[RuleBasedBreakIterator_Old.this.numCategories + 1];
            int i = 0;
            while (i < pendingChars.length()) {
                newValues[pendingChars.charAt((int)i) - 256] = newValue;
                ++i;
            }
            i = 0;
            while (i < rows.size()) {
                this.mergeStates((Integer)rows.elementAt(i), newValues, rows);
                ++i;
            }
        }

        private void mergeStates(int rowNum, short[] newValues, Vector rowsBeingUpdated) {
            short[] oldValues = (short[])this.tempStateTable.elementAt(rowNum);
            boolean isLoopingState = this.loopingStates.contains(new Integer(rowNum));
            int i = 0;
            while (i < oldValues.length) {
                if (oldValues[i] != newValues[i]) {
                    if (isLoopingState && this.loopingStates.contains(new Integer(oldValues[i]))) {
                        if (newValues[i] != 0) {
                            if (oldValues[i] == 0) {
                                this.clearLoopingStates = true;
                            }
                            oldValues[i] = newValues[i];
                        }
                    } else if (oldValues[i] == 0) {
                        oldValues[i] = newValues[i];
                    } else if (i == RuleBasedBreakIterator_Old.this.numCategories) {
                        oldValues[i] = (short)(newValues[i] & 0xE000 | oldValues[i]);
                    } else if (oldValues[i] != 0 && newValues[i] != 0) {
                        int combinedRowNum = this.searchMergeList(oldValues[i], newValues[i]);
                        if (combinedRowNum != 0) {
                            oldValues[i] = (short)combinedRowNum;
                        } else {
                            int oldRowNum = oldValues[i];
                            int newRowNum = newValues[i];
                            combinedRowNum = this.tempStateTable.size();
                            if (this.mergeList == null) {
                                this.mergeList = new Vector();
                            }
                            this.mergeList.addElement(new int[]{oldRowNum, newRowNum, combinedRowNum});
                            short[] newRow = new short[RuleBasedBreakIterator_Old.this.numCategories + 1];
                            short[] oldRow = (short[])this.tempStateTable.elementAt(oldRowNum);
                            System.arraycopy(oldRow, 0, newRow, 0, RuleBasedBreakIterator_Old.this.numCategories + 1);
                            this.tempStateTable.addElement(newRow);
                            oldValues[i] = (short)combinedRowNum;
                            if ((this.decisionPointList.contains(new Integer(oldRowNum)) || this.decisionPointList.contains(new Integer(newRowNum))) && !this.decisionPointList.contains(new Integer(combinedRowNum))) {
                                this.decisionPointList.addElement(new Integer(combinedRowNum));
                            }
                            if ((rowsBeingUpdated.contains(new Integer(oldRowNum)) || rowsBeingUpdated.contains(new Integer(newRowNum))) && !rowsBeingUpdated.contains(new Integer(combinedRowNum))) {
                                this.decisionPointList.addElement(new Integer(combinedRowNum));
                            }
                            int k = 0;
                            while (k < this.decisionPointStack.size()) {
                                Vector dpl = (Vector)this.decisionPointStack.elementAt(k);
                                if ((dpl.contains(new Integer(oldRowNum)) || dpl.contains(new Integer(newRowNum))) && !dpl.contains(new Integer(combinedRowNum))) {
                                    dpl.addElement(new Integer(combinedRowNum));
                                }
                                ++k;
                            }
                            this.mergeStates(combinedRowNum, (short[])this.tempStateTable.elementAt(newValues[i]), rowsBeingUpdated);
                        }
                    }
                }
                ++i;
            }
        }

        private int searchMergeList(int a, int b) {
            if (this.mergeList == null) {
                return 0;
            }
            int i = 0;
            while (i < this.mergeList.size()) {
                int[] entry = (int[])this.mergeList.elementAt(i);
                if (entry[0] == a && entry[1] == b || entry[0] == b && entry[1] == a) {
                    return entry[2];
                }
                if (entry[2] == a && (entry[0] == b || entry[1] == b)) {
                    return entry[2];
                }
                if (entry[2] == b && (entry[0] == a || entry[1] == a)) {
                    return entry[2];
                }
                ++i;
            }
            return 0;
        }

        private void setLoopingStates(Vector newLoopingStates, Vector endStates) {
            if (!this.loopingStates.isEmpty()) {
                int loopingState = (Integer)this.loopingStates.lastElement();
                int i = 0;
                while (i < endStates.size()) {
                    this.eliminateBackfillStates((Integer)endStates.elementAt(i));
                    ++i;
                }
                i = 0;
                while (i < this.statesToBackfill.size()) {
                    int rowNum = (Integer)this.statesToBackfill.elementAt(i);
                    short[] state = (short[])this.tempStateTable.elementAt(rowNum);
                    state[((RuleBasedBreakIterator_Old)RuleBasedBreakIterator_Old.this).numCategories] = (short)(state[RuleBasedBreakIterator_Old.this.numCategories] & 0xE000 | loopingState);
                    ++i;
                }
                this.statesToBackfill.removeAllElements();
                this.loopingStates.removeAllElements();
            }
            if (newLoopingStates != null) {
                this.loopingStates = (Vector)newLoopingStates.clone();
            }
        }

        private void eliminateBackfillStates(int baseState) {
            if (this.statesToBackfill.contains(new Integer(baseState))) {
                this.statesToBackfill.removeElement(new Integer(baseState));
                short[] state = (short[])this.tempStateTable.elementAt(baseState);
                int i = 0;
                while (i < RuleBasedBreakIterator_Old.this.numCategories) {
                    if (state[i] != 0) {
                        this.eliminateBackfillStates(state[i]);
                    }
                    ++i;
                }
            }
        }

        private void backfillLoopingStates() {
            short[] loopingState = null;
            int loopingStateRowNum = 0;
            int i = 0;
            while (i < this.tempStateTable.size()) {
                short[] state = (short[])this.tempStateTable.elementAt(i);
                int fromState = state[RuleBasedBreakIterator_Old.this.numCategories] & 0xFFFF1FFF;
                if (fromState > 0) {
                    if (fromState != loopingStateRowNum) {
                        loopingStateRowNum = fromState;
                        loopingState = (short[])this.tempStateTable.elementAt(loopingStateRowNum);
                    }
                    int n = RuleBasedBreakIterator_Old.this.numCategories;
                    state[n] = (short)(state[n] & 0xE000);
                    int j = 0;
                    while (j < state.length) {
                        if (state[j] == 0) {
                            state[j] = loopingState[j];
                        } else if (state[j] == 16384) {
                            state[j] = 0;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }

        private void finishBuildingStateTable(boolean forward) {
            int p;
            int lastClass;
            short[] state1;
            this.backfillLoopingStates();
            int[] rowNumMap = new int[this.tempStateTable.size()];
            Stack<Integer> rowsToFollow = new Stack<Integer>();
            rowsToFollow.push(new Integer(1));
            rowNumMap[1] = 1;
            while (rowsToFollow.size() != 0) {
                int rowNum = (Integer)rowsToFollow.pop();
                short[] row = (short[])this.tempStateTable.elementAt(rowNum);
                int i = 0;
                while (i < RuleBasedBreakIterator_Old.this.numCategories) {
                    if (row[i] != 0 && rowNumMap[row[i]] == 0) {
                        rowNumMap[row[i]] = row[i];
                        rowsToFollow.push(new Integer(row[i]));
                    }
                    ++i;
                }
            }
            int[] stateClasses = new int[this.tempStateTable.size()];
            int nextClass = RuleBasedBreakIterator_Old.this.numCategories + 1;
            int i = 1;
            while (i < stateClasses.length) {
                if (rowNumMap[i] != 0) {
                    state1 = (short[])this.tempStateTable.elementAt(i);
                    int j = 0;
                    while (j < RuleBasedBreakIterator_Old.this.numCategories) {
                        if (state1[j] != 0) {
                            int n = i;
                            stateClasses[n] = stateClasses[n] + 1;
                        }
                        ++j;
                    }
                    if (stateClasses[i] == 0) {
                        stateClasses[i] = nextClass;
                    }
                }
                ++i;
            }
            ++nextClass;
            do {
                int currentClass = 1;
                lastClass = nextClass;
                while (currentClass < nextClass) {
                    short[] state2;
                    boolean split = false;
                    state1 = state2 = (short[])null;
                    int i2 = 0;
                    while (i2 < stateClasses.length) {
                        if (stateClasses[i2] == currentClass) {
                            if (state1 == null) {
                                state1 = (short[])this.tempStateTable.elementAt(i2);
                            } else {
                                state2 = (short[])this.tempStateTable.elementAt(i2);
                                int j = 0;
                                while (j < state2.length) {
                                    if (j == RuleBasedBreakIterator_Old.this.numCategories && state1[j] != state2[j] && forward || j != RuleBasedBreakIterator_Old.this.numCategories && stateClasses[state1[j]] != stateClasses[state2[j]]) {
                                        stateClasses[i2] = nextClass;
                                        split = true;
                                        break;
                                    }
                                    ++j;
                                }
                            }
                        }
                        ++i2;
                    }
                    if (split) {
                        ++nextClass;
                    }
                    ++currentClass;
                }
            } while (lastClass != nextClass);
            int[] representatives = new int[nextClass];
            int i3 = 1;
            while (i3 < stateClasses.length) {
                if (representatives[stateClasses[i3]] == 0) {
                    representatives[stateClasses[i3]] = i3;
                } else {
                    rowNumMap[i3] = representatives[stateClasses[i3]];
                }
                ++i3;
            }
            i3 = 1;
            while (i3 < rowNumMap.length) {
                if (rowNumMap[i3] != i3) {
                    this.tempStateTable.setElementAt(null, i3);
                }
                ++i3;
            }
            int newRowNum = 1;
            i3 = 1;
            while (i3 < rowNumMap.length) {
                if (this.tempStateTable.elementAt(i3) != null) {
                    rowNumMap[i3] = newRowNum++;
                }
                ++i3;
            }
            i3 = 1;
            while (i3 < rowNumMap.length) {
                if (this.tempStateTable.elementAt(i3) == null) {
                    rowNumMap[i3] = rowNumMap[rowNumMap[i3]];
                }
                ++i3;
            }
            if (forward) {
                RuleBasedBreakIterator_Old.this.endStates = new boolean[newRowNum];
                RuleBasedBreakIterator_Old.this.lookaheadStates = new boolean[newRowNum];
                RuleBasedBreakIterator_Old.this.stateTable = new short[newRowNum * RuleBasedBreakIterator_Old.this.numCategories];
                p = 0;
                int p2 = 0;
                int i4 = 0;
                while (i4 < this.tempStateTable.size()) {
                    short[] row = (short[])this.tempStateTable.elementAt(i4);
                    if (row != null) {
                        int j = 0;
                        while (j < RuleBasedBreakIterator_Old.this.numCategories) {
                            ((RuleBasedBreakIterator_Old)RuleBasedBreakIterator_Old.this).stateTable[p] = (short)rowNumMap[row[j]];
                            ++p;
                            ++j;
                        }
                        ((RuleBasedBreakIterator_Old)RuleBasedBreakIterator_Old.this).endStates[p2] = (row[RuleBasedBreakIterator_Old.this.numCategories] & 0x8000) != 0;
                        ((RuleBasedBreakIterator_Old)RuleBasedBreakIterator_Old.this).lookaheadStates[p2] = (row[RuleBasedBreakIterator_Old.this.numCategories] & 0x2000) != 0;
                        ++p2;
                    }
                    ++i4;
                }
            } else {
                RuleBasedBreakIterator_Old.this.backwardsStateTable = new short[newRowNum * RuleBasedBreakIterator_Old.this.numCategories];
                p = 0;
                int i5 = 0;
                while (i5 < this.tempStateTable.size()) {
                    short[] row = (short[])this.tempStateTable.elementAt(i5);
                    if (row != null) {
                        int j = 0;
                        while (j < RuleBasedBreakIterator_Old.this.numCategories) {
                            ((RuleBasedBreakIterator_Old)RuleBasedBreakIterator_Old.this).backwardsStateTable[p] = (short)rowNumMap[row[j]];
                            ++p;
                            ++j;
                        }
                    }
                    ++i5;
                }
            }
        }

        private void buildBackwardsStateTable(Vector tempRuleList) {
            this.tempStateTable = new Vector();
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator_Old.this.numCategories + 1]);
            this.tempStateTable.addElement(new short[RuleBasedBreakIterator_Old.this.numCategories + 1]);
            int i = 0;
            while (i < tempRuleList.size()) {
                String rule = (String)tempRuleList.elementAt(i);
                if (rule.charAt(0) == '!') {
                    this.parseRule(rule.substring(1), false);
                }
                ++i;
            }
            this.backfillLoopingStates();
            int backTableOffset = this.tempStateTable.size();
            if (backTableOffset > 2) {
                ++backTableOffset;
            }
            int i2 = 0;
            while (i2 < RuleBasedBreakIterator_Old.this.numCategories + 1) {
                this.tempStateTable.addElement(new short[RuleBasedBreakIterator_Old.this.numCategories + 1]);
                ++i2;
            }
            short[] state = (short[])this.tempStateTable.elementAt(backTableOffset - 1);
            int i3 = 0;
            while (i3 < RuleBasedBreakIterator_Old.this.numCategories) {
                state[i3] = (short)(i3 + backTableOffset);
                ++i3;
            }
            int numRows = RuleBasedBreakIterator_Old.this.stateTable.length / RuleBasedBreakIterator_Old.this.numCategories;
            int column = 0;
            while (column < RuleBasedBreakIterator_Old.this.numCategories) {
                int row = 0;
                while (row < numRows) {
                    int nextRow = RuleBasedBreakIterator_Old.this.lookupState(row, column);
                    if (nextRow != 0) {
                        int nextColumn = 0;
                        while (nextColumn < RuleBasedBreakIterator_Old.this.numCategories) {
                            int cellValue = RuleBasedBreakIterator_Old.this.lookupState(nextRow, nextColumn);
                            if (cellValue != 0) {
                                state = (short[])this.tempStateTable.elementAt(nextColumn + backTableOffset);
                                state[column] = (short)(column + backTableOffset);
                            }
                            ++nextColumn;
                        }
                    }
                    ++row;
                }
                ++column;
            }
            if (backTableOffset > 1) {
                int j;
                state = (short[])this.tempStateTable.elementAt(1);
                int i4 = backTableOffset - 1;
                while (i4 < this.tempStateTable.size()) {
                    short[] state2 = (short[])this.tempStateTable.elementAt(i4);
                    j = 0;
                    while (j < RuleBasedBreakIterator_Old.this.numCategories) {
                        if (state[j] != 0 && state2[j] != 0) {
                            state2[j] = state[j];
                        }
                        ++j;
                    }
                    ++i4;
                }
                state = (short[])this.tempStateTable.elementAt(backTableOffset - 1);
                i4 = 1;
                while (i4 < backTableOffset - 1) {
                    short[] state2 = (short[])this.tempStateTable.elementAt(i4);
                    if ((state2[RuleBasedBreakIterator_Old.this.numCategories] & 0x8000) == 0) {
                        j = 0;
                        while (j < RuleBasedBreakIterator_Old.this.numCategories) {
                            if (state2[j] == 0) {
                                state2[j] = state[j];
                            }
                            ++j;
                        }
                    }
                    ++i4;
                }
            }
            this.finishBuildingStateTable(false);
        }

        protected void error(String message, int position, String context) {
            throw new IllegalArgumentException("Parse error: " + message + "\n" + Utility.escape(context.substring(0, position)) + "\n\n" + Utility.escape(context.substring(position)));
        }

        protected void debugPrintVector(String label, Vector v) {
            System.out.print(label);
            int i = 0;
            while (i < v.size()) {
                System.out.print(String.valueOf(v.elementAt(i).toString()) + "\t");
                ++i;
            }
            System.out.println();
        }

        protected void debugPrintVectorOfVectors(String label1, String label2, Vector v) {
            System.out.println(label1);
            int i = 0;
            while (i < v.size()) {
                this.debugPrintVector(label2, (Vector)v.elementAt(i));
                ++i;
            }
        }

        protected void debugPrintTempStateTable() {
            System.out.println("      tempStateTable:");
            System.out.print("        C:\t");
            int i = 0;
            while (i <= RuleBasedBreakIterator_Old.this.numCategories) {
                System.out.print(String.valueOf(Integer.toString(i)) + "\t");
                ++i;
            }
            System.out.println();
            i = 1;
            while (i < this.tempStateTable.size()) {
                short[] row = (short[])this.tempStateTable.elementAt(i);
                System.out.print("        " + i + ":\t");
                int j = 0;
                while (j < row.length) {
                    if (row[j] == 0) {
                        System.out.print(".\t");
                    } else {
                        System.out.print(String.valueOf(Integer.toString(row[j])) + "\t");
                    }
                    ++j;
                }
                System.out.println();
                ++i;
            }
        }
    }

    private static final class SafeCharIterator
    implements CharacterIterator,
    Cloneable {
        private CharacterIterator base;
        private int rangeStart;
        private int rangeLimit;
        private int currentIndex;

        SafeCharIterator(CharacterIterator base) {
            this.base = base;
            this.rangeStart = base.getBeginIndex();
            this.rangeLimit = base.getEndIndex();
            this.currentIndex = base.getIndex();
        }

        public char first() {
            return this.setIndex(this.rangeStart);
        }

        public char last() {
            return this.setIndex(this.rangeLimit - 1);
        }

        public char current() {
            if (this.currentIndex < this.rangeStart || this.currentIndex >= this.rangeLimit) {
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char next() {
            ++this.currentIndex;
            if (this.currentIndex >= this.rangeLimit) {
                this.currentIndex = this.rangeLimit;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char previous() {
            --this.currentIndex;
            if (this.currentIndex < this.rangeStart) {
                this.currentIndex = this.rangeStart;
                return '\uffff';
            }
            return this.base.setIndex(this.currentIndex);
        }

        public char setIndex(int i) {
            if (i < this.rangeStart || i > this.rangeLimit) {
                throw new IllegalArgumentException("Invalid position");
            }
            this.currentIndex = i;
            return this.current();
        }

        public int getBeginIndex() {
            return this.rangeStart;
        }

        public int getEndIndex() {
            return this.rangeLimit;
        }

        public int getIndex() {
            return this.currentIndex;
        }

        public Object clone() {
            CharacterIterator copyOfBase;
            SafeCharIterator copy = null;
            try {
                copy = (SafeCharIterator)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Clone not supported: " + e);
            }
            copy.base = copyOfBase = (CharacterIterator)this.base.clone();
            return copy;
        }
    }
}

