/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ByteBuffer;
import com.ibm.icu.impl.Utility;

public class ByteArrayWrapper
implements Comparable {
    public byte[] bytes;
    public int size;

    public ByteArrayWrapper() {
    }

    public ByteArrayWrapper(byte[] bytesToAdopt, int size) {
        if (bytesToAdopt == null && size != 0 || size < 0 || size > bytesToAdopt.length) {
            throw new IndexOutOfBoundsException("illegal size: " + size);
        }
        this.bytes = bytesToAdopt;
        this.size = size;
    }

    public ByteArrayWrapper(ByteBuffer source) {
        this.size = source.limit();
        this.bytes = new byte[this.size];
        source.get(this.bytes, 0, this.size);
    }

    public ByteArrayWrapper ensureCapacity(int capacity) {
        if (this.bytes == null || this.bytes.length < capacity) {
            byte[] newbytes = new byte[capacity];
            ByteArrayWrapper.copyBytes(this.bytes, 0, newbytes, 0, this.size);
            this.bytes = newbytes;
        }
        return this;
    }

    public final ByteArrayWrapper set(byte[] src, int start, int limit) {
        this.size = 0;
        this.append(src, start, limit);
        return this;
    }

    public final ByteArrayWrapper append(byte[] src, int start, int limit) {
        int len = limit - start;
        this.ensureCapacity(this.size + len);
        ByteArrayWrapper.copyBytes(src, start, this.bytes, this.size, len);
        this.size += len;
        return this;
    }

    public final byte[] releaseBytes() {
        byte[] result = this.bytes;
        this.bytes = null;
        this.size = 0;
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                result.append(" ");
            }
            result.append(Utility.hex(this.bytes[i] & 0xFF, 2));
            ++i;
        }
        return result.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            ByteArrayWrapper that = (ByteArrayWrapper)other;
            if (this.size != that.size) {
                return false;
            }
            int i = 0;
            while (i < this.size) {
                if (this.bytes[i] != that.bytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int result = this.bytes.length;
        int i = 0;
        while (i < this.size) {
            result = 37 * result + this.bytes[i];
            ++i;
        }
        return result;
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        ByteArrayWrapper that = (ByteArrayWrapper)other;
        int minSize = this.size < that.size ? this.size : that.size;
        int i = 0;
        while (i < minSize) {
            if (this.bytes[i] != that.bytes[i]) {
                return (this.bytes[i] & 0xFF) - (that.bytes[i] & 0xFF);
            }
            ++i;
        }
        return this.size - that.size;
    }

    private static final void copyBytes(byte[] src, int srcoff, byte[] tgt, int tgtoff, int length) {
        if (length < 64) {
            int i = srcoff;
            int n = tgtoff;
            while (--length >= 0) {
                tgt[n] = src[i];
                ++i;
                ++n;
            }
        } else {
            System.arraycopy(src, srcoff, tgt, tgtoff, length);
        }
    }
}

