/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.EclipseClasspath;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SourceAnalyzer {
    private SourceAnalyzer() {
    }

    public static void checkCycles(IJavaProject currentProject, EclipseClasspath classpath, Shell shell) {
        StringBuffer message = new StringBuffer();
        TreeMap src2dir = new TreeMap();
        TreeMap srcdir2classes = new TreeMap();
        SourceAnalyzer.determineSources(currentProject, classpath, src2dir, srcdir2classes);
        Map srcdir2sourcedirs = SourceAnalyzer.determineRequiredSrcDirs(src2dir, srcdir2classes);
        String projectName = currentProject.getProject().getName();
        ArrayList cycle = new ArrayList();
        if (SourceAnalyzer.isCyclic(srcdir2sourcedirs, cycle)) {
            SourceAnalyzer.showCycleWarning(projectName, shell, cycle, message);
            return;
        }
        SourceAnalyzer.checkBuildOrder(classpath, projectName, shell, srcdir2sourcedirs);
    }

    private static void determineSources(IJavaProject currentProject, EclipseClasspath classpath, Map src2dir, Map srcdir2classes) {
        int i = 0;
        while (i < classpath.srcDirs.size()) {
            String srcDir = (String)classpath.srcDirs.get(i);
            String classDir = (String)classpath.classDirs.get(i);
            if (!EclipseClasspath.isReference(srcDir)) {
                File dir;
                if (srcDir.equals(".")) {
                    dir = currentProject.getResource().getLocation().toFile();
                } else {
                    IFile file = currentProject.getProject().getFile(srcDir);
                    dir = file.getLocation().toFile();
                }
                if (EclipseClasspath.isLinkedResource(srcDir)) {
                    String link = classpath.resolveLinkedResource(srcDir);
                    dir = new File(link);
                }
                Set sources = SourceAnalyzer.findFiles(dir, ".java");
                Iterator iter = sources.iterator();
                while (iter.hasNext()) {
                    String srcFile = (String)iter.next();
                    src2dir.put(srcFile, srcDir);
                    IFile classFile = currentProject.getProject().getFile(String.valueOf(classDir) + '/' + srcFile + ".class");
                    if (!classFile.exists()) continue;
                    TreeSet classes = (TreeSet)srcdir2classes.get(srcDir);
                    if (classes == null) {
                        classes = new TreeSet();
                    }
                    classes.addAll(SourceAnalyzer.getRequiredClasses(classFile));
                    srcdir2classes.put(srcDir, classes);
                }
            }
            ++i;
        }
    }

    private static Map determineRequiredSrcDirs(Map src2dir, Map srcdir2classes) {
        TreeMap<String, TreeSet<String>> srcdir2sourcedirs = new TreeMap<String, TreeSet<String>>();
        Iterator iter = srcdir2classes.keySet().iterator();
        while (iter.hasNext()) {
            String srcDir = (String)iter.next();
            Set classes = (Set)srcdir2classes.get(srcDir);
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                String classname = (String)iterator.next();
                String classsrc = (String)src2dir.get(classname);
                if (classsrc == null || classsrc.equals(srcDir)) continue;
                TreeSet<String> sourcedirs = (TreeSet<String>)srcdir2sourcedirs.get(srcDir);
                if (sourcedirs == null) {
                    sourcedirs = new TreeSet<String>();
                }
                sourcedirs.add(classsrc);
                srcdir2sourcedirs.put(srcDir, sourcedirs);
            }
        }
        return srcdir2sourcedirs;
    }

    private static void showCycleWarning(String projectName, Shell shell, List cycle, StringBuffer message) {
        String m = MessageFormat.format(DataTransferMessages.SourceAnalyzer_0, projectName);
        message.append(m);
        message.append(ExportUtil.NEWLINE);
        Iterator iter = cycle.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            s = EclipseClasspath.getLinkedResourceName(s);
            message.append(s);
            message.append(" -> ");
        }
        message.append(EclipseClasspath.getLinkedResourceName((String)cycle.get(0)));
        MessageDialog.openWarning((Shell)shell, (String)DataTransferMessages.SourceAnalyzer_1, (String)message.toString());
    }

    private static void checkBuildOrder(EclipseClasspath classpath, String projectName, Shell shell, Map srcdir2sourcedirs) {
        Iterator iter = srcdir2sourcedirs.keySet().iterator();
        block0: while (iter.hasNext()) {
            String srcdir = (String)iter.next();
            Set sourcedirs = (Set)srcdir2sourcedirs.get(srcdir);
            int classpathIndex = classpath.srcDirs.indexOf(srcdir);
            Iterator iterator = sourcedirs.iterator();
            while (iterator.hasNext()) {
                String requiredSrc = (String)iterator.next();
                int i = classpath.srcDirs.indexOf(requiredSrc);
                if (i <= classpathIndex) continue;
                String s = MessageFormat.format(DataTransferMessages.SourceAnalyzer_3, projectName);
                MessageDialog.openWarning((Shell)shell, (String)DataTransferMessages.SourceAnalyzer_2, (String)(String.valueOf(s) + ExportUtil.NEWLINE + requiredSrc + " <-> " + srcdir + ExportUtil.NEWLINE));
                continue block0;
            }
        }
    }

    public static Set getRequiredClasses(IFile file) {
        TreeSet<String> classes = new TreeSet<String>();
        IClassFile classFile = JavaCore.createClassFileFrom((IFile)file);
        IClassFileReader reader = ToolFactory.createDefaultClassFileReader((IClassFile)classFile, (int)1);
        if (reader == null) {
            return classes;
        }
        IConstantPool pool = reader.getConstantPool();
        int i = 0;
        while (i < pool.getConstantPoolCount()) {
            if (pool.getEntryKind(i) == 7) {
                IConstantPoolEntry entry = pool.decodeEntry(i);
                String classname = new String(entry.getClassInfoName());
                int index = classname.indexOf(36);
                if (index != -1) {
                    classname = classname.substring(0, index);
                }
                classes.add(classname);
            }
            ++i;
        }
        return classes;
    }

    public static Set findFiles(File dir, String extension) {
        TreeSet visited = new TreeSet();
        SourceAnalyzer.findFiles(dir, dir, extension, visited);
        return visited;
    }

    private static void findFiles(File base, File dir, String extension, Set visited) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            int i = 0;
            while (i < children.length) {
                SourceAnalyzer.findFiles(base, children[i], extension, visited);
                ++i;
            }
        } else if (dir.getAbsolutePath().endsWith(extension)) {
            String filename = ExportUtil.removePrefixAndSuffix(dir.getAbsolutePath(), String.valueOf(base.getAbsolutePath()) + File.separator, extension);
            visited.add(filename.replace('\\', '/'));
        }
    }

    private static boolean isCyclic(Map srcdir2sourcedirs, List cycle) {
        return !SourceAnalyzer.isAcyclic(srcdir2sourcedirs, cycle);
    }

    private static boolean isAcyclic(Map srcdir2sourcedirs, List cycle) {
        ArrayList visited = new ArrayList();
        ArrayList exited = new ArrayList();
        Iterator iter = srcdir2sourcedirs.keySet().iterator();
        while (iter.hasNext()) {
            String srcdir = (String)iter.next();
            if (visited.contains(srcdir) || !SourceAnalyzer.circleSearch(srcdir, srcdir2sourcedirs, visited, exited, cycle)) continue;
            return false;
        }
        return true;
    }

    private static boolean circleSearch(String srcdir, Map srcdir2sourcedirs, List visited, List exited, List cycle) {
        boolean res = false;
        visited.add(srcdir);
        cycle.add(srcdir);
        Set sourcedirs = (Set)srcdir2sourcedirs.get(srcdir);
        if (sourcedirs != null) {
            Iterator iter = sourcedirs.iterator();
            while (iter.hasNext()) {
                String src = (String)iter.next();
                if (!visited.contains(src)) {
                    res = SourceAnalyzer.circleSearch(src, srcdir2sourcedirs, visited, exited, cycle);
                } else if (!exited.contains(src)) {
                    res = true;
                }
                if (res) break;
            }
        }
        if (!res) {
            cycle.clear();
        }
        exited.add(srcdir);
        return res;
    }
}

