/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.ExternalHyperlink;
import org.eclipse.ant.internal.ui.editor.AntAutoEditStrategy;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.editor.AntEditorSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.AntSourceViewerInformationControl;
import org.eclipse.ant.internal.ui.editor.OccurrencesFinder;
import org.eclipse.ant.internal.ui.editor.actions.FoldingActionGroup;
import org.eclipse.ant.internal.ui.editor.actions.InformationDispatchAction;
import org.eclipse.ant.internal.ui.editor.actions.OpenDeclarationAction;
import org.eclipse.ant.internal.ui.editor.actions.RenameInFileAction;
import org.eclipse.ant.internal.ui.editor.actions.RunToLineAdapter;
import org.eclipse.ant.internal.ui.editor.actions.ToggleLineBreakpointAction;
import org.eclipse.ant.internal.ui.editor.outline.AntEditorContentOutlinePage;
import org.eclipse.ant.internal.ui.editor.text.AntEditorDocumentProvider;
import org.eclipse.ant.internal.ui.editor.text.AntFoldingStructureProvider;
import org.eclipse.ant.internal.ui.editor.text.IReconcilingParticipant;
import org.eclipse.ant.internal.ui.editor.text.XMLTextHover;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntModelChangeEvent;
import org.eclipse.ant.internal.ui.model.AntModelCore;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.IAntModelListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public class AntEditor
extends TextEditor
implements IReconcilingParticipant,
IProjectionListener {
    protected ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            AntEditor.this.fSelectionSetFromOutline = false;
            AntEditor.this.doSelectionChanged(event);
            AntEditor.this.fSelectionSetFromOutline = true;
        }
    };
    private IAntModelListener fAntModelListener = new IAntModelListener(){

        public void antModelChanged(AntModelChangeEvent event) {
            AntModel model = AntEditor.this.getAntModel();
            if (event.getModel() == model) {
                if (event.isPreferenceChange()) {
                    AntEditor.this.updateEditorImage(model);
                }
                if (AntEditor.this.fFoldingStructureProvider != null) {
                    AntEditor.this.fFoldingStructureProvider.updateFoldingRegions(model);
                }
            }
        }
    };
    protected AntEditorContentOutlinePage fOutlinePage;
    private TabConverter fTabConverter;
    private boolean fInitialReconcile = true;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    private ProjectionSupport fProjectionSupport;
    private AntFoldingStructureProvider fFoldingStructureProvider;
    private boolean fSelectionSetFromOutline = false;
    private FoldingActionGroup fFoldingGroup;
    private Annotation[] fOccurrenceAnnotations = null;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ITextSelection fForcedMarkOccurrencesSelection;
    private ActivationListener fActivationListener = new ActivationListener();
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private AntModel fAntModel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public AntEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AntEditorSourceViewerConfiguration(this));
        this.setDocumentProvider(AntUIPlugin.getDefault().getDocumentProvider());
        AntModelCore.getDefault().addAntModelListener(this.fAntModelListener);
        if (this.isFoldingEnabled()) {
            this.fFoldingStructureProvider = new AntFoldingStructureProvider(this);
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.ant.internal.ui.editor.AntEditorMessages");
        Object action = new ContentAssistAction(bundle, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextOperationAction(bundle, "ContentFormat.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.format");
        this.setAction("ContentFormat", (IAction)action);
        action = new OpenDeclarationAction(this);
        this.setAction("OpenDeclaration", (IAction)action);
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer());
        Object resAction = new TextOperationAction(AntEditorMessages.getResourceBundle(), "ShowTooltip.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(AntEditorMessages.getResourceBundle(), "ShowTooltip.", (TextOperationAction)resAction, this);
        resAction.setActionDefinitionId("org.eclipse.ant.ui.showTooltip");
        this.setAction("ShowTooltip", (IAction)resAction);
        action = new RenameInFileAction(this);
        action.setActionDefinitionId("org.eclipse.ant.ui.renameInFile");
        this.setAction("renameInFile", (IAction)action);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(AntUIPlugin.getDefault().getCombinedPreferenceStore());
        this.setCompatibilityMode(false);
        this.setHelpContextId("org.eclipse.ant.ui.ant_editor_context");
        this.setRulerContextMenuId("org.eclipse.ant.internal.ui.editor.AntEditor.RulerContext");
        this.setEditorContextMenuId("org.eclipse.ant.internal.ui.editor.AntEditor");
        this.fMarkOccurrenceAnnotations = this.getPreferenceStore().getBoolean("editor_mark_occurrences");
        this.fStickyOccurrenceAnnotations = this.getPreferenceStore().getBoolean("stickyOccurrences");
    }

    public Object getAdapter(Class key) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getOutlinePage();
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), key)) != null) {
            return adapter;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz3) {
            return new ToggleLineBreakpointAction();
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.debug.ui.actions.IRunToLineTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz4) {
            return new RunToLineAdapter();
        }
        return super.getAdapter(key);
    }

    private AntEditorContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new AntEditorContentOutlinePage(AntModelCore.getDefault(), this);
            this.fOutlinePage.addPostSelectionChangedListener(this.fSelectionChangedListener);
            this.setOutlinePageInput();
        }
        return this.fOutlinePage;
    }

    private void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        AntElementNode selectedXmlElement;
        IStructuredSelection selection = (IStructuredSelection)selectionChangedEvent.getSelection();
        if (!this.isActivePart() && AntUIPlugin.getActivePage() != null) {
            AntUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        if ((selectedXmlElement = (AntElementNode)selection.getFirstElement()) != null) {
            this.setSelection(selectedXmlElement, !this.isActivePart());
        }
    }

    private boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSelection(AntElementNode reference, boolean moveCursor) {
        if (this.fSelectionSetFromOutline) {
            this.fSelectionSetFromOutline = false;
            return;
        }
        if (reference == null) {
            if (!moveCursor) return;
            this.resetHighlightRange();
            this.markInNavigationHistory();
            return;
        }
        if (moveCursor) {
            this.markInNavigationHistory();
        }
        while (reference.getImportNode() != null) {
            reference = reference.getImportNode();
        }
        if (reference.isExternal()) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText textWidget = sourceViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        try {
            try {
                int length;
                int offset;
                block21: {
                    block20: {
                        block19: {
                            offset = reference.getOffset();
                            if (offset >= 0) break block19;
                            break block20;
                        }
                        length = reference.getSelectionLength();
                        int highLightLength = reference.getLength();
                        textWidget.setRedraw(false);
                        if (highLightLength > 0) {
                            this.setHighlightRange(offset, highLightLength, moveCursor);
                        }
                        if (moveCursor) break block21;
                    }
                    Object var8_7 = null;
                    textWidget.setRedraw(true);
                    return;
                }
                if (offset > -1 && length > 0) {
                    sourceViewer.revealRange(offset, length);
                    sourceViewer.setSelectedRange(offset, length);
                    this.markInNavigationHistory();
                }
            }
            catch (IllegalArgumentException x) {
                AntUIPlugin.log(x);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            textWidget.setRedraw(true);
            throw throwable;
        }
        textWidget.setRedraw(true);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((AntEditorSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property)) {
            Object value = event.getNewValue();
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            int newValue = -1;
            if (value instanceof Integer) {
                newValue = (Integer)value;
            } else if (value instanceof String) {
                newValue = Integer.parseInt((String)value);
            }
            if (newValue != -1) {
                viewer.getTextWidget().setTabs(newValue);
                if (this.fTabConverter != null) {
                    this.fTabConverter.setNumberOfSpacesPerTab(newValue);
                }
            }
            return;
        }
        if ("spaces_for_tabs".equals(property)) {
            if (this.isTabConversionEnabled()) {
                this.startTabConversion();
            } else {
                this.stopTabConversion();
            }
            return;
        }
        if ("editor_mark_occurrences".equals(property)) {
            boolean newBooleanValue = Boolean.valueOf(event.getNewValue().toString());
            if (newBooleanValue != this.fMarkOccurrenceAnnotations) {
                this.fMarkOccurrenceAnnotations = newBooleanValue;
                if (this.fMarkOccurrenceAnnotations) {
                    this.installOccurrencesFinder();
                } else {
                    this.uninstallOccurrencesFinder();
                }
            }
            return;
        }
        if ("stickyOccurrences".equals(property)) {
            boolean newBooleanValue;
            this.fStickyOccurrenceAnnotations = newBooleanValue = Boolean.valueOf(event.getNewValue().toString()).booleanValue();
            return;
        }
        AntEditorSourceViewerConfiguration sourceViewerConfiguration = (AntEditorSourceViewerConfiguration)this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration != null) {
            if (this.affectsTextPresentation(event)) {
                sourceViewerConfiguration.adaptToPreferenceChange(event);
            }
            sourceViewerConfiguration.changeConfiguration(event);
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.fAntModel = null;
        super.doSetInput(input);
        this.setOutlinePageInput();
        if (this.fFoldingStructureProvider != null) {
            this.fFoldingStructureProvider.setDocument(this.getDocumentProvider().getDocument((Object)input));
        }
    }

    private void setOutlinePageInput() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setPageInput(this.getAntModel());
        }
    }

    public AntModel getAntModel() {
        IDocumentProvider provider;
        if (this.fAntModel == null && (provider = this.getDocumentProvider()) instanceof AntEditorDocumentProvider) {
            AntEditorDocumentProvider documentProvider = (AntEditorDocumentProvider)provider;
            this.fAntModel = documentProvider.getAntModel(this.getEditorInput());
        }
        return this.fAntModel;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StatusLineSourceViewer viewer = new StatusLineSourceViewer(parent, ruler, this.getOverviewRuler(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    protected void setStatusLineErrorMessage(String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
    }

    public void openReferenceElement() {
        ISelection selection = this.getSelectionProvider().getSelection();
        Object target = null;
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            ISourceViewer viewer = this.getSourceViewer();
            int textOffset = textSelection.getOffset();
            IRegion region = XMLTextHover.getRegion((ITextViewer)viewer, textOffset);
            target = this.findTarget(region);
        }
        this.openTarget(target);
    }

    protected void openTarget(Object node) {
        String errorMessage = null;
        if (node instanceof AntElementNode ? (errorMessage = this.openNode((AntElementNode)node)) == null : node instanceof String && (errorMessage = this.openInEditor((String)node, this.getAntModel().getEditedFile())) == null) {
            return;
        }
        if (errorMessage == null || errorMessage.length() == 0) {
            errorMessage = AntEditorMessages.getString("AntEditor.3");
        }
        this.setStatusLineErrorMessage(errorMessage);
        this.getSite().getShell().getDisplay().beep();
    }

    public Object findTarget(IRegion region) {
        ISourceViewer viewer = this.getSourceViewer();
        AntElementNode node = null;
        if (region != null) {
            IDocument document = viewer.getDocument();
            String text = null;
            try {
                text = document.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException badLocationException) {}
            if (text != null && text.length() > 0) {
                AntModel model = this.getAntModel();
                if (model == null) {
                    return null;
                }
                node = model.getReferenceNode(text);
                if (node == null && (node = model.getTargetNode(text)) == null && (node = model.getPropertyNode(text)) == null) {
                    String path = model.getPath(text, region.getOffset());
                    if (path != null) {
                        return path;
                    }
                    node = model.getDefininingTaskNode(text);
                    if (node == null) {
                        node = model.getMacroDefAttributeNode(text);
                    }
                }
            }
        }
        return node;
    }

    private String openNode(AntElementNode node) {
        String errorMessage = null;
        if (node.isExternal()) {
            String path = node.getFilePath();
            errorMessage = this.openInEditor(path, null);
        } else {
            this.setSelection(node, true);
        }
        return errorMessage;
    }

    private String openInEditor(String path, File buildFile) {
        IFile file;
        File buildFileParent = null;
        if (buildFile != null) {
            buildFileParent = buildFile.getParentFile();
        }
        if ((file = AntUtil.getFileForLocation(path, buildFileParent)) != null && file.exists()) {
            try {
                IWorkbenchPage p = this.getEditorSite().getPage();
                if (p != null) {
                    IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)this.isActivePart());
                }
                return null;
            }
            catch (PartInitException e) {
                return e.getLocalizedMessage();
            }
        }
        File externalFile = new File(path);
        if (externalFile.exists()) {
            new ExternalHyperlink(externalFile, -1).linkActivated();
            return null;
        }
        return "";
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.getAntModel() != null) {
            IAction action = this.getAction("OpenDeclaration");
            if (action != null) {
                String openGroup = "group.open";
                menu.appendToGroup("group.undo", (IContributionItem)new Separator(openGroup));
                menu.appendToGroup(openGroup, action);
            }
            action = this.getAction("renameInFile");
            String editGroup = "group.edit";
            menu.appendToGroup("group.edit", (IContributionItem)new Separator(editGroup));
            menu.appendToGroup(editGroup, action);
            action = this.getAction("ContentFormat");
            menu.appendToGroup(editGroup, action);
        }
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.fTabConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.fTabConverter.setNumberOfSpacesPerTab(this.getTabSize());
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            viewer.setTextConverter(this.fTabConverter);
            viewer.updateIndentationPrefixes();
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            StatusLineSourceViewer viewer = (StatusLineSourceViewer)this.getSourceViewer();
            viewer.setTextConverter(null);
            viewer.updateIndentationPrefixes();
            this.fTabConverter = null;
        }
    }

    protected int getTabSize() {
        IPreferenceStore preferences = this.getPreferenceStore();
        return preferences.getInt("tabWidth");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.createFoldingSupport(projectionViewer);
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        if (this.fMarkOccurrenceAnnotations) {
            this.installOccurrencesFinder();
        }
        this.getEditorSite().getShell().addShellListener((ShellListener)this.fActivationListener);
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
    }

    private void createFoldingSupport(ProjectionViewer projectionViewer) {
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new AntSourceViewerInformationControl(shell);
            }
        });
        this.fProjectionSupport.install();
        ((ProjectionViewer)this.getViewer()).addProjectionListener((IProjectionListener)this);
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("editor_folding_enabled");
    }

    protected boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("spaces_for_tabs");
    }

    public void dispose() {
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        ((ProjectionViewer)this.getViewer()).removeProjectionListener((IProjectionListener)this);
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        this.uninstallOccurrencesFinder();
        if (this.fActivationListener != null) {
            Shell shell = this.getEditorSite().getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.removeShellListener((ShellListener)this.fActivationListener);
            }
            this.fActivationListener = null;
        }
        AntModelCore.getDefault().removeAntModelListener(this.fAntModelListener);
        this.fAntModel = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        AntModel model = this.getAntModel();
        model.updateMarkers();
        this.updateEditorImage(model);
    }

    private void updateEditorImage(AntModel model) {
        Image titleImage = this.getTitleImage();
        if (titleImage == null) {
            return;
        }
        AntProjectNode node = model.getProjectNode();
        if (node != null) {
            this.postImageChange(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateForInitialReconcile() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (this.getAntModel() == null) {
            return;
        }
        IDocument doc = provider.getDocument((Object)this.getEditorInput());
        if (doc == null) {
            return;
        }
        Object lock = this.getLockObject(doc);
        if (lock == null) {
            this.updateModelForInitialReconcile();
        } else {
            Object object = lock;
            synchronized (object) {
                this.updateModelForInitialReconcile();
            }
        }
    }

    private void updateModelForInitialReconcile() {
        AntModel model = this.getAntModel();
        if (model == null) {
            return;
        }
        this.fInitialReconcile = false;
        this.updateEditorImage(model);
        model.updateForInitialReconcile();
    }

    private Object getLockObject(IDocument doc) {
        Object lock = null;
        lock = doc instanceof ISynchronizable ? ((ISynchronizable)doc).getLockObject() : this.getAntModel();
        return lock;
    }

    private void postImageChange(final AntElementNode node) {
        Shell shell = this.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Image newImage;
                    if (AntEditor.this.getSite().getShell() == null || AntEditor.this.getSite().getShell().isDisposed()) {
                        return;
                    }
                    Image titleImage = AntEditor.this.getTitleImage();
                    if (titleImage != (newImage = node.getImage())) {
                        AntEditor.this.setTitleImage(newImage);
                    }
                }
            });
        }
    }

    public void synchronizeOutlinePage(boolean checkIfOutlinePageActive) {
        if (this.getSelectionProvider() == null) {
            return;
        }
        AntElementNode node = this.getNode();
        this.synchronizeOutlinePage(node, checkIfOutlinePageActive);
    }

    protected void synchronize(boolean checkIfOutlinePageActive) {
        if (this.getSelectionProvider() == null) {
            return;
        }
        AntElementNode node = this.getNode();
        if (AntUIPlugin.getDefault().getPreferenceStore().getBoolean("outline.linkWithEditor")) {
            this.synchronizeOutlinePage(node, checkIfOutlinePageActive);
        }
        this.setSelection(node, false);
    }

    private AntElementNode getNode() {
        AntModel model = this.getAntModel();
        if (model == null) {
            return null;
        }
        AntElementNode node = null;
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            int offset = textSelection.getOffset();
            node = model.getNode(offset, false);
        }
        return node;
    }

    protected void synchronizeOutlinePage(AntElementNode node, boolean checkIfOutlinePageActive) {
        if (!(this.fOutlinePage == null || checkIfOutlinePageActive && this.isAntOutlinePageActive())) {
            this.fOutlinePage.removePostSelectionChangedListener(this.fSelectionChangedListener);
            this.fOutlinePage.select(node);
            this.fOutlinePage.addPostSelectionChangedListener(this.fSelectionChangedListener);
        }
    }

    public void reconciled() {
        SourceViewerConfiguration config;
        if (this.fInitialReconcile) {
            this.updateForInitialReconcile();
        }
        if ((config = this.getSourceViewerConfiguration()) == null) {
            return;
        }
        IAutoEditStrategy[] strategies = config.getAutoEditStrategies(this.getViewer(), null);
        int i = 0;
        while (i < strategies.length) {
            IAutoEditStrategy strategy = strategies[i];
            if (strategy instanceof AntAutoEditStrategy) {
                ((AntAutoEditStrategy)strategy).reconciled();
            }
            ++i;
        }
        Shell shell = this.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AntEditor.this.getSite().getShell() == null || AntEditor.this.getSite().getShell().isDisposed()) {
                        return;
                    }
                    AntEditor.this.synchronize(true);
                }
            });
        }
    }

    private boolean isAntOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return service.getActivePart();
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePage(true);
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    public void projectionEnabled() {
        this.fFoldingStructureProvider = new AntFoldingStructureProvider(this);
        this.fFoldingStructureProvider.setDocument(this.getDocumentProvider().getDocument((Object)this.getEditorInput()));
        this.fFoldingStructureProvider.updateFoldingRegions(this.getAntModel());
    }

    public void projectionDisabled() {
        this.fFoldingStructureProvider = null;
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ant.ui.AntEditorScope"});
    }

    protected IPreferenceStore getEditorPreferenceStore() {
        return this.getPreferenceStore();
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 6];
        more[0] = "org.eclipse.ant.ui.AntEditorPreferencePage";
        more[1] = "org.eclipse.ant.ui.AntCodeFormatterPreferencePage";
        more[2] = "org.eclipse.ant.ui.AntCodeAssistPreferencePage";
        more[3] = "org.eclipse.ant.ui.TemplatesPreferencePage";
        more[4] = "org.eclipse.ant.ui.AntPreferencePage";
        more[5] = "org.eclipse.ant.ui.AntRuntimePreferencePage";
        System.arraycopy(ids, 0, more, 6, ids.length);
        return more;
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, AntModel antModel) {
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (selection == null || antModel == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        List positions = null;
        OccurrencesFinder finder = new OccurrencesFinder(this, antModel, document, selection.getOffset());
        positions = finder.perform();
        if (positions == null || positions.size() == 0) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, positions, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOccurrenceAnnotations() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)this.getEditorInput());
        Object lock = this.getLockObject(document);
        if (lock == null) {
            this.updateAnnotationModelForRemoves(annotationModel);
        } else {
            Object object = lock;
            synchronized (object) {
                this.updateAnnotationModelForRemoves(annotationModel);
            }
        }
    }

    private void updateAnnotationModelForRemoves(IAnnotationModel annotationModel) {
        if (annotationModel instanceof IAnnotationModelExtension) {
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
        } else {
            int i = 0;
            int length = this.fOccurrenceAnnotations.length;
            while (i < length) {
                annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                ++i;
            }
        }
        this.fOccurrenceAnnotations = null;
    }

    protected void installOccurrencesFinder() {
        ISelection selection;
        this.fMarkOccurrenceAnnotations = true;
        if (this.getSelectionProvider() != null && (selection = this.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            this.fForcedMarkOccurrencesSelection = (ITextSelection)selection;
            this.updateOccurrenceAnnotations(this.fForcedMarkOccurrencesSelection, this.getAntModel());
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        this.removeOccurrenceAnnotations();
    }

    public boolean isMarkingOccurrences() {
        return this.fMarkOccurrenceAnnotations;
    }

    public void setInLinkedMode(boolean inLinkedMode, boolean effectsOccurrences) {
        if (inLinkedMode) {
            this.getAntModel().setShouldReconcile(false);
            if (effectsOccurrences) {
                this.uninstallOccurrencesFinder();
            }
        } else {
            this.getAntModel().setShouldReconcile(true);
            if (effectsOccurrences) {
                this.installOccurrencesFinder();
            }
        }
    }

    private class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null || AntEditor.this.getAntModel() == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null || AntEditor.this.getAntModel() == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AntModel model = AntEditor.this.getAntModel();
            ISelection selection = event.getSelection();
            AntElementNode node = null;
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                node = model.getNode(offset, false);
                AntEditor.this.updateOccurrenceAnnotations(textSelection, model);
            }
            if (AntUIPlugin.getDefault().getPreferenceStore().getBoolean("outline.linkWithEditor")) {
                AntEditor.this.synchronizeOutlinePage(node, true);
            }
            AntEditor.this.setSelection(node, false);
        }
    }

    static class TabConverter {
        private int fTabRatio;
        private ILineTracker fLineTracker;

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            this.fTabRatio = ratio;
        }

        public void setLineTracker(ILineTracker lineTracker) {
            this.fLineTracker = lineTracker;
        }

        private int insertTabString(StringBuffer buffer, int offsetInLine) {
            if (this.fTabRatio == 0) {
                return 0;
            }
            int remainder = offsetInLine % this.fTabRatio;
            remainder = this.fTabRatio - remainder;
            int i = 0;
            while (i < remainder) {
                buffer.append(' ');
                ++i;
            }
            return remainder;
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            String text = command.text;
            if (text == null) {
                return;
            }
            int index = text.indexOf(9);
            if (index > -1) {
                StringBuffer buffer = new StringBuffer();
                this.fLineTracker.set(command.text);
                int lines = this.fLineTracker.getNumberOfLines();
                try {
                    int i = 0;
                    while (i < lines) {
                        int offset = this.fLineTracker.getLineOffset(i);
                        int endOffset = offset + this.fLineTracker.getLineLength(i);
                        String line = text.substring(offset, endOffset);
                        int position = 0;
                        if (i == 0) {
                            IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                            position = command.offset - firstLine.getOffset();
                        }
                        int length = line.length();
                        int j = 0;
                        while (j < length) {
                            char c = line.charAt(j);
                            if (c == '\t') {
                                position += this.insertTabString(buffer, position);
                            } else {
                                buffer.append(c);
                                ++position;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    command.text = buffer.toString();
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    class StatusLineSourceViewer
    extends ProjectionViewer {
        private boolean fIgnoreTextConverters = false;

        public StatusLineSourceViewer(Composite composite, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, int styles) {
            super(composite, verticalRuler, overviewRuler, AntEditor.this.isOverviewRulerVisible(), styles);
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null || !this.redraws()) {
                return;
            }
            switch (operation) {
                case 13: {
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    AntEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 1: {
                    this.fIgnoreTextConverters = true;
                    break;
                }
                case 2: {
                    this.fIgnoreTextConverters = true;
                }
            }
            super.doOperation(operation);
        }

        protected void setTextConverter(TabConverter tabConverter) {
            AntEditor.this.fTabConverter = tabConverter;
        }

        protected void updateIndentationPrefixes() {
            SourceViewerConfiguration configuration = AntEditor.this.getSourceViewerConfiguration();
            String[] types = configuration.getConfiguredContentTypes((ISourceViewer)this);
            int i = 0;
            while (i < types.length) {
                String[] prefixes = configuration.getIndentPrefixes((ISourceViewer)this, types[i]);
                if (prefixes != null && prefixes.length > 0) {
                    this.setIndentPrefixes(prefixes, types[i]);
                }
                ++i;
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (!this.fIgnoreTextConverters && AntEditor.this.fTabConverter != null) {
                AntEditor.this.fTabConverter.customizeDocumentCommand(this.getDocument(), command);
            }
            this.fIgnoreTextConverters = false;
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private IDocument fDocument;
        private ISelection fSelection;
        private ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled = false;
        private IProgressMonitor fProgressMonitor;
        private List fPositions;

        public OccurrencesFinderJob(IDocument document, List positions, ISelection selection) {
            super("Occurrences Marker");
            this.fDocument = document;
            this.fSelection = selection;
            this.fPositions = positions;
            if (AntEditor.this.getSelectionProvider() instanceof ISelectionValidator) {
                this.fPostSelectionValidator = (ISelectionValidator)AntEditor.this.getSelectionProvider();
            }
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && AntEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = AntEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = AntEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)AntEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fPositions.size();
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                block15: {
                    String message;
                    if (this.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Position position = (Position)this.fPositions.get(i);
                    try {
                        message = document.get(position.offset, position.length);
                    }
                    catch (BadLocationException badLocationException) {
                        break block15;
                    }
                    annotationMap.put(new Annotation("org.eclipse.jdt.ui.occurrences", false, message), position);
                }
                ++i;
            }
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Object lock = AntEditor.this.getLockObject(document);
            if (lock == null) {
                this.updateAnnotations(annotationModel, annotationMap);
            } else {
                Object object = lock;
                synchronized (object) {
                    this.updateAnnotations(annotationModel, annotationMap);
                }
            }
            return Status.OK_STATUS;
        }

        private void updateAnnotations(IAnnotationModel annotationModel, Map annotationMap) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(AntEditor.this.fOccurrenceAnnotations, annotationMap);
            } else {
                AntEditor.this.removeOccurrenceAnnotations();
                Iterator iter = annotationMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry mapEntry = iter.next();
                    annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            AntEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = AntEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = AntEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = AntEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)AntEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (AntEditor.this.fOccurrencesFinderJob != null) {
                AntEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    private class ActivationListener
    extends ShellAdapter {
        private ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            ISelection selection;
            if (AntEditor.this.fMarkOccurrenceAnnotations && AntEditor.this.isActivePart() && (selection = AntEditor.this.getSelectionProvider().getSelection()) instanceof ITextSelection) {
                AntEditor.this.fForcedMarkOccurrencesSelection = (ITextSelection)selection;
                AntEditor.this.updateOccurrenceAnnotations(AntEditor.this.fForcedMarkOccurrencesSelection, AntEditor.this.getAntModel());
            }
        }

        public void shellDeactivated(ShellEvent e) {
            if (AntEditor.this.fMarkOccurrenceAnnotations && AntEditor.this.isActivePart()) {
                AntEditor.this.removeOccurrenceAnnotations();
            }
        }
    }
}

