/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.IJavaElementMapper;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointTypeChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class WatchpointTypeRenameChange
extends WatchpointTypeChange {
    private RefactoringProcessor fProcessor;
    private RenameTypeArguments fArguments;
    static /* synthetic */ Class class$0;

    public WatchpointTypeRenameChange(IJavaWatchpoint watchpoint, IType destType, IType originalType, RefactoringProcessor processor, RenameTypeArguments arguments) throws CoreException {
        super(watchpoint, destType, originalType);
        this.fProcessor = processor;
        this.fArguments = arguments;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IField originalField = this.getOriginalType().getField(this.getFieldName());
        IField destinationField = null;
        if (this.fArguments.getUpdateSimilarDeclarations()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.refactoring.IJavaElementMapper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IJavaElementMapper elementMapper = (IJavaElementMapper)this.fProcessor.getAdapter((Class)clazz);
            destinationField = (IField)elementMapper.getRefactoredJavaElement((IJavaElement)originalField);
        }
        if (destinationField == null) {
            destinationField = this.getDestinationType().getField(this.getFieldName());
        }
        HashMap map = new HashMap();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)destinationField);
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)destinationField);
        IJavaWatchpoint breakpoint = JDIDebugModel.createWatchpoint((IResource)resource, (String)this.getDestinationType().getFullyQualifiedName(), (String)destinationField.getElementName(), (int)this.getLineNumber(), (int)this.getCharStart(), (int)this.getCharEnd(), (int)0, (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

