/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaStructureErrorValue;
import org.eclipse.jdt.internal.debug.core.model.JDINullValue;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.actions.EditVariableLogicalStructureAction;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.ui.IActionFilter;

public class JavaVarActionFilter
implements IActionFilter {
    private static final Set fgPrimitiveTypes = JavaVarActionFilter.initPrimitiveTypes();

    private static Set initPrimitiveTypes() {
        HashSet<String> set = new HashSet<String>(8);
        set.add("short");
        set.add("int");
        set.add("long");
        set.add("float");
        set.add("double");
        set.add("boolean");
        set.add("byte");
        set.add("char");
        set.add("null");
        return set;
    }

    protected boolean isDeclaredSameAsConcrete(IJavaVariable var) {
        IValue value;
        block3: {
            try {
                value = var.getValue();
                if (!(value instanceof JDINullValue)) break block3;
                return false;
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e);
                return false;
            }
        }
        return !var.getReferenceTypeName().equals(value.getReferenceTypeName());
    }

    protected boolean isPrimitiveType(Object obj) {
        block7: {
            if (obj instanceof IJavaVariable) {
                try {
                    return !fgPrimitiveTypes.contains(this.removeArray(((IJavaVariable)obj).getReferenceTypeName()));
                }
                catch (DebugException e) {
                    JDIDebugUIPlugin.log(e);
                    break block7;
                }
            }
            if (obj instanceof JavaInspectExpression) {
                try {
                    JavaInspectExpression exp = (JavaInspectExpression)((Object)obj);
                    IValue value = exp.getValue();
                    if (value != null) {
                        return fgPrimitiveTypes.contains(this.removeArray(value.getReferenceTypeName()));
                    }
                }
                catch (DebugException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        }
        return false;
    }

    protected boolean isValuePrimitiveType(IValue value) {
        try {
            return !fgPrimitiveTypes.contains(this.removeArray(value.getReferenceTypeName()));
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            return false;
        }
    }

    protected String removeArray(String type) {
        int index;
        if (type != null && (index = type.indexOf(91)) > 0) {
            return type.substring(0, index);
        }
        return type;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof IJavaVariable) {
            IJavaVariable var = (IJavaVariable)target;
            try {
                IValue varValue = var.getValue();
                if (name.equals("PrimitiveVariableActionFilter")) {
                    if (value.equals("isPrimitive")) {
                        return this.isPrimitiveType(var);
                    }
                    if (value.equals("isValuePrimitive")) {
                        return this.isValuePrimitiveType(varValue);
                    }
                } else {
                    if (name.equals("ConcreteVariableActionFilter") && value.equals("isConcrete")) {
                        return this.isDeclaredSameAsConcrete(var);
                    }
                    if (name.equals("JavaVariableActionFilter") && value.equals("instanceFilter")) {
                        return !var.isStatic() && varValue instanceof IJavaObject && ((IJavaObject)varValue).getJavaType() instanceof IJavaClassType && ((IJavaDebugTarget)var.getDebugTarget()).supportsInstanceBreakpoints();
                    }
                    if (name.equals("DetailFormatterFilter") && value.equals("isDefined")) {
                        return varValue instanceof IJavaObject && JavaDetailFormattersManager.getDefault().hasAssociatedDetailFormatter(((IJavaObject)varValue).getJavaType());
                    }
                    if (name.equals("JavaLogicalStructureFilter") && value.equals("canEditLogicalStructure")) {
                        return varValue instanceof JavaStructureErrorValue || EditVariableLogicalStructureAction.getLogicalStructure(varValue) != null;
                    }
                }
            }
            catch (DebugException debugException) {}
        } else if (target instanceof JavaInspectExpression) {
            JavaInspectExpression exp = (JavaInspectExpression)((Object)target);
            if (name.equals("PrimitiveVariableActionFilter") && value.equals("isNotPrimitive")) {
                return !this.isPrimitiveType((Object)exp);
            }
            if (name.equals("DetailFormatterFilter") && value.equals("isDefined")) {
                try {
                    IValue varValue = exp.getValue();
                    return varValue instanceof IJavaObject && JavaDetailFormattersManager.getDefault().hasAssociatedDetailFormatter(((IJavaObject)varValue).getJavaType());
                }
                catch (DebugException debugException) {}
            }
        }
        return false;
    }
}

