/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.model.ITestRunListener2;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.RemoteTestRunnerClient;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.junit.ITestRunListener;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.util.Assert;

public class TestRunSession {
    private final IType fLaunchedType;
    private final ILaunch fLaunch;
    private final RemoteTestRunnerClient fTestRunnerClient;
    private final ListenerList fSessionListeners;
    private final TestRoot fTestRoot;
    private final HashMap fIdToTest;
    private List fIncompleteTestSuites;
    volatile int fStartedCount;
    volatile int fErrorCount;
    volatile int fFailureCount;
    volatile int fTotalCount;
    volatile long fStartTime;
    volatile boolean fIsRunning;
    volatile boolean fIsStopped;

    public TestRunSession(IType launchedType, int port, ILaunch launch) {
        Assert.isNotNull((Object)launchedType);
        Assert.isNotNull((Object)launch);
        this.fLaunchedType = launchedType;
        this.fLaunch = launch;
        this.fTestRoot = new TestRoot();
        this.fIdToTest = new HashMap();
        this.fTestRunnerClient = new RemoteTestRunnerClient();
        this.fTestRunnerClient.startListening(new ITestRunListener[]{new TestSessionNotifier()}, port);
        this.fSessionListeners = new ListenerList();
    }

    public TestRoot getTestRoot() {
        return this.fTestRoot;
    }

    public IType getLaunchedType() {
        return this.fLaunchedType;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public String getTestRunName() {
        return this.fLaunch.getLaunchConfiguration().getName();
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public int getFailureCount() {
        return this.fFailureCount;
    }

    public int getStartedCount() {
        return this.fStartedCount;
    }

    public int getTotalCount() {
        return this.fTotalCount;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public boolean isStopped() {
        return this.fIsStopped;
    }

    public void addTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.add((Object)listener);
    }

    public void removeTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.remove((Object)listener);
    }

    public void stopTestRun() {
        if (this.isRunning() || !this.isKeptAlive()) {
            this.fIsStopped = true;
        }
        this.fTestRunnerClient.stopTest();
    }

    public boolean isKeptAlive() {
        return this.fTestRunnerClient.isRunning() && "debug".equals(this.getLaunch().getLaunchMode());
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }

    public boolean rerunTest(String testId, String className, String testName, String launchMode) throws CoreException {
        ILaunchConfiguration launchConfiguration;
        if (this.isKeptAlive()) {
            TestElement.Status status = ((TestCaseElement)this.getTestElement(testId)).getStatus();
            if (status == TestElement.Status.ERROR) {
                --this.fErrorCount;
            } else if (status == TestElement.Status.FAILURE) {
                --this.fFailureCount;
            }
            this.fTestRunnerClient.rerunTest(testId, className, testName);
            return true;
        }
        if (this.getLaunch() != null && (launchConfiguration = this.getLaunch().getLaunchConfiguration()) != null) {
            String name = className;
            if (testName != null) {
                name = String.valueOf(name) + "." + testName;
            }
            String configName = Messages.format(JUnitMessages.TestRunnerViewPart_configName, name);
            ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(configName);
            tmp.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, className);
            tmp.setAttribute("org.eclipse.jdt.junit.CONTAINER", "");
            if (testName != null) {
                tmp.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
            }
            tmp.launch(launchMode, null);
            return true;
        }
        return false;
    }

    public TestElement getTestElement(String id) {
        return (TestElement)this.fIdToTest.get(id);
    }

    private TestElement addTreeEntry(String treeEntry) {
        int index0 = treeEntry.indexOf(44);
        String id = treeEntry.substring(0, index0);
        StringBuffer testNameBuffer = new StringBuffer(100);
        int index1 = this.scanTestName(treeEntry, index0 + 1, testNameBuffer);
        String testName = testNameBuffer.toString().trim();
        int index2 = treeEntry.indexOf(44, index1 + 1);
        boolean isSuite = treeEntry.substring(index1 + 1, index2).equals("true");
        int testCount = Integer.parseInt(treeEntry.substring(index2 + 1));
        if (this.fIncompleteTestSuites.isEmpty()) {
            return this.createTestElement(this.fTestRoot, id, testName, isSuite, testCount);
        }
        int suiteIndex = this.fIncompleteTestSuites.size() - 1;
        IncompleteTestSuite openSuite = (IncompleteTestSuite)this.fIncompleteTestSuites.get(suiteIndex);
        --openSuite.fOutstandingChildren;
        if (openSuite.fOutstandingChildren <= 0) {
            this.fIncompleteTestSuites.remove(suiteIndex);
        }
        return this.createTestElement(openSuite.fTestSuiteElement, id, testName, isSuite, testCount);
    }

    private TestElement createTestElement(TestSuiteElement parent, String id, String testName, boolean isSuite, int testCount) {
        TestElement testElement;
        if (isSuite) {
            TestSuiteElement testSuiteElement = new TestSuiteElement(parent, id, testName, testCount);
            testElement = testSuiteElement;
            if (testCount > 0) {
                this.fIncompleteTestSuites.add(new IncompleteTestSuite(testSuiteElement, testCount));
            }
        } else {
            testElement = new TestCaseElement(parent, id, testName);
        }
        this.fIdToTest.put(id, testElement);
        return testElement;
    }

    private int scanTestName(String s, int start, StringBuffer testName) {
        boolean inQuote = false;
        int i = start;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' && !inQuote) {
                inQuote = true;
            } else if (inQuote) {
                inQuote = false;
                testName.append(c);
            } else {
                if (c == ',') break;
                testName.append(c);
            }
            ++i;
        }
        return i;
    }

    public TestCaseElement[] getAllFailedTestCaseElements() {
        ArrayList failures = new ArrayList();
        this.addFailures(failures, this.getTestRoot());
        return failures.toArray(new TestCaseElement[failures.size()]);
    }

    private void addFailures(ArrayList failures, TestElement testElement) {
        if (testElement instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            if (testCaseElement.getStatus().isFailure()) {
                failures.add(testCaseElement);
            }
        } else {
            TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
            TestElement[] children = testSuiteElement.getChildren();
            int i = 0;
            while (i < children.length) {
                this.addFailures(failures, children[i]);
                ++i;
            }
        }
    }

    private class TestSessionNotifier
    implements ITestRunListener,
    ITestRunListener2 {
        private TestSessionNotifier() {
        }

        public void testRunStarted(int testCount) {
            TestRunSession.this.fIncompleteTestSuites = new ArrayList();
            TestRunSession.this.fStartedCount = 0;
            TestRunSession.this.fFailureCount = 0;
            TestRunSession.this.fErrorCount = 0;
            TestRunSession.this.fTotalCount = testCount;
            TestRunSession.this.fStartTime = System.currentTimeMillis();
            TestRunSession.this.fIsRunning = true;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionStarted();
                ++i;
            }
        }

        public void testRunEnded(long elapsedTime) {
            TestRunSession.this.fIsRunning = false;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionEnded(elapsedTime);
                ++i;
            }
        }

        public void testRunStopped(long elapsedTime) {
            TestRunSession.this.fIsRunning = false;
            TestRunSession.this.fIsStopped = true;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionStopped(elapsedTime);
                ++i;
            }
        }

        public void testRunTerminated() {
            TestRunSession.this.fIsRunning = false;
            TestRunSession.this.fIsStopped = true;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionTerminated();
                ++i;
            }
        }

        public void testTreeEntry(String description) {
            TestElement testElement = TestRunSession.this.addTreeEntry(description);
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testAdded(testElement);
                ++i;
            }
        }

        public void testStarted(String testId, String testName) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            this.setStatus(testCaseElement, TestElement.Status.RUNNING);
            ++TestRunSession.this.fStartedCount;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testStarted(testCaseElement);
                ++i;
            }
        }

        public void testEnded(String testId, String testName) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            if (testCaseElement.getStatus() == TestElement.Status.RUNNING) {
                this.setStatus(testCaseElement, TestElement.Status.OK);
            }
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testEnded(testCaseElement);
                ++i;
            }
        }

        public void testFailed(int status, String testId, String testName, String trace) {
            this.testFailed(status, testId, testName, trace, null, null);
        }

        public void testFailed(int statusCode, String testId, String testName, String trace, String expected, String actual) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement test = (TestCaseElement)testElement;
            TestElement.Status status = TestElement.Status.convert(statusCode);
            this.setStatus(test, status, trace, this.nullifyEmpty(expected), this.nullifyEmpty(actual));
            if (statusCode == 1) {
                ++TestRunSession.this.fErrorCount;
            } else {
                ++TestRunSession.this.fFailureCount;
            }
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testFailed(test, status, trace, expected, actual);
                ++i;
            }
        }

        private String nullifyEmpty(String string) {
            return string.length() == 0 ? null : string;
        }

        public void testReran(String testId, String testClass, String testName, int status, String trace) {
            this.testReran(testId, testClass, testName, status, trace, "", "");
        }

        public void testReran(String testId, String className, String testName, int statusCode, String trace, String expectedResult, String actualResult) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            TestElement.Status status = TestElement.Status.convert(statusCode);
            if (status == TestElement.Status.ERROR) {
                ++TestRunSession.this.fErrorCount;
            } else if (status == TestElement.Status.FAILURE) {
                ++TestRunSession.this.fFailureCount;
            }
            testCaseElement.setStatus(status, trace, this.nullifyEmpty(expectedResult), this.nullifyEmpty(actualResult));
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testReran(testCaseElement, status, trace, expectedResult, actualResult);
                ++i;
            }
        }

        private void setStatus(TestCaseElement testCaseElement, TestElement.Status status) {
            testCaseElement.setStatus(status);
        }

        private void setStatus(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expected, String actual) {
            testCaseElement.setStatus(status, trace, expected, actual);
        }

        private void logUnexpectedTest(String testId, TestElement testElement) {
            JUnitPlugin.log(new Exception("Unexpected TestElement type for testId '" + testId + "': " + testElement));
        }
    }

    private static class IncompleteTestSuite {
        public TestSuiteElement fTestSuiteElement;
        public int fOutstandingChildren;

        public IncompleteTestSuite(TestSuiteElement testSuiteElement, int outstandingChildren) {
            this.fTestSuiteElement = testSuiteElement;
            this.fOutstandingChildren = outstandingChildren;
        }
    }
}

