/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;

public class JUnitHomeInitializer
extends ClasspathVariableInitializer {
    public void initialize(String variable) {
        if ("JUNIT_HOME".equals(variable)) {
            this.initializeHome();
        } else if ("JUNIT_SRC_HOME".equals(variable)) {
            this.initializeSource();
        }
    }

    private void initializeHome() {
        Bundle bundle = Platform.getBundle((String)"org.junit");
        if (bundle == null) {
            JavaCore.removeClasspathVariable((String)"JUNIT_HOME", null);
            return;
        }
        URL installLocation = bundle.getEntry("/");
        URL local = null;
        try {
            local = Platform.asLocalURL((URL)installLocation);
        }
        catch (IOException iOException) {
            JavaCore.removeClasspathVariable((String)"JUNIT_HOME", null);
            return;
        }
        try {
            String fullPath = new File(local.getPath()).getAbsolutePath();
            JavaCore.setClasspathVariable((String)"JUNIT_HOME", (IPath)Path.fromOSString((String)fullPath), null);
        }
        catch (JavaModelException javaModelException) {
            JavaCore.removeClasspathVariable((String)"JUNIT_HOME", null);
        }
    }

    private void initializeSource() {
        Bundle bundle = Platform.getBundle((String)"org.junit");
        if (bundle == null) {
            JavaCore.removeClasspathVariable((String)"JUNIT_SRC_HOME", null);
            return;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version == null) {
            JavaCore.removeClasspathVariable((String)"JUNIT_SRC_HOME", null);
            return;
        }
        bundle = Platform.getBundle((String)"org.eclipse.jdt.source");
        if (bundle == null) {
            JavaCore.removeClasspathVariable((String)"JUNIT_SRC_HOME", null);
            return;
        }
        URL local = null;
        try {
            local = Platform.asLocalURL((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            JavaCore.removeClasspathVariable((String)"JUNIT_SRC_HOME", null);
            return;
        }
        try {
            String fullPath = String.valueOf(new File(local.getPath()).getAbsolutePath()) + File.separator + "src" + File.separator + "org.junit_" + version;
            JavaCore.setClasspathVariable((String)"JUNIT_SRC_HOME", (IPath)Path.fromOSString((String)fullPath), null);
        }
        catch (JavaModelException javaModelException) {
            JavaCore.removeClasspathVariable((String)"JUNIT_SRC_HOME", null);
        }
    }
}

