/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class TestSessionContentProvider
implements ITreeContentProvider {
    private final Object[] NO_CHILDREN = new Object[0];
    private Viewer fViewer;
    private int fLayoutMode = 1;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public Object[] getChildren(Object parentElement) {
        if (this.fLayoutMode == 0) {
            return this.NO_CHILDREN;
        }
        if (parentElement instanceof TestSuiteElement) {
            return ((TestSuiteElement)parentElement).getChildren();
        }
        return this.NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (this.fLayoutMode == 0) {
            return ((TestElement)element).getRoot();
        }
        return ((TestElement)element).getParent();
    }

    public boolean hasChildren(Object element) {
        if (this.fLayoutMode == 0) {
            return false;
        }
        if (element instanceof TestSuiteElement) {
            return ((TestSuiteElement)element).getChildren().length != 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this.fLayoutMode == 0) {
            ArrayList all = new ArrayList();
            this.addAll(all, (TestRoot)inputElement);
            return all.toArray();
        }
        return ((TestRoot)inputElement).getChildren();
    }

    private void addAll(ArrayList all, TestSuiteElement suite) {
        TestElement[] children = suite.getChildren();
        int i = 0;
        while (i < children.length) {
            TestElement element = children[i];
            if (element instanceof TestSuiteElement) {
                this.addAll(all, (TestSuiteElement)element);
            } else if (element instanceof TestCaseElement) {
                all.add(element);
            }
            ++i;
        }
    }

    public void setLayout(int layoutMode) {
        if (layoutMode != this.fLayoutMode) {
            this.fLayoutMode = layoutMode;
            if (this.fViewer != null) {
                List selected = ((IStructuredSelection)this.fViewer.getSelection()).toList();
                this.fViewer.refresh();
                this.fViewer.setSelection((ISelection)new StructuredSelection(selected), true);
            }
        }
    }

    public void dispose() {
        this.fViewer = null;
    }
}

