/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class ASTNode
implements TypeConstants,
TypeIds {
    public int sourceStart;
    public int sourceEnd;
    public static final int Bit1 = 1;
    public static final int Bit2 = 2;
    public static final int Bit3 = 4;
    public static final int Bit4 = 8;
    public static final int Bit5 = 16;
    public static final int Bit6 = 32;
    public static final int Bit7 = 64;
    public static final int Bit8 = 128;
    public static final int Bit9 = 256;
    public static final int Bit10 = 512;
    public static final int Bit11 = 1024;
    public static final int Bit12 = 2048;
    public static final int Bit13 = 4096;
    public static final int Bit14 = 8192;
    public static final int Bit15 = 16384;
    public static final int Bit16 = 32768;
    public static final int Bit17 = 65536;
    public static final int Bit18 = 131072;
    public static final int Bit19 = 262144;
    public static final int Bit20 = 524288;
    public static final int Bit21 = 0x100000;
    public static final int Bit22 = 0x200000;
    public static final int Bit23 = 0x400000;
    public static final int Bit24 = 0x800000;
    public static final int Bit25 = 0x1000000;
    public static final int Bit26 = 0x2000000;
    public static final int Bit27 = 0x4000000;
    public static final int Bit28 = 0x8000000;
    public static final int Bit29 = 0x10000000;
    public static final int Bit30 = 0x20000000;
    public static final int Bit31 = 0x40000000;
    public static final int Bit32 = Integer.MIN_VALUE;
    public static final long Bit32L = 0x80000000L;
    public static final long Bit33L = 0x100000000L;
    public static final long Bit34L = 0x200000000L;
    public static final long Bit35L = 0x400000000L;
    public static final long Bit36L = 0x800000000L;
    public static final long Bit37L = 0x1000000000L;
    public static final long Bit38L = 0x2000000000L;
    public static final long Bit39L = 0x4000000000L;
    public static final long Bit40L = 0x8000000000L;
    public static final long Bit41L = 0x10000000000L;
    public static final long Bit42L = 0x20000000000L;
    public static final long Bit43L = 0x40000000000L;
    public static final long Bit44L = 0x80000000000L;
    public static final long Bit45L = 0x100000000000L;
    public static final long Bit46L = 0x200000000000L;
    public static final long Bit47L = 0x400000000000L;
    public static final long Bit48L = 0x800000000000L;
    public static final long Bit49L = 0x1000000000000L;
    public static final long Bit50L = 0x2000000000000L;
    public static final long Bit51L = 0x4000000000000L;
    public static final long Bit52L = 0x8000000000000L;
    public static final long Bit53L = 0x10000000000000L;
    public static final long Bit54L = 0x20000000000000L;
    public static final long Bit55L = 0x40000000000000L;
    public static final long Bit56L = 0x80000000000000L;
    public static final long Bit57L = 0x100000000000000L;
    public static final long Bit58L = 0x200000000000000L;
    public static final long Bit59L = 0x400000000000000L;
    public static final long Bit60L = 0x800000000000000L;
    public static final long Bit61L = 0x1000000000000000L;
    public static final long Bit62L = 0x2000000000000000L;
    public static final long Bit63L = 0x4000000000000000L;
    public static final long Bit64L = Long.MIN_VALUE;
    public int bits = Integer.MIN_VALUE;
    public static final int ReturnTypeIDMASK = 15;
    public static final int OperatorSHIFT = 6;
    public static final int OperatorMASK = 4032;
    public static final int IsReturnedValue = 16;
    public static final int UnnecessaryCast = 16384;
    public static final int DisableUnnecessaryCastCheck = 32;
    public static final int GenerateCheckcast = 64;
    public static final int UnsafeCast = 128;
    public static final int RestrictiveFlagMASK = 7;
    public static final int FirstAssignmentToLocal = 8;
    public static final int IsImplicitThis = 4;
    public static final int DepthSHIFT = 5;
    public static final int DepthMASK = 8160;
    public static final int IsReachable = Integer.MIN_VALUE;
    public static final int IsLocalDeclarationReachable = 0x40000000;
    public static final int LabelUsed = 64;
    public static final int DocumentedFallthrough = 0x20000000;
    public static final int IsSubRoutineEscaping = 16384;
    public static final int IsTryBlockExiting = 0x20000000;
    public static final int ContainsAssertion = 1;
    public static final int IsLocalType = 256;
    public static final int IsAnonymousType = 512;
    public static final int IsMemberType = 1024;
    public static final int HasAbstractMethods = 2048;
    public static final int IsSecondaryType = 4096;
    public static final int HasLocalType = 2;
    public static final int ParenthesizedSHIFT = 21;
    public static final int ParenthesizedMASK = 534773760;
    public static final int IsStrictlyAssigned = 8192;
    public static final int IsCompoundAssigned = 65536;
    public static final int IsUsefulEmptyStatement = 1;
    public static final int UndocumentedEmptyBlock = 8;
    public static final int HasAllMethodBodies = 16;
    public static final int InsideJavadoc = 32768;
    public static final int IsElseIfStatement = 0x20000000;
    public static final int IsSuperType = 16;
    public static final int IsVarArgs = 16384;
    public static final int IgnoreRawTypeCheck = 0x40000000;
    public static final int IsAnnotationDefaultValue = 1;
    public static final int IsNonNull = 131072;

    private static boolean checkInvocationArgument(BlockScope scope, Expression argument, TypeBinding parameterType, TypeBinding argumentType, TypeBinding originalParameterType) {
        TypeBinding checkedParameterType;
        argument.computeConversion(scope, parameterType, argumentType);
        if (argumentType != TypeBinding.NULL && parameterType.isWildcard()) {
            WildcardBinding wildcard = (WildcardBinding)parameterType;
            if (wildcard.boundKind != 2 && wildcard.otherBounds == null) {
                return true;
            }
        }
        TypeBinding typeBinding = checkedParameterType = originalParameterType == null ? parameterType : originalParameterType;
        if (argumentType != checkedParameterType && argumentType.needsUncheckedConversion(checkedParameterType)) {
            scope.problemReporter().unsafeTypeConversion(argument, argumentType, checkedParameterType);
        }
        return false;
    }

    public static void checkInvocationArguments(BlockScope scope, Expression receiver, TypeBinding receiverType, MethodBinding method, Expression[] arguments, TypeBinding[] argumentTypes, boolean argsContainCast, InvocationSite invocationSite) {
        MethodBinding rawOriginalGenericMethod;
        boolean unsafeWildcardInvocation;
        block19: {
            block21: {
                int paramLength;
                TypeBinding[] params;
                block20: {
                    int dimensions;
                    TypeBinding lastArgType;
                    ArrayBinding varargsType;
                    block23: {
                        block22: {
                            unsafeWildcardInvocation = false;
                            params = method.parameters;
                            paramLength = params.length;
                            boolean isRawMemberInvocation = !method.isStatic() && !receiverType.isUnboundWildcard() && method.declaringClass.isRawType() && method.hasSubstitutedParameters();
                            rawOriginalGenericMethod = null;
                            if (!isRawMemberInvocation && method instanceof ParameterizedGenericMethodBinding) {
                                ParameterizedGenericMethodBinding paramMethod = (ParameterizedGenericMethodBinding)method;
                                if (paramMethod.isUnchecked || paramMethod.isRaw && method.hasSubstitutedParameters()) {
                                    rawOriginalGenericMethod = method.original();
                                }
                            }
                            if (arguments == null) break block19;
                            if (!method.isVarargs()) break block20;
                            int lastIndex = paramLength - 1;
                            int i = 0;
                            while (i < lastIndex) {
                                TypeBinding originalRawParam;
                                TypeBinding typeBinding = originalRawParam = rawOriginalGenericMethod == null ? null : rawOriginalGenericMethod.parameters[i];
                                if (ASTNode.checkInvocationArgument(scope, arguments[i], params[i], argumentTypes[i], originalRawParam)) {
                                    unsafeWildcardInvocation = true;
                                }
                                ++i;
                            }
                            int argLength = arguments.length;
                            if (lastIndex < argLength) {
                                TypeBinding parameterType = params[lastIndex];
                                TypeBinding originalRawParam = null;
                                if (paramLength != argLength || parameterType.dimensions() != argumentTypes[lastIndex].dimensions()) {
                                    if (!(parameterType = ((ArrayBinding)parameterType).elementsType()).isReifiable()) {
                                        scope.problemReporter().unsafeGenericArrayForVarargs(parameterType, (ASTNode)((Object)invocationSite));
                                    }
                                    originalRawParam = rawOriginalGenericMethod == null ? null : ((ArrayBinding)rawOriginalGenericMethod.parameters[lastIndex]).elementsType();
                                }
                                int i2 = lastIndex;
                                while (i2 < argLength) {
                                    if (ASTNode.checkInvocationArgument(scope, arguments[i2], parameterType, argumentTypes[i2], originalRawParam)) {
                                        unsafeWildcardInvocation = true;
                                    }
                                    ++i2;
                                }
                            }
                            if (paramLength != argumentTypes.length) break block21;
                            int varargsIndex = paramLength - 1;
                            varargsType = (ArrayBinding)params[varargsIndex];
                            lastArgType = argumentTypes[varargsIndex];
                            if (lastArgType != TypeBinding.NULL) break block22;
                            if (!varargsType.leafComponentType().isBaseType() || varargsType.dimensions() != 1) {
                                scope.problemReporter().varargsArgumentNeedCast(method, lastArgType, invocationSite);
                            }
                            break block21;
                        }
                        dimensions = lastArgType.dimensions();
                        if (varargsType.dimensions > dimensions) break block21;
                        if (lastArgType.leafComponentType().isBaseType()) {
                            --dimensions;
                        }
                        if (varargsType.dimensions >= dimensions) break block23;
                        scope.problemReporter().varargsArgumentNeedCast(method, lastArgType, invocationSite);
                        break block21;
                    }
                    if (varargsType.dimensions != dimensions || varargsType.leafComponentType == lastArgType.leafComponentType() || !lastArgType.isCompatibleWith(varargsType)) break block21;
                    scope.problemReporter().varargsArgumentNeedCast(method, lastArgType, invocationSite);
                    break block21;
                }
                int i = 0;
                while (i < paramLength) {
                    TypeBinding originalRawParam;
                    TypeBinding typeBinding = originalRawParam = rawOriginalGenericMethod == null ? null : rawOriginalGenericMethod.parameters[i];
                    if (ASTNode.checkInvocationArgument(scope, arguments[i], params[i], argumentTypes[i], originalRawParam)) {
                        unsafeWildcardInvocation = true;
                    }
                    ++i;
                }
            }
            if (argsContainCast) {
                CastExpression.checkNeedForArgumentCasts(scope, receiver, receiverType, method, arguments, argumentTypes, invocationSite);
            }
        }
        if (unsafeWildcardInvocation) {
            scope.problemReporter().wildcardInvocation((ASTNode)((Object)invocationSite), receiverType, method, argumentTypes);
        } else if (!method.isStatic() && !receiverType.isUnboundWildcard() && method.declaringClass.isRawType() && method.hasSubstitutedParameters()) {
            scope.problemReporter().unsafeRawInvocation((ASTNode)((Object)invocationSite), method);
        } else if (rawOriginalGenericMethod != null) {
            scope.problemReporter().unsafeRawGenericMethodInvocation((ASTNode)((Object)invocationSite), method);
        }
    }

    public ASTNode concreteStatement() {
        return this;
    }

    public final boolean isFieldUseDeprecated(FieldBinding field, Scope scope, boolean isStrictlyAssigned) {
        AccessRestriction restriction;
        if (!isStrictlyAssigned && (field.isPrivate() || field.declaringClass != null && field.declaringClass.isLocalType()) && !scope.isDefinedInField(field)) {
            field.original().modifiers |= 0x8000000;
        }
        if ((field.modifiers & 0x40000) != 0 && (restriction = scope.environment().getAccessRestriction(field.declaringClass.erasure())) != null) {
            scope.problemReporter().forbiddenReference(field, this, restriction.getFieldAccessMessageTemplate(), restriction.getProblemId());
        }
        if (!field.isViewedAsDeprecated()) {
            return false;
        }
        if (scope.isDefinedInSameUnit(field.declaringClass)) {
            return false;
        }
        return scope.compilerOptions().reportDeprecationInsideDeprecatedCode || !scope.isInsideDeprecatedCode();
    }

    public boolean isImplicitThis() {
        return false;
    }

    public final boolean isMethodUseDeprecated(MethodBinding method, Scope scope, boolean isExplicitUse) {
        AccessRestriction restriction;
        if ((method.isPrivate() || method.declaringClass.isLocalType()) && !scope.isDefinedInMethod(method)) {
            method.original().modifiers |= 0x8000000;
        }
        if (isExplicitUse && (method.modifiers & 0x40000) != 0 && (restriction = scope.environment().getAccessRestriction(method.declaringClass.erasure())) != null) {
            if (method.isConstructor()) {
                scope.problemReporter().forbiddenReference(method, this, restriction.getConstructorAccessMessageTemplate(), restriction.getProblemId());
            } else {
                scope.problemReporter().forbiddenReference(method, this, restriction.getMethodAccessMessageTemplate(), restriction.getProblemId());
            }
        }
        if (!method.isViewedAsDeprecated()) {
            return false;
        }
        if (scope.isDefinedInSameUnit(method.declaringClass)) {
            return false;
        }
        if (!isExplicitUse && (method.modifiers & 0x100000) == 0) {
            return false;
        }
        return scope.compilerOptions().reportDeprecationInsideDeprecatedCode || !scope.isInsideDeprecatedCode();
    }

    public boolean isSuper() {
        return false;
    }

    public boolean isThis() {
        return false;
    }

    public final boolean isTypeUseDeprecated(TypeBinding type, Scope scope) {
        AccessRestriction restriction;
        if (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType;
        }
        if (type.isBaseType()) {
            return false;
        }
        ReferenceBinding refType = (ReferenceBinding)type;
        if (refType.isPrivate() && !scope.isDefinedInType(refType)) {
            ((ReferenceBinding)refType.erasure()).modifiers |= 0x8000000;
        }
        if (refType.hasRestrictedAccess() && (restriction = scope.environment().getAccessRestriction(type.erasure())) != null) {
            scope.problemReporter().forbiddenReference(type, this, restriction.getMessageTemplate(), restriction.getProblemId());
        }
        refType.initializeDeprecatedAnnotationTagBits();
        if (!refType.isViewedAsDeprecated()) {
            return false;
        }
        if (scope.isDefinedInSameUnit(refType)) {
            return false;
        }
        return scope.compilerOptions().reportDeprecationInsideDeprecatedCode || !scope.isInsideDeprecatedCode();
    }

    public abstract StringBuffer print(int var1, StringBuffer var2);

    public static StringBuffer printAnnotations(Annotation[] annotations, StringBuffer output) {
        int length = annotations.length;
        int i = 0;
        while (i < length) {
            annotations[i].print(0, output);
            output.append(" ");
            ++i;
        }
        return output;
    }

    public static StringBuffer printIndent(int indent, StringBuffer output) {
        int i = indent;
        while (i > 0) {
            output.append("  ");
            --i;
        }
        return output;
    }

    public static StringBuffer printModifiers(int modifiers, StringBuffer output) {
        if ((modifiers & 1) != 0) {
            output.append("public ");
        }
        if ((modifiers & 2) != 0) {
            output.append("private ");
        }
        if ((modifiers & 4) != 0) {
            output.append("protected ");
        }
        if ((modifiers & 8) != 0) {
            output.append("static ");
        }
        if ((modifiers & 0x10) != 0) {
            output.append("final ");
        }
        if ((modifiers & 0x20) != 0) {
            output.append("synchronized ");
        }
        if ((modifiers & 0x40) != 0) {
            output.append("volatile ");
        }
        if ((modifiers & 0x80) != 0) {
            output.append("transient ");
        }
        if ((modifiers & 0x100) != 0) {
            output.append("native ");
        }
        if ((modifiers & 0x400) != 0) {
            output.append("abstract ");
        }
        return output;
    }

    public static void resolveAnnotations(BlockScope scope, Annotation[] annotations, Binding recipient) {
        int length;
        AnnotationBinding[] instances = null;
        int n = length = annotations == null ? 0 : annotations.length;
        if (recipient != null) {
            switch (recipient.kind()) {
                case 16: {
                    PackageBinding packageBinding = (PackageBinding)recipient;
                    if ((packageBinding.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    packageBinding.tagBits |= 0x200000000L;
                    break;
                }
                case 4: 
                case 2052: {
                    ReferenceBinding type = (ReferenceBinding)recipient;
                    if ((type.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    type.tagBits |= 0x200000000L;
                    if (length <= 0) break;
                    instances = new AnnotationBinding[length];
                    type.setAnnotations(instances);
                    break;
                }
                case 8: {
                    MethodBinding method = (MethodBinding)recipient;
                    if ((method.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    method.tagBits |= 0x200000000L;
                    if (length <= 0) break;
                    instances = new AnnotationBinding[length];
                    method.setAnnotations(instances);
                    break;
                }
                case 1: {
                    FieldBinding field = (FieldBinding)recipient;
                    if ((field.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    field.tagBits |= 0x200000000L;
                    if (length <= 0) break;
                    instances = new AnnotationBinding[length];
                    field.setAnnotations(instances);
                    break;
                }
                case 2: {
                    LocalVariableBinding local = (LocalVariableBinding)recipient;
                    if ((local.tagBits & 0x200000000L) != 0L) {
                        return;
                    }
                    local.tagBits |= 0x200000000L;
                    if (length <= 0) break;
                    instances = new AnnotationBinding[length];
                    local.setAnnotations(instances);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (annotations == null) {
            return;
        }
        TypeBinding[] annotationTypes = new TypeBinding[length];
        int i = 0;
        while (i < length) {
            Annotation annotation = annotations[i];
            annotation.recipient = recipient;
            annotationTypes[i] = annotation.resolveType(scope);
            if (instances != null) {
                instances[i] = annotation.getCompilerAnnotation();
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            TypeBinding annotationType = annotationTypes[i];
            if (annotationType != null) {
                boolean foundDuplicate = false;
                int j = i + 1;
                while (j < length) {
                    if (annotationTypes[j] == annotationType) {
                        foundDuplicate = true;
                        annotationTypes[j] = null;
                        scope.problemReporter().duplicateAnnotation(annotations[j]);
                    }
                    ++j;
                }
                if (foundDuplicate) {
                    scope.problemReporter().duplicateAnnotation(annotations[i]);
                }
            }
            ++i;
        }
    }

    public static void resolveDeprecatedAnnotations(BlockScope scope, Annotation[] annotations, Binding recipient) {
        if (annotations == null) {
            return;
        }
        int length = annotations.length;
        if (length == 0) {
            return;
        }
        if (recipient != null) {
            switch (recipient.kind()) {
                case 16: {
                    PackageBinding packageBinding = (PackageBinding)recipient;
                    if ((packageBinding.tagBits & 0x200200000000L) == 0L) break;
                    return;
                }
                case 4: 
                case 2052: {
                    ReferenceBinding type = (ReferenceBinding)recipient;
                    if ((type.tagBits & 0x200200000000L) == 0L) break;
                    return;
                }
                case 8: {
                    MethodBinding method = (MethodBinding)recipient;
                    if ((method.tagBits & 0x200200000000L) == 0L) break;
                    return;
                }
                case 1: {
                    FieldBinding field = (FieldBinding)recipient;
                    if ((field.tagBits & 0x200200000000L) == 0L) break;
                    return;
                }
                case 2: {
                    LocalVariableBinding local = (LocalVariableBinding)recipient;
                    if ((local.tagBits & 0x200200000000L) == 0L) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        int i = 0;
        while (i < length) {
            TypeReference annotationTypeRef = annotations[i].type;
            if (!CharOperation.equals(TypeConstants.JAVA_LANG_DEPRECATED[2], annotationTypeRef.getLastToken())) {
                return;
            }
            TypeBinding annotationType = annotations[i].type.resolveType(scope);
            if (annotationType != null && annotationType.isValidBinding() && annotationType.id == 44 && recipient != null) {
                switch (recipient.kind()) {
                    case 16: {
                        PackageBinding packageBinding = (PackageBinding)recipient;
                        packageBinding.tagBits |= 0x200000000000L;
                        break;
                    }
                    case 4: 
                    case 2052: 
                    case 4100: {
                        ReferenceBinding type = (ReferenceBinding)recipient;
                        type.tagBits |= 0x200000000000L;
                        break;
                    }
                    case 8: {
                        MethodBinding method = (MethodBinding)recipient;
                        method.tagBits |= 0x200000000000L;
                        break;
                    }
                    case 1: {
                        FieldBinding field = (FieldBinding)recipient;
                        field.tagBits |= 0x200000000000L;
                        break;
                    }
                    case 2: {
                        LocalVariableBinding local = (LocalVariableBinding)recipient;
                        local.tagBits |= 0x200000000000L;
                    }
                }
            }
            ++i;
        }
    }

    public int sourceStart() {
        return this.sourceStart;
    }

    public int sourceEnd() {
        return this.sourceEnd;
    }

    public String toString() {
        return this.print(0, new StringBuffer(30)).toString();
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
    }
}

