/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.NullInfoRegistry;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TryStatement
extends SubRoutineStatement {
    private static final char[] SECRET_RETURN_ADDRESS_NAME = " returnAddress".toCharArray();
    private static final char[] SECRET_ANY_HANDLER_NAME = " anyExceptionHandler".toCharArray();
    private static final char[] SECRET_RETURN_VALUE_NAME = " returnValue".toCharArray();
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean[] catchExits;
    BranchLabel subRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    ExceptionLabel[] declaredExceptionLabels;
    private Object[] reusableJSRTargets;
    private BranchLabel[] reusableJSRSequenceStartLabels;
    private int reusableJSRTargetsCount = 0;
    private static final int NO_FINALLY = 0;
    private static final int FINALLY_SUBROUTINE = 1;
    private static final int FINALLY_DOES_NOT_COMPLETE = 2;
    private static final int FINALLY_INLINE = 3;
    int preTryInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo tryInfo;
        this.preTryInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if (this.subRoutineStartLabel == null) {
            FlowInfo tryInfo2;
            ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(flowContext, this, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
            handlingContext.initsOnFinally = new NullInfoRegistry(flowInfo.unconditionalInits());
            if (this.tryBlock.isEmptyBlock()) {
                tryInfo2 = flowInfo;
            } else {
                tryInfo2 = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
                if ((tryInfo2.tagBits & 1) != 0) {
                    this.bits |= 0x20000000;
                }
            }
            handlingContext.complainIfUnusedExceptionHandlers(this.scope, this);
            if (this.catchArguments != null) {
                int catchCount = this.catchBlocks.length;
                this.catchExits = new boolean[catchCount];
                int i = 0;
                while (i < catchCount) {
                    FlowInfo catchInfo = this.caughtExceptionTypes[i].isUncheckedException(false) ? flowInfo.unconditionalCopy().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i])).addPotentialInitializationsFrom(tryInfo2).addPotentialInitializationsFrom(handlingContext.initsOnReturn) : flowInfo.unconditionalCopy().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i])).addPotentialInitializationsFrom(tryInfo2.nullInfoLessUnconditionalCopy()).addPotentialInitializationsFrom(handlingContext.initsOnReturn.nullInfoLessUnconditionalCopy());
                    LocalVariableBinding catchArg = this.catchArguments[i].binding;
                    catchInfo.markAsDefinitelyAssigned(catchArg);
                    catchInfo.markAsDefinitelyNonNull(catchArg);
                    if (this.tryBlock.statements == null) {
                        catchInfo.setReachMode(1);
                    }
                    catchInfo = this.catchBlocks[i].analyseCode(currentScope, flowContext, catchInfo);
                    this.catchExits[i] = (catchInfo.tagBits & 1) != 0;
                    tryInfo2 = tryInfo2.mergedWith(catchInfo.unconditionalInits());
                    ++i;
                }
            }
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(tryInfo2);
            if (flowContext.initsOnFinally != null) {
                flowContext.initsOnFinally.add(handlingContext.initsOnFinally);
            }
            return tryInfo2;
        }
        InsideSubRoutineFlowContext insideSubContext = new InsideSubRoutineFlowContext(flowContext, this);
        FinallyFlowContext finallyContext = new FinallyFlowContext(flowContext, this.finallyBlock);
        UnconditionalFlowInfo subInfo = this.finallyBlock.analyseCode(currentScope, finallyContext, flowInfo.nullInfoLessUnconditionalCopy()).unconditionalInits();
        if (subInfo == FlowInfo.DEAD_END) {
            this.bits |= 0x4000;
            this.scope.problemReporter().finallyMustCompleteNormally(this.finallyBlock);
        }
        this.subRoutineInits = subInfo;
        ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(insideSubContext, this, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
        handlingContext.initsOnFinally = new NullInfoRegistry(flowInfo.unconditionalInits());
        if (this.tryBlock.isEmptyBlock()) {
            tryInfo = flowInfo;
        } else {
            tryInfo = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
            if ((tryInfo.tagBits & 1) != 0) {
                this.bits |= 0x20000000;
            }
        }
        handlingContext.complainIfUnusedExceptionHandlers(this.scope, this);
        if (this.catchArguments != null) {
            int catchCount = this.catchBlocks.length;
            this.catchExits = new boolean[catchCount];
            int i = 0;
            while (i < catchCount) {
                FlowInfo catchInfo = flowInfo.unconditionalCopy().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i])).addPotentialInitializationsFrom(tryInfo.nullInfoLessUnconditionalCopy()).addPotentialInitializationsFrom(handlingContext.initsOnReturn.nullInfoLessUnconditionalCopy());
                LocalVariableBinding catchArg = this.catchArguments[i].binding;
                catchInfo.markAsDefinitelyAssigned(catchArg);
                catchInfo.markAsDefinitelyNonNull(catchArg);
                if (this.tryBlock.statements == null) {
                    catchInfo.setReachMode(1);
                }
                catchInfo = this.catchBlocks[i].analyseCode(currentScope, insideSubContext, catchInfo);
                this.catchExits[i] = (catchInfo.tagBits & 1) != 0;
                tryInfo = tryInfo.mergedWith(catchInfo.unconditionalInits());
                ++i;
            }
        }
        finallyContext.complainOnDeferredChecks(handlingContext.initsOnFinally.mitigateNullInfoOf((tryInfo.tagBits & 1) == 0 ? flowInfo.unconditionalCopy().addPotentialInitializationsFrom(tryInfo).addPotentialInitializationsFrom(insideSubContext.initsOnReturn) : insideSubContext.initsOnReturn), currentScope);
        if (flowContext.initsOnFinally != null) {
            flowContext.initsOnFinally.add(handlingContext.initsOnFinally);
        }
        if (subInfo == FlowInfo.DEAD_END) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(subInfo);
            return subInfo;
        }
        FlowInfo mergedInfo = tryInfo.addInitializationsFrom(subInfo);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public ExceptionLabel enterAnyExceptionHandler(CodeStream codeStream) {
        if (this.subRoutineStartLabel == null) {
            return null;
        }
        return super.enterAnyExceptionHandler(codeStream);
    }

    public void enterDeclaredExceptionHandlers(CodeStream codeStream) {
        int i = 0;
        int length = this.declaredExceptionLabels == null ? 0 : this.declaredExceptionLabels.length;
        while (i < length) {
            this.declaredExceptionLabels[i].placeStart();
            ++i;
        }
    }

    public void exitAnyExceptionHandler() {
        if (this.subRoutineStartLabel == null) {
            return;
        }
        super.exitAnyExceptionHandler();
    }

    public void exitDeclaredExceptionHandlers(CodeStream codeStream) {
        int i = 0;
        int length = this.declaredExceptionLabels == null ? 0 : this.declaredExceptionLabels.length;
        while (i < length) {
            this.declaredExceptionLabels[i].placeEnd();
            ++i;
        }
    }

    private int finallyMode() {
        if (this.subRoutineStartLabel == null) {
            return 0;
        }
        if (this.isSubRoutineEscaping()) {
            return 2;
        }
        if (this.scope.compilerOptions().inlineJsrBytecode) {
            return 3;
        }
        return 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        int pc;
        block46: {
            block45: {
                BranchLabel naturalExitLabel;
                boolean requiresNaturalExit;
                int finallyMode;
                block44: {
                    boolean tryBlockHasSomeCode;
                    ExceptionLabel[] exceptionLabels;
                    int maxCatches;
                    if ((this.bits & Integer.MIN_VALUE) == 0) {
                        return;
                    }
                    this.anyExceptionLabel = null;
                    this.reusableJSRTargets = null;
                    this.reusableJSRSequenceStartLabels = null;
                    this.reusableJSRTargetsCount = 0;
                    pc = codeStream.position;
                    finallyMode = this.finallyMode();
                    requiresNaturalExit = false;
                    int n = maxCatches = this.catchArguments == null ? 0 : this.catchArguments.length;
                    if (maxCatches > 0) {
                        exceptionLabels = new ExceptionLabel[maxCatches];
                        int i = 0;
                        while (i < maxCatches) {
                            ExceptionLabel exceptionLabel = new ExceptionLabel(codeStream, this.catchArguments[i].binding.type);
                            exceptionLabel.placeStart();
                            exceptionLabels[i] = exceptionLabel;
                            ++i;
                        }
                    } else {
                        exceptionLabels = null;
                    }
                    if (this.subRoutineStartLabel != null) {
                        this.subRoutineStartLabel.initialize(codeStream);
                        this.enterAnyExceptionHandler(codeStream);
                    }
                    try {
                        this.declaredExceptionLabels = exceptionLabels;
                        this.tryBlock.generateCode(this.scope, codeStream);
                    }
                    catch (Throwable exceptionLabel) {
                        Object i = null;
                        this.declaredExceptionLabels = null;
                        throw exceptionLabel;
                    }
                    {
                        Object i = null;
                        this.declaredExceptionLabels = null;
                        boolean bl = tryBlockHasSomeCode = codeStream.position != pc;
                    }
                    if (!tryBlockHasSomeCode) break block45;
                    naturalExitLabel = new BranchLabel(codeStream);
                    if ((this.bits & 0x20000000) == 0) {
                        int position = codeStream.position;
                        switch (finallyMode) {
                            case 1: 
                            case 3: {
                                requiresNaturalExit = true;
                            }
                            case 0: {
                                codeStream.goto_(naturalExitLabel);
                                break;
                            }
                            case 2: {
                                codeStream.goto_(this.subRoutineStartLabel);
                                break;
                            }
                        }
                        codeStream.updateLastRecordedEndPC(this.tryBlock.scope, position);
                    }
                    int i = 0;
                    while (true) {
                        if (i >= maxCatches) {
                            if (this.catchArguments != null) {
                                i = 0;
                                break;
                            }
                            break block44;
                        }
                        exceptionLabels[i].placeEnd();
                        ++i;
                    }
                    while (i < maxCatches) {
                        if (this.preTryInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                        }
                        codeStream.pushOnStack(exceptionLabels[i].exceptionType);
                        exceptionLabels[i].place();
                        int varPC = codeStream.position;
                        LocalVariableBinding catchVar = this.catchArguments[i].binding;
                        if (catchVar.resolvedPosition != -1) {
                            codeStream.store(catchVar, false);
                            catchVar.recordInitializationStartPC(codeStream.position);
                            codeStream.addVisibleLocalVariable(catchVar);
                        } else {
                            codeStream.pop();
                        }
                        codeStream.recordPositionsFrom(varPC, this.catchArguments[i].sourceStart);
                        this.catchBlocks[i].generateCode(this.scope, codeStream);
                        if (!this.catchExits[i]) {
                            switch (finallyMode) {
                                case 1: 
                                case 3: {
                                    requiresNaturalExit = true;
                                }
                                case 0: {
                                    codeStream.goto_(naturalExitLabel);
                                    break;
                                }
                                case 2: {
                                    codeStream.goto_(this.subRoutineStartLabel);
                                    break;
                                }
                            }
                        }
                        ++i;
                    }
                }
                this.exitAnyExceptionHandler();
                ExceptionLabel naturalExitExceptionHandler = requiresNaturalExit && finallyMode == 1 ? new ExceptionLabel(codeStream, null) : null;
                int finallySequenceStartPC = codeStream.position;
                if (this.subRoutineStartLabel != null) {
                    int position;
                    codeStream.pushOnStack(this.scope.getJavaLangThrowable());
                    if (this.preTryInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                    }
                    this.placeAllAnyExceptionHandler();
                    if (naturalExitExceptionHandler != null) {
                        naturalExitExceptionHandler.place();
                    }
                    switch (finallyMode) {
                        case 1: {
                            codeStream.store(this.anyExceptionVariable, false);
                            codeStream.jsr(this.subRoutineStartLabel);
                            codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                            position = codeStream.position;
                            codeStream.throwAnyException(this.anyExceptionVariable);
                            codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                            this.subRoutineStartLabel.place();
                            codeStream.pushOnStack(this.scope.getJavaLangThrowable());
                            position = codeStream.position;
                            codeStream.store(this.returnAddressVariable, false);
                            codeStream.recordPositionsFrom(position, this.finallyBlock.sourceStart);
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            position = codeStream.position;
                            codeStream.ret(this.returnAddressVariable.resolvedPosition);
                            codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                            break;
                        }
                        case 3: {
                            codeStream.store(this.anyExceptionVariable, false);
                            codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                            this.finallyBlock.generateCode(currentScope, codeStream);
                            position = codeStream.position;
                            codeStream.throwAnyException(this.anyExceptionVariable);
                            this.subRoutineStartLabel.place();
                            codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                            break;
                        }
                        case 2: {
                            codeStream.pop();
                            this.subRoutineStartLabel.place();
                            codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            break;
                        }
                    }
                    naturalExitLabel.place();
                    if (requiresNaturalExit) {
                        switch (finallyMode) {
                            case 1: {
                                position = codeStream.position;
                                naturalExitExceptionHandler.placeStart();
                                codeStream.jsr(this.subRoutineStartLabel);
                                naturalExitExceptionHandler.placeEnd();
                                codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                                break;
                            }
                            case 3: {
                                if (this.preTryInitStateIndex != -1) {
                                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                                }
                                this.finallyBlock.generateCode(this.scope, codeStream);
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block46;
                } else {
                    naturalExitLabel.place();
                }
                break block46;
            }
            if (this.subRoutineStartLabel != null) {
                this.finallyBlock.generateCode(this.scope, codeStream);
            }
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public boolean generateSubRoutineInvocation(BlockScope currentScope, CodeStream codeStream, Object targetLocation) {
        int finallyMode = this.finallyMode();
        switch (finallyMode) {
            case 2: {
                codeStream.goto_(this.subRoutineStartLabel);
                return true;
            }
            case 0: {
                this.exitDeclaredExceptionHandlers(codeStream);
                return false;
            }
        }
        if (targetLocation != null) {
            if (this.reusableJSRTargetsCount > 0) {
                int i = 0;
                int count = this.reusableJSRTargetsCount;
                while (i < count) {
                    Object reusableJSRTarget = this.reusableJSRTargets[i];
                    if (targetLocation == reusableJSRTarget || targetLocation instanceof Constant && reusableJSRTarget instanceof Constant && ((Constant)targetLocation).hasSameValue((Constant)reusableJSRTarget)) {
                        codeStream.goto_(this.reusableJSRSequenceStartLabels[i]);
                        return true;
                    }
                    ++i;
                }
            } else {
                this.reusableJSRTargets = new Object[3];
                this.reusableJSRSequenceStartLabels = new BranchLabel[3];
            }
            if (this.reusableJSRTargetsCount == this.reusableJSRTargets.length) {
                this.reusableJSRTargets = new Object[2 * this.reusableJSRTargetsCount];
                System.arraycopy(this.reusableJSRTargets, 0, this.reusableJSRTargets, 0, this.reusableJSRTargetsCount);
                this.reusableJSRSequenceStartLabels = new BranchLabel[2 * this.reusableJSRTargetsCount];
                System.arraycopy(this.reusableJSRSequenceStartLabels, 0, this.reusableJSRSequenceStartLabels, 0, this.reusableJSRTargetsCount);
            }
            this.reusableJSRTargets[this.reusableJSRTargetsCount] = targetLocation;
            BranchLabel reusableJSRSequenceStartLabel = new BranchLabel(codeStream);
            reusableJSRSequenceStartLabel.place();
            this.reusableJSRSequenceStartLabels[this.reusableJSRTargetsCount++] = reusableJSRSequenceStartLabel;
        }
        if (finallyMode == 3) {
            this.exitAnyExceptionHandler();
            this.exitDeclaredExceptionHandlers(codeStream);
            this.finallyBlock.generateCode(currentScope, codeStream);
        } else {
            codeStream.jsr(this.subRoutineStartLabel);
            this.exitAnyExceptionHandler();
            this.exitDeclaredExceptionHandlers(codeStream);
        }
        return false;
    }

    public boolean isSubRoutineEscaping() {
        return (this.bits & 0x4000) != 0;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        TryStatement.printIndent(indent, output).append("try \n");
        this.tryBlock.printStatement(indent + 1, output);
        if (this.catchBlocks != null) {
            int i = 0;
            while (i < this.catchBlocks.length) {
                output.append('\n');
                TryStatement.printIndent(indent, output).append("catch (");
                this.catchArguments[i].print(0, output).append(") ");
                this.catchBlocks[i].printStatement(indent + 1, output);
                ++i;
            }
        }
        if (this.finallyBlock != null) {
            output.append('\n');
            TryStatement.printIndent(indent, output).append("finally\n");
            this.finallyBlock.printStatement(indent + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope);
        BlockScope tryScope = new BlockScope(this.scope);
        BlockScope finallyScope = null;
        if (this.finallyBlock != null) {
            if (this.finallyBlock.isEmptyBlock()) {
                if ((this.finallyBlock.bits & 8) != 0) {
                    this.scope.problemReporter().undocumentedEmptyBlock(this.finallyBlock.sourceStart, this.finallyBlock.sourceEnd);
                }
            } else {
                MethodBinding methodBinding;
                finallyScope = new BlockScope(this.scope, false);
                MethodScope methodScope = this.scope.methodScope();
                if (!upperScope.compilerOptions().inlineJsrBytecode) {
                    this.returnAddressVariable = new LocalVariableBinding(SECRET_RETURN_ADDRESS_NAME, (TypeBinding)upperScope.getJavaLangObject(), 0, false);
                    finallyScope.addLocalVariable(this.returnAddressVariable);
                    this.returnAddressVariable.setConstant(Constant.NotAConstant);
                }
                this.subRoutineStartLabel = new BranchLabel();
                this.anyExceptionVariable = new LocalVariableBinding(SECRET_ANY_HANDLER_NAME, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
                finallyScope.addLocalVariable(this.anyExceptionVariable);
                this.anyExceptionVariable.setConstant(Constant.NotAConstant);
                if (!methodScope.isInsideInitializer() && (methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                    TypeBinding methodReturnType = methodBinding.returnType;
                    if (methodReturnType.id != 6) {
                        this.secretReturnValue = new LocalVariableBinding(SECRET_RETURN_VALUE_NAME, methodReturnType, 0, false);
                        finallyScope.addLocalVariable(this.secretReturnValue);
                        this.secretReturnValue.setConstant(Constant.NotAConstant);
                    }
                }
                this.finallyBlock.resolveUsing(finallyScope);
                finallyScope.shiftScopes = new BlockScope[this.catchArguments == null ? 1 : this.catchArguments.length + 1];
                finallyScope.shiftScopes[0] = tryScope;
            }
        }
        this.tryBlock.resolveUsing(tryScope);
        if (this.catchBlocks != null) {
            int length = this.catchArguments.length;
            TypeBinding[] argumentTypes = new TypeBinding[length];
            boolean catchHasError = false;
            int i = 0;
            while (i < length) {
                BlockScope catchScope = new BlockScope(this.scope);
                if (finallyScope != null) {
                    finallyScope.shiftScopes[i + 1] = catchScope;
                }
                if ((argumentTypes[i] = this.catchArguments[i].resolveForCatch(catchScope)) == null) {
                    catchHasError = true;
                }
                this.catchBlocks[i].resolveUsing(catchScope);
                ++i;
            }
            if (catchHasError) {
                return;
            }
            this.caughtExceptionTypes = new ReferenceBinding[length];
            i = 0;
            while (i < length) {
                this.caughtExceptionTypes[i] = (ReferenceBinding)argumentTypes[i];
                int j = 0;
                while (j < i) {
                    if (this.caughtExceptionTypes[i].isCompatibleWith(argumentTypes[j])) {
                        this.scope.problemReporter().wrongSequenceOfExceptionTypesError(this, this.caughtExceptionTypes[i], i, argumentTypes[j]);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
        if (finallyScope != null) {
            this.scope.addSubscope(finallyScope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.tryBlock.traverse(visitor, this.scope);
            if (this.catchArguments != null) {
                int i = 0;
                int max = this.catchBlocks.length;
                while (i < max) {
                    this.catchArguments[i].traverse(visitor, this.scope);
                    this.catchBlocks[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

