/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.core.ICVSDecoratorEnablementListener;
import org.eclipse.team.internal.ccvs.core.ICVSListener;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.ConsoleListeners;
import org.eclipse.team.internal.ccvs.core.client.listeners.IConsoleListener;
import org.eclipse.team.internal.ccvs.core.resources.FileModificationManager;
import org.eclipse.team.internal.ccvs.core.util.BuildCleanupListener;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.core.util.SyncFileChangeListener;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.osgi.framework.BundleContext;

public class CVSProviderPlugin
extends Plugin {
    public static final String READ_ONLY = "cvs.read.only";
    public static final String ENABLE_WATCH_ON_EDIT = "cvs.watch.on.edit";
    public static final String DEFAULT_CVS_RSH = "ssh";
    public static final String DEFAULT_CVS_RSH_PARAMETERS = "-l {user} {host}";
    public static final String DEFAULT_CVS_SERVER = "cvs";
    public static final boolean DEFAULT_PRUNE = true;
    public static final boolean DEFAULT_CONFIRM_MOVE_TAG = true;
    public static final boolean DEFAULT_FETCH = true;
    public static final int DEFAULT_TIMEOUT = 60;
    public static final int DEFAULT_COMPRESSION_LEVEL = 0;
    public static final Command.KSubstOption DEFAULT_TEXT_KSUBST_OPTION = Command.KSUBST_TEXT_EXPAND;
    public static final String ID = "org.eclipse.team.cvs.core";
    public static final QualifiedName CVS_WORKSPACE_SUBSCRIBER_ID = new QualifiedName("org.eclipse.team.cvs.ui.cvsworkspace-participant", "syncparticipant");
    public static final String PT_AUTHENTICATOR = "authenticator";
    public static final String PT_CONNECTIONMETHODS = "connectionmethods";
    public static final String PT_FILE_MODIFICATION_VALIDATOR = "filemodificationvalidator";
    private Command.QuietOption quietness;
    private int compressionLevel = 0;
    private Command.KSubstOption defaultTextKSubstOption = DEFAULT_TEXT_KSUBST_OPTION;
    private boolean usePlatformLineend = true;
    private int communicationsTimeout = 60;
    private boolean pruneEmptyDirectories = true;
    private boolean fetchAbsentDirectories = true;
    private boolean replaceUnmanaged = true;
    private boolean repositoriesAreBinary = false;
    private String cvsRshCommand = "ssh";
    private String cvsRshParameters = "-l {user} {host}";
    private String cvsServer = "cvs";
    private boolean determineVersionEnabled = true;
    private static volatile CVSProviderPlugin instance;
    private BuildCleanupListener addDeleteMoveListener;
    private FileModificationManager fileModificationManager;
    private SyncFileChangeListener metaFileSyncListener;
    private static final String REPOSITORIES_STATE_FILE = ".cvsProviderState";
    private static final int REPOSITORIES_STATE_FILE_VERSION_2 = -1;
    private static List decoratorEnablementListeners;
    private CVSWorkspaceSubscriber cvsWorkspaceSubscriber;
    private static final String NATURE_ID = "org.eclipse.team.cvs.core.cvsnature";
    private static final String CRASH_INDICATION_FILE = ".running";
    private boolean crash;
    private boolean autoShareOnImport;
    private boolean useProxy;
    public static final String PROXY_TYPE_HTTP = "HTTP";
    public static final String PROXY_TYPE_SOCKS5 = "SOCKS5";
    public static final String HTTP_DEFAULT_PORT = "80";
    public static final String SOCKS5_DEFAULT_PORT = "1080";
    private String proxyType;
    private String proxyHost;
    private String proxyPort;
    private boolean useProxyAuth;
    private static final String INFO_PROXY_USER = "org.eclipse.team.cvs.core.proxy.user";
    private static final String INFO_PROXY_PASS = "org.eclipse.team.cvs.core.proxy.pass";
    private static final URL FAKE_URL;

    static {
        decoratorEnablementListeners = new ArrayList();
        URL temp = null;
        try {
            temp = new URL("http://org.eclipse.team.cvs.proxy.auth");
        }
        catch (MalformedURLException malformedURLException) {}
        FAKE_URL = temp;
    }

    public synchronized CVSWorkspaceSubscriber getCVSWorkspaceSubscriber() {
        if (this.cvsWorkspaceSubscriber == null) {
            this.cvsWorkspaceSubscriber = new CVSWorkspaceSubscriber(CVS_WORKSPACE_SUBSCRIBER_ID, CVSMessages.CVSProviderPlugin_20);
        }
        return this.cvsWorkspaceSubscriber;
    }

    public CVSProviderPlugin() {
        instance = this;
    }

    public static void log(CoreException e) {
        CVSProviderPlugin.log(e.getStatus().getSeverity(), e.getMessage(), e);
    }

    public static void log(int severity, String message, Throwable e) {
        CVSProviderPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void log(IStatus status) {
        CVSProviderPlugin.getPlugin().getLog().log(status);
    }

    public static CVSProviderPlugin getPlugin() {
        return instance;
    }

    public static String getTypeId() {
        return NATURE_ID;
    }

    public void setCompressionLevel(int level) {
        this.compressionLevel = level;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setDefaultTextKSubstOption(Command.KSubstOption ksubst) {
        this.defaultTextKSubstOption = ksubst;
    }

    public Command.KSubstOption getDefaultTextKSubstOption() {
        return this.defaultTextKSubstOption;
    }

    public boolean getPruneEmptyDirectories() {
        return this.pruneEmptyDirectories;
    }

    public void setPruneEmptyDirectories(boolean prune) {
        this.pruneEmptyDirectories = prune;
    }

    public int getTimeout() {
        return this.communicationsTimeout;
    }

    public void setTimeout(int timeout) {
        this.communicationsTimeout = Math.max(0, timeout);
    }

    public void setQuietness(Command.QuietOption option) {
        this.quietness = option;
    }

    public Command.QuietOption getQuietness() {
        return this.quietness;
    }

    public void setConsoleListener(IConsoleListener consoleListener) {
        ConsoleListeners.getInstance().addListener(consoleListener);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.loadOldState();
        this.crash = this.createCrashFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.addDeleteMoveListener = new BuildCleanupListener();
        this.fileModificationManager = new FileModificationManager();
        this.metaFileSyncListener = new SyncFileChangeListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.addDeleteMoveListener, 16);
        workspace.addResourceChangeListener((IResourceChangeListener)this.metaFileSyncListener, 1);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fileModificationManager, 1);
        this.getCVSWorkspaceSubscriber();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            this.savePluginPreferences();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.removeResourceChangeListener((IResourceChangeListener)this.metaFileSyncListener);
            workspace.removeResourceChangeListener((IResourceChangeListener)this.fileModificationManager);
            workspace.removeResourceChangeListener((IResourceChangeListener)this.addDeleteMoveListener);
            workspace.removeSaveParticipant((Plugin)this);
            this.deleteCrashFile();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        super.stop(context);
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences store = this.getPluginPreferences();
        store.setDefault(READ_ONLY, false);
        store.setDefault(ENABLE_WATCH_ON_EDIT, false);
    }

    public String getCvsRshCommand() {
        return this.cvsRshCommand;
    }

    public void setCvsRshCommand(String cvsRshCommand) {
        this.cvsRshCommand = cvsRshCommand;
    }

    public String getCvsRshParameters() {
        return this.cvsRshParameters;
    }

    public void setCvsRshParameters(String cvsRshParameters) {
        this.cvsRshParameters = cvsRshParameters;
    }

    public String getCvsServer() {
        return this.cvsServer;
    }

    public void setCvsServer(String cvsServer) {
        this.cvsServer = cvsServer;
    }

    public boolean getFetchAbsentDirectories() {
        return this.fetchAbsentDirectories;
    }

    public boolean getRepositoriesAreBinary() {
        return this.repositoriesAreBinary;
    }

    public void setFetchAbsentDirectories(boolean fetchAbsentDirectories) {
        this.fetchAbsentDirectories = fetchAbsentDirectories;
    }

    public void setRepositoriesAreBinary(boolean binary) {
        this.repositoriesAreBinary = binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastDecoratorEnablementChanged(final boolean enabled) {
        ICVSDecoratorEnablementListener[] listeners;
        List list = decoratorEnablementListeners;
        synchronized (list) {
            listeners = decoratorEnablementListeners.toArray(new ICVSDecoratorEnablementListener[decoratorEnablementListeners.size()]);
        }
        int i = 0;
        while (i < listeners.length) {
            final ICVSDecoratorEnablementListener listener = listeners[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.decoratorEnablementChanged(enabled);
                }

                public void handleException(Throwable e) {
                }
            };
            Platform.run((ISafeRunnable)code);
            ++i;
        }
    }

    public boolean isReplaceUnmanaged() {
        return this.replaceUnmanaged;
    }

    public void setReplaceUnmanaged(boolean replaceUnmanaged) {
        this.replaceUnmanaged = replaceUnmanaged;
    }

    public void addRepositoryListener(ICVSListener listener) {
        KnownRepositories.getInstance().addRepositoryListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDecoratorEnablementListener(ICVSDecoratorEnablementListener listener) {
        List list = decoratorEnablementListeners;
        synchronized (list) {
            decoratorEnablementListeners.add(listener);
        }
    }

    public void removeRepositoryListener(ICVSListener listener) {
        KnownRepositories.getInstance().removeRepositoryListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDecoratorEnablementListener(ICVSDecoratorEnablementListener listener) {
        List list = decoratorEnablementListeners;
        synchronized (list) {
            decoratorEnablementListeners.remove(listener);
        }
    }

    public ICVSRepositoryLocation[] getKnownRepositories() {
        return KnownRepositories.getInstance().getRepositories();
    }

    private void loadOldState() {
        block4: {
            try {
                IPath pluginStateLocation = CVSProviderPlugin.getPlugin().getStateLocation().append(REPOSITORIES_STATE_FILE);
                File file = pluginStateLocation.toFile();
                if (!file.exists()) break block4;
                try {
                    DataInputStream dis = new DataInputStream(new FileInputStream(file));
                    this.readOldState(dis);
                    dis.close();
                    file.delete();
                }
                catch (IOException e) {
                    throw new TeamException((IStatus)new Status(4, ID, -6, CVSMessages.CVSProvider_ioException, (Throwable)e));
                }
            }
            catch (TeamException e) {
                Util.logError(CVSMessages.CVSProvider_errorLoading, e);
            }
        }
    }

    private void readOldState(DataInputStream dis) throws IOException, CVSException {
        KnownRepositories instance = KnownRepositories.getInstance();
        int count = dis.readInt();
        if (count >= 0) {
            int i = 0;
            while (i < count) {
                ICVSRepositoryLocation location = instance.getRepository(dis.readUTF());
                instance.addRepository(location, false);
                ++i;
            }
        } else if (count == -1) {
            count = dis.readInt();
            int i = 0;
            while (i < count) {
                ICVSRepositoryLocation location = instance.getRepository(dis.readUTF());
                instance.addRepository(location, false);
                dis.readUTF();
                ++i;
            }
        } else {
            Util.logError(NLS.bind((String)CVSMessages.CVSProviderPlugin_unknownStateFileVersion, (Object[])new String[]{new Integer(count).toString()}), null);
        }
    }

    public static boolean isText(IFile file) {
        if (CVSProviderPlugin.getPlugin().getRepositoriesAreBinary()) {
            return false;
        }
        return Team.getFileContentManager().getType((IStorage)file) == 1;
    }

    public boolean isDetermineVersionEnabled() {
        return this.determineVersionEnabled;
    }

    public void setDetermineVersionEnabled(boolean determineVersionEnabled) {
        this.determineVersionEnabled = determineVersionEnabled;
    }

    public FileModificationManager getFileModificationManager() {
        return this.fileModificationManager;
    }

    public boolean isWatchEditEnabled() {
        return this.getPluginPreferences().getBoolean(READ_ONLY);
    }

    public void setDebugProtocol(boolean value) {
        Policy.DEBUG_CVS_PROTOCOL = value;
    }

    public boolean isDebugProtocol() {
        return Policy.DEBUG_CVS_PROTOCOL;
    }

    private boolean createCrashFile() {
        IPath pluginStateLocation = CVSProviderPlugin.getPlugin().getStateLocation();
        File crashFile = pluginStateLocation.append(CRASH_INDICATION_FILE).toFile();
        if (crashFile.exists()) {
            return true;
        }
        try {
            crashFile.createNewFile();
        }
        catch (IOException e) {
            CVSProviderPlugin.log(4, e.getMessage(), e);
        }
        return false;
    }

    private void deleteCrashFile() {
        IPath pluginStateLocation = CVSProviderPlugin.getPlugin().getStateLocation();
        File crashFile = pluginStateLocation.append(CRASH_INDICATION_FILE).toFile();
        crashFile.delete();
    }

    public boolean crashOnLastRun() {
        return this.crash;
    }

    public org.osgi.service.prefs.Preferences getInstancePreferences() {
        return new InstanceScope().getNode(this.getBundle().getSymbolicName());
    }

    public boolean isUsePlatformLineend() {
        return this.usePlatformLineend;
    }

    public void setUsePlatformLineend(boolean usePlatformLineend) {
        this.usePlatformLineend = usePlatformLineend;
    }

    public void setAutoshareOnImport(boolean autoShareOnImport) {
        this.autoShareOnImport = autoShareOnImport;
    }

    public boolean isAutoshareOnImport() {
        return this.autoShareOnImport;
    }

    public boolean isWatchOnEdit() {
        return this.getPluginPreferences().getBoolean(ENABLE_WATCH_ON_EDIT);
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setUseProxyAuth(boolean useProxyAuth) {
        this.useProxyAuth = useProxyAuth;
    }

    public boolean isUseProxyAuth() {
        return this.useProxyAuth;
    }

    public String getProxyUser() {
        Object user = this.getAuthInfo().get(INFO_PROXY_USER);
        return user == null ? "" : (String)user;
    }

    public String getProxyPassword() {
        Object pass = this.getAuthInfo().get(INFO_PROXY_PASS);
        return pass == null ? "" : (String)pass;
    }

    private Map getAuthInfo() {
        Map authInfo = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)"");
        return authInfo != null ? authInfo : Collections.EMPTY_MAP;
    }

    public void setProxyAuth(String proxyUser, String proxyPass) {
        HashMap<String, String> authInfo = this.getAuthInfo();
        if (authInfo.size() == 0) {
            authInfo = new HashMap<String, String>(4);
        }
        if (proxyUser != null) {
            authInfo.put(INFO_PROXY_USER, proxyUser);
        }
        if (proxyPass != null) {
            authInfo.put(INFO_PROXY_PASS, proxyPass);
        }
        try {
            Platform.addAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)"", authInfo);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
        }
    }
}

