/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ExpandBar
extends Composite {
    public ExpandBar(Composite parent, int style) {
        super(parent, style);
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        int border = OS.gtk_container_get_border_width(this.handle);
        size.x += 2 * border;
        size.y += 2 * border;
        return size;
    }

    void createHandle(int index) {
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0)) {
            this.error(2);
        }
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_vbox_new(false, 0);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            int vsp = (this.style & 0x200) != 0 ? 1 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, 2, vsp);
            OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            OS.gtk_scrolled_window_add_with_viewport(this.scrolledHandle, this.handle);
        } else {
            OS.gtk_container_add(this.fixedHandle, this.handle);
        }
        OS.gtk_container_set_border_width(this.handle, 0);
    }

    int eventHandle() {
        return this.fixedHandle;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        int list = OS.gtk_container_get_children(this.handle);
        if (list == 0) {
            return new ExpandItem[0];
        }
        int count = OS.g_list_length(list);
        ExpandItem[] result = new ExpandItem[count];
        int i = 0;
        while (i < count) {
            int data = OS.g_list_nth_data(list, i);
            Widget widget = this.display.getWidget(data);
            result[i] = (ExpandItem)widget;
            ++i;
        }
        OS.g_list_free(list);
        return result;
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[index];
    }

    public int getItemCount() {
        this.checkWidget();
        int list = OS.gtk_container_get_children(this.handle);
        if (list == 0) {
            return 0;
        }
        int itemCount = OS.g_list_length(list);
        OS.g_list_free(list);
        return itemCount;
    }

    public int getSpacing() {
        this.checkWidget();
        return OS.gtk_container_get_border_width(this.handle);
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        ExpandItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (item == items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void releaseChildren(boolean destroy) {
        ExpandItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ExpandItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void relayout() {
        ExpandItem[] items = this.getItems();
        int yScroll = 0;
        if (this.scrolledHandle != 0) {
            int adjustmentHandle = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
            GtkAdjustment adjustment = new GtkAdjustment();
            OS.memmove(adjustment, adjustmentHandle);
            yScroll = (int)adjustment.value;
        }
        int i = 0;
        while (i < items.length) {
            ExpandItem item = items[i];
            if (item != null) {
                item.resizeControl(yScroll);
            }
            ++i;
        }
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        OS.gtk_box_set_spacing(this.handle, spacing);
        OS.gtk_container_set_border_width(this.handle, spacing);
    }

    void updateScrollBarValue(ScrollBar bar) {
        this.relayout();
    }
}

