/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistory;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.ui.AbstractCVSHistoryCategory;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilter;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilterAction;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.DateCVSHistoryCategory;
import org.eclipse.team.internal.ccvs.ui.MessageCVSHistoryCategory;
import org.eclipse.team.internal.ccvs.ui.TextViewerAction;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.CompareRevisionAction;
import org.eclipse.team.internal.ccvs.ui.actions.MoveRemoteTagAction;
import org.eclipse.team.internal.ccvs.ui.actions.OpenRevisionAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagInRepositoryOperation;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.core.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.TypedBufferedContent;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class CVSHistoryPage
extends HistoryPage
implements IAdaptable,
IHistoryCompareAdapter {
    ICVSFile file;
    IFileRevision currentFileRevision;
    CVSFileHistory cvsFileHistory;
    IFileRevision[] entries;
    protected CVSHistoryTableProvider historyTableProvider;
    TreeViewer treeViewer;
    protected TextViewer textViewer;
    protected TableViewer tagViewer;
    CompareRevisionAction compareAction;
    OpenRevisionAction openAction;
    private CVSHistoryFilterAction cvsHistoryFilter;
    private IAction toggleTextAction;
    private IAction toggleTextWrapAction;
    private IAction toggleListAction;
    private IAction toggleCompareAction;
    private IAction toggleFilterAction;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Action refreshAction;
    private Action tagWithExistingAction;
    private Action localMode;
    private Action remoteMode;
    private Action remoteLocalMode;
    private Action groupByDateMode;
    private Action collapseAll;
    private SashForm sashForm;
    private SashForm innerSashForm;
    private Image branchImage;
    private Image versionImage;
    protected IFileRevision currentSelection;
    protected RefreshCVSFileHistory refreshCVSFileHistoryJob;
    boolean shutdown = false;
    boolean localFilteredOut = false;
    boolean remoteFilteredOut = false;
    private HistoryResourceListener resourceListener;
    private boolean compareMode = false;
    public static final int REMOTE_LOCAL_MODE = 0;
    public static final int REMOTE_MODE = 1;
    public static final int LOCAL_MODE = 2;
    private int currentFilerMode = 0;
    private boolean groupingOn;
    private CVSHistoryFilter historyFilter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CVSHistoryPage(Object object) {
        this.file = this.getCVSFile(object);
    }

    public void createControl(Composite parent) {
        this.initializeImages();
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.treeViewer = this.createTree((Composite)this.sashForm);
        this.innerSashForm = new SashForm((Composite)this.sashForm, 256);
        this.tagViewer = this.createTagTable(this.innerSashForm);
        this.textViewer = this.createText(this.innerSashForm);
        this.sashForm.setWeights(new int[]{70, 30});
        this.innerSashForm.setWeights(new int[]{50, 50});
        this.contributeActions();
        this.setViewerVisibility();
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite != null && parentSite instanceof DialogHistoryPageSite && this.treeViewer != null) {
            parentSite.setSelectionProvider((ISelectionProvider)this.treeViewer);
        }
        this.resourceListener = new HistoryResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
    }

    private TextViewer createText(SashForm parent) {
        TextViewer result = new TextViewer((Composite)parent, 2826);
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CVSHistoryPage.this.copyAction.update();
            }
        });
        return result;
    }

    private TableViewer createTagTable(SashForm parent) {
        Table table = new Table((Composite)parent, 68352);
        TableViewer result = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        result.setContentProvider((IContentProvider)new SimpleContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                Object[] tags = (ITag[])inputElement;
                return tags;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == null) {
                    return null;
                }
                ITag tag = (ITag)element;
                if (!(tag instanceof CVSTag)) {
                    return null;
                }
                switch (((CVSTag)tag).getType()) {
                    case 0: 
                    case 1: {
                        return CVSHistoryPage.this.branchImage;
                    }
                    case 2: {
                        return CVSHistoryPage.this.versionImage;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return ((ITag)element).getName();
            }
        });
        result.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof ITag) || !(e2 instanceof ITag)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = (CVSTag)e1;
                CVSTag tag2 = (CVSTag)e2;
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type2 - type1;
                }
                return super.compare(viewer, (Object)tag1, (Object)tag2);
            }
        });
        return result;
    }

    public void setFocus() {
        this.sashForm.setFocus();
    }

    protected void contributeActions() {
        IToolBarManager tbm;
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.refreshAction = new Action(CVSUIMessages.HistoryView_refreshLabel, plugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                CVSHistoryPage.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(CVSUIMessages.HistoryView_refresh);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/refresh.gif"));
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        this.localMode = new Action(CVSUIMessages.CVSHistoryPage_LocalModeAction, plugin.getImageDescriptor("elcl16/local_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 2);
                    CVSHistoryPage.this.updateFilterMode(2);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.localMode.setToolTipText(CVSUIMessages.CVSHistoryPage_LocalModeTooltip);
        this.localMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/local_history_mode.gif"));
        this.localMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/local_history_mode.gif"));
        this.remoteMode = new Action(CVSUIMessages.CVSHistoryPage_RemoteModeAction, plugin.getImageDescriptor("elcl16/remote_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 1);
                    CVSHistoryPage.this.updateFilterMode(1);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.remoteMode.setToolTipText(CVSUIMessages.CVSHistoryPage_RemoteModeTooltip);
        this.remoteMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/remote_history_mode.gif"));
        this.remoteMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/remote_history_mode.gif"));
        this.remoteLocalMode = new Action(CVSUIMessages.CVSHistoryPage_CombinedModeAction, plugin.getImageDescriptor("elcl16/all_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 0);
                    CVSHistoryPage.this.updateFilterMode(0);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.remoteLocalMode.setToolTipText(CVSUIMessages.CVSHistoryPage_CombinedModeTooltip);
        this.remoteLocalMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/all_history_mode.gif"));
        this.remoteLocalMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/all_history_mode.gif"));
        this.updateFilterMode(store.getInt("pref_revision_mode"));
        this.groupByDateMode = new Action(CVSUIMessages.CVSHistoryPage_GroupByDate, CVSUIPlugin.getPlugin().getImageDescriptor("obj16/dates.gif")){

            public void run() {
                CVSHistoryPage.this.groupingOn = !CVSHistoryPage.this.groupingOn;
                CVSHistoryPage.this.toggleCompareAction.setChecked(CVSHistoryPage.this.groupingOn);
                store.setValue("pref_groupbydate_mode", CVSHistoryPage.this.groupingOn);
                CVSHistoryPage.this.refreshHistory(false);
            }
        };
        this.groupingOn = store.getBoolean("pref_groupbydate_mode");
        this.groupByDateMode.setChecked(this.groupingOn);
        this.groupByDateMode.setToolTipText(CVSUIMessages.CVSHistoryPage_GroupByDate);
        this.groupByDateMode.setDisabledImageDescriptor(plugin.getImageDescriptor("obj16/dates.gif"));
        this.groupByDateMode.setHoverImageDescriptor(plugin.getImageDescriptor("obj16/dates.gif"));
        this.collapseAll = new Action(CVSUIMessages.CVSHistoryPage_CollapseAllAction, plugin.getImageDescriptor("elcl16/collapseall.gif")){

            public void run() {
                CVSHistoryPage.this.treeViewer.collapseAll();
            }
        };
        this.collapseAll.setToolTipText(CVSUIMessages.CVSHistoryPage_CollapseAllTooltip);
        this.collapseAll.setDisabledImageDescriptor(plugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.collapseAll.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.compareAction = new CompareRevisionAction(CVSUIMessages.CVSHistoryPage_CompareRevisionAction);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)CVSHistoryPage.this.treeViewer.getSelection());
            }
        });
        this.compareAction.setPage(this);
        this.openAction = new OpenRevisionAction(CVSUIMessages.CVSHistoryPage_OpenAction);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSHistoryPage.this.openAction.selectionChanged((IStructuredSelection)CVSHistoryPage.this.treeViewer.getSelection());
            }
        });
        this.openAction.setPage(this);
        OpenStrategy handler = new OpenStrategy((Control)this.treeViewer.getTree());
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                StructuredSelection tableStructuredSelection = (StructuredSelection)CVSHistoryPage.this.treeViewer.getSelection();
                if (CVSHistoryPage.this.compareMode) {
                    StructuredSelection sel = new StructuredSelection(new Object[]{CVSHistoryPage.this.getCurrentFileRevision(), tableStructuredSelection.getFirstElement()});
                    CVSHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)sel);
                    CVSHistoryPage.this.compareAction.run();
                } else {
                    StructuredSelection sel = tableStructuredSelection;
                    CVSHistoryPage.this.openAction.selectionChanged((IStructuredSelection)sel);
                    CVSHistoryPage.this.openAction.run();
                }
            }
        });
        this.getContentsAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getContentsAction, true, new IWorkspaceRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 100);
                try {
                    try {
                        if (CVSHistoryPage.this.confirmOverwrite()) {
                            IStorage currentStorage = CVSHistoryPage.this.currentSelection.getStorage((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            InputStream in = currentStorage.getContents();
                            ((IFile)CVSHistoryPage.this.file.getIResource()).setContents(in, false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                        }
                    }
                    catch (TeamException e) {
                        throw new CoreException(e.getStatus());
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                }
                monitor.done();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getContentsAction, "org.eclipse.team.cvs.ui.get_file_contents_action_context");
        this.getRevisionAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getRevisionAction, true, new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)((CVSFileRevision)CVSHistoryPage.this.currentSelection).getCVSRemoteFile());
                try {
                    if (CVSHistoryPage.this.confirmOverwrite()) {
                        CVSTag revisionTag = new CVSTag(remoteFile.getRevision(), 2);
                        if (CVSAction.checkForMixingTags(CVSHistoryPage.this.getSite().getShell(), new IResource[]{CVSHistoryPage.this.file.getIResource()}, revisionTag)) {
                            new UpdateOperation(null, new IResource[]{CVSHistoryPage.this.file.getIResource()}, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, revisionTag).run(monitor);
                            Display.getDefault().asyncExec(new Runnable(this){
                                final /* synthetic */ 17 this$1;
                                {
                                    this.this$1 = var1_1;
                                }

                                public void run() {
                                    17.access$0(this.this$1).refresh();
                                }
                            });
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    CVSException.wrapException((Exception)e);
                }
                catch (InterruptedException interruptedException) {}
            }

            static /* synthetic */ CVSHistoryPage access$0(17 var0) {
                return var0.CVSHistoryPage.this;
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.get_file_revision_action_context");
        MoveRemoteTagAction tagActionDelegate = new MoveRemoteTagAction(){

            protected ICVSResource[] getSelectedCVSResources() {
                ICVSResource[] resources = super.getSelectedCVSResources();
                if (resources == null || resources.length == 0) {
                    ArrayList<ICVSRemoteFile> logEntrieFiles = null;
                    IStructuredSelection selection = this.getSelection();
                    if (!selection.isEmpty()) {
                        logEntrieFiles = new ArrayList<ICVSRemoteFile>();
                        Iterator elements = selection.iterator();
                        while (elements.hasNext()) {
                            Object adapter;
                            Object next = elements.next();
                            if (next instanceof CVSFileRevision) {
                                logEntrieFiles.add(((CVSFileRevision)next).getCVSRemoteFile());
                                continue;
                            }
                            if (!(next instanceof IAdaptable)) continue;
                            IAdaptable a = (IAdaptable)next;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (!((adapter = a.getAdapter((Class)clazz)) instanceof ICVSResource)) continue;
                            logEntrieFiles.add(((ILogEntry)adapter).getRemoteFile());
                        }
                    }
                    if (logEntrieFiles != null && !logEntrieFiles.isEmpty()) {
                        return logEntrieFiles.toArray(new ICVSResource[logEntrieFiles.size()]);
                    }
                }
                return resources;
            }

            protected ITagOperation createTagOperation() {
                return new TagInRepositoryOperation(this, this.getTargetPart(), this.getSelectedRemoteResources()){
                    final /* synthetic */ 19 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
                        super.execute(monitor);
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 20 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                if (!20.access$0(this.this$2).wasCancelled()) {
                                    19.access$0(20.access$0(this.this$2)).refresh();
                                }
                            }
                        });
                    }

                    static /* synthetic */ 19 access$0(20 var0) {
                        return var0.this$1;
                    }
                };
            }

            static /* synthetic */ CVSHistoryPage access$0(19 var0) {
                return var0.CVSHistoryPage.this;
            }
        };
        this.tagWithExistingAction = this.getContextMenuAction(CVSUIMessages.HistoryView_tagWithExistingAction, false, new IWorkspaceRunnable((IActionDelegate)tagActionDelegate){
            private final /* synthetic */ IActionDelegate val$tagActionDelegate;
            {
                this.val$tagActionDelegate = iActionDelegate;
            }

            public void run(IProgressMonitor monitor) throws CoreException {
                this.val$tagActionDelegate.selectionChanged((IAction)CVSHistoryPage.this.tagWithExistingAction, CVSHistoryPage.this.treeViewer.getSelection());
                this.val$tagActionDelegate.run((IAction)CVSHistoryPage.this.tagWithExistingAction);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.tag_with_existing_action_context");
        this.toggleTextAction = new Action(TeamUIMessages.GenericHistoryView_ShowCommentViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_comments", CVSHistoryPage.this.toggleTextAction.isChecked());
            }
        };
        this.toggleTextAction.setChecked(store.getBoolean("pref_show_comments"));
        this.toggleTextWrapAction = new Action(TeamUIMessages.GenericHistoryView_WrapComments){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_wrap_comments", CVSHistoryPage.this.toggleTextWrapAction.isChecked());
            }
        };
        this.toggleTextWrapAction.setChecked(store.getBoolean("pref_wrap_comments"));
        this.toggleListAction = new Action(TeamUIMessages.GenericHistoryView_ShowTagViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_tags", CVSHistoryPage.this.toggleListAction.isChecked());
            }
        };
        this.toggleListAction.setChecked(store.getBoolean("pref_show_tags"));
        this.toggleFilterAction = new Action(CVSUIMessages.CVSHistoryPage_NoFilter){

            public void run() {
                if (CVSHistoryPage.this.historyFilter != null) {
                    CVSHistoryPage.this.treeViewer.removeFilter((ViewerFilter)CVSHistoryPage.this.historyFilter);
                }
                CVSHistoryPage.this.historyFilter = null;
                CVSHistoryPage.this.toggleFilterAction.setEnabled(false);
            }
        };
        this.toggleFilterAction.setEnabled(this.historyFilter != null);
        this.toggleCompareAction = new Action(CVSUIMessages.CVSHistoryPage_CompareModeToggleAction){

            public void run() {
                CVSHistoryPage.this.compareMode = !CVSHistoryPage.this.compareMode;
                CVSHistoryPage.this.toggleCompareAction.setChecked(CVSHistoryPage.this.compareMode);
            }
        };
        this.toggleCompareAction.setChecked(false);
        this.cvsHistoryFilter = new CVSHistoryFilterAction(this);
        this.cvsHistoryFilter.setText(CVSUIMessages.CVSHistoryPage_FilterOn);
        this.cvsHistoryFilter.init(this.treeViewer);
        this.cvsHistoryFilter.setToolTipText(CVSUIMessages.CVSHistoryPage_FilterHistoryTooltip);
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                CVSHistoryPage.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getTree().setMenu(menu);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (!parentSite.isModal()) {
            IPageSite pageSite;
            IWorkbenchPart part = parentSite.getPart();
            if (part != null) {
                IWorkbenchPartSite workbenchPartSite = part.getSite();
                workbenchPartSite.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
            }
            if ((pageSite = parentSite.getWorkbenchPageSite()) != null) {
                IActionBars actionBars = pageSite.getActionBars();
                IMenuManager actionBarsMenu = actionBars.getMenuManager();
                if (actionBarsMenu != null) {
                    actionBarsMenu.add(this.toggleCompareAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add(this.toggleTextWrapAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add(this.toggleTextAction);
                    actionBarsMenu.add(this.toggleListAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add((IAction)this.cvsHistoryFilter);
                    actionBarsMenu.add(this.toggleFilterAction);
                }
                this.copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
                this.copyAction.setText(CVSUIMessages.HistoryView_copy);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
                this.selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
                this.selectAllAction.setText(CVSUIMessages.HistoryView_selectAll);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
                actionBars.updateActionBars();
            }
        }
        if ((tbm = parentSite.getToolBarManager()) != null) {
            tbm.add((IContributionItem)new Separator("grouping"));
            tbm.appendToGroup("grouping", (IAction)this.groupByDateMode);
            tbm.add((IContributionItem)new Separator("modes"));
            tbm.appendToGroup("modes", (IAction)this.remoteLocalMode);
            tbm.appendToGroup("modes", (IAction)this.localMode);
            tbm.appendToGroup("modes", (IAction)this.remoteMode);
            tbm.add((IContributionItem)new Separator("collapse"));
            tbm.appendToGroup("collapse", (IAction)this.collapseAll);
            tbm.update(false);
        }
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                CVSHistoryPage.this.fillTextMenu(menuMgr);
            }
        });
        StyledText text = this.textViewer.getTextWidget();
        menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private boolean isLocalHistoryFilteredOut() {
        return this.localFilteredOut;
    }

    private boolean isRemoteHistoryFilteredOut() {
        return this.remoteFilteredOut;
    }

    void fillTableMenu(IMenuManager manager) {
        IStructuredSelection tempSelection;
        ISelection sel;
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        manager.add((IContributionItem)new Separator("group.file"));
        if (this.file != null && !parentSite.isModal()) {
            manager.add((IAction)this.openAction);
            manager.add((IAction)this.compareAction);
            manager.add((IContributionItem)new Separator("openCompare"));
        }
        if (this.file != null && !(this.file instanceof RemoteFile) && !(sel = this.treeViewer.getSelection()).isEmpty() && sel instanceof IStructuredSelection && (tempSelection = (IStructuredSelection)sel).size() == 1) {
            manager.add((IAction)this.getContentsAction);
            if (!(tempSelection.getFirstElement() instanceof LocalFileRevision)) {
                manager.add((IAction)this.getRevisionAction);
                manager.add((IContributionItem)new Separator());
                if (!parentSite.isModal()) {
                    manager.add((IAction)this.tagWithExistingAction);
                }
            }
        }
        if (!parentSite.isModal()) {
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)this.refreshAction);
            manager.add((IContributionItem)new Separator("additions-end"));
        }
    }

    private void fillTextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
    }

    protected TreeViewer createTree(Composite parent) {
        this.historyTableProvider = new CVSHistoryTableProvider();
        TreeViewer viewer = this.historyTableProvider.createTree(parent);
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (CVSHistoryPage.this.entries != null) {
                    return CVSHistoryPage.this.entries;
                }
                if (!(inputElement instanceof IFileHistory) && !(inputElement instanceof AbstractCVSHistoryCategory[])) {
                    return new Object[0];
                }
                if (inputElement instanceof AbstractCVSHistoryCategory[]) {
                    return (AbstractCVSHistoryCategory[])inputElement;
                }
                IFileHistory fileHistory = (IFileHistory)inputElement;
                CVSHistoryPage.this.entries = fileHistory.getFileRevisions();
                return CVSHistoryPage.this.entries;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                CVSHistoryPage.this.entries = null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AbstractCVSHistoryCategory) {
                    return ((AbstractCVSHistoryCategory)parentElement).getRevisions();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                IFileRevision[] revs;
                if (element instanceof AbstractCVSHistoryCategory && (revs = ((AbstractCVSHistoryCategory)element).getRevisions()) != null) {
                    return revs.length > 0;
                }
                return false;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                Object o = ss.getFirstElement();
                if (o instanceof AbstractCVSHistoryCategory) {
                    CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(""));
                    CVSHistoryPage.this.tagViewer.setInput(null);
                    return;
                }
                IFileRevision entry = (IFileRevision)o;
                CVSHistoryPage.this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
                CVSHistoryPage.this.tagViewer.setInput((Object)entry.getTags());
            }
        });
        return viewer;
    }

    private Action getContextMenuAction(String title, final boolean needsProgressDialog, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                block9: {
                    try {
                        if (CVSHistoryPage.this.file == null) {
                            return;
                        }
                        ISelection selection = CVSHistoryPage.this.treeViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Object o = ss.getFirstElement();
                        if (o instanceof AbstractCVSHistoryCategory) {
                            return;
                        }
                        CVSHistoryPage.this.currentSelection = (IFileRevision)o;
                        if (needsProgressDialog) {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(this, action){
                                final /* synthetic */ 32 this$1;
                                private final /* synthetic */ IWorkspaceRunnable val$action;
                                {
                                    this.this$1 = var1_1;
                                    this.val$action = iWorkspaceRunnable;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        this.val$action.run(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                            break block9;
                        }
                        try {
                            action.run(null);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        IHistoryPageSite parentSite = CVSHistoryPage.this.getHistoryPageSite();
                        CVSUIPlugin.openError(parentSite.getShell(), null, null, e, 12);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public boolean isEnabled() {
                ISelection selection = CVSHistoryPage.this.treeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.getIResource().exists()) {
            try {
                if (this.file.isModified(null)) {
                    String title = CVSUIMessages.HistoryView_overwriteTitle;
                    String msg = CVSUIMessages.HistoryView_overwriteMsg;
                    IHistoryPageSite parentSite = this.getHistoryPageSite();
                    final MessageDialog dialog = new MessageDialog(parentSite.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    final int[] result = new int[1];
                    parentSite.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            result[0] = dialog.open();
                        }
                    });
                    if (result[0] != 0) {
                        return false;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return true;
    }

    public void refresh() {
        this.refreshHistory(true);
    }

    private void refreshHistory(boolean refetch) {
        if (this.refreshCVSFileHistoryJob.getState() != 0) {
            this.refreshCVSFileHistoryJob.cancel();
        }
        this.refreshCVSFileHistoryJob.setFileHistory(this.cvsFileHistory);
        this.refreshCVSFileHistoryJob.setRefetchHistory(refetch);
        this.refreshCVSFileHistoryJob.setIncludeLocals(!this.isLocalHistoryFilteredOut());
        this.refreshCVSFileHistoryJob.setIncludeRemote(!this.isRemoteHistoryFilteredOut());
        this.refreshCVSFileHistoryJob.setGrouping(this.groupingOn);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        Utils.schedule((Job)this.refreshCVSFileHistoryJob, (IWorkbenchSite)this.getWorkbenchSite(parentSite));
    }

    private IWorkbenchPartSite getWorkbenchSite(IHistoryPageSite parentSite) {
        IWorkbenchPart part = parentSite.getPart();
        if (part != null) {
            return part.getSite();
        }
        return null;
    }

    public void selectRevision(String revision) {
        if (this.entries == null) {
            return;
        }
        IFileRevision entry = null;
        int i = 0;
        while (i < this.entries.length) {
            if (this.entries[i].getContentIdentifier().equals(revision)) {
                entry = this.entries[i];
                break;
            }
            ++i;
        }
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            this.treeViewer.setSelection((ISelection)selection, true);
        }
    }

    private ICVSFile getCVSFile(Object object) {
        if (object instanceof IFile) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)object));
        }
        if (object instanceof ICVSRemoteFile) {
            return (ICVSRemoteFile)object;
        }
        if (object instanceof CVSFileRevision) {
            return ((CVSFileRevision)object).getCVSRemoteFile();
        }
        return null;
    }

    void setViewerVisibility() {
        boolean showText = this.toggleTextAction.isChecked();
        boolean showList = this.toggleListAction.isChecked();
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite.isModal()) {
            showText = false;
            showList = false;
        }
        if (showText && showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
        } else if (showText) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (showList) {
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.tagViewer.getTable());
        } else {
            this.sashForm.setMaximizedControl(this.treeViewer.getControl());
        }
        boolean wrapText = this.toggleTextWrapAction.isChecked();
        this.textViewer.getTextWidget().setWordWrap(wrapText);
    }

    private void initializeImages() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.versionImage = plugin.getImageDescriptor("obj16/prjversions_rep.gif").createImage();
        this.branchImage = plugin.getImageDescriptor("obj16/tag.gif").createImage();
    }

    public void dispose() {
        this.shutdown = true;
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.resourceListener = null;
        }
        if (this.branchImage != null) {
            this.branchImage.dispose();
            this.branchImage = null;
        }
        if (this.versionImage != null) {
            this.versionImage.dispose();
            this.versionImage = null;
        }
        if (this.refreshCVSFileHistoryJob != null && this.refreshCVSFileHistoryJob.getState() != 0) {
            this.refreshCVSFileHistoryJob.cancel();
        }
    }

    public IFileRevision getCurrentFileRevision() {
        if (this.currentFileRevision != null) {
            return this.currentFileRevision;
        }
        if (this.file != null) {
            try {
                if (this.file instanceof RemoteFile) {
                    RemoteFile remote = (RemoteFile)this.file;
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(remote.getContentIdentifier());
                    return this.currentFileRevision;
                }
                IFile localFile = (IFile)this.file.getIResource();
                if (localFile != null) {
                    this.currentFileRevision = new LocalFileRevision(localFile);
                } else if (this.file.getSyncInfo() != null) {
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(this.file.getSyncInfo().getRevision());
                }
                return this.currentFileRevision;
            }
            catch (CVSException cVSException) {}
        }
        return null;
    }

    public Control getControl() {
        return this.sashForm;
    }

    public boolean isValidInput(Object object) {
        RepositoryProvider provider;
        return object instanceof IResource ? (provider = RepositoryProvider.getProvider((IProject)((IResource)object).getProject())) instanceof CVSTeamProvider : object instanceof ICVSRemoteResource;
    }

    public String getName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public void setSorter(boolean localDisplayed) {
        this.historyTableProvider.setLocalRevisionsDisplayed(localDisplayed);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryCompareAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public ICompareInput getCompareInput(Object object) {
        Object o;
        IStructuredSelection ss;
        if (object != null && object instanceof IStructuredSelection && (ss = (IStructuredSelection)object).size() == 1 && (o = ss.getFirstElement()) instanceof IFileRevision) {
            IFileRevision selectedFileRevision = (IFileRevision)o;
            TypedBufferedContent left = new TypedBufferedContent((IFile)this.file.getIResource());
            FileRevisionTypedElement right = new FileRevisionTypedElement(selectedFileRevision);
            DiffNode node = new DiffNode((ITypedElement)left, (ITypedElement)right);
            return node;
        }
        return null;
    }

    public void setClickAction(boolean compare) {
        this.compareMode = !compare;
        this.toggleCompareAction.run();
    }

    public void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) {
        this.initLabels(input, configuration);
    }

    private void initLabels(ICompareInput input, CompareConfiguration cc) {
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        String leftLabel = this.getFileRevisionLabel(input.getLeft(), cc);
        cc.setLeftLabel(leftLabel);
        String rightLabel = this.getFileRevisionLabel(input.getRight(), cc);
        cc.setRightLabel(rightLabel);
    }

    private String getFileRevisionLabel(ITypedElement element, CompareConfiguration cc) {
        String label = null;
        if (element instanceof TypedBufferedContent) {
            Date dateFromLong = new Date(((TypedBufferedContent)element).getModificationDate());
            label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace, (Object[])new Object[]{element.getName(), DateFormat.getDateTimeInstance().format(dateFromLong)});
            cc.setLeftEditable(true);
            return label;
        }
        if (element instanceof FileRevisionTypedElement) {
            Object fileObject = ((FileRevisionTypedElement)element).getFileRevision();
            if (fileObject instanceof LocalFileRevision) {
                try {
                    IStorage storage = ((LocalFileRevision)fileObject).getStorage((IProgressMonitor)new NullProgressMonitor());
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.core.resources.IFileState");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (Utils.getAdapter((Object)storage, (Class)clazz) != null) {
                        label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_localRevision, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getTimestamp()});
                    }
                }
                catch (CoreException coreException) {}
            } else {
                label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_repository, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getContentIdentifier()});
            }
        }
        return label;
    }

    public String getDescription() {
        try {
            if (this.file != null) {
                return this.file.getRepositoryRelativePath();
            }
        }
        catch (CVSException cVSException) {}
        return null;
    }

    public boolean inputSet() {
        ICVSFile cvsFile;
        this.treeViewer.setInput(null);
        this.currentFileRevision = null;
        this.file = cvsFile = this.getCVSFile(this.getInput());
        if (cvsFile == null) {
            return false;
        }
        this.cvsFileHistory = new CVSFileHistory(cvsFile);
        this.cvsFileHistory.includeLocalRevisions(true);
        if (this.refreshCVSFileHistoryJob == null) {
            this.refreshCVSFileHistoryJob = new RefreshCVSFileHistory();
        }
        this.refreshHistory(true);
        return true;
    }

    private void updateFilterMode(int mode) {
        this.currentFilerMode = mode;
        switch (mode) {
            case 2: {
                this.localFilteredOut = false;
                this.remoteFilteredOut = true;
                this.localMode.setChecked(true);
                this.remoteMode.setChecked(false);
                this.remoteLocalMode.setChecked(false);
                break;
            }
            case 1: {
                this.localFilteredOut = true;
                this.remoteFilteredOut = false;
                this.localMode.setChecked(false);
                this.remoteMode.setChecked(true);
                this.remoteLocalMode.setChecked(false);
                break;
            }
            case 0: {
                this.localFilteredOut = false;
                this.remoteFilteredOut = false;
                this.localMode.setChecked(false);
                this.remoteMode.setChecked(false);
                this.remoteLocalMode.setChecked(true);
            }
        }
        if (this.refreshCVSFileHistoryJob != null) {
            this.refreshHistory(false);
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void showFilter(CVSHistoryFilter filter) {
        if (this.historyFilter != null) {
            this.treeViewer.removeFilter((ViewerFilter)this.historyFilter);
        }
        this.historyFilter = filter;
        this.treeViewer.addFilter((ViewerFilter)filter);
        this.toggleFilterAction.setEnabled(true);
    }

    public void setMode(int flag) {
        switch (flag) {
            case 2: {
                this.localMode.setChecked(true);
                this.localMode.run();
                break;
            }
            case 1: {
                this.remoteMode.setChecked(true);
                this.remoteMode.run();
                break;
            }
            case 0: {
                this.remoteLocalMode.setChecked(true);
                this.remoteLocalMode.run();
            }
        }
        this.refreshHistory(true);
    }

    private class RefreshCVSFileHistory
    extends Job {
        private static final int NUMBER_OF_CATEGORIES = 4;
        private CVSFileHistory fileHistory;
        private AbstractCVSHistoryCategory[] categories;
        private boolean grouping;
        private Object[] elementsToExpand;
        private boolean revisionsFound;

        public RefreshCVSFileHistory() {
            super(CVSUIMessages.HistoryView_fetchHistoryJob);
        }

        public void setIncludeLocals(boolean flag) {
            if (this.fileHistory != null) {
                this.fileHistory.includeLocalRevisions(flag);
            }
        }

        public void setIncludeRemote(boolean flag) {
            if (this.fileHistory != null) {
                this.fileHistory.includeRemoteRevisions(flag);
            }
        }

        public void setRefetchHistory(boolean refetch) {
            if (this.fileHistory != null) {
                this.fileHistory.setRefetchRevisions(refetch);
            }
        }

        public void setFileHistory(CVSFileHistory fileHistory) {
            this.fileHistory = fileHistory;
        }

        public void setGrouping(boolean value) {
            this.grouping = value;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this.fileHistory != null && !CVSHistoryPage.this.shutdown) {
                    if (!this.fileHistory.refresh(monitor)) {
                        this.fileHistory.fetchLocalOnly(monitor);
                    }
                    if (this.grouping) {
                        this.revisionsFound = this.sortRevisions();
                    }
                    Utils.asyncExec((Runnable)new Runnable(this){
                        final /* synthetic */ RefreshCVSFileHistory this$1;
                        {
                            this.this$1 = refreshCVSFileHistory;
                        }

                        public void run() {
                            RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).historyTableProvider.setLocalRevisionsDisplayed(RefreshCVSFileHistory.access$0(this.this$1).getIncludesExists());
                            RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).historyTableProvider.setFile((IFileHistory)RefreshCVSFileHistory.access$0(this.this$1), RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).file);
                            if (RefreshCVSFileHistory.access$1(this.this$1)) {
                                RefreshCVSFileHistory.access$2(this.this$1, RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getExpandedElements());
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getTree().setLinesVisible(RefreshCVSFileHistory.access$3(this.this$1));
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getTree().setRedraw(false);
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.setInput((Object)RefreshCVSFileHistory.access$4(this.this$1));
                                if (RefreshCVSFileHistory.access$5(this.this$1).length > 0) {
                                    RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.setExpandedElements(RefreshCVSFileHistory.access$5(this.this$1));
                                } else {
                                    RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.expandAll();
                                    Object[] el = RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getExpandedElements();
                                    if (el != null && el.length > 0) {
                                        RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.setSelection((ISelection)new StructuredSelection(el[0]));
                                        RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getTree().deselectAll();
                                    }
                                }
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getTree().setRedraw(true);
                            } else if (RefreshCVSFileHistory.access$0(this.this$1).getFileRevisions().length > 0) {
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getTree().setLinesVisible(true);
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.setInput((Object)RefreshCVSFileHistory.access$0(this.this$1));
                            } else {
                                RefreshCVSFileHistory.access$7(this.this$1, new AbstractCVSHistoryCategory[]{RefreshCVSFileHistory.access$6(this.this$1)});
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.getTree().setLinesVisible(false);
                                RefreshCVSFileHistory.access$8((RefreshCVSFileHistory)this.this$1).treeViewer.setInput((Object)RefreshCVSFileHistory.access$4(this.this$1));
                            }
                        }
                    }, (StructuredViewer)CVSHistoryPage.this.treeViewer);
                }
                return Status.OK_STATUS;
            }
            catch (TeamException e) {
                return e.getStatus();
            }
        }

        private void mapExpandedElements(Object[] expandedElements) {
            HashMap elementMap = new HashMap();
            int i = 0;
            while (i < expandedElements.length) {
                elementMap.put(((DateCVSHistoryCategory)expandedElements[i]).getName(), null);
                ++i;
            }
            ArrayList<AbstractCVSHistoryCategory> expandable = new ArrayList<AbstractCVSHistoryCategory>();
            int i2 = 0;
            while (i2 < this.categories.length) {
                if (elementMap.containsKey(this.categories[i2].getName())) {
                    expandable.add(this.categories[i2]);
                }
                ++i2;
            }
            this.elementsToExpand = new Object[expandable.size()];
            this.elementsToExpand = expandable.toArray(new Object[expandable.size()]);
        }

        private boolean sortRevisions() {
            IFileRevision[] fileRevision = this.fileHistory.getFileRevisions();
            DateCVSHistoryCategory[] tempCategories = new DateCVSHistoryCategory[4];
            Calendar currentCal = Calendar.getInstance();
            tempCategories[0] = new DateCVSHistoryCategory(CVSUIMessages.CVSHistoryPage_Today, currentCal, null);
            Calendar yesterdayCal = Calendar.getInstance();
            yesterdayCal.roll(6, -1);
            tempCategories[1] = new DateCVSHistoryCategory(CVSUIMessages.CVSHistoryPage_Yesterday, yesterdayCal, null);
            Calendar lastWeekCal = Calendar.getInstance();
            lastWeekCal.roll(6, -7);
            tempCategories[2] = new DateCVSHistoryCategory(CVSUIMessages.CVSHistoryPage_LastWeek, lastWeekCal, yesterdayCal);
            tempCategories[3] = new DateCVSHistoryCategory(CVSUIMessages.CVSHistoryPage_Previous, null, lastWeekCal);
            ArrayList<AbstractCVSHistoryCategory> finalCategories = new ArrayList<AbstractCVSHistoryCategory>();
            int i = 0;
            while (i < 4) {
                tempCategories[i].collectFileRevisions(fileRevision, false);
                if (tempCategories[i].hasRevisions()) {
                    finalCategories.add(tempCategories[i]);
                }
                ++i;
            }
            boolean revisionsFound = true;
            if (finalCategories.size() == 0) {
                finalCategories.add(this.getErrorMessage());
                revisionsFound = false;
            }
            this.categories = finalCategories.toArray(new AbstractCVSHistoryCategory[finalCategories.size()]);
            return revisionsFound;
        }

        private MessageCVSHistoryCategory getErrorMessage() {
            String message = "";
            switch (CVSHistoryPage.this.currentFilerMode) {
                case 2: {
                    message = CVSUIMessages.CVSHistoryPage_LocalModeTooltip;
                    break;
                }
                case 1: {
                    message = CVSUIMessages.CVSHistoryPage_RemoteModeTooltip;
                    break;
                }
                case 0: {
                    message = CVSUIMessages.CVSHistoryPage_NoRevisions;
                }
            }
            MessageCVSHistoryCategory messageCategory = new MessageCVSHistoryCategory(NLS.bind((String)CVSUIMessages.CVSHistoryPage_NoRevisionsForMode, (Object[])new String[]{message}));
            return messageCategory;
        }

        static /* synthetic */ CVSFileHistory access$0(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.fileHistory;
        }

        static /* synthetic */ boolean access$1(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.grouping;
        }

        static /* synthetic */ void access$2(RefreshCVSFileHistory refreshCVSFileHistory, Object[] objectArray) {
            refreshCVSFileHistory.mapExpandedElements(objectArray);
        }

        static /* synthetic */ boolean access$3(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.revisionsFound;
        }

        static /* synthetic */ AbstractCVSHistoryCategory[] access$4(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.categories;
        }

        static /* synthetic */ Object[] access$5(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.elementsToExpand;
        }

        static /* synthetic */ MessageCVSHistoryCategory access$6(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.getErrorMessage();
        }

        static /* synthetic */ void access$7(RefreshCVSFileHistory refreshCVSFileHistory, AbstractCVSHistoryCategory[] abstractCVSHistoryCategoryArray) {
            refreshCVSFileHistory.categories = abstractCVSHistoryCategoryArray;
        }

        static /* synthetic */ CVSHistoryPage access$8(RefreshCVSFileHistory refreshCVSFileHistory) {
            return refreshCVSFileHistory.CVSHistoryPage.this;
        }
    }

    private class SimpleContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object element) {
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class HistoryResourceListener
    implements IResourceChangeListener {
        private HistoryResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            if (CVSHistoryPage.this.file == null || CVSHistoryPage.this.file.getIResource() == null) {
                return;
            }
            IResourceDelta resourceDelta = root.findMember(((IFile)CVSHistoryPage.this.file.getIResource()).getFullPath());
            if (resourceDelta != null) {
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ HistoryResourceListener this$1;
                    {
                        this.this$1 = historyResourceListener;
                    }

                    public void run() {
                        HistoryResourceListener.access$1(this.this$1).refresh();
                    }
                });
            }
        }

        static /* synthetic */ CVSHistoryPage access$1(HistoryResourceListener historyResourceListener) {
            return historyResourceListener.CVSHistoryPage.this;
        }
    }
}

