/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.HistoryPageSaveablePart;
import org.eclipse.team.ui.history.IHistoryPage;

public class CompareWithRevisionAction
extends WorkspaceAction {
    protected ICVSRemoteFile getSelectedRemoteFile() {
        IResource[] resources = this.getSelectedResources();
        if (resources.length != 1) {
            return null;
        }
        if (!(resources[0] instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)resources[0];
        try {
            return (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e), null, null);
            return null;
        }
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final ICVSRemoteFile[] file = new ICVSRemoteFile[1];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                file[0] = CompareWithRevisionAction.this.getSelectedRemoteFile();
            }
        }, false, 2);
        if (file[0] == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)CVSUIMessages.CompareWithRevisionAction_noRevisions, (String)CVSUIMessages.CompareWithRevisionAction_noRevisionsLong);
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                if (CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_compare_revision_in_dialog")) {
                    IFile file = (IFile)CompareWithRevisionAction.this.getSelectedResources()[0];
                    CompareWithRevisionAction.this.showCompareInDialog(CompareWithRevisionAction.this.getShell(), file);
                } else {
                    IHistoryPage page = TeamUI.getHistoryView().showHistoryFor((Object)((IFile)CompareWithRevisionAction.this.getSelectedResources()[0]));
                    if (page instanceof CVSHistoryPage) {
                        CVSHistoryPage cvsHistoryPage = (CVSHistoryPage)page;
                        cvsHistoryPage.setClickAction(true);
                    }
                }
            }
        }, false, 2);
    }

    protected void showCompareInDialog(Shell shell, Object object) {
        HistoryPageSaveablePart.showHistoryInDialog((Shell)shell, (Object)object);
    }

    protected String getActionTitle() {
        return CVSUIMessages.CompareWithRevisionAction_4;
    }

    protected String getErrorTitle() {
        return CVSUIMessages.CompareWithRevisionAction_compare;
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isFolder() && super.isEnabledForCVSResource(cvsResource);
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }
}

