/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.operations.ShowAnnotationOperation;

public class ShowAnnotationAction
extends WorkspaceAction {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        ICVSResource resource = this.getSingleSelectedCVSResource();
        if (resource == null) {
            return;
        }
        this.execute(resource);
    }

    public void execute(ICVSResource cvsResource) throws InvocationTargetException, InterruptedException {
        String revision = this.getRevision(cvsResource);
        if (revision == null) {
            return;
        }
        boolean binary = this.isBinary(cvsResource);
        if (binary && !MessageDialog.openQuestion((Shell)this.getShell(), (String)CVSUIMessages.ShowAnnotationAction_2, (String)NLS.bind((String)CVSUIMessages.ShowAnnotationAction_3, (Object[])new String[]{cvsResource.getName()}))) {
            return;
        }
        new ShowAnnotationOperation(this.getTargetPart(), cvsResource, revision, binary).run();
    }

    private boolean isBinary(ICVSResource cvsResource) {
        byte[] syncBytes;
        block5: {
            if (cvsResource.isFolder()) {
                return false;
            }
            if (cvsResource instanceof RemoteFile) {
                RemoteFile rFile = (RemoteFile)cvsResource;
                int result = Team.getFileContentManager().getTypeForName(rFile.getName());
                return result == 2 || result == 0;
            }
            try {
                syncBytes = ((ICVSFile)cvsResource).getSyncBytes();
                if (syncBytes != null) break block5;
                return false;
            }
            catch (CVSException cVSException) {
                return false;
            }
        }
        return ResourceSyncInfo.isBinary((byte[])syncBytes);
    }

    protected boolean isEnabled() throws TeamException {
        ICVSResource resource = this.getSingleSelectedCVSResource();
        return resource != null && !resource.isFolder() && resource.isManaged();
    }

    private ICVSResource getSingleSelectedCVSResource() {
        Object[] fileRevisions;
        Object[] logEntries;
        ICVSResource[] cvsResources = this.getSelectedCVSResources();
        if (cvsResources.length == 1) {
            return cvsResources[0];
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((logEntries = this.getAdaptedSelection(clazz)).length == 1) {
            LogEntry aLogEntry = (LogEntry)logEntries[0];
            ICVSRemoteFile cvsRemoteFile = aLogEntry.getRemoteFile();
            return cvsRemoteFile;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((fileRevisions = this.getAdaptedSelection(clazz2)).length == 1) {
            ICVSRemoteFile cvsRemoteFile = ((CVSFileRevision)fileRevisions[0]).getCVSRemoteFile();
            return cvsRemoteFile;
        }
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 1) {
            return this.getCVSResourceFor(resources[0]);
        }
        return null;
    }

    private String getRevision(ICVSResource cvsResource) throws InvocationTargetException {
        ResourceSyncInfo info;
        try {
            info = cvsResource.getSyncInfo();
            if (info == null) {
                throw new CVSException(NLS.bind((String)CVSUIMessages.ShowAnnotationAction_noSyncInfo, (Object[])new String[]{cvsResource.getName()}));
            }
        }
        catch (CVSException e) {
            throw new InvocationTargetException(e);
        }
        return info.getRevision();
    }

    public String getId() {
        return "org.eclipse.team.cvs.ui.showAnnotation";
    }
}

