/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelProviderAction;
import org.eclipse.team.internal.ccvs.ui.wizards.GenerateDiffFileWizard;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;

public class CreatePatchAction
extends CVSModelProviderAction {
    public CreatePatchAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        try {
            IResource[] resources = this.getVisibleResources(selection);
            return resources.length > 0;
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
            return false;
        }
    }

    private IResource[] getVisibleResources(IStructuredSelection selection) throws CoreException {
        HashSet<IResource> resources = new HashSet<IResource>();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            IResource resource = Utils.getResource(element);
            if (resource == null) {
                return new IResource[0];
            }
            IResourceDiffTree diffTree = this.getSynchronizationContext().getDiffTree();
            IDiff[] diffs = diffTree.getDiffs(resource, 2);
            int i = 0;
            while (i < diffs.length) {
                IThreeWayDiff twd;
                ITwoWayDiff local;
                IDiff diff = diffs[i];
                IResource child = diffTree.getResource(diff);
                if (child.getType() == 1 && diff instanceof IThreeWayDiff && (local = (twd = (IThreeWayDiff)diff).getLocalChange()) != null && local.getKind() != 0) {
                    resources.add(child);
                }
                ++i;
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    protected String getBundleKeyPrefix() {
        return "GenerateDiffFileAction.";
    }

    public void execute() {
        final ResourceTraversal[][] traversals = new ResourceTraversal[1][];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        traversals[0] = CreatePatchAction.this.getResourceTraversals(CreatePatchAction.this.getStructuredSelection(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handleError((Shell)this.getConfiguration().getSite().getShell(), (Exception)e, null, null);
        }
        catch (InterruptedException interruptedException) {}
        if (traversals[0] != null) {
            IResource[] resources = this.getVisibleResources(traversals[0]);
            GenerateDiffFileWizard.run(this.getConfiguration().getSite().getPart(), resources, false);
        }
    }

    private IResource[] getVisibleResources(ResourceTraversal[] traversals) {
        HashSet<IResource> resources = new HashSet<IResource>();
        IResourceDiffTree diffTree = this.getSynchronizationContext().getDiffTree();
        IDiff[] diffs = diffTree.getDiffs(traversals);
        int i = 0;
        while (i < diffs.length) {
            IThreeWayDiff twd;
            ITwoWayDiff local;
            IDiff diff = diffs[i];
            IResource child = diffTree.getResource(diff);
            if (child.getType() == 1 && diff instanceof IThreeWayDiff && (local = (twd = (IThreeWayDiff)diff).getLocalChange()) != null && local.getKind() != 0) {
                resources.add(child);
            }
            ++i;
        }
        return resources.toArray(new IResource[resources.size()]);
    }
}

