/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import java.util.ResourceBundle;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.BranchAction;
import org.eclipse.team.internal.ccvs.ui.actions.IgnoreAction;
import org.eclipse.team.internal.ccvs.ui.actions.SetKeywordSubstitutionAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowAnnotationAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelSynchronizeParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.CommitAction;
import org.eclipse.team.internal.ccvs.ui.mappings.CreatePatchAction;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceChangeSetCapability;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceCommitAction;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceModelParticipant;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.MergeAllActionHandler;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipantActionGroup;

public class WorkspaceModelParticipant
extends CVSModelSynchronizeParticipant
implements IChangeSetProvider {
    public static final String VIEWER_ID = "org.eclipse.team.cvs.ui.workspaceSynchronization";
    public static final String CONTEXT_MENU_UPDATE_GROUP_1 = "update";
    public static final String CONTEXT_MENU_COMMIT_GROUP_1 = "commit";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_2 = "overrideActions";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_3 = "otherActions1";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP_4 = "otherActions2";
    public static final String ID = "org.eclipse.team.cvs.ui.workspace-participant";
    private WorkspaceChangeSetCapability capability;

    public WorkspaceModelParticipant() {
    }

    public WorkspaceModelParticipant(SynchronizationContext context) {
        super(context);
        try {
            this.setInitializationData(TeamUI.getSynchronizeManager().getParticipantDescriptor(ID));
        }
        catch (CoreException e) {
            TeamUIPlugin.log((CoreException)e);
        }
        this.setSecondaryId(Long.toString(System.currentTimeMillis()));
    }

    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_VIEWER_ID", (Object)VIEWER_ID);
        super.initializeConfiguration(configuration);
    }

    protected ModelSynchronizeParticipantActionGroup createMergeActionGroup() {
        return new WorkspaceMergeActionGroup();
    }

    protected MergeContext restoreContext(ISynchronizationScopeManager manager) {
        return WorkspaceSubscriberContext.createContext(manager, 3);
    }

    protected ISynchronizationScopeManager createScopeManager(ResourceMapping[] mappings) {
        return new SubscriberScopeManager(CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().getName(), mappings, (Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), true);
    }

    public ChangeSetCapability getChangeSetCapability() {
        if (this.capability == null) {
            this.capability = new WorkspaceChangeSetCapability();
        }
        return this.capability;
    }

    public class WorkspaceMergeActionGroup
    extends ModelSynchronizeParticipantActionGroup {
        private WorkspaceCommitAction commitToolbar;

        public void initialize(ISynchronizePageConfiguration configuration) {
            configuration.setProperty("org.eclipse.team.ui.mergeAll", (Object)new MergeAllActionHandler(this, configuration){
                final /* synthetic */ WorkspaceMergeActionGroup this$1;
                {
                    this.this$1 = workspaceMergeActionGroup;
                }

                protected String getJobName() {
                    String name = this.getConfiguration().getParticipant().getName();
                    return NLS.bind((String)CVSUIMessages.WorkspaceModelParticipant_0, (Object)Utils.shortenText((int)30, (String)name));
                }

                protected boolean promptToUpdate() {
                    IResourceDiffTree tree = this.getMergeContext().getDiffTree();
                    if (tree.isEmpty()) {
                        return false;
                    }
                    long count = tree.countFor(512, 768) + tree.countFor(768, 768);
                    if (count == 0L) {
                        return false;
                    }
                    boolean[] result = new boolean[]{true};
                    TeamUIPlugin.getStandardDisplay().syncExec(new Runnable(this, count, tree, result){
                        final /* synthetic */ 1 this$2;
                        private final /* synthetic */ long val$count;
                        private final /* synthetic */ IResourceDiffTree val$tree;
                        private final /* synthetic */ boolean[] val$result;
                        {
                            this.this$2 = var1_1;
                            this.val$count = l;
                            this.val$tree = iResourceDiffTree;
                            this.val$result = blArray;
                        }

                        public void run() {
                            String sizeString = Long.toString(this.val$count);
                            String message = this.val$tree.size() > 1 ? NLS.bind((String)CVSUIMessages.UpdateAction_promptForUpdateSeveral, (Object[])new String[]{sizeString}) : NLS.bind((String)CVSUIMessages.UpdateAction_promptForUpdateOne, (Object[])new String[]{sizeString});
                            this.val$result[0] = MessageDialog.openQuestion((Shell)1.access$0(this.this$2).getSite().getShell(), (String)NLS.bind((String)CVSUIMessages.UpdateAction_promptForUpdateTitle, (Object[])new String[]{sizeString}), (String)message);
                        }
                    });
                    return result[0];
                }

                private IMergeContext getMergeContext() {
                    return (IMergeContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
                }

                protected boolean needsToSaveDirtyEditors() {
                    int option = CVSUIPlugin.getPlugin().getPreferenceStore().getInt("pref_save_dirty_editors");
                    return option != 1;
                }

                protected boolean confirmSaveOfDirtyEditor() {
                    int option = CVSUIPlugin.getPlugin().getPreferenceStore().getInt("pref_save_dirty_editors");
                    return option == 2;
                }

                static /* synthetic */ ISynchronizePageConfiguration access$0(1 var0) {
                    return var0.getConfiguration();
                }
            });
            super.initialize(configuration);
            int modes = configuration.getSupportedModes();
            if ((modes & 6) != 0) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_COMMIT_GROUP_1, (IAction)new CommitAction(configuration));
                this.commitToolbar = new WorkspaceCommitAction(configuration);
                this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", "merge", (IAction)this.commitToolbar);
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new IgnoreAction(), configuration));
            }
            if (!configuration.getSite().isModal()) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CreatePatchAction(configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new BranchAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new ShowAnnotationAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new ShowResourceInHistoryAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_3, (IAction)new CVSActionDelegateWrapper(new SetKeywordSubstitutionAction(), configuration));
            }
        }

        protected void configureMergeAction(String mergeActionId, Action action) {
            if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
                Utils.initAction((IAction)action, (String)"WorkspaceUpdateAction.", (ResourceBundle)Policy.getActionBundle());
            } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
                Utils.initAction((IAction)action, (String)"OverrideAndUpdateAction.", (ResourceBundle)Policy.getActionBundle());
            } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
                Utils.initAction((IAction)action, (String)"ConfirmMergedAction.", (ResourceBundle)Policy.getActionBundle());
            } else if (mergeActionId == "org.eclipse.team.ui.mergeAll") {
                Utils.initAction((IAction)action, (String)"WorkspaceToolbarUpdateAction.", (ResourceBundle)Policy.getActionBundle());
            } else {
                super.configureMergeAction(mergeActionId, action);
            }
        }

        protected void addToContextMenu(String mergeActionId, Action action, IMenuManager manager) {
            IContributionItem group = null;
            if (mergeActionId == "org.eclipse.team.ui.mergeAction") {
                group = manager.find(WorkspaceModelParticipant.CONTEXT_MENU_UPDATE_GROUP_1);
            } else if (mergeActionId == "org.eclipse.team.ui.overwriteAction") {
                group = manager.find(WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2);
            } else if (mergeActionId == "org.eclipse.team.ui.markAsMergeAction") {
                group = manager.find(WorkspaceModelParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP_2);
            } else {
                super.addToContextMenu(mergeActionId, action, manager);
                return;
            }
            if (group != null) {
                manager.appendToGroup(group.getId(), (IAction)action);
            } else {
                manager.add((IAction)action);
            }
        }
    }
}

