/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RDiff;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.RDiffSummaryListener;
import org.eclipse.team.internal.ccvs.core.resources.FileContentCachingService;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSCompareEditorInput;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ResourceEditionNode;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteOperation;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class RemoteCompareOperation
extends RemoteOperation {
    private CompareTreeBuilder builder;
    private CVSTag left;
    private CVSTag right;

    public static CVSTag getTag(ICVSRemoteResource resource) throws CVSException {
        CVSTag tag = null;
        try {
            if (resource.isContainer()) {
                tag = ((ICVSRemoteFolder)resource).getTag();
            } else {
                ICVSRemoteFile file = (ICVSRemoteFile)resource;
                String revision = file.getRevision();
                if (revision.equals("0")) {
                    ResourceSyncInfo info = file.getSyncInfo();
                    if (info != null) {
                        tag = info.getTag();
                    }
                } else {
                    tag = new CVSTag(revision, 2);
                }
            }
        }
        catch (TeamException e) {
            throw CVSException.wrapException((CoreException)((Object)e));
        }
        if (tag == null) {
            tag = CVSTag.DEFAULT;
        }
        return tag;
    }

    public static RemoteCompareOperation create(IWorkbenchPart part, ICVSRemoteResource remoteResource, CVSTag tag) throws CVSException {
        CVSTag tag0 = RemoteCompareOperation.getTag(remoteResource);
        CVSTag tag1 = tag;
        if (tag0.getType() == 3 && tag1.getType() == 3 && tag0.asDate().after(tag1.asDate())) {
            tag = tag0;
            remoteResource = remoteResource.forTag(tag1);
        }
        return new RemoteCompareOperation(part, remoteResource, tag);
    }

    protected RemoteCompareOperation(IWorkbenchPart part, ICVSRemoteResource remoteResource, CVSTag tag) {
        super(part, new ICVSRemoteResource[]{remoteResource});
        Assert.isNotNull((Object)tag);
        this.right = tag;
        try {
            this.left = RemoteCompareOperation.getTag(remoteResource);
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        if (this.left == null) {
            this.left = CVSTag.DEFAULT;
        }
        this.builder = new CompareTreeBuilder(remoteResource.getRepository(), this.left, this.right);
    }

    private ICVSRemoteResource getRemoteResource() {
        return this.getRemoteResources()[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IProgressMonitor monitor) throws CVSException {
        boolean fetchContents = CVSUIPlugin.getPlugin().getPluginPreferences().getBoolean("pref_consider_contents");
        monitor.beginTask(this.getTaskName(), 50 + (fetchContents ? 100 : 0));
        try {
            ICVSRemoteResource resource = this.getRemoteResource();
            IStatus status = this.buildTrees(resource, Policy.subMonitorFor(monitor, 50));
            if (status.isOK() && fetchContents) {
                this.builder.cacheContents(Policy.subMonitorFor(monitor, 100));
            }
            this.collectStatus(status);
            this.openCompareEditor(this.builder);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    protected void openCompareEditor(CompareTreeBuilder builder) {
        builder.openCompareEditor(this.getTargetPage(), null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus buildTrees(ICVSRemoteResource resource, IProgressMonitor monitor) throws CVSException {
        this.builder.reset();
        oldOption = CVSProviderPlugin.getPlugin().getQuietness();
        session = new Session(resource.getRepository(), (ICVSFolder)this.builder.getLeftTree(), false);
        try {
            monitor.beginTask(this.getTaskName(), 100);
            CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
            session.open(Policy.subMonitorFor(monitor, 10));
            var8_6 = status = Command.RDIFF.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(), new ICVSResource[]{resource}, (ICommandOutputListener)new RDiffSummaryListener((RDiffSummaryListener.IFileDiffListener)this.builder), Policy.subMonitorFor(monitor, 90));
            var6_7 = null;
            ** GOTO lbl-1000
        }
        catch (Throwable var7_13) {
            var6_8 = null;
            try {
                session.close();
                ** GOTO lbl35
            }
            catch (Throwable var10_10) {
                v0 = null;
lbl20:
                // 2 sources

                while (true) {
                    var9_12 = v0;
                    CVSProviderPlugin.getPlugin().setQuietness(oldOption);
                    throw var7_13;
                }
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Throwable var10_9) {
                v1 = null;
lbl27:
                // 2 sources

                while (true) {
                    var9_11 = v1;
                    CVSProviderPlugin.getPlugin().setQuietness(oldOption);
                    return var8_6;
                }
            }
            session.close();
            {
                v1 = null;
                ** continue;
lbl35:
                // 1 sources

                v0 = null;
                ** continue;
            }
        }
    }

    private Command.LocalOption[] getLocalOptions() {
        return new Command.LocalOption[]{RDiff.SUMMARY, RDiff.makeTagOption((CVSTag)this.left), RDiff.makeTagOption((CVSTag)this.right)};
    }

    protected String getTaskName() {
        return NLS.bind((String)CVSUIMessages.RemoteCompareOperation_0, (Object[])new Object[]{this.left.getName(), this.right.getName(), this.getRemoteResource().getRepositoryRelativePath()});
    }

    protected IWorkbenchPage getTargetPage() {
        return TeamUIPlugin.getActivePage();
    }

    public static class CompareTreeBuilder
    implements RDiffSummaryListener.IFileDiffListener {
        private ICVSRepositoryLocation location;
        private RemoteFolderTree leftTree;
        private RemoteFolderTree rightTree;
        private CVSTag left;
        private CVSTag right;

        public CompareTreeBuilder(ICVSRepositoryLocation location, CVSTag left, CVSTag right) {
            this.left = left;
            this.right = right;
            this.location = location;
            this.reset();
        }

        public RemoteFolderTree getLeftTree() {
            return this.leftTree;
        }

        public RemoteFolderTree getRightTree() {
            return this.rightTree;
        }

        public void reset() {
            this.leftTree = new RemoteFolderTree(null, this.location, "", this.left);
            this.leftTree.setChildren(new ICVSRemoteResource[0]);
            this.rightTree = new RemoteFolderTree(null, this.location, "", this.right);
            this.rightTree.setChildren(new ICVSRemoteResource[0]);
        }

        public void cacheContents(IProgressMonitor monitor) throws CVSException {
            String[] overlappingFilePaths = this.getOverlappingFilePaths();
            if (overlappingFilePaths.length > 0) {
                monitor.beginTask(null, 100);
                this.fetchFileContents(this.leftTree, overlappingFilePaths, Policy.subMonitorFor(monitor, 50));
                this.fetchFileContents(this.rightTree, overlappingFilePaths, Policy.subMonitorFor(monitor, 50));
                monitor.done();
            }
        }

        public void openCompareEditor(IWorkbenchPage page, String title, String toolTip) {
            if (this.leftTree == null || this.rightTree == null) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(this, title, toolTip, page){
                final /* synthetic */ CompareTreeBuilder this$1;
                private final /* synthetic */ String val$title;
                private final /* synthetic */ String val$toolTip;
                private final /* synthetic */ IWorkbenchPage val$page;
                {
                    this.this$1 = compareTreeBuilder;
                    this.val$title = string;
                    this.val$toolTip = string2;
                    this.val$page = iWorkbenchPage;
                }

                public void run() {
                    CompareUI.openCompareEditorOnPage((CompareEditorInput)new CVSCompareEditorInput(this.val$title, this.val$toolTip, new ResourceEditionNode((ICVSRemoteResource)CompareTreeBuilder.access$0(this.this$1)), new ResourceEditionNode((ICVSRemoteResource)CompareTreeBuilder.access$1(this.this$1))), (IWorkbenchPage)this.val$page);
                }
            });
        }

        public void addToTrees(ICVSRemoteFile predecessor, ICVSRemoteFile remote) {
            Path filePath;
            if (remote != null) {
                try {
                    filePath = new Path(null, remote.getRepositoryRelativePath());
                    this.addFile(this.rightTree, this.right, filePath, remote.getRevision());
                    this.getFolder(this.leftTree, this.left, filePath.removeLastSegments(1), (IPath)Path.EMPTY);
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
            if (predecessor != null) {
                try {
                    filePath = new Path(null, predecessor.getRepositoryRelativePath());
                    this.addFile(this.leftTree, this.left, filePath, predecessor.getRevision());
                    this.getFolder(this.rightTree, this.right, filePath.removeLastSegments(1), (IPath)Path.EMPTY);
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
        }

        private void addFile(RemoteFolderTree tree, CVSTag tag, Path filePath, String revision) throws CVSException {
            RemoteFolderTree parent = (RemoteFolderTree)this.getFolder(tree, tag, filePath.removeLastSegments(1), (IPath)Path.EMPTY);
            String name = filePath.lastSegment();
            RemoteFile file = new RemoteFile((RemoteFolder)parent, 0, name, revision, null, this.getTag(revision, tag));
            this.addChild(parent, (ICVSRemoteResource)file);
        }

        private CVSTag getTag(String revision, CVSTag tag) {
            if (tag == null) {
                tag = new CVSTag(revision, 2);
            }
            return tag;
        }

        private ICVSRemoteFolder getFolder(RemoteFolderTree tree, CVSTag tag, IPath remoteFolderPath, IPath parentPath) throws CVSException {
            ICVSResource child;
            if (remoteFolderPath.segmentCount() == 0) {
                return tree;
            }
            String name = remoteFolderPath.segment(0);
            IPath childPath = parentPath.append(name);
            if (tree.childExists(name)) {
                child = tree.getChild(name);
            } else {
                child = new RemoteFolderTree((RemoteFolder)tree, tree.getRepository(), childPath.toString(), tag);
                ((RemoteFolderTree)child).setChildren(new ICVSRemoteResource[0]);
                this.addChild(tree, (ICVSRemoteResource)child);
            }
            return this.getFolder((RemoteFolderTree)child, tag, remoteFolderPath.removeFirstSegments(1), childPath);
        }

        private void addChild(RemoteFolderTree tree, ICVSRemoteResource resource) {
            ICVSRemoteResource[] newChildren;
            ICVSRemoteResource[] children = tree.getChildren();
            if (children == null) {
                newChildren = new ICVSRemoteResource[]{resource};
            } else {
                newChildren = new ICVSRemoteResource[children.length + 1];
                System.arraycopy(children, 0, newChildren, 0, children.length);
                newChildren[children.length] = resource;
            }
            tree.setChildren(newChildren);
        }

        public void fileDiff(String remoteFilePath, String leftRevision, String rightRevision) {
            try {
                this.addFile(this.rightTree, this.right, new Path(null, remoteFilePath), rightRevision);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            try {
                this.addFile(this.leftTree, this.left, new Path(null, remoteFilePath), leftRevision);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }

        public void newFile(String remoteFilePath, String rightRevision) {
            try {
                this.addFile(this.rightTree, this.right, new Path(null, remoteFilePath), rightRevision);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }

        public void deletedFile(String remoteFilePath, String leftRevision) {
            try {
                this.addFile(this.leftTree, this.left, new Path(null, remoteFilePath), leftRevision);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }

        public void directory(String remoteFolderPath) {
            try {
                this.getFolder(this.leftTree, this.left, (IPath)new Path(null, remoteFolderPath), (IPath)Path.EMPTY);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
            try {
                this.getFolder(this.rightTree, this.right, (IPath)new Path(null, remoteFolderPath), (IPath)Path.EMPTY);
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }

        private String[] getOverlappingFilePaths() {
            String[] leftFiles = this.getFilePaths(this.leftTree);
            String[] rightFiles = this.getFilePaths(this.rightTree);
            HashSet<String> set = new HashSet<String>();
            int i = 0;
            while (i < rightFiles.length) {
                String rightFile = rightFiles[i];
                int j = 0;
                while (j < leftFiles.length) {
                    String leftFile = leftFiles[j];
                    if (leftFile.equals(rightFile)) {
                        set.add(leftFile);
                    }
                    ++j;
                }
                ++i;
            }
            return set.toArray(new String[set.size()]);
        }

        private void fetchFileContents(RemoteFolderTree tree, String[] overlappingFilePaths, IProgressMonitor monitor) throws CVSException {
            FileContentCachingService.fetchFileContents((RemoteFolderTree)tree, (String[])overlappingFilePaths, (IProgressMonitor)monitor);
        }

        private String[] getFilePaths(RemoteFolderTree tree) {
            ICVSRemoteResource[] children = tree.getChildren();
            ArrayList<String> result = new ArrayList<String>();
            int i = 0;
            while (i < children.length) {
                ICVSRemoteResource resource = children[i];
                if (resource.isContainer()) {
                    result.addAll(Arrays.asList(this.getFilePaths((RemoteFolderTree)resource)));
                } else {
                    result.add(resource.getRepositoryRelativePath());
                }
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }

        static /* synthetic */ RemoteFolderTree access$0(CompareTreeBuilder compareTreeBuilder) {
            return compareTreeBuilder.leftTree;
        }

        static /* synthetic */ RemoteFolderTree access$1(CompareTreeBuilder compareTreeBuilder) {
            return compareTreeBuilder.rightTree;
        }
    }
}

