/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ui.TeamCapabilityHelper;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.StreamMergerDelegate;
import org.eclipse.team.internal.ui.mapping.WorkspaceTeamStateProvider;
import org.eclipse.team.internal.ui.synchronize.SynchronizeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamStateProvider;
import org.eclipse.team.ui.synchronize.SubscriberTeamStateProvider;
import org.eclipse.team.ui.synchronize.TeamStateProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public class TeamUIPlugin
extends AbstractUIPlugin {
    private static TeamUIPlugin instance;
    public static final String ICON_PATH = "$nl$/icons/full/";
    public static final String ID = "org.eclipse.team.ui";
    public static final String PLUGIN_ID = "org.eclipse.team.ui";
    private static List propertyChangeListeners;
    private Hashtable imageDescriptors = new Hashtable(20);
    private WorkspaceTeamStateProvider provider;
    private Map decoratedStateProviders = new HashMap();

    static {
        propertyChangeListeners = new ArrayList(5);
    }

    public TeamUIPlugin() {
        instance = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getNamespace());
        if (bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = TeamUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static TeamUIPlugin getPlugin() {
        return instance;
    }

    protected void initializeDefaultPluginPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault("org.eclipse.team.ui.view_syncinfo_in_label", false);
        store.setDefault("org.eclipse.team.ui.show_author_in_compare_editor", false);
        store.setDefault("org.eclipse.team.ui.compress_folders", true);
        store.setDefault("org.eclipse.team.ui.default_layout", "org.eclipse.team.ui.compressed_layout");
        store.setDefault("org.eclipse.team.ui.syncview_default_perspective", "org.eclipse.team.ui.TeamSynchronizingPerspective");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_participant", "none");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_participant_sec_id", "none");
        store.setDefault("org.eclipse.team.ui.sychronizing_default_perspective_to_show", "prompt");
        store.setDefault("org.eclipse.team.ui.remove_from_view_without_prompt", false);
        store.setDefault("org.eclipse.team.ui.first_time", true);
        if (!store.isDefault("org.eclipse.team.ui.compress_folders") && !store.getBoolean("org.eclipse.team.ui.compress_folders")) {
            store.setToDefault("org.eclipse.team.ui.compress_folders");
            store.setDefault("org.eclipse.team.ui.default_layout", "org.eclipse.team.ui.tree_layout");
        }
    }

    public static void log(IStatus status) {
        TeamUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(CoreException e) {
        IStatus status = e.getStatus();
        TeamUIPlugin.log(status.getSeverity(), status.getMessage(), e);
    }

    public static void log(int severity, String message, Throwable e) {
        TeamUIPlugin.log((IStatus)new Status(severity, "org.eclipse.team.ui", 0, message, e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeImages(this);
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean("org.eclipse.team.ui.first_time")) {
            Job capabilityInitializer = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    TeamCapabilityHelper.getInstance();
                    TeamUIPlugin.this.getPreferenceStore().setValue("org.eclipse.team.ui.first_time", false);
                    return Status.OK_STATUS;
                }

                public boolean shouldRun() {
                    return PlatformUI.isWorkbenchRunning();
                }
            };
            capabilityInitializer.setSystem(true);
            capabilityInitializer.setPriority(50);
            capabilityInitializer.schedule(1000L);
        }
        StreamMergerDelegate.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            ((SynchronizeManager)TeamUI.getSynchronizeManager()).dispose();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            super.stop(context);
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        super.stop(context);
        if (this.provider != null) {
            this.provider.dispose();
        }
        Iterator iter = this.decoratedStateProviders.values().iterator();
        while (iter.hasNext()) {
            SubscriberTeamStateProvider sdsp = (SubscriberTeamStateProvider)iter.next();
            sdsp.dispose();
        }
        return;
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static void broadcastPropertyChange(PropertyChangeEvent event) {
        Iterator it = propertyChangeListeners.iterator();
        while (it.hasNext()) {
            IPropertyChangeListener listener = (IPropertyChangeListener)it.next();
            listener.propertyChange(event);
        }
    }

    private static void createImageDescriptor(TeamUIPlugin plugin, String id) {
        plugin.privateCreateImageDescriptor(id);
    }

    private void privateCreateImageDescriptor(String id) {
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)this.getImageUrl(id));
        this.imageDescriptors.put(id, desc);
    }

    public static ImageDescriptor getImageDescriptor(String id) {
        return TeamUIPlugin.getPlugin().privateGetImageDescriptor(id);
    }

    private ImageDescriptor privateGetImageDescriptor(String id) {
        if (!this.imageDescriptors.containsKey(id)) {
            TeamUIPlugin.createImageDescriptor(TeamUIPlugin.getPlugin(), id);
        }
        return (ImageDescriptor)this.imageDescriptors.get(id);
    }

    public static ImageDescriptor getImageDescriptorFromExtension(IExtension extension, String subdirectoryAndFilename) {
        URL fullPathString = Platform.find((Bundle)Platform.getBundle((String)extension.getNamespace()), (IPath)new Path(subdirectoryAndFilename));
        return ImageDescriptor.createFromURL((URL)fullPathString);
    }

    private void initializeImages(TeamUIPlugin plugin) {
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/dirty_ov.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/confchg_ov.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/version_controlled.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/checkedout_ov.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/error_co.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/warning_co.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "ovr/waiting_ovr.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/site_element.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/incom_synch.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/outgo_synch.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/conflict_synch.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/refresh.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/change_filter.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/ignorews_edit.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/collapseall.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/collapseall.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/incom_synch.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/outgo_synch.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/conflict_synch.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/refresh.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/ignorews_edit.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchup_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/release_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchuprelease_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/catchup_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/release_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "dlcl16/catchuprelease_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchup_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/release_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/catchuprelease_rls.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/import_projectset_wizban.png");
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/export_projectset_wizban.png");
        TeamUIPlugin.createImageDescriptor(plugin, "wizban/share_wizban.png");
        TeamUIPlugin.createImageDescriptor(plugin, "obj/compressed_folder_obj.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "eview16/synch_synch.gif");
        TeamUIPlugin.createImageDescriptor(plugin, "elcl16/hierarchicalLayout.gif");
    }

    private URL getImageUrl(String relative) {
        return Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.team.ui"), (IPath)new Path(ICON_PATH + relative));
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        if (image == null) {
            ImageDescriptor d = TeamUIPlugin.getImageDescriptor(key);
            image = d.createImage();
            this.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static void run(IRunnableWithProgress runnable) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Utils.handleError(TeamUIPlugin.getStandardDisplay().getActiveShell(), e, null, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public Preferences getInstancePreferences() {
        return new InstanceScope().getNode(this.getBundle().getSymbolicName());
    }

    public synchronized TeamStateProvider getDecoratedStateProvider(RepositoryProviderType rpt) {
        TeamStateProvider provider = (TeamStateProvider)this.decoratedStateProviders.get(rpt.getID());
        if (provider != null) {
            return provider;
        }
        Subscriber subscriber = rpt.getSubscriber();
        if (subscriber != null) {
            provider = new SubscriberTeamStateProvider(subscriber);
            this.decoratedStateProviders.put(rpt.getID(), provider);
            return provider;
        }
        return null;
    }

    public synchronized ITeamStateProvider getDecoratedStateProvider() {
        if (this.provider == null) {
            this.provider = new WorkspaceTeamStateProvider();
        }
        return this.provider;
    }
}

