/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ui.TeamUIMessages;

public class LocalHistoryTableProvider {
    private static final int COL_DATE = 0;
    private static final int COL_AUTHOR = 1;
    private static final int COL_COMMENT = 2;
    static /* synthetic */ Class class$0;

    protected IFileState adaptToFileState(Object element) {
        IFileState entry = null;
        if (element instanceof IFileState) {
            entry = (IFileState)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IFileState");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            entry = (IFileState)iAdaptable.getAdapter((Class)clazz);
        }
        return entry;
    }

    public TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableViewer viewer = new TableViewer(table);
        this.createColumns(table, layout, viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new LocalHistoryLabelProvider());
        return viewer;
    }

    private void createColumns(Table table, TableLayout layout, TableViewer viewer) {
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_RevisionTime);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Author);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_Comment);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    class LocalHistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        LocalHistoryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IFileState entry = LocalHistoryTableProvider.this.adaptToFileState(element);
            if (entry == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    String revision = DateFormat.getDateTimeInstance().format(new Date(entry.getModificationTime()));
                    return revision;
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return TeamUIMessages.LocalHistoryTableProvider_localRevision;
                }
            }
            return "";
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            IFileState entry = LocalHistoryTableProvider.this.adaptToFileState(element);
            if (entry == null) {
                return null;
            }
            return null;
        }
    }
}

