/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.registry.TeamContentProviderDescriptor;
import org.eclipse.team.internal.ui.registry.TeamContentProviderManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.mapping.ITeamContentProviderDescriptor;
import org.eclipse.team.ui.mapping.ITeamContentProviderManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ModelEnablementPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Set previosulyEnabled = new HashSet();
    private CheckboxTableViewer tableViewer;

    public ModelEnablementPreferencePage() {
        this.setTitle(TeamUIMessages.ModelEnablementPreferencePage_0);
        this.setPreferenceStore(TeamUIPlugin.getPlugin().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label l = SWTUtils.createLabel(composite, TeamUIMessages.ModelEnablementPreferencePage_1);
        l.setLayoutData((Object)new GridData(768));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object element) {
                if (element instanceof ITeamContentProviderManager) {
                    ITeamContentProviderManager manager = (ITeamContentProviderManager)element;
                    return manager.getDescriptors();
                }
                return new Object[0];
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            Map images = new HashMap();

            public String getText(Object element) {
                if (element instanceof ITeamContentProviderDescriptor) {
                    ITeamContentProviderDescriptor desc = (ITeamContentProviderDescriptor)element;
                    return this.getTextFor(desc.getModelProviderId());
                }
                return super.getText(element);
            }

            private String getTextFor(String modelProviderId) {
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)modelProviderId);
                if (desc != null) {
                    return desc.getLabel();
                }
                return modelProviderId;
            }

            public Image getImage(Object element) {
                if (element instanceof ITeamContentProviderDescriptor) {
                    ImageDescriptor idesc;
                    ITeamContentProviderDescriptor desc = (ITeamContentProviderDescriptor)element;
                    Image image = (Image)this.images.get(desc);
                    if (image == null && (idesc = desc.getImageDescriptor()) != null && (image = idesc.createImage()) != null) {
                        this.images.put(desc, image);
                    }
                    return image;
                }
                return super.getImage(element);
            }

            public void dispose() {
                Iterator iter = this.images.values().iterator();
                while (iter.hasNext()) {
                    Image image = (Image)iter.next();
                    image.dispose();
                }
                super.dispose();
            }
        });
        this.tableViewer.setInput((Object)TeamUI.getTeamContentProviderManager());
        this.updateChecks();
        this.applyDialogFont(composite);
        return composite;
    }

    private void updateChecks() {
        ITeamContentProviderDescriptor[] descriptors = TeamUI.getTeamContentProviderManager().getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            ITeamContentProviderDescriptor descriptor = descriptors[i];
            if (descriptor.isEnabled()) {
                this.previosulyEnabled.add(descriptor);
            }
            ++i;
        }
        this.tableViewer.setCheckedElements(this.previosulyEnabled.toArray());
    }

    public boolean performOk() {
        boolean changed = false;
        Object[] checked = this.tableViewer.getCheckedElements();
        HashSet<Object> nowEnabled = new HashSet<Object>();
        nowEnabled.addAll(Arrays.asList(checked));
        ITeamContentProviderDescriptor[] descriptors = TeamUI.getTeamContentProviderManager().getDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            ITeamContentProviderDescriptor descriptor = descriptors[i];
            boolean enable = false;
            int j = 0;
            while (j < checked.length) {
                ITeamContentProviderDescriptor checkedDesc = (ITeamContentProviderDescriptor)checked[j];
                if (checkedDesc.getModelProviderId().equals(descriptor.getModelProviderId())) {
                    enable = true;
                    break;
                }
                ++j;
            }
            if (descriptor.isEnabled() != enable) {
                ((TeamContentProviderDescriptor)descriptor).setEnabled(enable);
                changed = true;
            }
            ++i;
        }
        if (changed) {
            ((TeamContentProviderManager)TeamUI.getTeamContentProviderManager()).enablementChanged(this.previosulyEnabled.toArray(new ITeamContentProviderDescriptor[this.previosulyEnabled.size()]), nowEnabled.toArray(new ITeamContentProviderDescriptor[nowEnabled.size()]));
            this.previosulyEnabled = nowEnabled;
        }
        return true;
    }

    protected void performDefaults() {
        this.tableViewer.setCheckedElements((Object[])TeamUI.getTeamContentProviderManager().getDescriptors());
    }

    public void init(IWorkbench workbench) {
    }
}

