/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.ide.IDE;

public abstract class ResourceMergeActionHandler
extends MergeActionHandler {
    public ResourceMergeActionHandler(ISynchronizePageConfiguration configuration) {
        super(configuration);
    }

    public final boolean saveDirtyEditors() {
        return !this.needsToSaveDirtyEditors() || this.saveAllEditors(this.getTargetResources(), this.confirmSaveOfDirtyEditor());
    }

    private IResource[] getTargetResources() {
        IStructuredSelection selection = this.getStructuredSelection();
        Object[] objects = selection.toArray();
        HashSet<IResource> roots = new HashSet<IResource>();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            ResourceMapping mapping = Utils.getResourceMapping(object);
            if (mapping != null) {
                try {
                    ResourceTraversal[] traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                    int j = 0;
                    while (j < traversals.length) {
                        ResourceTraversal traversal = traversals[j];
                        IResource[] resources = traversal.getResources();
                        int k = 0;
                        while (k < resources.length) {
                            IResource resource = resources[k];
                            roots.add(resource);
                            ++k;
                        }
                        ++j;
                    }
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    public final boolean saveAllEditors(IResource[] resources, boolean confirm) {
        return IDE.saveAllEditors((IResource[])resources, (boolean)confirm);
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    protected boolean confirmSaveOfDirtyEditor() {
        return true;
    }
}

