/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.FileStateTypedElement;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableCompareModel;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class ResourceSaveableCompareModel
extends SaveableCompareModel
implements IPropertyChangeListener {
    ICompareInput input;
    ISynchronizeParticipant participant;
    private final CompareEditorInput editorInput;
    private boolean isSaving;

    public ResourceSaveableCompareModel(ICompareInput input, ISynchronizeParticipant participant, ModelCompareEditorInput editorInput) {
        this.input = input;
        this.participant = participant;
        this.editorInput = editorInput;
        this.initializeContentChangeListeners();
    }

    private void initializeContentChangeListeners() {
        ITypedElement te = this.input.getLeft();
        if (te instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)te).addContentChangeListener(new IContentChangeListener(){

                public void contentChanged(IContentChangeNotifier source) {
                    try {
                        if (!ResourceSaveableCompareModel.this.isSaving) {
                            ResourceSaveableCompareModel.this.performSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (CoreException e) {
                        TeamUIPlugin.log(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSave(IProgressMonitor monitor) throws CoreException {
        try {
            this.isSaving = true;
            monitor.beginTask(null, 100);
            this.editorInput.saveChanges(Policy.subMonitorFor(monitor, 40));
            ITypedElement left = this.input.getLeft();
            if (left instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)left).commit(Policy.subMonitorFor(monitor, 60));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this.input instanceof ResourceDiffCompareInput) {
                ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)this.input;
                rdci.fireChange();
            }
            this.setDirty(false);
            this.isSaving = false;
            monitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        if (this.input instanceof ResourceDiffCompareInput) {
            ResourceDiffCompareInput rdci = (ResourceDiffCompareInput)this.input;
            rdci.fireChange();
        }
        this.setDirty(false);
        this.isSaving = false;
        monitor.done();
    }

    public boolean isDirty() {
        return this.editorInput.isSaveNeeded();
    }

    protected void setDirty(boolean dirty) {
        this.editorInput.setDirty(dirty);
    }

    protected void performRevert(IProgressMonitor monitor) {
        ITypedElement left = this.input.getLeft();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).discardBuffer();
        }
    }

    public String getName() {
        return this.input.getName();
    }

    public String getToolTipText() {
        String fullPath;
        if (this.input instanceof ISynchronizationCompareInput) {
            ISynchronizationCompareInput mci = (ISynchronizationCompareInput)this.input;
            fullPath = mci.getFullPath();
        } else {
            fullPath = this.getName();
        }
        return NLS.bind((String)TeamUIMessages.SyncInfoCompareInput_tooltip, (Object[])new String[]{Utils.shortenText(30, this.participant.getName()), fullPath});
    }

    public ImageDescriptor getImageDescriptor() {
        Image image = this.input.getImage();
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.gif");
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getProperty();
        if ("DIRTY_STATE".equals(propertyName)) {
            boolean changed = false;
            Object newValue = e.getNewValue();
            if (newValue instanceof Boolean) {
                changed = (Boolean)newValue;
            }
            this.setDirty(changed);
        }
    }

    public static class ResourceDiffCompareInput
    extends DiffNode
    implements ISynchronizationCompareInput,
    IAdaptable {
        private final IDiff node;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public ResourceDiffCompareInput(IDiff node) {
            super(ResourceDiffCompareInput.getCompareKind(node), ResourceDiffCompareInput.getAncestor(node), ResourceDiffCompareInput.getLeftContributor(node), ResourceDiffCompareInput.getRightContributor(node));
            this.node = node;
        }

        public void fireChange() {
            super.fireChange();
        }

        private static int getCompareKind(IDiff node) {
            int kind = 0;
            switch (node.getKind()) {
                case 4: {
                    kind = 3;
                    break;
                }
                case 1: {
                    kind = 1;
                    break;
                }
                case 2: {
                    kind = 2;
                }
            }
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                switch (twd.getDirection()) {
                    case 512: {
                        kind |= 8;
                        break;
                    }
                    case 256: {
                        kind |= 4;
                        break;
                    }
                    case 768: {
                        kind |= 0xC;
                    }
                }
            }
            return kind;
        }

        private static ITypedElement getRightContributor(IDiff node) {
            if (node instanceof IResourceDiff) {
                IResourceDiff rd = (IResourceDiff)node;
                return ResourceDiffCompareInput.asTypedElement(rd.getAfterState());
            }
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
                if (diff != null) {
                    return ResourceDiffCompareInput.getRightContributor((IDiff)diff);
                }
                diff = (IResourceDiff)twd.getLocalChange();
                return ResourceDiffCompareInput.asTypedElement(diff.getBeforeState());
            }
            return null;
        }

        private static ITypedElement getLeftContributor(IDiff node) {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)node);
            return new LocalResourceTypedElement(resource, resource, node){
                private final /* synthetic */ IResource val$resource;
                private final /* synthetic */ IDiff val$node;
                {
                    this.val$resource = iResource;
                    this.val$node = iDiff;
                }

                public boolean isEditable() {
                    if (!this.val$resource.exists() && this.isOutgoingDeletion(this.val$node)) {
                        return false;
                    }
                    return super.isEditable();
                }

                private boolean isOutgoingDeletion(IDiff node) {
                    if (node instanceof IThreeWayDiff) {
                        IThreeWayDiff twd = (IThreeWayDiff)node;
                        return twd.getKind() == 2 && twd.getDirection() == 256;
                    }
                    return false;
                }
            };
        }

        private static ITypedElement getAncestor(IDiff node) {
            if (node instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)node;
                IResourceDiff diff = (IResourceDiff)twd.getLocalChange();
                if (diff == null) {
                    diff = (IResourceDiff)twd.getRemoteChange();
                }
                return ResourceDiffCompareInput.asTypedElement(diff.getBeforeState());
            }
            return null;
        }

        private static ITypedElement asTypedElement(IFileRevision state) {
            if (state == null) {
                return null;
            }
            return new FileStateTypedElement(state);
        }

        public void prepareInput(CompareConfiguration configuration, IProgressMonitor monitor) throws CoreException {
            ITypedElement right;
            Utils.updateLabels(this.node, configuration, monitor);
            ITypedElement ancestor = this.getAncestor();
            if (ancestor instanceof FileStateTypedElement) {
                FileStateTypedElement fste = (FileStateTypedElement)ancestor;
                fste.cacheContents(monitor);
            }
            if ((right = this.getRight()) instanceof FileStateTypedElement) {
                FileStateTypedElement fste = (FileStateTypedElement)right;
                fste.cacheContents(monitor);
            }
        }

        public ISaveableCompareModel getSaveableModel() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            block15: {
                block14: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapter == clazz) break block14;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapter != clazz2) break block15;
                }
                if (this.node instanceof IResourceDiff) {
                    IResourceDiff rd = (IResourceDiff)this.node;
                    return (IFile)rd.getResource();
                }
                if (this.node instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)this.node;
                    IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
                    if (diff != null) {
                        return (IFile)diff.getResource();
                    }
                    diff = (IResourceDiff)twd.getLocalChange();
                    return (IFile)diff.getResource();
                }
            }
            return null;
        }

        public String getFullPath() {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)this.node);
            if (resource != null) {
                return resource.getFullPath().toString();
            }
            return this.getName();
        }

        public boolean isCompareInputFor(Object object) {
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)this.node);
            IResource other = Utils.getResource(object);
            if (resource != null && other != null) {
                return resource.equals((Object)other);
            }
            return false;
        }
    }
}

