/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshEvent;
import org.eclipse.team.internal.ui.synchronize.WorkbenchAction;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.UIJob;

public abstract class RefreshParticipantJob
extends Job {
    private static final Object FAMILY_ID = new Object();
    private boolean reschedule = false;
    private boolean restartOnCancel = true;
    private static long scheduleDelay;
    private ISynchronizeParticipant participant;
    private String taskName;
    private static List listeners;
    private static final int STARTED = 1;
    private static final int DONE = 2;
    private static final ILock lock;
    private static final IStatus POSTPONED;

    static {
        listeners = new ArrayList(1);
        lock = Platform.getJobManager().newLock();
        POSTPONED = new Status(8, "org.eclipse.team.ui", 0, "Scheduled refresh postponed due to conflicting operation", null);
    }

    public RefreshParticipantJob(ISynchronizeParticipant participant, String jobName, String taskName, IRefreshSubscriberListener listener) {
        super(taskName);
        Assert.isNotNull((Object)participant);
        this.participant = participant;
        this.taskName = jobName;
        this.setPriority(50);
        this.setRefreshInterval(3600L);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (RefreshParticipantJob.this.shouldReschedule()) {
                    IStatus result = event.getResult();
                    if (result.getSeverity() == 8 && !RefreshParticipantJob.this.restartOnCancel) {
                        return;
                    }
                    long delay = scheduleDelay;
                    if (result == POSTPONED) {
                        delay = 5000L;
                    }
                    RefreshParticipantJob.this.schedule(delay);
                    RefreshParticipantJob.this.restartOnCancel = true;
                }
            }
        });
        if (listener != null) {
            this.initialize(listener);
        }
    }

    public boolean belongsTo(Object family) {
        if (family instanceof SubscriberParticipant) {
            return family == this.participant;
        }
        return family == RefreshParticipantJob.getFamily() || family == ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION;
    }

    public static Object getFamily() {
        return FAMILY_ID;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        block24: {
            block22: {
                block23: {
                    if (this.shouldReschedule()) {
                        if (this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_AUTO_BUILD) != false) return RefreshParticipantJob.POSTPONED;
                        if (this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_MANUAL_BUILD)) {
                            return RefreshParticipantJob.POSTPONED;
                        }
                    }
                    acquired = false;
                    try {
                        while (true) {
                            if (acquired) {
                                changeDescription = this.createChangeDescription();
                            }
                            try {
                                acquired = RefreshParticipantJob.lock.acquire(1000L);
                            }
                            catch (InterruptedException v0) {
                                acquired = false;
                            }
                            Policy.checkCanceled(monitor);
                        }
                        event = new RefreshEvent(this.reschedule != false ? 1 : 2, this.participant, changeDescription);
                        status = null;
                        wrappedMonitor = null;
                        try {
                            event.setStartTime(System.currentTimeMillis());
                            if (monitor.isCanceled()) {
                                var12_7 = Status.CANCEL_STATUS;
                                var10_8 = null;
                                event.setStopTime(System.currentTimeMillis());
                            }
                            ** GOTO lbl-1000
                        }
                        catch (OperationCanceledException v1) {
                            block26: {
                                block25: {
                                    if (!monitor.isCanceled()) break block25;
                                    status = Status.CANCEL_STATUS;
                                    ** GOTO lbl64
                                }
                                if (wrappedMonitor == null || !wrappedMonitor.wasBlocking()) break block26;
                                status = RefreshParticipantJob.POSTPONED;
                                ** GOTO lbl64
                            }
                            status = Status.CANCEL_STATUS;
                        }
                        catch (CoreException e) {
                            status = e.getStatus();
                            if (!this.isUser() && (prop = this.getProperty(IProgressConstants.ACTION_PROPERTY)) instanceof GotoActionWrapper) {
                                wrapper = (GotoActionWrapper)prop;
                                wrapper.setStatus(e.getStatus());
                                status = new Status(0, "org.eclipse.team.ui", 0, e.getStatus().getMessage(), (Throwable)e);
                            }
                            if (!this.isUser() && status.getSeverity() == 4) {
                                this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                            }
                            ** GOTO lbl64
                        }
                        catch (Throwable var11_17) {
                            var10_9 = null;
                            event.setStopTime(System.currentTimeMillis());
                            throw var11_17;
                        }
                        var13_11 = null;
                        if (!acquired) break block22;
                        break block23;
lbl-1000:
                        // 1 sources

                        {
                            this.notifyListeners(1, event);
                            monitor.setTaskName(this.getName());
                            wrappedMonitor = new NonblockingProgressMonitor(monitor, this);
                            this.doRefresh(changeDescription, (IProgressMonitor)wrappedMonitor);
                            this.setProperty(IProgressConstants.KEEPONE_PROPERTY, this.isJobModal() == false);
                        }
                        {
lbl64:
                            // 6 sources

                            var10_10 = null;
                            event.setStopTime(System.currentTimeMillis());
                            if (status == null) {
                                status = this.calculateStatus(event);
                            }
                            event.setStatus(status);
                            this.notifyListeners(2, event);
                            var15_18 = event.getStatus();
                        }
                        break block24;
                    }
                    catch (Throwable var14_19) {
                        var13_13 = null;
                        if (acquired) {
                            RefreshParticipantJob.lock.release();
                        }
                        monitor.done();
                        throw var14_19;
                    }
                }
                RefreshParticipantJob.lock.release();
            }
            monitor.done();
            return var12_7;
        }
        var13_12 = null;
        if (acquired) {
            RefreshParticipantJob.lock.release();
        }
        monitor.done();
        return var15_18;
    }

    protected abstract void doRefresh(IChangeDescription var1, IProgressMonitor var2) throws CoreException;

    protected abstract int getChangeCount();

    private boolean isJobInFamilyRunning(Object family) {
        Job[] jobs = Platform.getJobManager().find(family);
        if (jobs != null && jobs.length > 0) {
            int i = 0;
            while (i < jobs.length) {
                Job job = jobs[i];
                if (job.getState() != 0) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private IStatus calculateStatus(IRefreshEvent event) {
        StringBuffer text = new StringBuffer();
        int code = 0;
        int changeCount = event.getChangeDescription().getChangeCount();
        int numChanges = this.getChangeCount();
        if (numChanges > 0) {
            code = 1;
            if (changeCount > 0) {
                String numNewChanges = Integer.toString(changeCount);
                if (changeCount == 1) {
                    text.append(NLS.bind((String)TeamUIMessages.RefreshCompleteDialog_newChangesSingular, (Object[])new Object[]{this.getName(), numNewChanges}));
                } else {
                    text.append(NLS.bind((String)TeamUIMessages.RefreshCompleteDialog_newChangesPlural, (Object[])new Object[]{this.getName(), numNewChanges}));
                }
            } else if (numChanges == 1) {
                text.append(NLS.bind((String)TeamUIMessages.RefreshCompleteDialog_changesSingular, (Object[])new Object[]{this.getName(), new Integer(numChanges)}));
            } else {
                text.append(NLS.bind((String)TeamUIMessages.RefreshCompleteDialog_changesPlural, (Object[])new Object[]{this.getName(), new Integer(numChanges)}));
            }
        } else {
            code = 2;
            text.append(NLS.bind((String)TeamUIMessages.RefreshCompleteDialog_6, (Object[])new String[]{this.getName()}));
        }
        return new Status(0, "org.eclipse.team.ui", code, text.toString(), null);
    }

    private void initialize(final IRefreshSubscriberListener listener) {
        final GotoActionWrapper actionWrapper = new GotoActionWrapper();
        IProgressMonitor group = Platform.getJobManager().createProgressGroup();
        group.beginTask(this.taskName, 100);
        this.setProgressGroup(group, 80);
        this.handleProgressGroupSet(group, 20);
        this.setProperty(IProgressConstants.ICON_PROPERTY, this.participant.getImageDescriptor());
        this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)actionWrapper);
        this.setProperty(IProgressConstants.KEEPONE_PROPERTY, !this.isJobModal());
        IRefreshSubscriberListener autoListener = new IRefreshSubscriberListener(){

            public void refreshStarted(IRefreshEvent event) {
                if (listener != null) {
                    listener.refreshStarted(event);
                }
            }

            public ActionFactory.IWorkbenchAction refreshDone(IRefreshEvent event) {
                if (listener != null) {
                    boolean isModal = RefreshParticipantJob.this.isJobModal();
                    ActionFactory.IWorkbenchAction runnable = listener.refreshDone(event);
                    if (runnable != null) {
                        if (isModal) {
                            if (runnable != null) {
                                UIJob update = new UIJob(this, "", runnable){
                                    final /* synthetic */ 3 this$1;
                                    private final /* synthetic */ ActionFactory.IWorkbenchAction val$runnable;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$runnable = iWorkbenchAction;
                                    }

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        this.val$runnable.run();
                                        return Status.OK_STATUS;
                                    }
                                };
                                update.setSystem(true);
                                update.schedule();
                            }
                        } else {
                            actionWrapper.setGotoAction(runnable);
                        }
                    }
                    RefreshParticipantJob.removeRefreshListener(this);
                }
                return null;
            }
        };
        if (listener != null) {
            RefreshParticipantJob.addRefreshListener(autoListener);
        }
    }

    protected abstract void handleProgressGroupSet(IProgressMonitor var1, int var2);

    protected abstract IChangeDescription createChangeDescription();

    public long getScheduleDelay() {
        return scheduleDelay;
    }

    protected void start() {
        if (this.getState() == 0 && this.shouldReschedule()) {
            this.schedule(this.getScheduleDelay());
        }
    }

    public void setRefreshInterval(long seconds) {
        boolean restart = false;
        if (this.getState() == 1) {
            restart = true;
            this.cancel();
        }
        scheduleDelay = seconds * 1000L;
        if (restart) {
            this.start();
        }
    }

    public void setRestartOnCancel(boolean restartOnCancel) {
        this.restartOnCancel = restartOnCancel;
    }

    public void setReschedule(boolean reschedule) {
        this.reschedule = reschedule;
    }

    public boolean shouldReschedule() {
        return this.reschedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRefreshListener(IRefreshSubscriberListener listener) {
        List list = listeners;
        synchronized (list) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRefreshListener(IRefreshSubscriberListener listener) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(final int state, final IRefreshEvent event) {
        IRefreshSubscriberListener[] listenerArray;
        List list = listeners;
        synchronized (list) {
            listenerArray = listeners.toArray(new IRefreshSubscriberListener[listeners.size()]);
        }
        int i = 0;
        while (i < listenerArray.length) {
            IRefreshSubscriberListener listener = listenerArray[i];
            Notification notification = new Notification(){

                protected void notify(IRefreshSubscriberListener listener) {
                    switch (state) {
                        case 1: {
                            listener.refreshStarted(event);
                            break;
                        }
                        case 2: {
                            listener.refreshDone(event);
                            break;
                        }
                    }
                }
            };
            notification.run(listener);
            ++i;
        }
    }

    private boolean isJobModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    public ISynchronizeParticipant getParticipant() {
        return this.participant;
    }

    private final class GotoActionWrapper
    extends WorkbenchAction {
        private ActionFactory.IWorkbenchAction gotoAction;
        private IStatus status;

        private GotoActionWrapper() {
        }

        public void run() {
            if (this.status != null && !this.status.isOK()) {
                ErrorDialog.openError((Shell)Utils.getShell(null), null, (String)TeamUIMessages.RefreshSubscriberJob_3, (IStatus)this.status);
            } else if (this.gotoAction != null) {
                this.gotoAction.run();
            }
        }

        public boolean isEnabled() {
            if (this.gotoAction != null) {
                return this.gotoAction.isEnabled();
            }
            return true;
        }

        public String getText() {
            if (this.gotoAction != null) {
                return this.gotoAction.getText();
            }
            return null;
        }

        public String getToolTipText() {
            if (this.status != null && !this.status.isOK()) {
                return this.status.getMessage();
            }
            if (this.gotoAction != null) {
                return this.gotoAction.getToolTipText();
            }
            return Utils.shortenText(100, RefreshParticipantJob.this.getName());
        }

        public void dispose() {
            super.dispose();
            if (this.gotoAction != null) {
                this.gotoAction.dispose();
            }
        }

        public void setGotoAction(ActionFactory.IWorkbenchAction gotoAction) {
            this.gotoAction = gotoAction;
            this.setEnabled(this.isEnabled());
            this.setToolTipText(this.getToolTipText());
            gotoAction.addPropertyChangeListener(new IPropertyChangeListener(this){
                final /* synthetic */ GotoActionWrapper this$1;
                {
                    this.this$1 = gotoActionWrapper;
                }

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("enabled")) {
                        Boolean bool = (Boolean)event.getNewValue();
                        this.this$1.setEnabled(bool);
                    }
                }
            });
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }

    private abstract class Notification
    implements ISafeRunnable {
        private IRefreshSubscriberListener listener;

        private Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(IRefreshSubscriberListener listener) {
            this.listener = listener;
            SafeRunner.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(IRefreshSubscriberListener var1);
    }

    private class NonblockingProgressMonitor
    extends ProgressMonitorWrapper {
        private final RefreshParticipantJob job;
        private long blockTime;
        private static final int THRESHOLD = 250;
        private boolean wasBlocking = false;

        protected NonblockingProgressMonitor(IProgressMonitor monitor, RefreshParticipantJob job) {
            super(monitor);
            this.job = job;
        }

        public boolean isCanceled() {
            if (super.isCanceled()) {
                return true;
            }
            if (this.job.shouldReschedule() && this.job.isBlocking()) {
                if (this.blockTime == 0L) {
                    this.blockTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.blockTime > 250L) {
                    this.wasBlocking = true;
                    return true;
                }
            } else {
                this.blockTime = 0L;
            }
            this.wasBlocking = false;
            return false;
        }

        public boolean wasBlocking() {
            return this.wasBlocking;
        }
    }

    public static interface IChangeDescription {
        public int getChangeCount();
    }
}

