/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.ui.mapping.ISaveableCompareModel;
import org.eclipse.ui.IPropertyListener;

public abstract class SaveableCompareModel
implements ISaveableCompareModel {
    private boolean dirty;
    private ListenerList listeners = new ListenerList(1);

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) throws CoreException {
        if (!this.isDirty()) {
            return;
        }
        this.performSave(monitor);
        this.setDirty(false);
    }

    public void doRevert(IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return;
        }
        this.performRevert(monitor);
        this.setDirty(false);
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void setDirty(boolean dirty) {
        if (this.dirty == dirty) {
            return;
        }
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    protected void firePropertyChange(final int property) {
        Object[] allListeners = this.listeners.getListeners();
        int i = 0;
        while (i < allListeners.length) {
            final Object object = allListeners[i];
            Platform.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPropertyListener)object).propertyChanged((Object)SaveableCompareModel.this, property);
                }

                public void handleException(Throwable exception) {
                }
            });
            ++i;
        }
    }

    protected abstract void performSave(IProgressMonitor var1) throws CoreException;

    protected abstract void performRevert(IProgressMonitor var1);

    protected void handleException(CoreException exception) {
    }
}

