/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class PluginModelManager
implements IAdaptable {
    private static final String OSGI_RUNTIME = "org.eclipse.osgi";
    private IModelProviderListener fProviderListener = new IModelProviderListener(){

        public void modelsChanged(IModelProviderEvent e) {
            PluginModelManager.this.handleModelsChanged(e);
        }
    };
    private ExternalModelManager fExternalManager;
    private WorkspaceModelManager fWorkspaceManager;
    private SearchablePluginsManager fSearchablePluginsManager;
    private ArrayList fListeners;
    private Map fEntries;
    private PDEState fState;

    public PluginModelManager(WorkspaceModelManager wm, ExternalModelManager em) {
        this.fWorkspaceManager = wm;
        this.fExternalManager = em;
        this.fExternalManager.addModelProviderListener(this.fProviderListener);
        this.fWorkspaceManager.addModelProviderListener(this.fProviderListener);
        this.fListeners = new ArrayList();
        this.fSearchablePluginsManager = new SearchablePluginsManager(this);
    }

    public String getTargetVersion() {
        ModelEntry entry = this.findEntry(OSGI_RUNTIME);
        if (entry == null) {
            return "3.2";
        }
        IPluginModelBase model = entry.getActiveModel();
        String version = model.getPluginBase().getVersion();
        if (PluginVersionIdentifier.validateVersion((String)version).getSeverity() == 0) {
            PluginVersionIdentifier id = new PluginVersionIdentifier(version);
            int major = id.getMajorComponent();
            int minor = id.getMinorComponent();
            if (major == 3 && minor == 0) {
                return "3.0";
            }
            if (major == 3 && minor == 1) {
                return "3.1";
            }
        }
        return "3.2";
    }

    public Object getAdapter(Class key) {
        return null;
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.fListeners.contains(listener)) {
            this.fListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.getEntryTable().isEmpty();
    }

    public ModelEntry[] getEntries() {
        Collection values = this.getEntryTable().values();
        return values.toArray(new ModelEntry[values.size()]);
    }

    public IPluginModelBase[] getPlugins() {
        Collection values = this.getEntryTable().values();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            IPluginModelBase model = entry.getActiveModel();
            if (model == null || !model.isEnabled()) continue;
            result.add(model);
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModelBase[] getAllPlugins() {
        Collection values = this.getEntryTable().values();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            result.add(entry.getActiveModel());
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModel[] getPluginsOnly() {
        Collection values = this.getEntryTable().values();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            IPluginModelBase model = entry.getActiveModel();
            if (!model.isEnabled() || !(model instanceof IPluginModel)) continue;
            result.add(model);
        }
        return result.toArray(new IPluginModel[result.size()]);
    }

    public IFragmentModel[] getFragments() {
        Collection values = this.getEntryTable().values();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            IPluginModelBase model = entry.getActiveModel();
            if (!(model instanceof IFragmentModel)) continue;
            result.add(model);
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    public ModelEntry findEntry(IProject project) {
        this.initializeTable();
        IPluginModelBase model = this.fWorkspaceManager.getWorkspacePluginModel(project);
        return model == null ? null : this.findEntry(model.getPluginBase().getId());
    }

    public IPluginModelBase findModel(IProject project) {
        ModelEntry entry = this.findEntry(project);
        return entry != null ? entry.getActiveModel() : null;
    }

    public IPluginModelBase findModel(BundleDescription desc) {
        return desc == null ? null : this.findModel(desc.getSymbolicName());
    }

    public ModelEntry findEntry(String id) {
        if (id == null) {
            return null;
        }
        if (id.equalsIgnoreCase("system.bundle")) {
            return (ModelEntry)((Object)this.getEntryTable().get(OSGI_RUNTIME));
        }
        return (ModelEntry)((Object)this.getEntryTable().get(id));
    }

    public IPluginModelBase findModel(String id) {
        ModelEntry entry = this.findEntry(id);
        return entry == null ? null : entry.getActiveModel();
    }

    public IPluginModelBase findPlugin(String id, String version, int match) {
        return this.findModel(id);
    }

    public IPluginModel findPluginModel(String id) {
        IPluginModelBase model = this.findModel(id);
        return model != null && model instanceof IPluginModel ? (IPluginModel)model : null;
    }

    public IFragmentModel findFragmentModel(String id) {
        IPluginModelBase model = this.findModel(id);
        return model != null && model instanceof IFragmentModel ? (IFragmentModel)model : null;
    }

    private void handleModelsChanged(IModelProviderEvent e) {
        IPluginModelBase model;
        IPluginBase plugin;
        ModelEntry entry;
        int i;
        PluginModelDelta delta = new PluginModelDelta();
        boolean javaSearchAffected = false;
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            i = 0;
            while (i < removed.length) {
                if (removed[i] instanceof IPluginModelBase && (entry = this.updateTable((plugin = (model = (IPluginModelBase)removed[i]).getPluginBase()).getId(), model, false, delta)) != null && (model.getUnderlyingResource() != null || entry.isInJavaSearch())) {
                    javaSearchAffected = true;
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            i = 0;
            while (i < added.length) {
                if (added[i] instanceof IPluginModelBase && (entry = this.updateTable((plugin = (model = (IPluginModelBase)added[i]).getPluginBase()).getId(), model, true, delta)) != null && (model.getUnderlyingResource() != null || entry.isInJavaSearch())) {
                    javaSearchAffected = true;
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            i = 0;
            while (i < changed.length) {
                if (changed[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)changed[i];
                    BundleDescription desc = model.getBundleDescription();
                    String oldID = desc == null ? null : desc.getSymbolicName();
                    String newID = model.getPluginBase().getId();
                    if (oldID != null || newID != null) {
                        ModelEntry entry2 = null;
                        if (oldID == null && newID != null) {
                            entry2 = this.updateTable(newID, model, true, delta);
                        } else if (oldID != null && newID == null) {
                            entry2 = this.updateTable(oldID, model, false, delta);
                            model.setBundleDescription(null);
                        } else if (oldID.equals(newID)) {
                            this.fState.addBundle(model, true);
                            entry2 = (ModelEntry)((Object)this.getEntryTable().get(oldID));
                            delta.addEntry(entry2, 4);
                        } else {
                            entry2 = this.updateTable(oldID, model, false, delta);
                            entry2 = this.updateTable(newID, model, true, delta);
                        }
                        if (entry2 != null && (model.getUnderlyingResource() != null || entry2.isInJavaSearch())) {
                            javaSearchAffected = true;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.fState != null) {
            StateDelta stateDelta = (e.getEventTypes() & 8) != 0 ? null : this.fState.resolveState(true);
            this.updateAffectedEntries(stateDelta);
        }
        if (javaSearchAffected) {
            this.fSearchablePluginsManager.updateClasspathContainer();
        }
        this.fireDelta(delta);
    }

    private ModelEntry updateTable(String id, IPluginModelBase model, boolean added, PluginModelDelta delta) {
        if (id == null) {
            return null;
        }
        boolean workspace = model.getUnderlyingResource() != null;
        Map entries = this.getEntryTable();
        ModelEntry entry = (ModelEntry)((Object)entries.get(id));
        int kind = 0;
        if (added && entry == null) {
            entry = new ModelEntry(this, id);
            entries.put(id, entry);
            kind = 1;
        }
        if (added) {
            if (workspace) {
                entry.setWorkspaceModel(model);
            } else {
                entry.setExternalModel(model);
            }
        } else if (entry != null) {
            if (workspace) {
                entry.setWorkspaceModel(null);
            } else {
                entry.setExternalModel(null);
            }
            if (entry.isEmpty()) {
                entries.remove(id);
                kind = 2;
            }
        }
        if (workspace) {
            if (added) {
                this.addWorkspaceBundleToState(model);
            } else {
                this.removeWorkspaceBundleFromState(model, id);
            }
        }
        if (kind == 0) {
            kind = 4;
        }
        delta.addEntry(entry, kind);
        return entry;
    }

    private void updateAffectedEntries(StateDelta delta) {
        int i;
        HashMap<IJavaProject, RequiredPluginsClasspathContainer> map = new HashMap<IJavaProject, RequiredPluginsClasspathContainer>();
        if (delta == null) {
            ModelEntry[] entries = this.getEntries();
            i = 0;
            while (i < entries.length) {
                ModelEntry entry = entries[i];
                try {
                    IProject project;
                    IJavaProject jProject;
                    if (entry != null && entry.shouldUpdateClasspathContainer(true) && !map.containsKey(jProject = JavaCore.create((IProject)(project = entry.getWorkspaceModel().getUnderlyingResource().getProject())))) {
                        map.put(jProject, entry.getClasspathContainer(true));
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        } else {
            BundleDelta[] deltas = delta.getChanges();
            i = 0;
            while (i < deltas.length) {
                try {
                    IProject project;
                    IJavaProject jProject;
                    String id = deltas[i].getBundle().getSymbolicName();
                    ModelEntry entry = this.findEntry(id);
                    if (entry != null && entry.shouldUpdateClasspathContainer(true) && !map.containsKey(jProject = JavaCore.create((IProject)(project = entry.getWorkspaceModel().getUnderlyingResource().getProject())))) {
                        map.put(jProject, entry.getClasspathContainer(true));
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            this.addAdditionalDependencyProjects(map);
        }
        if (map.size() > 0) {
            try {
                IJavaProject[] jProjects = map.keySet().toArray(new IJavaProject[map.size()]);
                IClasspathContainer[] containers = map.values().toArray(new IClasspathContainer[map.size()]);
                JavaCore.setClasspathContainer((IPath)new Path("org.eclipse.pde.core.requiredPlugins"), (IJavaProject[])jProjects, (IClasspathContainer[])containers, null);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void addAdditionalDependencyProjects(Map map) {
        if (map.size() == 0) {
            return;
        }
        Stack<IProject> changedProjects = new Stack<IProject>();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            changedProjects.push(((IJavaProject)it.next()).getProject());
        }
        IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IJavaProject> projects = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < projs.length) {
            try {
                if (!changedProjects.contains(projs[i]) && projs[i].isOpen() && projs[i].hasNature("org.eclipse.jdt.core.javanature")) {
                    projects.add(JavaCore.create((IProject)projs[i]));
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        while (!changedProjects.isEmpty()) {
            IProject refreshProject = (IProject)changedProjects.pop();
            ListIterator li = projects.listIterator();
            while (li.hasNext()) {
                IJavaProject jp = (IJavaProject)li.next();
                if (!jp.isOnClasspath((IResource)refreshProject)) continue;
                li.remove();
                IProject baseProject = jp.getProject();
                changedProjects.push(baseProject);
                ModelEntry entry = this.findEntry(baseProject);
                try {
                    if (entry == null || !entry.shouldUpdateClasspathContainer(true)) continue;
                    map.put(jp, entry.getClasspathContainer(true));
                }
                catch (CoreException coreException) {}
            }
        }
    }

    private Map getEntryTable() {
        this.initializeTable();
        return this.fEntries;
    }

    private synchronized void initializeTable() {
        if (this.fEntries != null) {
            return;
        }
        this.fEntries = Collections.synchronizedMap(new TreeMap());
        this.fState = new PDEState(WorkspaceModelManager.getPluginPaths(), ExternalModelManager.getPluginPaths(), true, (IProgressMonitor)new NullProgressMonitor());
        this.fExternalManager.initializeModels(this.fState.getTargetModels());
        this.addToTable(this.fExternalManager.getAllModels(), false);
        if (this.fState.isCombined()) {
            IPluginModelBase[] models = this.fState.getWorkspaceModels();
            this.fWorkspaceManager.initializeModels(models);
            this.addToTable(models, true);
        } else {
            this.addToTable(this.fWorkspaceManager.getAllModels(), true);
            this.addWorkspaceBundlesToNewState();
        }
        this.fSearchablePluginsManager.initialize();
    }

    public PDEState getState() {
        this.initializeTable();
        return this.fState;
    }

    public void setState(PDEState state) {
        this.fState = state;
    }

    private void addToTable(IPluginModelBase[] models, boolean workspace) {
        int i = 0;
        while (i < models.length) {
            IPluginModelBase model = models[i];
            String id = model.getPluginBase().getId();
            if (id != null) {
                ModelEntry entry = (ModelEntry)((Object)this.fEntries.get(id));
                if (entry == null) {
                    entry = new ModelEntry(this, id);
                    this.fEntries.put(id, entry);
                }
                if (workspace) {
                    entry.setWorkspaceModel(model);
                } else {
                    entry.setExternalModel(model);
                }
            }
            ++i;
        }
    }

    private void addWorkspaceBundlesToNewState() {
        IPluginModelBase[] models = this.fWorkspaceManager.getAllModels();
        int i = 0;
        while (i < models.length) {
            this.addWorkspaceBundleToState(models[i]);
            ++i;
        }
        if (models.length > 0) {
            this.fState.resolveState(true);
        }
    }

    private void addWorkspaceBundleToState(IPluginModelBase model) {
        IPluginModelBase host;
        HostSpecification spec;
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        this.fState.addBundle(model, false);
        BundleDescription desc = model.getBundleDescription();
        if (desc != null && (spec = desc.getHost()) != null && spec.getName() != null && ("true".equals(System.getProperty("pde.allowCycles")) || ClasspathUtilCore.isPatchFragment(desc) || desc.getImportPackages().length > 0 || desc.getRequiredBundles().length > 0) && (host = this.findModel(spec.getName())) != null) {
            this.fState.addBundle(host, true);
        }
    }

    private void removeWorkspaceBundleFromState(IPluginModelBase model, String id) {
        IPluginModelBase external;
        BundleDescription description = model.getBundleDescription();
        if (description == null) {
            return;
        }
        this.fState.removeBundleDescription(description);
        ModelEntry entry = this.findEntry(id);
        IPluginModelBase iPluginModelBase = external = entry == null ? null : entry.getExternalModel();
        if (external != null) {
            this.fState.addBundleDescription(external.getBundleDescription());
        }
    }

    private void fireDelta(PluginModelDelta delta) {
        Object[] entries = this.fListeners.toArray();
        int i = 0;
        while (i < entries.length) {
            ((IPluginModelListener)entries[i]).modelsChanged(delta);
            ++i;
        }
    }

    public void shutdown() {
        if (this.fWorkspaceManager != null) {
            this.fWorkspaceManager.removeModelProviderListener(this.fProviderListener);
        }
        if (this.fExternalManager != null) {
            this.fExternalManager.removeModelProviderListener(this.fProviderListener);
        }
        if (this.fState != null) {
            this.fState.shutdown();
        }
        this.fSearchablePluginsManager.shutdown();
    }

    public void setInJavaSearch(ModelEntry[] entries, boolean value, IProgressMonitor monitor) throws CoreException {
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch() != value) {
                entry.setInJavaSearch(value);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.fSearchablePluginsManager.persistStates(monitor);
            this.fireDelta(delta);
        }
    }

    void searchablePluginsRemoved() {
        ModelEntry[] entries = this.getEntries();
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch()) {
                entry.setInJavaSearch(false);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.fireDelta(delta);
        }
    }

    public IFileAdapterFactory getFileAdapterFactory() {
        return this.fSearchablePluginsManager;
    }

    public SearchablePluginsManager getSearchablePluginsManager() {
        this.initializeTable();
        return this.fSearchablePluginsManager;
    }

    public IPluginModelBase[] getExternalModels() {
        this.initializeTable();
        return this.fExternalManager.getAllModels();
    }

    public IPluginModelBase[] getWorkspaceModels() {
        this.initializeTable();
        return this.fWorkspaceManager.getAllModels();
    }
}

