/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.plugin;

import java.io.Serializable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.text.AbstractTextChangeListener;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class XMLTextChangeListener
extends AbstractTextChangeListener {
    public XMLTextChangeListener(IDocument document) {
        super(document);
    }

    public TextEdit[] getTextOperations() {
        if (this.fOperationTable.size() == 0) {
            return new TextEdit[0];
        }
        return this.fOperationTable.values().toArray(new TextEdit[this.fOperationTable.size()]);
    }

    protected void deleteNode(IDocumentNode node) {
        TextEdit old = (TextEdit)this.fOperationTable.get(node);
        if (old != null) {
            this.fOperationTable.remove(node);
        }
        if (node.getOffset() > -1) {
            DeleteEdit op = this.getDeleteNodeOperation(node);
            this.fOperationTable.put(node, op);
        } else if (old == null) {
            this.insertNode(node);
        }
    }

    protected void insertNode(IDocumentNode node) {
        InsertEdit op = null;
        if ((node = this.getHighestNodeToBeWritten(node)).getParentNode() == null) {
            op = new InsertEdit(0, node.write(true));
        } else if (node.getOffset() > -1) {
            op = new ReplaceEdit(node.getOffset(), node.getLength(), node.write(false));
        } else {
            op = this.insertAfterSibling(node);
            if (op == null) {
                op = this.insertAsFirstChild(node);
            }
        }
        this.fOperationTable.put(node, op);
    }

    private InsertEdit insertAfterSibling(IDocumentNode node) {
        for (IDocumentNode sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getOffset() <= -1) continue;
            node.setLineIndent(sibling.getLineIndent());
            return new InsertEdit(sibling.getOffset() + sibling.getLength(), String.valueOf(this.fSep) + node.write(true));
        }
        return null;
    }

    private InsertEdit insertAsFirstChild(IDocumentNode node) {
        int offset = node.getParentNode().getOffset();
        int length = this.getNextPosition(this.fDocument, offset, '>');
        node.setLineIndent(node.getParentNode().getLineIndent() + 3);
        return new InsertEdit(offset + length + 1, String.valueOf(this.fSep) + node.write(true));
    }

    protected void modifyNode(IDocumentNode node, IModelChangedEvent event) {
        IDocumentNode node2;
        IDocumentNode oldNode = (IDocumentNode)event.getOldValue();
        IDocumentNode newNode = (IDocumentNode)event.getNewValue();
        IDocumentNode node1 = oldNode.getPreviousSibling() == null || oldNode.equals(newNode.getPreviousSibling()) ? oldNode : newNode;
        IDocumentNode iDocumentNode = node2 = node1.equals(oldNode) ? newNode : oldNode;
        if (node1.getOffset() < 0 && node2.getOffset() < 0) {
            TextEdit op = (TextEdit)this.fOperationTable.get(node1);
            if (op == null) {
                this.insertNode(node);
            }
        } else if (node1.getOffset() > -1 && node2.getOffset() > -1) {
            IRegion region = this.getMoveRegion(node1);
            MoveSourceEdit source = new MoveSourceEdit(region.getOffset(), region.getLength());
            region = this.getMoveRegion(node2);
            source.setTargetEdit(new MoveTargetEdit(region.getOffset()));
            this.fOperationTable.put(node, source);
        } else {
            this.insertNode(node1.getOffset() < 0 ? node1 : node2);
        }
    }

    private IRegion getMoveRegion(IDocumentNode node) {
        int offset = node.getOffset();
        int length = node.getLength();
        int i = 1;
        try {
            while (true) {
                char ch;
                if (!Character.isWhitespace(ch = this.fDocument.get(offset - i, 1).toCharArray()[0])) {
                    --i;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new Region(offset - i, length + i);
    }

    protected void addAttributeOperation(IDocumentAttribute attr, IModelChangedEvent event) {
        int offset = attr.getValueOffset();
        Object newValue = event.getNewValue();
        Serializable changedObject = attr;
        ReplaceEdit op = null;
        if (offset > -1) {
            if (newValue == null || newValue.toString().length() == 0) {
                int length = attr.getValueOffset() + attr.getValueLength() + 1 - attr.getNameOffset();
                op = this.getAttributeDeleteEditOperation(attr.getNameOffset(), length);
            } else {
                op = new ReplaceEdit(offset, attr.getValueLength(), this.getWritableString(event.getNewValue().toString()));
            }
        }
        if (op == null) {
            IDocumentNode node = attr.getEnclosingElement();
            if (node.getOffset() > -1) {
                changedObject = node;
                int len = this.getNextPosition(this.fDocument, node.getOffset(), '>');
                op = new ReplaceEdit(node.getOffset(), len + 1, node.writeShallow(this.shouldTerminateElement(this.fDocument, node.getOffset() + len)));
            } else {
                this.insertNode(node);
                return;
            }
        }
        this.fOperationTable.put(changedObject, op);
    }

    protected void addElementContentOperation(IDocumentTextNode textNode) {
        ReplaceEdit op = null;
        Object changedObject = textNode;
        if (textNode.getOffset() > -1) {
            String newText = this.getWritableString(textNode.getText());
            op = new ReplaceEdit(textNode.getOffset(), textNode.getLength(), newText);
        } else {
            IDocumentNode parent = textNode.getEnclosingElement();
            if (parent.getOffset() > -1) {
                try {
                    String endChars = this.fDocument.get(parent.getOffset() + parent.getLength() - 2, 2);
                    if ("/>".equals(endChars)) {
                        this.insertNode(parent);
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {}
                changedObject = parent;
                StringBuffer buffer = new StringBuffer(this.fSep);
                int i = 0;
                while (i < parent.getLineIndent()) {
                    buffer.append(" ");
                    ++i;
                }
                buffer.append("   " + this.getWritableString(textNode.getText()));
                int offset = parent.getOffset();
                int length = this.getNextPosition(this.fDocument, offset, '>');
                op = new InsertEdit(offset + length + 1, buffer.toString());
            } else {
                this.insertNode(parent);
                return;
            }
        }
        this.fOperationTable.put(changedObject, op);
    }

    private boolean shouldTerminateElement(IDocument doc, int offset) {
        try {
            return doc.get(offset - 1, 1).toCharArray()[0] == '/';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private int getNextPosition(IDocument doc, int offset, char ch) {
        int i = 0;
        try {
            i = 0;
            while (i + offset < doc.getLength()) {
                if (ch != doc.get(offset + i, 1).toCharArray()[0]) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {}
        return i;
    }

    private DeleteEdit getAttributeDeleteEditOperation(int offset, int length) {
        try {
            char ch;
            while (Character.isWhitespace(ch = this.fDocument.get(offset + length, 1).toCharArray()[0])) {
                ++length;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new DeleteEdit(offset, length);
    }

    private DeleteEdit getDeleteNodeOperation(IDocumentNode node) {
        int offset = node.getOffset();
        int length = node.getLength();
        int indent = 0;
        try {
            char ch;
            int line = this.fDocument.getLineOfOffset(offset + length);
            while (true) {
                ch = this.fDocument.get(offset + length, 1).toCharArray()[0];
                if (this.fDocument.getLineOfOffset(offset + length) > line || !Character.isWhitespace(ch)) {
                    --length;
                    break;
                }
                ++length;
            }
            indent = 1;
            while (indent <= node.getLineIndent()) {
                ch = this.fDocument.get(offset - indent, 1).toCharArray()[0];
                if (!Character.isWhitespace(ch)) {
                    --indent;
                    break;
                }
                ++indent;
            }
        }
        catch (BadLocationException badLocationException) {}
        return new DeleteEdit(offset - indent, length + indent);
    }

    private IDocumentNode getHighestNodeToBeWritten(IDocumentNode node) {
        IDocumentNode parent = node.getParentNode();
        if (parent == null) {
            return node;
        }
        if (parent.getOffset() > -1) {
            try {
                String endChars = this.fDocument.get(parent.getOffset() + parent.getLength() - 2, 2);
                return "/>".equals(endChars) ? parent : node;
            }
            catch (BadLocationException badLocationException) {
                return node;
            }
        }
        return this.getHighestNodeToBeWritten(parent);
    }

    private String getWritableString(String source) {
        return CoreUtility.getWritableString(source);
    }

    public void modelChanged(IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects == null) {
            return;
        }
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IDocumentNode) {
                IDocumentNode node = (IDocumentNode)objects[i];
                this.fOperationTable.remove(node);
                switch (event.getChangeType()) {
                    case 2: {
                        this.deleteNode(node);
                        break;
                    }
                    case 1: {
                        this.insertNode(node);
                        break;
                    }
                    case 3: {
                        IDocumentAttribute attr = node.getDocumentAttribute(event.getChangedProperty());
                        if (attr != null) {
                            this.addAttributeOperation(attr, event);
                            break;
                        }
                        if (event.getOldValue() instanceof IDocumentTextNode) {
                            this.addElementContentOperation((IDocumentTextNode)event.getOldValue());
                            break;
                        }
                        if (!(event.getOldValue() instanceof IDocumentNode) || !(event.getNewValue() instanceof IDocumentNode)) break;
                        this.modifyNode(node, event);
                    }
                }
            }
            ++i;
        }
    }
}

