/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.xhtml.UAContentParser;
import org.eclipse.help.internal.xhtml.UATransformManager;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class DynamicContentProducer
implements IHelpContentProducer {
    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        String extension;
        int loc;
        String file = href;
        int qloc = href.indexOf(63);
        if (qloc != -1) {
            file = href.substring(0, qloc);
        }
        if ((loc = file.lastIndexOf(46)) != -1 && "xhtml".equals(extension = file.substring(loc + 1).toLowerCase())) {
            boolean filter = true;
            if (qloc != -1 && qloc < href.length() - 1) {
                String query = href.substring(qloc + 1);
                filter = query.indexOf("filter=false") == -1;
            }
            return this.openXHTMLFromPlugin(pluginID, file, locale.toString(), filter);
        }
        return null;
    }

    private InputStream openXHTMLFromPlugin(String pluginID, String file, String locale, boolean filter) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle != null) {
            InputStream inputStream = ResourceLocator.openFromZip(bundle, "doc.zip", file, locale);
            if (inputStream == null) {
                inputStream = ResourceLocator.openFromPlugin(bundle, file, locale);
            }
            if (inputStream != null) {
                UAContentParser parser = new UAContentParser(inputStream);
                Document dom = parser.getDocument();
                XHTMLSupport support = new XHTMLSupport(pluginID, file, dom, locale);
                dom = support.processDOM(filter);
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                return UATransformManager.getAsInputStream(dom);
            }
        }
        return null;
    }
}

