/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public abstract class FilterableUAElement {
    private Map filters;

    public void addFilters(Attributes attrs) {
        String filterAttribute;
        if (attrs != null && (filterAttribute = attrs.getValue("filter")) != null) {
            this.addFilter(filterAttribute);
        }
    }

    public void addFilters(Element element) {
        String filterAttribute = element.getAttribute("filter");
        if (filterAttribute.length() > 0) {
            this.addFilter(filterAttribute);
        }
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1 && "filter".equals(node.getNodeName())) {
                Element elementNode = (Element)node;
                this.addFilter(elementNode.getAttribute("name"), elementNode.getAttribute("value"));
            }
            ++i;
        }
    }

    public void addFilter(String nameAndValue) {
        boolean isPositive = nameAndValue.indexOf("!=") == -1;
        String[] tokens = nameAndValue.split("!?=");
        String name = tokens[0];
        String value = tokens[1];
        if (!isPositive) {
            value = String.valueOf('!') + value;
        }
        this.addFilter(name, value);
    }

    public void addFilter(String name, String value) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        this.filters.put(name, value);
    }

    public Map getFilters() {
        return this.filters;
    }
}

