/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.fix.SerialVersionDefaultOperation;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionHashOperation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class PotentialProgrammingProblemsFix
extends AbstractFix {
    private static final String EXTERNALIZABLE_NAME = "java.io.Externalizable";
    private static final String SERIALIZABLE_NAME = "java.io.Serializable";
    private static final String NAME_FIELD = "serialVersionUID";
    private static final long SERIAL_VALUE = 1L;

    public static IFix[] createMissingSerialVersionFixes(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        if (problem.getProblemId() != 0x20000060) {
            return null;
        }
        ICompilationUnit unit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (unit == null) {
            return null;
        }
        SimpleName simpleName = PotentialProgrammingProblemsFix.getSimpleTypeName(compilationUnit, problem);
        if (simpleName == null) {
            return null;
        }
        SerialVersionDefaultOperation defop = new SerialVersionDefaultOperation(unit, new SimpleName[]{simpleName});
        PotentialProgrammingProblemsFix fix1 = new PotentialProgrammingProblemsFix(FixMessages.Java50Fix_SerialVersion_default_description, compilationUnit, new IFixRewriteOperation[]{defop});
        SerialVersionHashOperation hashop = new SerialVersionHashOperation(unit, new SimpleName[]{simpleName});
        PotentialProgrammingProblemsFix fix2 = new PotentialProgrammingProblemsFix(FixMessages.Java50Fix_SerialVersion_hash_description, compilationUnit, new IFixRewriteOperation[]{hashop});
        return new IFix[]{fix1, fix2};
    }

    private static SerialVersionHashBatchOperation createSerialVersionHashOperation(CompilationUnit compilationUnit, IProblemLocation[] problems, ISerialVersionFixContext context) {
        ICompilationUnit unit = (ICompilationUnit)compilationUnit.getJavaElement();
        if (unit == null) {
            return null;
        }
        ArrayList<SimpleName> simpleNames = new ArrayList<SimpleName>();
        int i = 0;
        while (i < problems.length) {
            SimpleName simpleName;
            if (problems[i].getProblemId() == 0x20000060 && (simpleName = PotentialProgrammingProblemsFix.getSimpleTypeName(compilationUnit, problems[i])) != null) {
                simpleNames.add(simpleName);
            }
            ++i;
        }
        if (simpleNames.size() == 0) {
            return null;
        }
        return new SerialVersionHashBatchOperation(unit, (ASTNode[])simpleNames.toArray(new SimpleName[simpleNames.size()]), context);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean addSerialVersionIds, ISerialVersionFixContext context) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return PotentialProgrammingProblemsFix.createCleanUp(compilationUnit, locations, addSerialVersionIds, context);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addSerialVersionIds, ISerialVersionFixContext context) {
        SerialVersionHashBatchOperation operation;
        ArrayList<SerialVersionHashBatchOperation> operations = new ArrayList<SerialVersionHashBatchOperation>();
        if (addSerialVersionIds && (operation = PotentialProgrammingProblemsFix.createSerialVersionHashOperation(compilationUnit, problems, context)) != null) {
            operations.add(operation);
        }
        if (operations.isEmpty()) {
            return null;
        }
        IFixRewriteOperation[] ops = operations.toArray(new IFixRewriteOperation[operations.size()]);
        return new PotentialProgrammingProblemsFix("", compilationUnit, ops);
    }

    public static SerialVersionHashContext createSerialVersionHashContext(IJavaProject project, ICompilationUnit[] compilationUnits, IProgressMonitor monitor) throws CoreException {
        SerialVersionHashContext serialVersionHashContext;
        try {
            monitor.beginTask("", compilationUnits.length * 2 + 20);
            ArrayList qualifiedClassNames = new ArrayList();
            if (compilationUnits.length > 500) {
                PotentialProgrammingProblemsFix.findWithTypeHierarchy(project, compilationUnits, qualifiedClassNames, monitor);
            } else {
                PotentialProgrammingProblemsFix.findWithRecursion(project, compilationUnits, qualifiedClassNames, monitor);
            }
            SerialVersionHashContext result = new SerialVersionHashContext(project, qualifiedClassNames.toArray(new String[qualifiedClassNames.size()]));
            try {
                result.initialize((IProgressMonitor)new SubProgressMonitor(monitor, 20));
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
            serialVersionHashContext = result;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return serialVersionHashContext;
    }

    private static void findWithRecursion(IJavaProject project, ICompilationUnit[] compilationUnits, List qualifiedClassNames, IProgressMonitor monitor) throws JavaModelException {
        IType serializable = project.findType(SERIALIZABLE_NAME);
        IType externalizable = project.findType(EXTERNALIZABLE_NAME);
        int i = 0;
        while (i < compilationUnits.length) {
            monitor.subTask(Messages.format(FixMessages.Java50Fix_InitializeSerialVersionId_subtask_description, new Object[]{project.getElementName(), compilationUnits[i].getElementName()}));
            PotentialProgrammingProblemsFix.findTypesWithoutSerialVersionId(compilationUnits[i].getChildren(), serializable, externalizable, qualifiedClassNames);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(2);
            ++i;
        }
    }

    private static void findWithTypeHierarchy(IJavaProject project, ICompilationUnit[] compilationUnits, List qualifiedClassNames, IProgressMonitor monitor) throws JavaModelException {
        IType serializable = project.findType(SERIALIZABLE_NAME);
        IType externalizable = project.findType(EXTERNALIZABLE_NAME);
        HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
        int i = 0;
        while (i < compilationUnits.length) {
            cus.add(compilationUnits[i]);
            ++i;
        }
        monitor.subTask(Messages.format(FixMessages.Java50Fix_SerialVersion_CalculateHierarchy_description, SERIALIZABLE_NAME));
        ITypeHierarchy hierarchy1 = serializable.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, compilationUnits.length));
        IType[] allSubtypes1 = hierarchy1.getAllSubtypes(serializable);
        PotentialProgrammingProblemsFix.addTypes(allSubtypes1, cus, qualifiedClassNames);
        monitor.subTask(Messages.format(FixMessages.Java50Fix_SerialVersion_CalculateHierarchy_description, EXTERNALIZABLE_NAME));
        ITypeHierarchy hierarchy2 = externalizable.newTypeHierarchy(project, (IProgressMonitor)new SubProgressMonitor(monitor, compilationUnits.length));
        IType[] allSubtypes2 = hierarchy2.getAllSubtypes(externalizable);
        PotentialProgrammingProblemsFix.addTypes(allSubtypes2, cus, qualifiedClassNames);
    }

    private static void addTypes(IType[] allSubtypes, HashSet cus, List qualifiedClassNames) throws JavaModelException {
        int i = 0;
        while (i < allSubtypes.length) {
            IField field;
            IType type = allSubtypes[i];
            if (type.isClass() && cus.contains(type.getCompilationUnit()) && !(field = type.getField(NAME_FIELD)).exists()) {
                qualifiedClassNames.add(type.getFullyQualifiedName());
            }
            ++i;
        }
    }

    private static void findTypesWithoutSerialVersionId(IJavaElement[] children, IType serializable, IType externalizable, List qualifiedClassNames) throws JavaModelException {
        int i = 0;
        while (i < children.length) {
            IJavaElement child = children[i];
            if (child instanceof IType) {
                IType type = (IType)child;
                ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IType[] allInterfaces = hierarchy.getAllSuperInterfaces(type);
                int j = 0;
                while (j < allInterfaces.length) {
                    if (allInterfaces[j].equals(serializable) || allInterfaces[j].equals(externalizable)) {
                        IField field = type.getField(NAME_FIELD);
                        if (field.exists()) break;
                        qualifiedClassNames.add(type.getFullyQualifiedName());
                        break;
                    }
                    ++j;
                }
                PotentialProgrammingProblemsFix.findTypesWithoutSerialVersionId(type.getChildren(), serializable, externalizable, qualifiedClassNames);
            } else if (child instanceof IMethod) {
                IMethod method = (IMethod)child;
                PotentialProgrammingProblemsFix.findTypesWithoutSerialVersionId(method.getChildren(), serializable, externalizable, qualifiedClassNames);
            } else if (child instanceof IField) {
                IField field = (IField)child;
                PotentialProgrammingProblemsFix.findTypesWithoutSerialVersionId(field.getChildren(), serializable, externalizable, qualifiedClassNames);
            }
            ++i;
        }
    }

    private static SimpleName getSimpleTypeName(CompilationUnit compilationUnit, IProblemLocation problem) {
        SimpleType type;
        ASTNode selection = problem.getCoveredNode(compilationUnit);
        if (selection == null) {
            return null;
        }
        Name name = null;
        if (selection instanceof SimpleType) {
            type = (SimpleType)selection;
            name = type.getName();
        } else if (selection instanceof ParameterizedType) {
            type = (ParameterizedType)selection;
            Type raw = type.getType();
            if (raw instanceof SimpleType) {
                name = ((SimpleType)raw).getName();
            } else if (raw instanceof QualifiedType) {
                name = ((QualifiedType)raw).getName();
            }
        } else if (selection instanceof Name) {
            name = (Name)selection;
        }
        if (name == null) {
            return null;
        }
        SimpleName result = name.isSimpleName() ? (SimpleName)name : ((QualifiedName)name).getName();
        return result;
    }

    protected PotentialProgrammingProblemsFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static interface ISerialVersionFixContext {
        public long getSerialVersionId(String var1) throws CoreException;
    }

    private static class SerialVersionHashContext
    implements ISerialVersionFixContext {
        private final IJavaProject fProject;
        private final String[] fQualifiedNames;
        private Hashtable fIdsTable;

        public SerialVersionHashContext(IJavaProject project, String[] qualifiedNames) {
            this.fProject = project;
            this.fQualifiedNames = qualifiedNames;
        }

        public void initialize(IProgressMonitor monitor) throws CoreException, IOException {
            this.fIdsTable = new Hashtable();
            if (this.fQualifiedNames.length > 0) {
                long[] ids = SerialVersionHashOperation.calculateSerialVersionIds(this.fQualifiedNames, this.fProject, monitor);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (ids.length != this.fQualifiedNames.length) {
                    int i = 0;
                    while (i < this.fQualifiedNames.length) {
                        this.fIdsTable.put(this.fQualifiedNames[i], new Long(1L));
                        ++i;
                    }
                    return;
                }
                int i = 0;
                while (i < ids.length) {
                    this.fIdsTable.put(this.fQualifiedNames[i], new Long(ids[i]));
                    ++i;
                }
            }
        }

        public long getSerialVersionId(String qualifiedName) throws CoreException {
            if (this.fIdsTable == null) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, FixMessages.Java50Fix_SerialVersionNotInitialized_exception_description, null));
            }
            Long id = (Long)this.fIdsTable.get(qualifiedName);
            if (id == null) {
                try {
                    long[] ids = SerialVersionHashOperation.calculateSerialVersionIds(new String[]{qualifiedName}, this.fProject, (IProgressMonitor)new NullProgressMonitor());
                    if (ids.length == 0) {
                        throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FixMessages.Java50Fix_SerialVersionNotFound_exception_description, qualifiedName), null));
                    }
                    this.fIdsTable.put(qualifiedName, new Long(ids[0]));
                    return ids[0];
                }
                catch (CoreException e) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FixMessages.Java50Fix_SerialVersionNotFound_exception_description, qualifiedName), (Throwable)e));
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, Messages.format(FixMessages.Java50Fix_SerialVersionNotFound_exception_description, qualifiedName), (Throwable)e));
                }
            }
            return id;
        }
    }

    private static class SerialVersionHashBatchOperation
    extends AbstractSerialVersionOperation {
        private final ISerialVersionFixContext fContext;

        protected SerialVersionHashBatchOperation(ICompilationUnit unit, ASTNode[] node, ISerialVersionFixContext context) {
            super(unit, node);
            this.fContext = context;
        }

        protected void addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) throws CoreException {
            long id = this.fContext.getSerialVersionId(this.getQualifiedName(declarationNode));
            if (id == -1L) {
                id = 1L;
            }
            fragment.setInitializer((Expression)fragment.getAST().newNumberLiteral(String.valueOf(id) + "L"));
        }

        protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, List positionGroups) {
        }
    }
}

