/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;
    static /* synthetic */ Class class$0;

    private Checks() {
    }

    public static RefactoringStatus checkIfConstructorName(IMethod method, String newMethodName, String newTypeName) {
        if (!newMethodName.equals(newTypeName)) {
            return null;
        }
        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.Checks_constructor_name, new Object[]{JavaElementUtil.createMethodSignature(method), JavaModelUtil.getFullyQualifiedName(method.getDeclaringType())}));
    }

    public static RefactoringStatus checkFieldName(String name) {
        return Checks.checkName(name, JavaConventions.validateFieldName((String)name));
    }

    public static RefactoringStatus checkTypeParameterName(String name) {
        return Checks.checkName(name, JavaConventions.validateTypeVariableName((String)name));
    }

    public static RefactoringStatus checkIdentifier(String name) {
        return Checks.checkName(name, JavaConventions.validateIdentifier((String)name));
    }

    public static RefactoringStatus checkMethodName(String name) {
        RefactoringStatus status = Checks.checkName(name, JavaConventions.validateMethodName((String)name));
        if (status.isOK() && Checks.startsWithUpperCase(name)) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.Checks_method_names_lowercase);
        }
        return status;
    }

    public static RefactoringStatus checkTypeName(String name) {
        if (name.indexOf(".") != -1) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_no_dot);
        }
        return Checks.checkName(name, JavaConventions.validateJavaTypeName((String)name));
    }

    public static RefactoringStatus checkPackageName(String name) {
        return Checks.checkName(name, JavaConventions.validatePackageName((String)name));
    }

    public static RefactoringStatus checkCompilationUnitName(String name) {
        return Checks.checkName(name, JavaConventions.validateCompilationUnitName((String)name));
    }

    public static RefactoringStatus checkCompilationUnitNewName(ICompilationUnit cu, String newName) {
        String newCUName = JavaModelUtil.getRenamedCUName(cu, newName);
        if (Checks.resourceExists(RenameResourceChange.renamedResourcePath(ResourceUtil.getResource(cu).getFullPath(), newCUName))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_cu_name_used, newName));
        }
        return new RefactoringStatus();
    }

    public static boolean startsWithUpperCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toUpperCase(s.charAt(0));
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static boolean isTopLevel(IType type) {
        return type.getDeclaringType() == null;
    }

    public static boolean isAnonymous(IType type) throws JavaModelException {
        return type.isAnonymous();
    }

    public static boolean isTopLevelType(IMember member) {
        return member.getElementType() == 7 && Checks.isTopLevel((IType)member);
    }

    public static boolean isInsideLocalType(IType type) throws JavaModelException {
        while (type != null) {
            if (type.isLocal()) {
                return true;
            }
            type = type.getDeclaringType();
        }
        return false;
    }

    public static boolean isAlreadyNamed(IJavaElement element, String name) {
        return name.equals(element.getElementName());
    }

    public static RefactoringStatus checkForMainAndNativeMethods(ICompilationUnit cu) throws JavaModelException {
        return Checks.checkForMainAndNativeMethods(cu.getTypes());
    }

    public static RefactoringStatus checkForMainAndNativeMethods(IType[] types) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < types.length) {
            result.merge(Checks.checkForMainAndNativeMethods(types[i]));
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkForMainAndNativeMethods(IType type) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkForMainAndNativeMethods(type.getMethods()));
        result.merge(Checks.checkForMainAndNativeMethods(type.getTypes()));
        return result;
    }

    private static RefactoringStatus checkForMainAndNativeMethods(IMethod[] methods) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < methods.length) {
            String msg;
            if (JdtFlags.isNative((IMember)methods[i])) {
                msg = Messages.format(RefactoringCoreMessages.Checks_method_native, new String[]{JavaModelUtil.getFullyQualifiedName(methods[i].getDeclaringType()), methods[i].getElementName(), "UnsatisfiedLinkError"});
                result.addEntry(3, msg, JavaStatusContext.create((IMember)methods[i]), Corext.getPluginId(), 192);
            }
            if (methods[i].isMainMethod()) {
                msg = Messages.format(RefactoringCoreMessages.Checks_has_main, JavaModelUtil.getFullyQualifiedName(methods[i].getDeclaringType()));
                result.addEntry(2, msg, JavaStatusContext.create((IMember)methods[i]), Corext.getPluginId(), 193);
            }
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters) {
        IMethodBinding method;
        RefactoringStatus result = new RefactoringStatus();
        if (methodName.equals(type.getName())) {
            result.addWarning(RefactoringCoreMessages.Checks_methodName_constructor);
        }
        if ((method = Bindings.findMethodInType(type, methodName, parameters)) != null) {
            result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_exists, new Object[]{methodName, type.getName()}), JavaStatusContext.create(method));
        }
        return result;
    }

    public static RefactoringStatus checkMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding returnType, ITypeBinding[] parameters) {
        RefactoringStatus result = new RefactoringStatus();
        IMethodBinding method = Bindings.findMethodInHierarchy(type, methodName, parameters);
        if (method != null) {
            boolean returnTypeClash = false;
            ITypeBinding methodReturnType = method.getReturnType();
            if (returnType != null && methodReturnType != null) {
                String returnTypeKey = returnType.getKey();
                String methodReturnTypeKey = methodReturnType.getKey();
                if (returnTypeKey == null && methodReturnTypeKey == null) {
                    returnTypeClash = returnType != methodReturnType;
                } else if (returnTypeKey != null && methodReturnTypeKey != null) {
                    returnTypeClash = !returnTypeKey.equals(methodReturnTypeKey);
                }
            }
            ITypeBinding dc = method.getDeclaringClass();
            if (returnTypeClash) {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_returnTypeClash, new Object[]{methodName, dc.getName()}), JavaStatusContext.create(method));
            } else {
                result.addError(Messages.format(RefactoringCoreMessages.Checks_methodName_overrides, new Object[]{methodName, dc.getName()}), JavaStatusContext.create(method));
            }
        }
        return result;
    }

    public static boolean isExtractableExpression(ASTNode[] selectedNodes, ASTNode coveringNode) {
        ASTNode node = coveringNode;
        if (Checks.isEnumCase(node)) {
            return false;
        }
        if (selectedNodes != null && selectedNodes.length == 1) {
            node = selectedNodes[0];
        }
        return Checks.isExtractableExpression(node);
    }

    public static boolean isEnumCase(ASTNode node) {
        Name name;
        IBinding binding;
        SwitchCase caze;
        Expression expression;
        if (node instanceof SwitchCase && (expression = (caze = (SwitchCase)node).getExpression()) instanceof Name && (binding = (name = (Name)expression).resolveBinding()) instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            return variableBinding.isEnumConstant();
        }
        return false;
    }

    public static boolean isExtractableExpression(ASTNode node) {
        if (!(node instanceof Expression)) {
            return false;
        }
        if (node instanceof Name) {
            IBinding binding = ((Name)node).resolveBinding();
            return !(binding instanceof ITypeBinding);
        }
        return true;
    }

    public static boolean isInsideJavadoc(ASTNode node) {
        do {
            if (node.getNodeType() != 29) continue;
            return true;
        } while ((node = node.getParent()) != null);
        return false;
    }

    public static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static IMethod findMethod(String name, int parameterCount, boolean isConstructor, IType type) throws JavaModelException {
        return Checks.findMethod(name, parameterCount, isConstructor, type.getMethods());
    }

    public static IMethod findMethod(IMethod method, IType type) throws JavaModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), type.getMethods());
    }

    public static IMethod findMethod(IMethod method, IMethod[] methods) throws JavaModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), methods);
    }

    public static IMethod findMethod(String name, int parameters, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            IMethod curr = methods[i];
            if (name.equals(curr.getElementName()) && isConstructor == curr.isConstructor() && parameters == curr.getParameterTypes().length) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static IMethod findSimilarMethod(IMethod method, IType type) throws JavaModelException {
        return Checks.findSimilarMethod(method, type.getMethods());
    }

    public static IMethod findSimilarMethod(IMethod method, IMethod[] methods) throws JavaModelException {
        boolean isConstructor = method.isConstructor();
        int i = 0;
        while (i < methods.length) {
            IMethod otherMethod = methods[i];
            if (otherMethod.isConstructor() == isConstructor && method.isSimilar(otherMethod)) {
                return otherMethod;
            }
            ++i;
        }
        return null;
    }

    public static boolean compareParamTypes(String[] paramTypes1, String[] paramTypes2) {
        if (paramTypes1.length == paramTypes2.length) {
            int i = 0;
            while (i < paramTypes1.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes1[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)paramTypes2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static RefactoringStatus checkIfCuBroken(IMember member) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)ResourceUtil.getResource(member));
        if (cu == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_created);
        }
        if (!cu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_parsed);
        }
        return new RefactoringStatus();
    }

    public static SearchResultGroup[] excludeCompilationUnits(SearchResultGroup[] grouped, RefactoringStatus status) throws JavaModelException {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        boolean wasEmpty = grouped.length == 0;
        int i = 0;
        while (i < grouped.length) {
            IResource resource = grouped[i].getResource();
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)resource);
                if (!cu.isStructureKnown()) {
                    String path = Checks.getFullPath(cu);
                    status.addError(Messages.format(RefactoringCoreMessages.Checks_cannot_be_parsed, path));
                } else {
                    result.add(grouped[i]);
                }
            }
            ++i;
        }
        if (!wasEmpty && result.isEmpty()) {
            status.addFatalError(RefactoringCoreMessages.Checks_all_excluded);
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private static final String getFullPath(ICompilationUnit cu) {
        Assert.isTrue(cu.exists());
        return ResourceUtil.getResource(cu).getFullPath().toString();
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] grouped) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < grouped.length) {
            Checks.checkCompileErrorsInAffectedFile(result, grouped[i].getResource());
            ++i;
        }
        return result;
    }

    public static void checkCompileErrorsInAffectedFile(RefactoringStatus result, IResource resource) throws JavaModelException {
        if (Checks.hasCompileErrors(resource)) {
            result.addWarning(Messages.format(RefactoringCoreMessages.Checks_cu_has_compile_errors, resource.getFullPath().makeRelative()));
        }
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] references, IResource declaring) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < references.length) {
            IResource resource = references[i].getResource();
            if (resource.equals((Object)declaring)) {
                declaring = null;
            }
            Checks.checkCompileErrorsInAffectedFile(result, resource);
            ++i;
        }
        if (declaring != null) {
            Checks.checkCompileErrorsInAffectedFile(result, declaring);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCompileErrors(IResource resource) throws JavaModelException {
        try {
            IMarker[] problemMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int i = 0;
            while (true) {
                if (i >= problemMarkers.length) {
                    return false;
                }
                if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public static boolean isReadOnly(Object element) throws JavaModelException {
        if (element instanceof IResource) {
            return Checks.isReadOnly((IResource)element);
        }
        if (element instanceof IJavaElement) {
            if (element instanceof IPackageFragmentRoot && Checks.isClasspathDelete((IPackageFragmentRoot)element)) {
                return false;
            }
            return Checks.isReadOnly(((IJavaElement)element).getResource());
        }
        Assert.isTrue(false, "not expected to get here");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadOnly(IResource res) throws JavaModelException {
        ResourceAttributes attributes = res.getResourceAttributes();
        if (attributes != null && attributes.isReadOnly()) {
            return true;
        }
        if (!(res instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)res;
        try {
            IResource[] children = container.members();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return false;
                }
                if (Checks.isReadOnly(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public static boolean isClasspathDelete(IPackageFragmentRoot pkgRoot) {
        IResource res = pkgRoot.getResource();
        if (res == null) {
            return true;
        }
        IProject definingProject = res.getProject();
        if (res.getParent() != null && pkgRoot.isArchive() && !res.getParent().equals((Object)definingProject)) {
            return true;
        }
        IProject occurringProject = pkgRoot.getJavaProject().getProject();
        return !definingProject.equals((Object)occurringProject);
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus validateEdit(ICompilationUnit unit, Object context) {
        IResource resource = unit.getPrimary().getResource();
        RefactoringStatus result = new RefactoringStatus();
        if (resource == null) {
            return result;
        }
        IStatus status = Resources.checkInSync(resource);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable(resource, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus checkAvailability(IJavaElement javaElement) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (!javaElement.exists()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_not_in_model, javaElement.getElementName()));
        }
        if (javaElement.isReadOnly()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_read_only, javaElement.getElementName()));
        }
        if (javaElement.exists() && !javaElement.isStructureKnown()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_unknown_structure, javaElement.getElementName()));
        }
        if (javaElement instanceof IMember && ((IMember)javaElement).isBinary()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_binary, javaElement.getElementName()));
        }
        return result;
    }

    public static boolean isAvailable(IJavaElement javaElement) throws JavaModelException {
        if (javaElement == null) {
            return false;
        }
        if (!javaElement.exists()) {
            return false;
        }
        if (javaElement.isReadOnly()) {
            return false;
        }
        if (!(javaElement instanceof IJavaProject || javaElement instanceof ILocalVariable || javaElement.isStructureKnown())) {
            return false;
        }
        return !(javaElement instanceof IMember) || !((IMember)javaElement).isBinary();
    }

    public static IType findTypeInPackage(IPackageFragment pack, String name) throws JavaModelException {
        Assert.isTrue(pack.exists());
        Assert.isTrue(!pack.isReadOnly());
        if (name.indexOf(".") != -1) {
            name = name.substring(0, name.indexOf("."));
        }
        ICompilationUnit[] cus = pack.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            if (cus[i].getType(name).exists()) {
                return cus[i].getType(name);
            }
            ++i;
        }
        return null;
    }

    public static RefactoringStatus checkTempName(String newName) {
        RefactoringStatus result = Checks.checkIdentifier(newName);
        if (result.hasFatalError()) {
            return result;
        }
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.ExtractTempRefactoring_convention);
        }
        return result;
    }

    public static RefactoringStatus checkEnumConstantName(String newName) {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.RenameEnumConstRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkConstantName(String newName) {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.ExtractConstantRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isException(IType iType, IProgressMonitor pm) throws JavaModelException {
        block6: {
            if (iType.isClass()) break block6;
            while (true) {
                var4_2 = null;
                pm.done();
                return false;
            }
        }
        try {
            superTypes = iType.newSupertypeHierarchy(pm).getAllSupertypes(iType);
            i = 0;
            while (true) {
                if (i >= superTypes.length) ** continue;
                if (!"java.lang.Throwable".equals(superTypes[i].getFullyQualifiedName())) break block7;
                var4_3 = null;
                break;
            }
        }
        catch (Throwable var5_7) {
            var4_4 = null;
            pm.done();
            throw var5_7;
        }
        {
            block7: {
                pm.done();
                return true;
            }
            ++i;
            continue;
        }
    }

    public static int checkExpressionIsRValue(Expression e) {
        if (e instanceof Name && !(((Name)e).resolveBinding() instanceof IVariableBinding)) {
            return 1;
        }
        ITypeBinding tb = e.resolveTypeBinding();
        if (tb == null) {
            return 1;
        }
        if (tb.getName().equals("void")) {
            return 2;
        }
        return 0;
    }

    public static boolean isDeclaredIn(VariableDeclaration tempDeclaration, Class astNodeClass) {
        ASTNode anonymous;
        ASTNode initializer = ASTNodes.getParent((ASTNode)tempDeclaration, astNodeClass);
        if (initializer == null) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((anonymous = ASTNodes.getParent((ASTNode)tempDeclaration, clazz)) == null) {
            return true;
        }
        return !ASTNodes.isParent(anonymous, initializer);
    }
}

