/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameCompilationUnitChange
extends AbstractJavaElementRenameChange {
    public static final String ID_RENAME_COMPILATION_UNIT = "org.eclipse.jdt.ui.rename.compilationunit";

    public RenameCompilationUnitChange(ICompilationUnit cu, String newName, String comment) {
        this(ResourceUtil.getResource(cu).getFullPath(), cu.getElementName(), newName, comment, -1L);
        Assert.isTrue(!cu.isReadOnly(), "cu must not be read-only");
    }

    private RenameCompilationUnitChange(IPath resourcePath, String oldName, String newName, String comment, long stampToRestore) {
        super(resourcePath, oldName, newName, comment, stampToRestore);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 7);
    }

    protected IPath createNewPath() {
        if (this.getResourcePath().getFileExtension() != null) {
            return this.getResourcePath().removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_name, new String[]{this.getOldName(), this.getNewName()});
    }

    protected Change createUndoChange(long stampToRestore) throws JavaModelException {
        return new RenameCompilationUnitChange(this.createNewPath(), this.getNewName(), this.getOldName(), this.getComment(), stampToRestore);
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        ICompilationUnit cu = (ICompilationUnit)this.getModifiedElement();
        if (cu != null) {
            cu.rename(this.getNewName(), false, pm);
        }
    }

    public final ChangeDescriptor getDescriptor() {
        IPackageFragment fragment;
        String label = null;
        ICompilationUnit unit = (ICompilationUnit)this.getModifiedElement();
        label = unit != null ? (!(fragment = (IPackageFragment)unit.getParent()).isDefaultPackage() ? String.valueOf(fragment.getElementName()) + "." + unit.getElementName() : unit.getElementName()) : this.getOldName();
        HashMap<String, String> arguments = new HashMap<String, String>();
        JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(ID_RENAME_COMPILATION_UNIT, this.getResource().getProject().getName(), Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_descriptor_description, new String[]{label, this.getNewName()}), this.getComment(), arguments, 589830);
        arguments.put("input", descriptor.elementToHandle((IJavaElement)unit));
        arguments.put("name", this.getNewName());
        return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
    }
}

