/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

abstract class TargetProvider {
    public static final boolean BUG_CORE_130317 = true;
    protected SourceProvider fSourceProvider;

    TargetProvider() {
    }

    public void setSourceProvider(SourceProvider sourceProvider) {
        Assert.isNotNull(sourceProvider);
        this.fSourceProvider = sourceProvider;
    }

    public abstract void initialize();

    public abstract ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus var1, IProgressMonitor var2) throws JavaModelException;

    public abstract BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit var1, IProgressMonitor var2);

    public abstract ASTNode[] getInvocations(BodyDeclaration var1, IProgressMonitor var2);

    public abstract RefactoringStatus checkActivation() throws JavaModelException;

    public abstract int getStatusSeverity();

    public boolean isSingle() {
        return false;
    }

    public static TargetProvider create(ICompilationUnit cu, MethodInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(ICompilationUnit cu, SuperMethodInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(ICompilationUnit cu, ConstructorInvocation invocation) {
        return new SingleCallTargetProvider(cu, (ASTNode)invocation);
    }

    public static TargetProvider create(MethodDeclaration declaration) {
        IMethodBinding method = declaration.resolveBinding();
        if (method == null) {
            return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_method_declaration_not_unique));
        }
        ITypeBinding type = method.getDeclaringClass();
        if (type.isLocal()) {
            if (((IType)type.getJavaElement()).isBinary()) {
                return new ErrorTargetProvider(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.TargetProvider_cannot_local_method_in_binary));
            }
            IType declaringClassOfLocal = (IType)type.getDeclaringClass().getJavaElement();
            return new LocalTypeTargetProvider(declaringClassOfLocal.getCompilationUnit(), declaration);
        }
        return new MemberTypeTargetProvider(declaration.resolveBinding());
    }

    public static TargetProvider create(IMethodBinding methodBinding) {
        return new MemberTypeTargetProvider(methodBinding);
    }

    static void fastDone(IProgressMonitor pm) {
        if (pm == null) {
            return;
        }
        pm.beginTask("", 1);
        pm.worked(1);
        pm.done();
    }

    static class ErrorTargetProvider
    extends TargetProvider {
        private RefactoringStatus fErrorStatus;

        public ErrorTargetProvider(RefactoringStatus status) {
            this.fErrorStatus = status;
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return this.fErrorStatus;
        }

        public void initialize() {
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
            return null;
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            return null;
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            return null;
        }

        public int getStatusSeverity() {
            return 0;
        }
    }

    static class SingleCallTargetProvider
    extends TargetProvider {
        private ICompilationUnit fCUnit;
        private ASTNode fInvocation;
        private boolean fIterated;
        static /* synthetic */ Class class$0;

        public SingleCallTargetProvider(ICompilationUnit cu, ASTNode invocation) {
            Assert.isNotNull(cu);
            Assert.isNotNull(invocation);
            Assert.isTrue(Invocations.isInvocation(invocation));
            this.fCUnit = cu;
            this.fInvocation = invocation;
        }

        public void initialize() {
            this.fIterated = false;
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus status, IProgressMonitor pm) {
            return new ICompilationUnit[]{this.fCUnit};
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            Assert.isTrue(unit == this.fCUnit);
            if (this.fIterated) {
                return new BodyDeclaration[0];
            }
            SingleCallTargetProvider.fastDone(pm);
            BodyDeclaration[] bodyDeclarationArray = new BodyDeclaration[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bodyDeclarationArray[0] = (BodyDeclaration)ASTNodes.getParent(this.fInvocation, clazz);
            return bodyDeclarationArray;
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            SingleCallTargetProvider.fastDone(pm);
            if (this.fIterated) {
                return null;
            }
            this.fIterated = true;
            return new ASTNode[]{this.fInvocation};
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 4;
        }

        public boolean isSingle() {
            return true;
        }
    }

    private static class BodyData {
        public BodyDeclaration fBody;
        private List fInvocations;

        public BodyData(BodyDeclaration declaration) {
            this.fBody = declaration;
        }

        public void addInvocation(ASTNode node) {
            if (this.fInvocations == null) {
                this.fInvocations = new ArrayList(2);
            }
            this.fInvocations.add(node);
        }

        public ASTNode[] getInvocations() {
            return this.fInvocations.toArray(new ASTNode[this.fInvocations.size()]);
        }

        public boolean hasInvocations() {
            return this.fInvocations != null && !this.fInvocations.isEmpty();
        }

        public BodyDeclaration getDeclaration() {
            return this.fBody;
        }
    }

    private static class InvocationFinder
    extends ASTVisitor {
        Map result = new HashMap(2);
        Stack fBodies = new Stack();
        BodyData fCurrent;
        private IMethodBinding fBinding;

        public InvocationFinder(IMethodBinding binding) {
            Assert.isNotNull(binding);
            this.fBinding = binding.getMethodDeclaration();
            Assert.isNotNull(this.fBinding);
        }

        public boolean visit(MethodInvocation node) {
            if (this.matches(node.getName().resolveBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            if (this.matches(node.getName().resolveBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(ConstructorInvocation node) {
            if (this.matches((IBinding)node.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            if (this.matches((IBinding)node.resolveConstructorBinding()) && this.fCurrent != null) {
                this.fCurrent.addInvocation((ASTNode)node);
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType();
        }

        public void endVisit(TypeDeclaration node) {
            this.endVisitType();
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitType();
        }

        public void endVisit(EnumDeclaration node) {
            this.endVisitType();
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitType();
        }

        public void endVisit(AnnotationTypeDeclaration node) {
            this.endVisitType();
        }

        private boolean visitType() {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = null;
            return true;
        }

        private void endVisitType() {
            this.fCurrent = (BodyData)this.fBodies.remove(this.fBodies.size() - 1);
        }

        public boolean visit(FieldDeclaration node) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)node);
            return true;
        }

        public void endVisit(FieldDeclaration node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(node, this.fCurrent);
            }
            this.endVisitType();
        }

        public boolean visit(MethodDeclaration node) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)node);
            return true;
        }

        public void endVisit(MethodDeclaration node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(node, this.fCurrent);
            }
            this.endVisitType();
        }

        public boolean visit(Initializer node) {
            this.fBodies.add(this.fCurrent);
            this.fCurrent = new BodyData((BodyDeclaration)node);
            return true;
        }

        public void endVisit(Initializer node) {
            if (this.fCurrent.hasInvocations()) {
                this.result.put(node, this.fCurrent);
            }
            this.endVisitType();
        }

        private boolean matches(IBinding binding) {
            if (!(binding instanceof IMethodBinding)) {
                return false;
            }
            return this.fBinding.getKey().equals(((IMethodBinding)binding).getMethodDeclaration().getKey());
        }
    }

    private static class LocalTypeTargetProvider
    extends TargetProvider {
        private ICompilationUnit fCUnit;
        private MethodDeclaration fDeclaration;
        private Map fBodies;
        static /* synthetic */ Class class$0;

        public LocalTypeTargetProvider(ICompilationUnit unit, MethodDeclaration declaration) {
            Assert.isNotNull(unit);
            Assert.isNotNull(declaration);
            this.fCUnit = unit;
            this.fDeclaration = declaration;
        }

        public void initialize() {
            InvocationFinder finder = new InvocationFinder(this.fDeclaration.resolveBinding());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ASTNode type = ASTNodes.getParent((ASTNode)this.fDeclaration, clazz);
            type.accept((ASTVisitor)finder);
            this.fBodies = finder.result;
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus status, IProgressMonitor pm) {
            LocalTypeTargetProvider.fastDone(pm);
            return new ICompilationUnit[]{this.fCUnit};
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            Assert.isTrue(unit == this.fCUnit);
            Set result = this.fBodies.keySet();
            LocalTypeTargetProvider.fastDone(pm);
            return result.toArray(new BodyDeclaration[result.size()]);
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            BodyData data = (BodyData)this.fBodies.get(declaration);
            Assert.isNotNull(data);
            LocalTypeTargetProvider.fastDone(pm);
            return data.getInvocations();
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 3;
        }
    }

    private static class MemberTypeTargetProvider
    extends TargetProvider {
        private final IMethodBinding fMethodBinding;
        private Map fCurrentBodies;

        public MemberTypeTargetProvider(IMethodBinding methodBinding) {
            Assert.isNotNull(methodBinding);
            this.fMethodBinding = methodBinding;
        }

        public void initialize() {
        }

        public ICompilationUnit[] getAffectedCompilationUnits(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
            IMethod method = (IMethod)this.fMethodBinding.getJavaElement();
            Assert.isTrue(method != null);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)method, (int)2, (int)24));
            engine.setGranularity(2);
            engine.setFiltering(true, true);
            engine.setScope(RefactoringScopeFactory.create((IJavaElement)method));
            engine.setRequestor(new IRefactoringSearchRequestor(this, status){
                final /* synthetic */ MemberTypeTargetProvider this$1;
                private final /* synthetic */ RefactoringStatus val$status;
                {
                    this.this$1 = memberTypeTargetProvider;
                    this.val$status = refactoringStatus;
                }

                public SearchMatch acceptSearchMatch(SearchMatch match) {
                    if (match.isInsideDocComment()) {
                        return null;
                    }
                    if (match.getAccuracy() == 1) {
                        IJavaElement jElement;
                        ICompilationUnit unit;
                        Object element = match.getElement();
                        if (element instanceof IJavaElement && (unit = (ICompilationUnit)(jElement = (IJavaElement)element).getAncestor(5)) != null) {
                            this.val$status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match, JavaStatusContext.create(unit, (ISourceRange)new SourceRange(match.getOffset(), match.getLength())));
                            return null;
                        }
                        this.val$status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match);
                        return null;
                    }
                    return match;
                }
            });
            engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return engine.getAffectedCompilationUnits();
        }

        public BodyDeclaration[] getAffectedBodyDeclarations(ICompilationUnit unit, IProgressMonitor pm) {
            CompilationUnit root = new RefactoringASTParser(3).parse(unit, true);
            InvocationFinder finder = new InvocationFinder(this.fMethodBinding);
            root.accept((ASTVisitor)finder);
            this.fCurrentBodies = finder.result;
            Set result = this.fCurrentBodies.keySet();
            MemberTypeTargetProvider.fastDone(pm);
            return result.toArray(new BodyDeclaration[result.size()]);
        }

        public ASTNode[] getInvocations(BodyDeclaration declaration, IProgressMonitor pm) {
            BodyData data = (BodyData)this.fCurrentBodies.get(declaration);
            Assert.isNotNull(data);
            MemberTypeTargetProvider.fastDone(pm);
            return data.getInvocations();
        }

        public RefactoringStatus checkActivation() throws JavaModelException {
            return new RefactoringStatus();
        }

        public int getStatusSeverity() {
            return 3;
        }
    }
}

