/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.deprecation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class CreateDeprecationFixChange
extends JDTChange {
    private final String fLabel;
    private final IPath fPath;
    private final String fScript;

    public CreateDeprecationFixChange(IPath path, String script, String label) {
        Assert.isNotNull((Object)path);
        Assert.isLegal((script != null && !"".equals(script) ? 1 : 0) != 0);
        Assert.isNotNull((Object)label);
        this.fPath = path;
        this.fScript = script;
        this.fLabel = label;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFile(IFile file, InputStream stream, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 3);
            this.createFolder(file.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            if (file.exists()) {
                file.delete(true, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            }
            file.create(stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createFolder(IContainer container, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 2);
            if (container instanceof IFolder) {
                IFolder folder = (IFolder)container;
                this.createFolder(folder.getParent(), (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                if (!folder.exists()) {
                    folder.create(false, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.CreateDeprecationScriptChange_name, this.fLabel);
    }

    public RefactoringStatus isValid(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI uri = file.getLocationURI();
        if (uri == null) {
            status.addFatalError(Messages.format(RefactoringCoreMessages.CreateDeprecationScriptChange_unknown_location, file.getFullPath().toString()));
        }
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Change perform(IProgressMonitor monitor) throws CoreException {
        InputStream stream = null;
        try {
            DeleteFileChange deleteFileChange;
            monitor.beginTask(RefactoringCoreMessages.CreateDeprecationScriptChange_performing_change, 2);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            try {
                stream = new ByteArrayInputStream(this.fScript.getBytes("utf-8"));
                this.createFile(file, stream, monitor);
                file.setCharset("utf-8", (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                deleteFileChange = new DeleteFileChange(file);
            }
            catch (UnsupportedEncodingException exception) {
                throw new JavaModelException((Throwable)exception, 985);
            }
            Object var5_5 = null;
            try {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException exception) {
                    throw new JavaModelException((Throwable)exception, 985);
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return deleteFileChange;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (Throwable throwable2) {
                Object var9_13 = null;
                monitor.done();
                throw throwable2;
            }
            try {}
            catch (IOException exception) {
                throw new JavaModelException((Throwable)exception, 985);
            }
            if (stream != null) {
                stream.close();
            }
            Object var9_14 = null;
            monitor.done();
            throw throwable;
        }
    }
}

