/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.deprecation;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;

public final class DeprecationRefactorings {
    public static final String SCRIPT_ENCODING = "utf-8";
    public static final String SCRIPT_FOLDER = ".deprecations";
    private static final String SCRIPT_PREFIX = "DEPRECATE_";

    public static String createInlineDeprecationScript(IBinding binding) {
        InlineMethodRefactoring refactoring;
        IJavaElement element;
        String script = null;
        RefactoringSessionDescriptor descriptor = null;
        if (binding instanceof IVariableBinding) {
            InlineConstantRefactoring refactoring2;
            element = binding.getJavaElement();
            if (element != null && (refactoring2 = new InlineConstantRefactoring((IField)element)).canEnableDeprecationResolving()) {
                descriptor = refactoring2.createDeprecationResolution();
            }
        } else if (binding instanceof IMethodBinding && (element = binding.getJavaElement()) != null && (refactoring = new InlineMethodRefactoring((IMethod)element)).canEnableDeprecationResolving()) {
            descriptor = refactoring.createDeprecationResolution();
        }
        if (descriptor != null) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
                RefactoringCore.getHistoryService().writeRefactoringSession(descriptor, (OutputStream)stream, false);
                script = stream.toString(SCRIPT_ENCODING);
            }
            catch (CoreException exception) {
                JavaPlugin.log(exception);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.isTrue(false);
            }
        }
        return script;
    }

    public static String getFieldScriptName(IVariableBinding binding) {
        Assert.isNotNull(binding);
        IJavaElement element = binding.getDeclaringClass().getJavaElement();
        if (element instanceof IType) {
            IType type = (IType)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(SCRIPT_PREFIX);
            buffer.append(type.getFullyQualifiedName());
            buffer.append('.');
            buffer.append(binding.getName());
            buffer.append(".xml");
            return DeprecationRefactorings.makePortable(buffer);
        }
        return null;
    }

    public static String getMethodScriptName(IMethodBinding binding) {
        Assert.isNotNull(binding);
        IJavaElement element = binding.getDeclaringClass().getJavaElement();
        if (element instanceof IType) {
            IType type = (IType)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(SCRIPT_PREFIX);
            buffer.append(type.getFullyQualifiedName());
            buffer.append('.');
            buffer.append(binding.getName());
            buffer.append('(');
            ITypeBinding[] parameters = binding.getParameterTypes();
            int index = 0;
            while (index < parameters.length) {
                IJavaElement javaElem;
                if (index != 0) {
                    buffer.append(',');
                }
                if ((javaElem = parameters[index].getJavaElement()) instanceof IType) {
                    buffer.append(((IType)javaElem).getFullyQualifiedName());
                } else if (javaElem instanceof ITypeParameter) {
                    buffer.append(((ITypeParameter)javaElem).getElementName());
                } else {
                    buffer.append(parameters[index].getQualifiedName());
                }
                ++index;
            }
            buffer.append(')');
            buffer.append(".xml");
            return DeprecationRefactorings.makePortable(buffer);
        }
        return null;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IBinding binding) {
        IPackageFragmentRoot root = null;
        IJavaElement element = binding.getJavaElement();
        if (element != null && (root = (IPackageFragmentRoot)element.getAncestor(3)) != null && !root.isArchive()) {
            root = null;
        }
        return root;
    }

    public static RefactoringHistory getRefactoringHistory(IBinding binding) {
        RefactoringHistory history = null;
        String name = DeprecationRefactorings.getRefactoringScriptName(binding);
        if (name != null) {
            IPackageFragmentRoot root = DeprecationRefactorings.getPackageFragmentRoot(binding);
            if (root != null) {
                history = DeprecationRefactorings.getRefactoringHistory(root, name);
            }
            if (history == null) {
                IJavaProject project;
                IFile file = null;
                IJavaElement element = binding.getJavaElement();
                if (element != null && (project = element.getJavaProject()) != null) {
                    file = project.getProject().getFolder(SCRIPT_FOLDER).getFile(name);
                }
                if (file != null && file.exists()) {
                    history = DeprecationRefactorings.getRefactoringHistory(file);
                }
            }
        }
        return history;
    }

    /*
     * Exception decompiling
     */
    public static RefactoringHistory getRefactoringHistory(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 71->74)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static RefactoringHistory getRefactoringHistory(IPackageFragmentRoot root, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [3 : 136->142)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IFile getRefactoringScriptFile(IJavaProject project, String name) {
        return project.getProject().getFolder(SCRIPT_FOLDER).getFile(name);
    }

    public static String getRefactoringScriptName(IBinding binding) {
        String fileName = null;
        if (binding instanceof IVariableBinding) {
            fileName = DeprecationRefactorings.getFieldScriptName((IVariableBinding)binding);
        } else if (binding instanceof IMethodBinding) {
            fileName = DeprecationRefactorings.getMethodScriptName((IMethodBinding)binding);
        }
        return fileName;
    }

    private static String makePortable(StringBuffer buffer) {
        int index = 0;
        while (index < buffer.length()) {
            char character = buffer.charAt(index);
            switch (character) {
                case ',': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '\\': 
                case '|': {
                    buffer.setCharAt(index, '_');
                }
            }
            ++index;
        }
        return buffer.toString();
    }

    private DeprecationRefactorings() {
    }
}

