/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSUtil {
    private NLSUtil() {
    }

    /*
     * Exception decompiling
     */
    public static String readString(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 107->110)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TextEdit createNLSEdit(ICompilationUnit cu, int position) throws CoreException {
        NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, position);
        if (nlsLine == null) {
            return null;
        }
        NLSElement element = NLSUtil.findElement(nlsLine, position);
        if (element.hasTag()) {
            return null;
        }
        NLSElement[] elements = nlsLine.getElements();
        int indexInElementList = Arrays.asList(elements).indexOf(element);
        int editOffset = NLSUtil.computeInsertOffset(elements, indexInElementList, cu);
        String editText = String.valueOf(' ') + NLSElement.createTagText(indexInElementList + 1);
        return new InsertEdit(editOffset, editText);
    }

    public static TextEdit[] createNLSEdits(ICompilationUnit cu, int[] positions) throws CoreException {
        ArrayList<InsertEdit> result = new ArrayList<InsertEdit>();
        try {
            NLSLine[] allLines = NLSScanner.scan(cu);
            int i = 0;
            while (i < allLines.length) {
                NLSLine line = allLines[i];
                NLSElement[] elements = line.getElements();
                int j = 0;
                while (j < elements.length) {
                    NLSElement element = elements[j];
                    if (!element.hasTag()) {
                        int k = 0;
                        while (k < positions.length) {
                            if (NLSUtil.isPositionInElement(element, positions[k])) {
                                int editOffset;
                                if (j == 0) {
                                    editOffset = elements.length > j + 1 ? elements[j + 1].getTagPosition().getOffset() : NLSUtil.findLineEnd(cu, element.getPosition().getOffset());
                                } else {
                                    Region previousPosition = elements[j - 1].getTagPosition();
                                    editOffset = previousPosition.getOffset() + previousPosition.getLength();
                                }
                                String editText = String.valueOf(' ') + NLSElement.createTagText(j + 1);
                                result.add(new InsertEdit(editOffset, editText));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    private static NLSLine scanCurrentLine(ICompilationUnit cu, int position) throws JavaModelException {
        try {
            Assert.isTrue(position >= 0 && position <= cu.getBuffer().getLength());
            NLSLine[] allLines = NLSScanner.scan(cu);
            int i = 0;
            while (i < allLines.length) {
                NLSLine line = allLines[i];
                if (NLSUtil.findElement(line, position) != null) {
                    return line;
                }
                ++i;
            }
            return null;
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
    }

    private static boolean isPositionInElement(NLSElement element, int position) {
        Region elementPosition = element.getPosition();
        return elementPosition.getOffset() <= position && position <= elementPosition.getOffset() + elementPosition.getLength();
    }

    private static NLSElement findElement(NLSLine line, int position) {
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            NLSElement element = elements[i];
            if (NLSUtil.isPositionInElement(element, position)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static int computeInsertOffset(NLSElement[] elements, int index, ICompilationUnit cu) throws CoreException {
        NLSElement previousTagged = NLSUtil.findPreviousTagged(index, elements);
        if (previousTagged != null) {
            return previousTagged.getTagPosition().getOffset() + previousTagged.getTagPosition().getLength();
        }
        NLSElement nextTagged = NLSUtil.findNextTagged(index, elements);
        if (nextTagged != null) {
            return nextTagged.getTagPosition().getOffset();
        }
        return NLSUtil.findLineEnd(cu, elements[index].getPosition().getOffset());
    }

    private static NLSElement findPreviousTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex - 1;
        while (i >= 0) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            --i;
        }
        return null;
    }

    private static NLSElement findNextTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex + 1;
        while (i < elements.length) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    private static int findLineEnd(ICompilationUnit cu, int position) throws JavaModelException {
        IBuffer buffer = cu.getBuffer();
        int length = buffer.getLength();
        int i = position;
        while (i < length) {
            if (IndentManipulation.isLineDelimiterChar((char)buffer.getChar(i))) {
                return i;
            }
            ++i;
        }
        return length;
    }
}

