/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.CommentAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenamePackageProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating {
    public static final String ID_RENAME_PACKAGE = "org.eclipse.jdt.ui.rename.package";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_REFERENCES = "references";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private IPackageFragment fPackage;
    private TextChangeManager fChangeManager;
    private ImportsManager fImportsManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    private boolean fRenameSubpackages;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renamePackageProcessor";

    public RenamePackageProcessor(IPackageFragment fragment) {
        this.fPackage = fragment;
        if (this.fPackage != null) {
            this.setNewElementName(this.fPackage.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameSubpackages = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fPackage);
    }

    public String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_name, new String[]{this.fPackage.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fPackage);
    }

    public Object[] getElements() {
        return new Object[]{this.fPackage};
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fPackage, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()), this.fRenameSubpackages);
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        HashSet<IFile> combined = new HashSet<IFile>();
        combined.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fRenameSubpackages) {
            IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
            int i = 0;
            while (i < allPackages.length) {
                combined.addAll(Arrays.asList(ResourceUtil.getFiles(allPackages[i].getCompilationUnits())));
                ++i;
            }
        } else {
            combined.addAll(Arrays.asList(ResourceUtil.getFiles(this.fPackage.getCompilationUnits())));
        }
        if (this.fQualifiedNameSearchResult != null) {
            combined.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        return combined.toArray(new IFile[combined.size()]);
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fPackage.isDefaultPackage();
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull(patterns);
        this.fFilePatterns = patterns;
    }

    public boolean canEnableRenameSubpackages() throws JavaModelException {
        return this.fPackage.hasSubpackages();
    }

    public boolean getRenameSubpackages() {
        return this.fRenameSubpackages;
    }

    public void setRenameSubpackages(boolean rename) {
        this.fRenameSubpackages = rename;
    }

    public final String getCurrentElementName() {
        return this.fPackage.getElementName();
    }

    public String getCurrentElementQualifier() {
        return "";
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkPackageName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fPackage, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenamePackageRefactoring_another_name);
        }
        result.merge(this.checkPackageInCurrentRoot(newName));
        return result;
    }

    public Object getNewElement() {
        IJavaElement parent = this.fPackage.getParent();
        if (!(parent instanceof IPackageFragmentRoot)) {
            return this.fPackage;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
        return root.getPackageFragment(this.getNewElementName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus result;
        block10: {
            String message;
            pm.beginTask("", 23 + (this.fUpdateQualifiedNames ? 10 : 0));
            pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
            result = new RefactoringStatus();
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            result.merge(this.checkForMainAndNativeMethods());
            pm.worked(2);
            if (this.fPackage.isReadOnly()) {
                message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_Packagered_only, this.fPackage.getElementName());
                result.addFatalError(message);
            } else if (Resources.isReadOnly(this.fPackage.getResource())) {
                message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_resource_read_only, this.fPackage.getElementName());
                result.addError(message);
            }
            result.merge(this.checkPackageName(this.getNewElementName()));
            if (!result.hasFatalError()) break block10;
            RefactoringStatus refactoringStatus2 = result;
            Object var7_7 = null;
            pm.done();
            return refactoringStatus2;
        }
        try {
            this.fChangeManager = new TextChangeManager();
            this.fImportsManager = new ImportsManager();
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 16);
            if (this.fRenameSubpackages) {
                IPackageFragment[] allSubpackages = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
                subPm.beginTask("", allSubpackages.length);
                int i = 0;
                while (i < allSubpackages.length) {
                    new PackageRenamer(allSubpackages[i], this, this.fChangeManager, this.fImportsManager).doRename((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1), result);
                    ++i;
                }
                subPm.done();
            } else {
                new PackageRenamer(this.fPackage, this, this.fChangeManager, this.fImportsManager).doRename((IProgressMonitor)subPm, result);
            }
            this.fImportsManager.rewriteImports(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            if (this.fUpdateQualifiedNames) {
                this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 10));
            }
            refactoringStatus = result;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public IPackageFragment getPackage() {
        return this.fPackage;
    }

    private RefactoringStatus checkForMainAndNativeMethods() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fRenameSubpackages) {
            IPackageFragment[] allSubpackages = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
            int i = 0;
            while (i < allSubpackages.length) {
                ICompilationUnit[] cus = allSubpackages[i].getCompilationUnits();
                int c = 0;
                while (c < cus.length) {
                    result.merge(Checks.checkForMainAndNativeMethods(cus[c]));
                    ++c;
                }
                ++i;
            }
        } else {
            ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                result.merge(Checks.checkForMainAndNativeMethods(cus[i]));
                ++i;
            }
        }
        return result;
    }

    public static boolean isPackageNameOkInRoot(String newName, IPackageFragmentRoot root) throws CoreException {
        IPackageFragment pack = root.getPackageFragment(newName);
        if (!pack.exists()) {
            return true;
        }
        if (!pack.hasSubpackages()) {
            return false;
        }
        if (pack.containsJavaResources()) {
            return false;
        }
        return pack.getNonJavaResources().length == 0;
    }

    private RefactoringStatus checkPackageInCurrentRoot(String newName) throws CoreException {
        if (RenamePackageProcessor.isPackageNameOkInRoot(newName, this.getPackageFragmentRoot())) {
            return null;
        }
        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenamePackageRefactoring_package_exists);
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fPackage.getParent();
    }

    private RefactoringStatus checkPackageName(String newName) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        IPackageFragmentRoot[] roots = this.fPackage.getJavaProject().getPackageFragmentRoots();
        Set topLevelTypeNames = this.getTopLevelTypeNames();
        int i = 0;
        while (i < roots.length) {
            if (!RenamePackageProcessor.isPackageNameOkInRoot(newName, roots[i])) {
                String message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_aleady_exists, new Object[]{this.getNewElementName(), roots[i].getElementName()});
                status.merge(RefactoringStatus.createWarningStatus((String)message));
                status.merge(this.checkTypeNameConflicts(roots[i], newName, topLevelTypeNames));
            }
            ++i;
        }
        return status;
    }

    private Set getTopLevelTypeNames() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        HashSet result = new HashSet(2 * cus.length);
        int i = 0;
        while (i < cus.length) {
            result.addAll(RenamePackageProcessor.getTopLevelTypeNames(cus[i]));
            ++i;
        }
        return result;
    }

    private static Collection getTopLevelTypeNames(ICompilationUnit iCompilationUnit) throws CoreException {
        IType[] types = iCompilationUnit.getTypes();
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            result.add(types[i].getElementName());
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(IPackageFragmentRoot root, String newName, Set topLevelTypeNames) throws CoreException {
        IPackageFragment otherPack = root.getPackageFragment(newName);
        if (this.fPackage.equals(otherPack)) {
            return null;
        }
        ICompilationUnit[] cus = otherPack.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(this.checkTypeNameConflicts(cus[i], topLevelTypeNames));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(ICompilationUnit iCompilationUnit, Set topLevelTypeNames) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] types = iCompilationUnit.getTypes();
        String packageName = iCompilationUnit.getParent().getElementName();
        int i = 0;
        while (i < types.length) {
            String name = types[i].getElementName();
            if (topLevelTypeNames.contains(name)) {
                Object[] keys = new String[]{packageName, name};
                String msg = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_contains_type, keys);
                RefactoringStatusContext context = JavaStatusContext.create((IMember)types[i]);
                result.addError(msg, context);
            }
            ++i;
        }
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        try {
            monitor.beginTask(RefactoringCoreMessages.RenamePackageRefactoring_creating_change, 1);
            DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.Change_javaChanges){

                public final ChangeDescriptor getDescriptor() {
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    String project = null;
                    IJavaProject javaProject = RenamePackageProcessor.this.fPackage.getJavaProject();
                    if (javaProject != null) {
                        project = javaProject.getElementName();
                    }
                    JavaRefactoringDescriptor descriptor = new JavaRefactoringDescriptor(RenamePackageProcessor.ID_RENAME_PACKAGE, project, Messages.format(RefactoringCoreMessages.RenamePackageProcessor_descriptor_description, new String[]{RenamePackageProcessor.this.fPackage.getElementName(), RenamePackageProcessor.this.getNewElementName()}), RenamePackageProcessor.this.getComment(), arguments, 589830);
                    arguments.put("input", descriptor.elementToHandle((IJavaElement)RenamePackageProcessor.this.fPackage));
                    arguments.put("name", RenamePackageProcessor.this.getNewElementName());
                    if (RenamePackageProcessor.this.fFilePatterns != null && !"".equals(RenamePackageProcessor.this.fFilePatterns)) {
                        arguments.put(RenamePackageProcessor.ATTRIBUTE_PATTERNS, RenamePackageProcessor.this.fFilePatterns);
                    }
                    arguments.put(RenamePackageProcessor.ATTRIBUTE_REFERENCES, Boolean.valueOf(RenamePackageProcessor.this.fUpdateReferences).toString());
                    arguments.put(RenamePackageProcessor.ATTRIBUTE_QUALIFIED, Boolean.valueOf(RenamePackageProcessor.this.fUpdateQualifiedNames).toString());
                    arguments.put(RenamePackageProcessor.ATTRIBUTE_TEXTUAL_MATCHES, Boolean.valueOf(RenamePackageProcessor.this.fUpdateTextualMatches).toString());
                    arguments.put(RenamePackageProcessor.ATTRIBUTE_HIERARCHICAL, Boolean.valueOf(RenamePackageProcessor.this.fRenameSubpackages).toString());
                    return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
                }
            };
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            result.add(new RenamePackageChange(this.fPackage, this.getNewElementName(), this.getComment(), this.fRenameSubpackages));
            monitor.worked(1);
            dynamicValidationStateChange = result;
            Object var3_4 = null;
            this.fChangeManager = null;
            this.fImportsManager = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fChangeManager = null;
            this.fImportsManager = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return dynamicValidationStateChange;
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            try {
                Change change = this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
                Object var3_4 = null;
                this.fQualifiedNameSearchResult = null;
                return change;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.fQualifiedNameSearchResult = null;
                throw throwable;
            }
        }
        return null;
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fPackage.getElementName(), this.getNewElementName(), this.fFilePatterns, this.fPackage.getJavaProject().getProject(), pm);
    }

    public String getNewPackageName(String oldSubPackageName) {
        String oldPackageName = this.getPackage().getElementName();
        return String.valueOf(this.getNewElementName()) + oldSubPackageName.substring(oldPackageName.length());
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String hierarchical;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JavaRefactoringDescriptor.handleToElement(extended.getProject(), handle);
                if (element == null || element.getElementType() != 4) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_input_not_exists, ID_RENAME_PACKAGE));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fPackage = (IPackageFragment)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName(name);
            String patterns = extended.getAttribute(ATTRIBUTE_PATTERNS);
            this.fFilePatterns = patterns != null && !"".equals(patterns) ? patterns : "";
            String references = extended.getAttribute(ATTRIBUTE_REFERENCES);
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REFERENCES));
            }
            this.fUpdateReferences = Boolean.valueOf(references);
            String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
            if (matches == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
            }
            this.fUpdateTextualMatches = Boolean.valueOf(matches);
            String qualified = extended.getAttribute(ATTRIBUTE_QUALIFIED);
            if (qualified == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFIED));
            }
            this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
            hierarchical = extended.getAttribute(ATTRIBUTE_HIERARCHICAL);
            if (hierarchical == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_HIERARCHICAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fRenameSubpackages = Boolean.valueOf(hierarchical);
        return new RefactoringStatus();
    }

    private static class PackageRenamer {
        private final IPackageFragment fPackage;
        private final RenamePackageProcessor fProcessor;
        private final TextChangeManager fTextChangeManager;
        private final ImportsManager fImportsManager;
        private SearchResultGroup[] fOccurrences;
        private List fReferencesToTypesInNamesakes;
        private List fReferencesToTypesInPackage;

        public PackageRenamer(IPackageFragment pack, RenamePackageProcessor processor, TextChangeManager textChangeManager, ImportsManager importsManager) {
            this.fPackage = pack;
            this.fProcessor = processor;
            this.fTextChangeManager = textChangeManager;
            this.fImportsManager = importsManager;
        }

        void doRename(IProgressMonitor pm, RefactoringStatus result) throws CoreException {
            pm.beginTask("", 16 + (this.fProcessor.getUpdateTextualMatches() ? 10 : 0));
            if (this.fProcessor.getUpdateReferences()) {
                pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_searching);
                this.fOccurrences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
                this.fReferencesToTypesInNamesakes = this.getReferencesToTypesInNamesakes((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
                this.fReferencesToTypesInPackage = this.getReferencesToTypesInPackage((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
                pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
                result.merge(this.analyzeAffectedCompilationUnits());
                pm.worked(1);
            } else {
                this.fOccurrences = new SearchResultGroup[0];
                pm.worked(13);
            }
            if (result.hasFatalError()) {
                return;
            }
            if (this.fProcessor.getUpdateReferences()) {
                this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 3));
            } else {
                pm.worked(3);
            }
            if (this.fProcessor.getUpdateTextualMatches() && this.fPackage.equals(this.fProcessor.getPackage())) {
                pm.subTask(RefactoringCoreMessages.RenamePackageRefactoring_searching_text);
                this.addTextMatches((IProgressMonitor)new SubProgressMonitor(pm, 10));
            }
            pm.done();
        }

        private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fPackage);
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fPackage, (int)2);
            return RefactoringSearchEngine.search(pattern, scope, pm, status);
        }

        private void addReferenceUpdates(IProgressMonitor pm) throws CoreException {
            pm.beginTask("", this.fOccurrences.length + this.fReferencesToTypesInPackage.size() + this.fReferencesToTypesInNamesakes.size());
            int i = 0;
            while (i < this.fOccurrences.length) {
                ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
                if (cu != null) {
                    SearchResultGroup typeRefsRequiringNewNameImport;
                    SearchResultGroup typeRefsRequiringOldNameImport;
                    SearchMatch[] results = this.fOccurrences[i].getSearchResults();
                    int j = 0;
                    while (j < results.length) {
                        SearchMatch result = results[j];
                        IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
                        if (enclosingElement instanceof IImportDeclaration) {
                            IImportDeclaration importDeclaration = (IImportDeclaration)enclosingElement;
                            String updatedImport = this.getUpdatedImport(importDeclaration);
                            this.updateImport(cu, importDeclaration, updatedImport);
                        } else {
                            TextChangeCompatibility.addTextEdit(this.fTextChangeManager.get(cu), RefactoringCoreMessages.RenamePackageRefactoring_update_reference, this.createTextChange(result));
                        }
                        ++j;
                    }
                    if (this.fReferencesToTypesInNamesakes.size() != 0 && (typeRefsRequiringOldNameImport = PackageRenamer.extractGroupFor(cu, this.fReferencesToTypesInNamesakes)) != null) {
                        this.addTypeImports(typeRefsRequiringOldNameImport);
                    }
                    if (this.fReferencesToTypesInPackage.size() != 0 && (typeRefsRequiringNewNameImport = PackageRenamer.extractGroupFor(cu, this.fReferencesToTypesInPackage)) != null) {
                        this.updateTypeImports(typeRefsRequiringNewNameImport);
                    }
                    pm.worked(1);
                }
                ++i;
            }
            if (this.fReferencesToTypesInNamesakes.size() != 0) {
                Iterator iter = this.fReferencesToTypesInNamesakes.iterator();
                while (iter.hasNext()) {
                    SearchResultGroup referencesToTypesInNamesakes = (SearchResultGroup)iter.next();
                    this.addTypeImports(referencesToTypesInNamesakes);
                    pm.worked(1);
                }
            }
            if (this.fReferencesToTypesInPackage.size() != 0) {
                Iterator iter = this.fReferencesToTypesInPackage.iterator();
                while (iter.hasNext()) {
                    SearchResultGroup namesakeReferencesToPackage = (SearchResultGroup)iter.next();
                    this.updateTypeImports(namesakeReferencesToPackage);
                    pm.worked(1);
                }
            }
            pm.done();
        }

        private static SearchResultGroup extractGroupFor(ICompilationUnit cu, List searchResultGroups) {
            Iterator iter = searchResultGroups.iterator();
            while (iter.hasNext()) {
                SearchResultGroup group = (SearchResultGroup)iter.next();
                if (!cu.equals(group.getCompilationUnit())) continue;
                iter.remove();
                return group;
            }
            return null;
        }

        private TextEdit createTextChange(SearchMatch searchResult) {
            return new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), this.getNewPackageName());
        }

        private void addTextMatches(IProgressMonitor pm) throws CoreException {
            TextMatchUpdater.perform(pm, RefactoringScopeFactory.create((IJavaElement)this.fPackage), this.fProcessor, this.fTextChangeManager, this.fOccurrences);
        }

        private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
            RefactoringStatus result = new RefactoringStatus();
            this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
            if (result.hasFatalError()) {
                return result;
            }
            result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
            return result;
        }

        private IJavaSearchScope getPackageAndOccurrencesWithoutNamesakesScope() {
            ArrayList<Object> scopeList = new ArrayList<Object>();
            scopeList.add(this.fPackage);
            int i = 0;
            while (i < this.fOccurrences.length) {
                IPackageFragment pack;
                ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
                if (cu != null && !(pack = (IPackageFragment)cu.getParent()).getElementName().equals(this.fPackage.getElementName())) {
                    scopeList.add(cu);
                }
                ++i;
            }
            return SearchEngine.createJavaSearchScope((IJavaElement[])scopeList.toArray(new IJavaElement[scopeList.size()]));
        }

        private List getReferencesToTypesInNamesakes(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
            pm.beginTask("", 2);
            IJavaElement[] elements = new IJavaElement[this.fOccurrences.length + 1];
            int i = 0;
            while (i < this.fOccurrences.length) {
                elements[i] = this.fOccurrences[i].getCompilationUnit();
                ++i;
            }
            elements[this.fOccurrences.length] = this.fPackage;
            IJavaSearchScope namesakePackagesScope = RefactoringScopeFactory.createReferencedScope(elements);
            IPackageFragment[] namesakePackages = this.getNamesakePackages(namesakePackagesScope, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (namesakePackages.length == 0) {
                pm.done();
                return new ArrayList(0);
            }
            IType[] typesToSearch = this.getTypesInPackages(namesakePackages);
            if (typesToSearch.length == 0) {
                pm.done();
                return new ArrayList(0);
            }
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])typesToSearch, 2);
            IJavaSearchScope scope = this.getPackageAndOccurrencesWithoutNamesakesScope();
            SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            pm.done();
            return new ArrayList<SearchResultGroup>(Arrays.asList(results));
        }

        private List getReferencesToTypesInPackage(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
            pm.beginTask("", 2);
            IJavaSearchScope referencedFromNamesakesScope = RefactoringScopeFactory.create((IJavaElement)this.fPackage);
            IPackageFragment[] namesakePackages = this.getNamesakePackages(referencedFromNamesakesScope, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (namesakePackages.length == 0) {
                pm.done();
                return new ArrayList(0);
            }
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])namesakePackages);
            IType[] typesToSearch = this.getTypesInPackage(this.fPackage);
            if (typesToSearch.length == 0) {
                pm.done();
                return new ArrayList(0);
            }
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])typesToSearch, 2);
            SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            pm.done();
            return new ArrayList<SearchResultGroup>(Arrays.asList(results));
        }

        private IType[] getTypesInPackage(IPackageFragment packageFragment) throws JavaModelException {
            ArrayList types = new ArrayList();
            this.addContainedTypes(packageFragment, types);
            return types.toArray(new IType[types.size()]);
        }

        private IPackageFragment[] getNamesakePackages(IJavaSearchScope scope, IProgressMonitor pm) throws CoreException {
            SearchPattern pattern = SearchPattern.createPattern((String)this.fPackage.getElementName(), (int)2, (int)0, (int)8);
            ArrayList packageFragments = new ArrayList();
            SearchRequestor requestor = new SearchRequestor(this, packageFragments){
                final /* synthetic */ PackageRenamer this$1;
                private final /* synthetic */ List val$packageFragments;
                {
                    this.this$1 = packageRenamer;
                    this.val$packageFragments = list;
                }

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (RefactoringSearchEngine.isFiltered(match)) {
                        return;
                    }
                    IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(match);
                    if (enclosingElement instanceof IPackageFragment) {
                        IPackageFragment pack = (IPackageFragment)enclosingElement;
                        if (!PackageRenamer.access$0(this.this$1).equals(pack)) {
                            this.val$packageFragments.add(pack);
                        }
                    }
                }
            };
            new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
            return packageFragments.toArray(new IPackageFragment[packageFragments.size()]);
        }

        private IType[] getTypesInPackages(IPackageFragment[] packageFragments) throws JavaModelException {
            ArrayList types = new ArrayList();
            int i = 0;
            while (i < packageFragments.length) {
                IPackageFragment pack = packageFragments[i];
                this.addContainedTypes(pack, types);
                ++i;
            }
            return types.toArray(new IType[types.size()]);
        }

        private void addContainedTypes(IPackageFragment pack, List typesCollector) throws JavaModelException {
            IJavaElement[] children = pack.getChildren();
            int c = 0;
            while (c < children.length) {
                IJavaElement child = children[c];
                if (child instanceof ICompilationUnit) {
                    typesCollector.addAll(Arrays.asList(((ICompilationUnit)child).getTypes()));
                }
                ++c;
            }
        }

        private void updateImport(ICompilationUnit cu, IImportDeclaration importDeclaration, String updatedImport) throws JavaModelException {
            ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(cu);
            if (Flags.isStatic((int)importDeclaration.getFlags())) {
                importChange.removeStaticImport(importDeclaration.getElementName());
                importChange.addStaticImport(Signature.getQualifier((String)updatedImport), Signature.getSimpleName((String)updatedImport));
            } else {
                importChange.removeImport(importDeclaration.getElementName());
                importChange.addImport(updatedImport);
            }
        }

        private void addTypeImports(SearchResultGroup typeReferences) throws CoreException {
            SearchMatch[] searchResults = typeReferences.getSearchResults();
            int i = 0;
            while (i < searchResults.length) {
                String reference;
                SearchMatch result = searchResults[i];
                IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
                if (!(enclosingElement instanceof IImportDeclaration) && !(reference = PackageRenamer.getNormalizedTypeReference(result)).startsWith(this.fPackage.getElementName())) {
                    reference = PackageRenamer.cutOffInnerTypes(reference);
                    ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(typeReferences.getCompilationUnit());
                    importChange.addImport(String.valueOf(this.fPackage.getElementName()) + '.' + reference);
                }
                ++i;
            }
        }

        private void updateTypeImports(SearchResultGroup typeReferences) throws CoreException {
            SearchMatch[] searchResults = typeReferences.getSearchResults();
            int i = 0;
            while (i < searchResults.length) {
                SearchMatch result = searchResults[i];
                IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
                if (enclosingElement instanceof IImportDeclaration) {
                    IImportDeclaration importDeclaration = (IImportDeclaration)enclosingElement;
                    this.updateImport(typeReferences.getCompilationUnit(), importDeclaration, this.getUpdatedImport(importDeclaration));
                } else {
                    String reference = PackageRenamer.getNormalizedTypeReference(result);
                    if (!reference.startsWith(this.fPackage.getElementName())) {
                        reference = PackageRenamer.cutOffInnerTypes(reference);
                        ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(typeReferences.getCompilationUnit());
                        importChange.removeImport(String.valueOf(this.fPackage.getElementName()) + '.' + reference);
                        importChange.addImport(String.valueOf(this.getNewPackageName()) + '.' + reference);
                    }
                }
                ++i;
            }
        }

        private static String getNormalizedTypeReference(SearchMatch searchResult) throws JavaModelException {
            ICompilationUnit cu = SearchUtils.getCompilationUnit(searchResult);
            String reference = cu.getBuffer().getText(searchResult.getOffset(), searchResult.getLength());
            return CommentAnalyzer.normalizeReference(reference);
        }

        private static String cutOffInnerTypes(String reference) {
            int dotPos = reference.indexOf(46);
            if (dotPos != -1) {
                reference = reference.substring(0, dotPos);
            }
            return reference;
        }

        private String getUpdatedImport(IImportDeclaration importDeclaration) {
            String fullyQualifiedImportType = importDeclaration.getElementName();
            int offsetOfDotBeforeTypeName = this.fPackage.getElementName().length();
            String result = String.valueOf(this.getNewPackageName()) + fullyQualifiedImportType.substring(offsetOfDotBeforeTypeName);
            return result;
        }

        private String getNewPackageName() {
            return this.fProcessor.getNewPackageName(this.fPackage.getElementName());
        }

        static /* synthetic */ IPackageFragment access$0(PackageRenamer packageRenamer) {
            return packageRenamer.fPackage;
        }
    }

    static class ImportsManager {
        private HashMap fImportChanges = new HashMap();

        ImportsManager() {
        }

        public ImportChange getImportChange(ICompilationUnit cu) {
            ImportChange importChange = (ImportChange)this.fImportChanges.get(cu);
            if (importChange == null) {
                importChange = new ImportChange();
                this.fImportChanges.put(cu, importChange);
            }
            return importChange;
        }

        public void rewriteImports(TextChangeManager changeManager, IProgressMonitor pm) throws CoreException {
            Iterator iter = this.fImportChanges.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ICompilationUnit cu = (ICompilationUnit)entry.getKey();
                ImportChange importChange = (ImportChange)entry.getValue();
                ImportRewrite importRewrite = StubUtility.createImportRewrite(cu, true);
                importRewrite.setFilterImplicitImports(false);
                Iterator iterator = importChange.fStaticToRemove.iterator();
                while (iterator.hasNext()) {
                    importRewrite.removeStaticImport((String)iterator.next());
                }
                iterator = importChange.fToRemove.iterator();
                while (iterator.hasNext()) {
                    importRewrite.removeImport((String)iterator.next());
                }
                iterator = importChange.fStaticToAdd.iterator();
                while (iterator.hasNext()) {
                    String[] toAdd = (String[])iterator.next();
                    importRewrite.addStaticImport(toAdd[0], toAdd[1], true);
                }
                iterator = importChange.fToAdd.iterator();
                while (iterator.hasNext()) {
                    importRewrite.addImport((String)iterator.next());
                }
                if (!importRewrite.hasRecordedChanges()) continue;
                TextEdit importEdit = importRewrite.rewriteImports(pm);
                String name = RefactoringCoreMessages.RenamePackageRefactoring_update_imports;
                TextChangeCompatibility.addTextEdit(changeManager.get(cu), name, importEdit);
            }
        }

        public static class ImportChange {
            private ArrayList fStaticToRemove = new ArrayList();
            private ArrayList fStaticToAdd = new ArrayList();
            private ArrayList fToRemove = new ArrayList();
            private ArrayList fToAdd = new ArrayList();

            public void removeStaticImport(String elementName) {
                this.fStaticToRemove.add(elementName);
            }

            public void addStaticImport(String declaringType, String memberName) {
                this.fStaticToAdd.add(new String[]{declaringType, memberName});
            }

            public void removeImport(String elementName) {
                this.fToRemove.add(elementName);
            }

            public void addImport(String elementName) {
                this.fToAdd.add(elementName);
            }
        }
    }
}

