/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameSourceFolderChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class RenameSourceFolderProcessor
extends JavaRenameProcessor {
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private IPackageFragmentRoot fSourceFolder;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameSourceFolderProcessor";

    public RenameSourceFolderProcessor(IPackageFragmentRoot root) {
        this.fSourceFolder = root;
        if (root != null) {
            this.setNewElementName(root.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fSourceFolder);
    }

    public String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenameSourceFolderRefactoring_rename, new String[]{this.fSourceFolder.getElementName(), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fSourceFolder);
    }

    public Object[] getElements() {
        return new Object[]{this.fSourceFolder};
    }

    public Object getNewElement() throws CoreException {
        IPackageFragmentRoot[] roots = this.fSourceFolder.getJavaProject().getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getElementName().equals(this.getNewElementName())) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fSourceFolder, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[0];
    }

    public String getCurrentElementName() {
        return this.fSourceFolder.getElementName();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        IPath p;
        Assert.isNotNull(newName, "new name");
        if (!newName.trim().equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_blank);
        }
        IContainer c = this.fSourceFolder.getResource().getParent();
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_invalid_name);
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, 2));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), 2)));
        if (result.hasFatalError()) {
            return result;
        }
        IJavaProject project = this.fSourceFolder.getJavaProject();
        if (project.findPackageFragmentRoot(p = project.getProject().getFullPath().append(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_already_exists);
        }
        if (project.getProject().findMember((IPath)new Path(newName)) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameSourceFolderRefactoring_alread_exists);
        }
        return result;
    }

    private String createNewPath(String newName) {
        return this.fSourceFolder.getPath().removeLastSegments(1).append(newName).toString();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            refactoringStatus = new RefactoringStatus();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameSourceFolderChange(this.fSourceFolder, this.getNewElementName(), this.getComment()));
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        if (arguments instanceof JavaRefactoringArguments) {
            IResource resource;
            JavaRefactoringArguments generic = (JavaRefactoringArguments)arguments;
            String path = generic.getAttribute(ATTRIBUTE_PATH);
            if (path != null) {
                resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                if (resource == null || !resource.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_input_not_exists, "org.eclipse.jdt.ui.rename.source.folder"));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PATH));
            }
            this.fSourceFolder = (IPackageFragmentRoot)JavaCore.create((IResource)resource);
            name = generic.getAttribute(ATTRIBUTE_NAME);
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_NAME));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }
}

